/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.streaming;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.linqs.psl.reasoner.term.streaming.StreamingIterator;
import org.linqs.psl.reasoner.term.streaming.StreamingTerm;
import org.linqs.psl.reasoner.term.streaming.StreamingTermStore;
import org.linqs.psl.util.RandUtils;

public abstract class StreamingCacheIterator<T extends StreamingTerm>
implements StreamingIterator<T> {
    protected StreamingTermStore<T> parentStore;
    protected int[] shuffleMap;
    protected List<T> termCache;
    protected List<T> termPool;
    protected ByteBuffer termBuffer;
    protected long termCount;
    protected int currentPage;
    protected int nextCachedTermIndex;
    protected T nextTerm;
    protected boolean shufflePage;
    protected List<Integer> pageAccessOrder;
    protected boolean closed;
    protected int numPages;

    public StreamingCacheIterator(StreamingTermStore<T> parentStore, List<T> termCache, List<T> termPool, ByteBuffer termBuffer, boolean shufflePage, int[] shuffleMap, boolean randomizePageAccess, int numPages) {
        this.parentStore = parentStore;
        this.shuffleMap = shuffleMap;
        this.termCache = termCache;
        this.termCache.clear();
        this.termPool = termPool;
        this.termBuffer = termBuffer;
        this.termCount = 0L;
        this.nextCachedTermIndex = 0;
        this.currentPage = -1;
        this.numPages = numPages;
        this.shufflePage = shufflePage;
        this.pageAccessOrder = new ArrayList<Integer>(numPages);
        for (int i = 0; i < numPages; ++i) {
            this.pageAccessOrder.add(i);
        }
        if (randomizePageAccess) {
            RandUtils.shuffle(this.pageAccessOrder);
        }
        this.closed = false;
        this.nextTerm = null;
    }

    @Override
    public boolean hasNext() {
        if (this.nextTerm != null) {
            throw new IllegalStateException("hasNext() was called twice in a row. Call next() directly after hasNext() == true.");
        }
        if (this.closed) {
            return false;
        }
        do {
            this.nextTerm = this.fetchNextTerm();
            if (this.nextTerm != null) continue;
            this.close();
            return false;
        } while (this.parentStore.rejectCacheTerm(this.nextTerm));
        return true;
    }

    @Override
    public T next() {
        if (this.nextTerm == null) {
            throw new IllegalStateException("Called next() when hasNext() == false (or before the first hasNext() call).");
        }
        ++this.termCount;
        T term = this.nextTerm;
        this.nextTerm = null;
        return term;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private T fetchNextTerm() {
        if (this.nextCachedTermIndex >= this.termCache.size() && !this.fetchPage()) {
            return null;
        }
        StreamingTerm term = (StreamingTerm)this.termCache.get(this.nextCachedTermIndex);
        ++this.nextCachedTermIndex;
        return (T)term;
    }

    private boolean fetchPage() {
        this.termCache.clear();
        ++this.currentPage;
        this.nextCachedTermIndex = 0;
        if (this.currentPage >= this.numPages) {
            return false;
        }
        int pageIndex = this.pageAccessOrder.get(this.currentPage);
        String termPagePath = this.parentStore.getTermPagePath(pageIndex);
        this.termBuffer.clear();
        this.readPage(termPagePath);
        if (this.shufflePage) {
            for (int i = 0; i < this.termCache.size(); ++i) {
                this.shuffleMap[i] = i;
            }
            RandUtils.pairedShuffleIndexes(this.termCache, this.shuffleMap);
        }
        return true;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.termCache.clear();
        this.parentStore.cacheIterationComplete(this.termCount);
    }

    protected abstract void readPage(String var1);
}

