/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.streaming;

import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.reasoner.term.streaming.StreamingIterator;
import org.linqs.psl.reasoner.term.streaming.StreamingTerm;
import org.linqs.psl.util.FileUtils;
import org.linqs.psl.util.Logger;

public abstract class StreamingTermStore<T extends StreamingTerm>
extends TermStore<T> {
    private static final Logger log = Logger.getLogger(StreamingTermStore.class);
    public static final int INITIAL_PATH_CACHE_SIZE = 100;
    protected List<Rule> rules;
    protected List<String> termPagePaths;
    protected boolean initialRound;
    protected StreamingIterator<T> activeIterator;
    protected long termCount;
    protected int numPages;
    protected int pageSize = Options.STREAMING_TS_PAGE_SIZE.getInt();
    protected String pageDir = Options.STREAMING_TS_PAGE_LOCATION.getString();
    protected boolean shufflePage = Options.STREAMING_TS_SHUFFLE_PAGE.getBoolean();
    protected boolean randomizePageAccess = Options.STREAMING_TS_RANDOMIZE_PAGE_ACCESS.getBoolean();
    protected boolean warnRules = Options.STREAMING_TS_WARN_RULES.getBoolean();
    protected ByteBuffer termBuffer;
    protected List<T> termCache;
    protected List<T> termPool;
    protected int[] shuffleMap;

    public StreamingTermStore(List<Rule> rawRules, Database database, TermGenerator<T> termGenerator) {
        super(database, termGenerator);
        this.rules = new ArrayList<Rule>();
        for (Rule rule : rawRules) {
            if (!this.supportsRule(rule, this.warnRules)) continue;
            this.rules.add(rule);
        }
        if (this.rules.size() == 0) {
            throw new IllegalArgumentException("Found no valid rules for a streaming term store.");
        }
        this.termPagePaths = new ArrayList<String>(100);
        this.initialRound = true;
        this.activeIterator = null;
        this.termCount = 0L;
        this.numPages = 0;
        this.termBuffer = null;
        this.termCache = new ArrayList<T>(this.pageSize);
        this.termPool = new ArrayList<T>(this.pageSize);
        this.shuffleMap = new int[this.pageSize];
        if (this.pageSize <= 1) {
            throw new IllegalArgumentException("Page size is too small.");
        }
        FileUtils.recursiveDelete(this.pageDir);
        FileUtils.mkdir(this.pageDir);
    }

    @Override
    public int add(GroundRule rule, T term, Hyperplane hyperplane) {
        throw new UnsupportedOperationException();
    }

    public void cacheIterationComplete(long termCount) {
        this.termCount = termCount;
        this.activeIterator = null;
    }

    @Override
    public void clear() {
        this.initialRound = true;
        this.termCount = 0L;
        this.numPages = 0;
        if (this.activeIterator != null) {
            this.activeIterator.close();
            this.activeIterator = null;
        }
        if (this.termCache != null) {
            this.termCache.clear();
        }
        if (this.termPool != null) {
            this.termPool.clear();
        }
        FileUtils.recursiveDelete(this.pageDir);
    }

    @Override
    public void close() {
        super.close();
        if (this.termBuffer != null) {
            this.termBuffer.clear();
            this.termBuffer = null;
        }
        if (this.termCache != null) {
            this.termCache = null;
        }
        if (this.termPool != null) {
            this.termPool = null;
        }
    }

    @Override
    public void ensureCapacity(long capacity) {
    }

    @Override
    public T get(long index) {
        throw new UnsupportedOperationException();
    }

    public String getTermPagePath(int index) {
        for (int i = this.termPagePaths.size(); i <= index; ++i) {
            this.termPagePaths.add(Paths.get(this.pageDir, String.format("%08d_term.page", i)).toString());
        }
        return this.termPagePaths.get(index);
    }

    public void groundingIterationComplete(long termCount, int numPages, ByteBuffer termBuffer) {
        this.termCount += termCount;
        this.numPages = numPages;
        this.termBuffer = termBuffer;
        this.initialRound = false;
        this.activeIterator = null;
    }

    public boolean isInitialRound() {
        return this.initialRound;
    }

    @Override
    public Iterator<T> iterator() {
        return this.streamingIterator();
    }

    public boolean rejectCacheTerm(T term) {
        return false;
    }

    @Override
    public long size() {
        return this.termCount;
    }

    protected StreamingIterator<T> streamingIterator() {
        if (this.activeIterator != null) {
            throw new IllegalStateException("Iterator already exists for this StreamingTermStore. Exhaust the iterator first.");
        }
        this.activeIterator = this.initialRound ? this.getGroundingIterator() : this.getCacheIterator();
        return this.activeIterator;
    }

    protected boolean supportsRule(Rule rule, boolean warnRules) {
        if (!rule.isWeighted()) {
            if (warnRules) {
                log.warn("Streaming term stores do not support hard constraints: " + rule);
            }
            return false;
        }
        if (!rule.supportsIndividualGrounding()) {
            if (warnRules) {
                log.warn("Streaming term stores do not support rules that cannot individually ground (arithmetic rules with summations): " + rule);
            }
            return false;
        }
        return true;
    }

    protected abstract StreamingIterator<T> getGroundingIterator();

    protected abstract StreamingIterator<T> getCacheIterator();
}

