/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.runtime;

import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.config.Config;
import org.linqs.psl.config.Options;
import org.linqs.psl.config.RuntimeOptions;
import org.linqs.psl.database.AtomStore;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.Partition;
import org.linqs.psl.grounding.Grounding;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.model.rule.arithmetic.AbstractGroundArithmeticRule;
import org.linqs.psl.model.rule.logical.AbstractGroundLogicalRule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.reasoner.term.DummyTermStore;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.runtime.Runtime;
import org.linqs.psl.runtime.RuntimeConfig;
import org.linqs.psl.util.Logger;
import org.linqs.psl.util.StringUtils;
import org.linqs.psl.util.Version;

public final class GroundingAPI
extends Runtime {
    private static final Logger log = Logger.getLogger(GroundingAPI.class);

    public static GroundProgram groundStatic(String configPath) {
        GroundingAPI api = new GroundingAPI();
        return api.ground(configPath);
    }

    public static GroundProgram groundStatic(RuntimeConfig config) {
        GroundingAPI api = new GroundingAPI();
        return api.ground(config);
    }

    public static String serializedGround(String jsonConfig, String basePath) {
        RuntimeConfig config = RuntimeConfig.fromJSON(jsonConfig, basePath);
        GroundProgram program = GroundingAPI.groundStatic(config);
        return program.toJSON();
    }

    public GroundProgram ground(String configPath) {
        RuntimeConfig config = RuntimeConfig.fromFile(configPath);
        return this.ground(config);
    }

    public GroundProgram ground(RuntimeConfig config) {
        Config.pushLayer();
        try {
            GroundProgram groundProgram = this.groundInternal(config);
            return groundProgram;
        }
        finally {
            Config.popLayer();
            this.cleanup();
        }
    }

    private GroundProgram groundInternal(RuntimeConfig config) {
        for (Map.Entry<String, String> entry : config.options.entrySet()) {
            Config.setProperty(entry.getKey(), entry.getValue(), false);
        }
        this.initLogger();
        log.info("PSL Grounding API Version {}", Version.getFull());
        config.validate();
        Options.ATOM_STORE_STORE_ALL_ATOMS.set(true);
        for (Map.Entry<String, String> entry : config.options.entrySet()) {
            Config.setProperty(entry.getKey(), entry.getValue(), false);
        }
        final ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Rule rule : config.rules.getRules()) {
            rules.add(rule);
        }
        DataStore dataStore = this.initDataStore(config);
        this.loadData(dataStore, config, "infer");
        Set<StandardPredicate> closedPredicates = config.getClosedPredicates("infer");
        Partition targetPartition = dataStore.getPartition("targets");
        Partition observationsPartition = dataStore.getPartition("observations");
        Database database = dataStore.getDatabase(targetPartition, closedPredicates, observationsPartition);
        final AtomStore atomStore = database.getAtomStore();
        DummyTermStore store = new DummyTermStore(database);
        final ArrayList<GroundRuleInfo> groundRules = new ArrayList<GroundRuleInfo>();
        HashMap<Integer, AtomInfo> groundAtoms = null;
        if (!RuntimeOptions.OUTPUT_ALL_ATOMS.getBoolean()) {
            groundAtoms = new HashMap<Integer, AtomInfo>();
        }
        final HashMap<Integer, AtomInfo> finalGroundAtoms = groundAtoms;
        Grounding.setGroundRuleCallback(new Grounding.GroundRuleCallback(){

            @Override
            public synchronized void call(GroundRule groundRule) {
                groundRules.add(GroundingAPI.this.mapGroundRule(rules.indexOf(groundRule.getRule()), atomStore, groundRule, finalGroundAtoms));
            }
        });
        Grounding.groundAll(rules, store);
        Grounding.setGroundRuleCallback(null);
        if (groundAtoms == null) {
            groundAtoms = new HashMap(atomStore.size());
            for (GroundAtom groundAtom : atomStore) {
                groundAtoms.put(groundAtom.getIndex(), new AtomInfo(groundAtom));
            }
        }
        ((TermStore)store).close();
        database.close();
        dataStore.close();
        return new GroundProgram(groundAtoms, groundRules);
    }

    private GroundRuleInfo mapGroundRule(int ruleIndex, AtomStore store, GroundRule groundRule, Map<Integer, AtomInfo> usedAtoms) {
        float weight = -1.0f;
        if (groundRule.getRule().isWeighted()) {
            weight = ((WeightedRule)groundRule.getRule()).getWeight();
        }
        if (groundRule instanceof AbstractGroundLogicalRule) {
            return this.mapGroundRule(ruleIndex, store, (AbstractGroundLogicalRule)groundRule, weight, usedAtoms);
        }
        if (groundRule instanceof AbstractGroundArithmeticRule) {
            return this.mapGroundRule(ruleIndex, store, (AbstractGroundArithmeticRule)groundRule, weight, usedAtoms);
        }
        throw new IllegalStateException("Unknown rule type: " + groundRule.getClass());
    }

    private GroundRuleInfo mapGroundRule(int ruleIndex, AtomStore store, AbstractGroundLogicalRule groundRule, float weight, Map<Integer, AtomInfo> usedAtoms) {
        Integer key;
        int atomIndex;
        int currentAtom = 0;
        float[] coefficients = new float[groundRule.size()];
        int[] atoms = new int[groundRule.size()];
        for (GroundAtom atom : groundRule.getPositiveAtoms()) {
            coefficients[currentAtom] = -1.0f;
            atoms[currentAtom] = atomIndex = store.getAtomIndex(atom);
            ++currentAtom;
            if (usedAtoms == null || usedAtoms.containsKey(key = Integer.valueOf(atomIndex))) continue;
            usedAtoms.put(key, new AtomInfo(atom));
        }
        for (GroundAtom atom : groundRule.getNegativeAtoms()) {
            coefficients[currentAtom] = 1.0f;
            atoms[currentAtom] = atomIndex = store.getAtomIndex(atom);
            ++currentAtom;
            if (usedAtoms == null || usedAtoms.containsKey(key = Integer.valueOf(atomIndex))) continue;
            usedAtoms.put(key, new AtomInfo(atom));
        }
        return new GroundRuleInfo(ruleIndex, "|", weight, 0.0f, coefficients, atoms);
    }

    private GroundRuleInfo mapGroundRule(int ruleIndex, AtomStore store, AbstractGroundArithmeticRule groundRule, float weight, Map<Integer, AtomInfo> usedAtoms) {
        GroundAtom[] rawAtoms = groundRule.getOrderedAtoms();
        int[] atoms = new int[rawAtoms.length];
        for (int i = 0; i < rawAtoms.length; ++i) {
            Integer key;
            int atomIndex;
            atoms[i] = atomIndex = store.getAtomIndex(rawAtoms[i]);
            if (usedAtoms == null || usedAtoms.containsKey(key = Integer.valueOf(atomIndex))) continue;
            usedAtoms.put(key, new AtomInfo(rawAtoms[i]));
        }
        return new GroundRuleInfo(ruleIndex, groundRule.getComparator().toString(), weight, groundRule.getConstant(), groundRule.getCoefficients(), atoms);
    }

    public static void main(String[] args) {
        if (args == null || args.length != 1) {
            System.out.println("USAGE: " + GroundingAPI.class + " <path to JSON config>");
            return;
        }
        GroundProgram program = GroundingAPI.groundStatic(args[0]);
        System.out.println(program);
    }

    public static final class GroundRuleInfo {
        public int ruleIndex;
        public String operator;
        public float weight;
        public float constant;
        public float[] coefficients;
        public int[] atoms;

        public GroundRuleInfo(int ruleIndex, String operator, float weight, float constant, float[] coefficients, int[] atoms) {
            this.ruleIndex = ruleIndex;
            this.operator = operator;
            this.weight = weight;
            this.constant = constant;
            this.coefficients = coefficients;
            this.atoms = atoms;
        }

        public String toString() {
            return String.format("Rule Type: %s, Weight: %f, Constant: %f, coefficients: [%s], atoms: [%s].", this.operator, Float.valueOf(this.weight), Float.valueOf(this.constant), StringUtils.join(", ", this.coefficients), StringUtils.join(", ", this.atoms));
        }
    }

    public static final class AtomInfo {
        public String predicate;
        public String[] arguments;
        public float value;
        public boolean observed;

        public AtomInfo(GroundAtom atom) {
            this.predicate = atom.getPredicate().getName();
            this.value = atom.getValue();
            this.observed = atom instanceof ObservedAtom;
            this.arguments = new String[atom.getArity()];
            Constant[] terms = atom.getArguments();
            for (int i = 0; i < terms.length; ++i) {
                this.arguments[i] = terms[i].rawToString();
            }
        }
    }

    public static final class GroundProgram {
        public Map<Integer, AtomInfo> atoms;
        public List<GroundRuleInfo> groundRules;

        public GroundProgram(Map<Integer, AtomInfo> atoms, List<GroundRuleInfo> groundRules) {
            this.atoms = atoms;
            this.groundRules = groundRules;
        }

        public String toString() {
            return this.toJSON();
        }

        public String toJSON() {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
            DefaultPrettyPrinter printer = new DefaultPrettyPrinter().withObjectIndenter(new DefaultIndenter("    ", "\n"));
            try {
                return mapper.writer(printer).writeValueAsString(this);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

