/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.runtime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.config.RuntimeOptions;
import org.linqs.psl.evaluation.statistics.Evaluator;
import org.linqs.psl.model.Model;
import org.linqs.psl.model.function.ExternalFunction;
import org.linqs.psl.model.predicate.ExternalFunctionalPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.parser.ModelLoader;
import org.linqs.psl.util.FileUtils;
import org.linqs.psl.util.IteratorUtils;
import org.linqs.psl.util.Reflection;

public class RuntimeConfig {
    public static final String KEY_RULES = "rules";
    public static final String KEY_ALL = "all";
    public static final String KEY_LEARN = "learn";
    public static final String KEY_VALIDATION = "validation";
    public static final String KEY_INFER = "infer";
    public static final String KEY_EVALUATOR = "evaluator";
    public static final String KEY_OPTIONS = "options";
    public static final String KEY_PRIMARY = "primary";
    public RuleSource rules = new RuleList();
    public Map<String, PredicateConfigInfo> predicates = new HashMap<String, PredicateConfigInfo>();
    public Map<String, String> options = new HashMap<String, String>();
    public SplitConfigInfo learn = new SplitConfigInfo();
    public SplitConfigInfo validation = new SplitConfigInfo();
    public SplitConfigInfo infer = new SplitConfigInfo();
    @JsonIgnore
    protected String relativeBasePath = ".";

    public void validate() {
        boolean runLearn = false;
        boolean runValidation = false;
        boolean runInfer = false;
        if (!this.learn.isEmpty()) {
            runLearn = true;
        }
        if (!this.validation.isEmpty()) {
            runValidation = true;
        }
        if (!this.infer.isEmpty()) {
            runInfer = true;
        }
        boolean hasPrimaryEval = false;
        for (Map.Entry<String, PredicateConfigInfo> entry : this.predicates.entrySet()) {
            hasPrimaryEval = this.validatePredicate(entry.getKey(), entry.getValue(), hasPrimaryEval);
            if (entry.getValue().hasExplicitLearnData()) {
                runLearn = true;
            }
            if (entry.getValue().hasExplicitValidationData()) {
                runValidation = true;
            }
            if (!entry.getValue().hasExplicitInferData()) continue;
            runInfer = true;
        }
        this.validateRules(this.rules);
        this.validateRules(this.learn.rules);
        this.validateRules(this.validation.rules);
        this.validateRules(this.infer.rules);
        if (!(RuntimeOptions.LEARN.isSet() || RuntimeOptions.INFERENCE.isSet() || runLearn || runInfer)) {
            runInfer = true;
        }
        if (RuntimeOptions.LEARN.isSet()) {
            runLearn = RuntimeOptions.LEARN.getBoolean();
        }
        if (RuntimeOptions.VALIDATION.isSet()) {
            runValidation = RuntimeOptions.VALIDATION.getBoolean();
        }
        if (RuntimeOptions.INFERENCE.isSet()) {
            runInfer = RuntimeOptions.INFERENCE.getBoolean();
        }
        this.options.put(RuntimeOptions.LEARN.name(), "" + runLearn);
        this.options.put(RuntimeOptions.VALIDATION.name(), "" + runValidation);
        this.options.put(RuntimeOptions.INFERENCE.name(), "" + runInfer);
    }

    public Set<StandardPredicate> getClosedPredicates(String splitName) {
        HashSet<StandardPredicate> closedPredicates = new HashSet<StandardPredicate>();
        for (PredicateConfigInfo predicateInfo : this.predicates.values()) {
            Predicate predicate;
            if (predicateInfo.isOpen(splitName) || !((predicate = Predicate.get(predicateInfo.name)) instanceof StandardPredicate)) continue;
            closedPredicates.add((StandardPredicate)predicate);
        }
        return closedPredicates;
    }

    private void validateRules(RuleSource ruleSource) {
        ruleSource.resolvePaths(this.relativeBasePath);
        for (Rule rule : ruleSource.getRules()) {
        }
    }

    private boolean validatePredicate(String name, PredicateConfigInfo info, boolean hasPrimaryEval) {
        int i;
        if (!name.equals(info.name)) {
            throw new IllegalArgumentException(String.format("Predicate name mismatch: ['%s', '%s'].", name, info.name));
        }
        info.resolvePaths(this.relativeBasePath);
        if (info.types == null) {
            info.types = new ArrayList<String>();
        }
        if (info.types.size() != 0 && info.arity <= 0) {
            info.arity = info.types.size();
        }
        if (info.types.size() != 0 && info.types.size() != info.arity) {
            throw new IllegalArgumentException(String.format("Arity mismatch on predicate %s. Arity declared as property: %d. Arity inferred by types: %d.", info.name, info.arity, info.types.size()));
        }
        if (info.arity <= 0) {
            throw new IllegalArgumentException(String.format("Bad or missing arity on predicate %s. Arity should be a positive integer, found %d.", info.name, info.arity));
        }
        if (info.types == null || info.types.size() == 0) {
            info.types = new ArrayList<String>(info.arity);
            String defaultType = ConstantType.UniqueStringID.toString();
            if (RuntimeOptions.DB_INT_IDS.getBoolean()) {
                defaultType = ConstantType.UniqueIntID.toString();
            }
            for (i = 0; i < info.arity; ++i) {
                info.types.add(defaultType);
            }
        }
        ConstantType[] types = new ConstantType[info.arity];
        for (i = 0; i < info.arity; ++i) {
            types[i] = ConstantType.valueOf(info.types.get(i));
        }
        for (String string : info.getAllDataPaths()) {
            if (FileUtils.isFile(string)) continue;
            throw new IllegalArgumentException(String.format("Non-existent path found in data for predicate %s. Path: '%s'.", info.name, string));
        }
        for (List list : info.getAllDataPoints()) {
            if (list.size() == info.arity || list.size() == info.arity + 1) continue;
            throw new IllegalArgumentException(String.format("Mismatch on embedded data size for predicate %s. Expected size %s or %s, found size %s. Offending row: %s.", info.name, info.arity, info.arity + 1, list.size(), list));
        }
        if (info.function != null) {
            ExternalFunctionalPredicate.get(name, (ExternalFunction)Reflection.newObject(info.function));
            if (info.dataSize() > 0) {
                throw new IllegalArgumentException(String.format("Predicate (%s) cannot be functional and have data.", name));
            }
        } else {
            this.getPredicateMethod(info, new Object[]{name, types});
        }
        for (EvalInfo evalInfo : info.evaluations) {
            Object evaluator = Reflection.newObject(evalInfo.evaluator);
            if (!(evaluator instanceof Evaluator)) {
                throw new IllegalArgumentException(String.format("Predicate (%s) has a listed evaluator that is not a child of %s. Found type: %s.", name, "org.linqs.psl.evaluation.statistics.Evaluator", evaluator.getClass()));
            }
            if (!evalInfo.primary) continue;
            if (hasPrimaryEval) {
                throw new IllegalArgumentException("Multiple primary evaluations found, at most one is allowed.");
            }
            hasPrimaryEval = true;
        }
        return hasPrimaryEval;
    }

    public void getPredicateMethod(PredicateConfigInfo info, Object ... parameters) {
        Method method = null;
        Class[] paramtersClass = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            paramtersClass[i] = parameters[i].getClass();
        }
        try {
            method = info.type.getMethod("get", paramtersClass);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(String.format("Predicate (%s) with type (%s) does not have a static method with the name %s.", info.name, info.type, "get"));
        }
        try {
            method.invoke(null, parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new IllegalArgumentException(String.format("Predicate (%s) with type (%s) contains illegal arguments on static method with name %s. Found arguments: %s.", info.name, info.type, "get", Arrays.toString(parameters)), ex);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean skipEmptyValues) {
        ObjectMapper mapper = RuntimeConfig.getMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        if (skipEmptyValues) {
            JsonInclude.Value includeValue = JsonInclude.Value.empty().withValueInclusion(JsonInclude.Include.CUSTOM).withValueFilter(EmptyValueFilter.class);
            mapper.setDefaultPropertyInclusion(includeValue);
        }
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter().withObjectIndenter(new DefaultIndenter("    ", "\n"));
        try {
            return mapper.writer(printer).writeValueAsString(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof RuntimeConfig)) {
            return false;
        }
        RuntimeConfig otherConfig = (RuntimeConfig)other;
        return this.rules.equals(otherConfig.rules) && this.predicates.equals(otherConfig.predicates) && this.options.equals(otherConfig.options) && this.learn.equals(otherConfig.learn) && this.validation.equals(otherConfig.validation) && this.infer.equals(otherConfig.infer);
    }

    public static RuntimeConfig fromFile(String path) {
        RuntimeConfig config = null;
        if (path.toLowerCase().endsWith(".json")) {
            config = RuntimeConfig.fromJSON(FileUtils.readFileAsString(path));
        } else if (path.toLowerCase().endsWith(".yaml")) {
            config = RuntimeConfig.fromJSON(RuntimeConfig.convertYAML(FileUtils.readFileAsString(path)));
        } else {
            throw new IllegalArgumentException("Expected runtime config file to end  in '.json' or '.yaml'.");
        }
        Path parent = Paths.get(path, new String[0]).normalize().getParent();
        if (parent != null) {
            config.relativeBasePath = parent.toString();
        }
        return config;
    }

    public static RuntimeConfig fromJSON(String contents) {
        return RuntimeConfig.fromJSON(contents, ".");
    }

    public static RuntimeConfig fromJSON(String contents, String relativeBasePath) {
        JSONRuntimeConfig baseConfig = RuntimeConfig.parseJSON(contents);
        RuntimeConfig config = baseConfig.formalize();
        config.relativeBasePath = relativeBasePath;
        return config;
    }

    private static JSONRuntimeConfig parseJSON(String contents) {
        JSONRuntimeConfig baseConfig = null;
        ObjectMapper mapper = RuntimeConfig.getMapper();
        try {
            baseConfig = mapper.readValue(contents, JSONRuntimeConfig.class);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
        return baseConfig;
    }

    private static ObjectMapper getMapper() {
        Object mapper = JsonMapper.builder().enable(JsonReadFeature.ALLOW_JAVA_COMMENTS).enable(JsonReadFeature.ALLOW_YAML_COMMENTS).enable(JsonReadFeature.ALLOW_SINGLE_QUOTES).enable(JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS).enable(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS).enable(JsonReadFeature.ALLOW_TRAILING_COMMA).build();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(PartitionInfo.class, new PartitionDeserializer());
        module.addDeserializer(RuleSource.class, new RuleDeserializer());
        module.addSerializer(RuleSource.class, new RuleSerializer());
        module.addDeserializer(EvalInfo.class, new EvalDeserializer());
        module.addSerializer(SplitDataInfo.class, new SplitSerializer());
        ((ObjectMapper)mapper).registerModule(module);
        return mapper;
    }

    private static String convertYAML(String contents) {
        try {
            ObjectMapper yamlReader = new ObjectMapper(new YAMLFactory());
            Object obj = yamlReader.readValue(contents, Object.class);
            ObjectMapper jsonWriter = new ObjectMapper();
            return jsonWriter.writeValueAsString(obj);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) {
        RuntimeConfig config = RuntimeConfig.fromFile(args[0]);
        System.out.println(config.toString(true));
        RuntimeConfig.fromJSON(config.toString());
    }

    private static class EmptyValueFilter {
        private EmptyValueFilter() {
        }

        public boolean equals(Object value) {
            if (value == null) {
                return true;
            }
            if (value instanceof Collection && ((Collection)value).size() == 0) {
                return true;
            }
            if (value instanceof Map && ((Map)value).size() == 0) {
                return true;
            }
            if (value instanceof SplitDataInfo && ((SplitDataInfo)value).size() == 0) {
                return true;
            }
            return value instanceof PartitionInfo && ((PartitionInfo)value).size() == 0;
        }
    }

    private static class PartitionDeserializer
    extends StdDeserializer<PartitionInfo> {
        public PartitionDeserializer() {
            this((Class<PartitionInfo>)null);
        }

        public PartitionDeserializer(Class<PartitionInfo> cls) {
            super(cls);
        }

        @Override
        public PartitionInfo deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode root = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            PartitionInfo partition = new PartitionInfo();
            if (root instanceof ArrayNode) {
                this.parseDataSpec((ArrayNode)root, partition.all);
            } else if (root instanceof ObjectNode) {
                for (Map.Entry<String, JsonNode> entry : IteratorUtils.newIterable(((ObjectNode)root).fields())) {
                    if (!(entry.getValue() instanceof ArrayNode)) {
                        throw new IllegalStateException("Expecting split value to be an array, found " + entry.getValue().getClass() + ".");
                    }
                    if (entry.getKey().equals(RuntimeConfig.KEY_ALL)) {
                        this.parseDataSpec((ArrayNode)entry.getValue(), partition.all);
                        continue;
                    }
                    if (entry.getKey().equals(RuntimeConfig.KEY_LEARN)) {
                        this.parseDataSpec((ArrayNode)entry.getValue(), partition.learn);
                        continue;
                    }
                    if (entry.getKey().equals(RuntimeConfig.KEY_VALIDATION)) {
                        this.parseDataSpec((ArrayNode)entry.getValue(), partition.validation);
                        continue;
                    }
                    if (entry.getKey().equals(RuntimeConfig.KEY_INFER)) {
                        this.parseDataSpec((ArrayNode)entry.getValue(), partition.infer);
                        continue;
                    }
                    throw new IllegalStateException(String.format("Unknown split type (%s). Expecting one of [%s, %s, %s, %s].", entry.getKey(), RuntimeConfig.KEY_ALL, RuntimeConfig.KEY_LEARN, RuntimeConfig.KEY_VALIDATION, RuntimeConfig.KEY_INFER));
                }
            } else {
                throw new IllegalArgumentException("Expecting partition value to be an array or object, found " + root.getClass() + ".");
            }
            return partition;
        }

        private void parseDataSpec(ArrayNode root, SplitDataInfo split) {
            for (JsonNode element : root) {
                if (element instanceof TextNode) {
                    split.paths.add(((TextNode)element).textValue());
                    continue;
                }
                if (element instanceof ArrayNode) {
                    ArrayList<String> values = new ArrayList<String>(((ArrayNode)element).size());
                    for (JsonNode value : element) {
                        if (!(value instanceof ValueNode)) {
                            throw new IllegalStateException("Literal data should only be simple types, found " + value.getClass() + ".");
                        }
                        values.add(value.asText());
                    }
                    split.data.add(values);
                    continue;
                }
                throw new IllegalStateException("Data specifications must be strings (file paths) or arrays (literal data), found " + element.getClass() + ".");
            }
        }
    }

    private static class RuleDeserializer
    extends StdDeserializer<RuleSource> {
        public RuleDeserializer() {
            this((Class<RuleSource>)null);
        }

        public RuleDeserializer(Class<RuleSource> cls) {
            super(cls);
        }

        @Override
        public RuleSource deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode root = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            if (root instanceof ArrayNode) {
                ArrayList<String> rules = new ArrayList<String>();
                for (JsonNode ruleNode : (ArrayNode)root) {
                    if (!(ruleNode instanceof TextNode)) {
                        throw new IllegalArgumentException("Expecting rule array to only contain strings, found " + ruleNode.getClass() + ".");
                    }
                    rules.add(((TextNode)ruleNode).textValue());
                }
                return new RuleList(rules);
            }
            if (root instanceof TextNode) {
                return new RulePath(((TextNode)root).textValue());
            }
            throw new IllegalArgumentException("Expecting rule value to be an array or string (path), found " + root.getClass() + ".");
        }
    }

    private static class RuleSerializer
    extends StdSerializer<RuleSource> {
        public RuleSerializer() {
            this((Class<RuleSource>)null);
        }

        public RuleSerializer(Class<RuleSource> cls) {
            super(cls);
        }

        @Override
        public void serialize(RuleSource value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (value instanceof RulePath) {
                generator.writeString(((RulePath)value).path);
            } else if (value instanceof RuleList) {
                generator.writeObject(((RuleList)value).rules);
            } else {
                throw new IllegalStateException("Unknown RuleSource subtype: " + value.getClass());
            }
        }
    }

    private static class SplitSerializer
    extends StdSerializer<SplitDataInfo> {
        public SplitSerializer() {
            this((Class<SplitDataInfo>)null);
        }

        public SplitSerializer(Class<SplitDataInfo> cls) {
            super(cls);
        }

        @Override
        public void serialize(SplitDataInfo value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            ArrayList<Object> values = new ArrayList<Object>(value.paths.size() + value.data.size());
            values.addAll(value.paths);
            values.addAll(value.data);
            generator.writeObject(values);
        }
    }

    private static class EvalDeserializer
    extends StdDeserializer<EvalInfo> {
        public EvalDeserializer() {
            this((Class)null);
        }

        public EvalDeserializer(Class cls) {
            super(cls);
        }

        @Override
        public EvalInfo deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode root = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            if (root instanceof TextNode) {
                return new EvalInfo(((TextNode)root).textValue(), new HashMap<String, String>(), false);
            }
            if (root instanceof ObjectNode) {
                return this.parseEvalDef((ObjectNode)root);
            }
            throw new IllegalArgumentException("Expecting evaluation value to be a string (class name) or object, found " + root.getClass() + ".");
        }

        private EvalInfo parseEvalDef(ObjectNode root) {
            if (!root.hasNonNull(RuntimeConfig.KEY_EVALUATOR)) {
                throw new IllegalArgumentException("Evalautor object missing the 'evaluator' key.");
            }
            String evaluator = root.get(RuntimeConfig.KEY_EVALUATOR).textValue();
            Map<Object, Object> options = null;
            boolean primary = false;
            options = root.hasNonNull(RuntimeConfig.KEY_OPTIONS) ? this.parseEvalOptions(root.get(RuntimeConfig.KEY_OPTIONS)) : new HashMap();
            if (root.hasNonNull(RuntimeConfig.KEY_PRIMARY)) {
                primary = root.get(RuntimeConfig.KEY_PRIMARY).booleanValue();
            }
            return new EvalInfo(evaluator, options, primary);
        }

        private Map<String, String> parseEvalOptions(JsonNode root) {
            if (!(root instanceof ObjectNode)) {
                throw new IllegalArgumentException("Expecting evaluation options to be an object, found " + root.getClass() + ".");
            }
            ObjectMapper mapper = RuntimeConfig.getMapper();
            MapLikeType mapType = mapper.getTypeFactory().constructMapLikeType(Map.class, String.class, String.class);
            try {
                Map rawMap = mapper.treeToValue((TreeNode)root, Map.class);
                return (Map)mapper.convertValue((Object)rawMap, mapType);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class JSONPredicate {
        public String name;
        public String type;
        public Integer arity;
        public List<String> types;
        @JsonProperty(value="force-open")
        public Boolean forceOpen;
        public PartitionInfo observations;
        public PartitionInfo targets;
        public PartitionInfo truth;
        public String function;
        public List<EvalInfo> evaluations;
        public Map<String, String> options;

        private JSONPredicate() {
        }

        public PredicateConfigInfo formalize(String rawName) {
            Class suppressWarnings;
            PredicateConfigInfo config = new PredicateConfigInfo();
            config.function = this.function;
            config.type = this.type == null ? StandardPredicate.class : (suppressWarnings = Reflection.getClass(this.type));
            config.options = this.options == null ? new HashMap() : this.options;
            config.types = this.types == null ? new ArrayList() : this.types;
            config.evaluations = this.evaluations == null ? new ArrayList() : this.evaluations;
            config.observations = this.observations == null ? new PartitionInfo() : this.observations;
            config.targets = this.targets == null ? new PartitionInfo() : this.targets;
            config.truth = this.truth == null ? new PartitionInfo() : this.truth;
            config.forceOpen = false;
            if (this.forceOpen != null && this.forceOpen.booleanValue()) {
                config.forceOpen = true;
            }
            config.arity = -1;
            if (this.arity != null) {
                config.arity = this.arity;
            }
            if (rawName.contains("/")) {
                String[] parts = rawName.split("/");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Predicate names may not contain a slash. Offending name: '" + rawName + "'.");
                }
                config.name = parts[0];
                int parsedArity = Integer.parseInt(parts[1]);
                if (config.arity != -1 && config.arity != parsedArity) {
                    throw new IllegalArgumentException(String.format("Arity mismatch on predicate %s. Arity declared as property: %d. Arity declared on predicate name: %d.", config.name, config.arity, parsedArity));
                }
                config.arity = parsedArity;
            } else {
                config.name = rawName;
            }
            return config;
        }
    }

    private static class JSONRuntimeConfig {
        public RuleSource rules;
        public Map<String, JSONPredicate> predicates;
        public Map<String, String> options;
        public SplitConfigInfo learn;
        public SplitConfigInfo validation;
        public SplitConfigInfo infer;

        private JSONRuntimeConfig() {
        }

        public RuntimeConfig formalize() {
            RuntimeConfig config = new RuntimeConfig();
            config.options = this.options == null ? new HashMap() : this.options;
            config.rules = this.rules == null ? new RuleList() : this.rules;
            config.learn = this.learn == null ? new SplitConfigInfo() : this.learn;
            config.validation = this.validation == null ? new SplitConfigInfo() : this.validation;
            SplitConfigInfo splitConfigInfo = config.infer = this.infer == null ? new SplitConfigInfo() : this.infer;
            if (this.predicates == null) {
                this.predicates = new HashMap<String, JSONPredicate>();
            }
            config.predicates = new HashMap<String, PredicateConfigInfo>(this.predicates.size());
            for (Map.Entry<String, JSONPredicate> entry : this.predicates.entrySet()) {
                PredicateConfigInfo predicate = entry.getValue().formalize(entry.getKey());
                config.predicates.put(predicate.name, predicate);
            }
            return config;
        }
    }

    public static class EvalInfo {
        public String evaluator;
        public Map<String, String> options;
        public boolean primary;

        public EvalInfo(String evaluator) {
            this(evaluator, new HashMap<String, String>(), false);
        }

        public EvalInfo(String evaluator, Map<String, String> options, boolean primary) {
            this.evaluator = evaluator;
            this.options = options;
            this.primary = primary;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof EvalInfo)) {
                return false;
            }
            EvalInfo otherInfo = (EvalInfo)other;
            return this.evaluator.equals(otherInfo.evaluator) && this.options.equals(otherInfo.options) && this.primary == otherInfo.primary;
        }
    }

    public static class SplitDataInfo {
        public List<String> paths = new ArrayList<String>();
        public List<List<String>> data = new ArrayList<List<String>>();

        public int size() {
            return this.paths.size() + this.data.size();
        }

        public void resolvePaths(String relativeBasePath) {
            for (int i = 0; i < this.paths.size(); ++i) {
                this.paths.set(i, FileUtils.makePath(relativeBasePath, this.paths.get(i)));
            }
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof SplitDataInfo)) {
                return false;
            }
            SplitDataInfo otherInfo = (SplitDataInfo)other;
            return this.paths.equals(otherInfo.paths) && this.data.equals(otherInfo.data);
        }
    }

    public static class PartitionInfo {
        public SplitDataInfo all = new SplitDataInfo();
        public SplitDataInfo learn = new SplitDataInfo();
        public SplitDataInfo validation = new SplitDataInfo();
        public SplitDataInfo infer = new SplitDataInfo();

        public int size() {
            return this.all.size() + this.learn.size() + this.validation.size() + this.infer.size();
        }

        public void resolvePaths(String relativeBasePath) {
            this.all.resolvePaths(relativeBasePath);
            this.learn.resolvePaths(relativeBasePath);
            this.validation.resolvePaths(relativeBasePath);
            this.infer.resolvePaths(relativeBasePath);
        }

        public Iterable<String> getDataPaths(String splitName) {
            Iterable<String> allPaths = this.all.paths;
            switch (splitName) {
                case "learn": {
                    allPaths = IteratorUtils.join(allPaths, this.learn.paths);
                    break;
                }
                case "validation": {
                    allPaths = IteratorUtils.join(allPaths, this.validation.paths);
                    break;
                }
                case "infer": {
                    allPaths = IteratorUtils.join(allPaths, this.infer.paths);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown split name: " + splitName);
                }
            }
            return allPaths;
        }

        public Iterable<List<String>> getDataPoints(String splitName) {
            Iterable<List<String>> allPoints = this.all.data;
            switch (splitName) {
                case "learn": {
                    allPoints = IteratorUtils.join(allPoints, this.learn.data);
                    break;
                }
                case "validation": {
                    allPoints = IteratorUtils.join(allPoints, this.validation.data);
                    break;
                }
                case "infer": {
                    allPoints = IteratorUtils.join(allPoints, this.infer.data);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown split name: " + splitName);
                }
            }
            return allPoints;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof PartitionInfo)) {
                return false;
            }
            PartitionInfo otherInfo = (PartitionInfo)other;
            return this.all.equals(otherInfo.all) && this.learn.equals(otherInfo.learn) && this.validation.equals(otherInfo.validation) && this.infer.equals(otherInfo.infer);
        }
    }

    public static class PredicateConfigInfo {
        public String name;
        public Class<? extends StandardPredicate> type;
        public int arity;
        public List<String> types;
        @JsonProperty(value="force-open")
        public boolean forceOpen;
        public PartitionInfo observations;
        public PartitionInfo targets;
        public PartitionInfo truth;
        public String function;
        public List<EvalInfo> evaluations;
        public Map<String, String> options;

        public PredicateConfigInfo() {
            this(null, -1);
        }

        public PredicateConfigInfo(String name, int arity) {
            this.name = name;
            this.arity = arity;
            this.types = new ArrayList<String>();
            this.forceOpen = false;
            this.observations = new PartitionInfo();
            this.targets = new PartitionInfo();
            this.truth = new PartitionInfo();
            this.function = null;
            this.evaluations = new ArrayList<EvalInfo>();
            this.options = new HashMap<String, String>();
        }

        public void setType(String name) {
            Class suppressWarnings;
            this.type = suppressWarnings = Reflection.getClass(name);
        }

        public int dataSize() {
            return this.observations.size() + this.targets.size() + this.truth.size();
        }

        public boolean hasExplicitLearnData() {
            return this.observations.learn.size() > 0 || this.targets.learn.size() > 0 || this.truth.learn.size() > 0;
        }

        public boolean hasExplicitValidationData() {
            return this.observations.validation.size() > 0 || this.targets.validation.size() > 0 || this.truth.validation.size() > 0;
        }

        public boolean hasExplicitInferData() {
            return this.observations.infer.size() > 0 || this.targets.infer.size() > 0 || this.truth.infer.size() > 0;
        }

        public void resolvePaths(String relativeBasePath) {
            this.observations.resolvePaths(relativeBasePath);
            this.targets.resolvePaths(relativeBasePath);
            this.truth.resolvePaths(relativeBasePath);
        }

        public boolean isOpen(String splitName) {
            return this.forceOpen || this.targets.all.size() > 0 || RuntimeConfig.KEY_INFER.equals(splitName) && this.targets.infer.size() > 0 || RuntimeConfig.KEY_VALIDATION.equals(splitName) && this.targets.validation.size() > 0 || RuntimeConfig.KEY_LEARN.equals(splitName) && this.targets.learn.size() > 0;
        }

        public Iterable<String> getAllDataPaths() {
            return IteratorUtils.join(this.observations.getDataPaths(RuntimeConfig.KEY_LEARN), this.observations.getDataPaths(RuntimeConfig.KEY_VALIDATION), this.observations.getDataPaths(RuntimeConfig.KEY_INFER), this.targets.getDataPaths(RuntimeConfig.KEY_LEARN), this.targets.getDataPaths(RuntimeConfig.KEY_VALIDATION), this.targets.getDataPaths(RuntimeConfig.KEY_INFER), this.truth.getDataPaths(RuntimeConfig.KEY_LEARN), this.truth.getDataPaths(RuntimeConfig.KEY_VALIDATION), this.truth.getDataPaths(RuntimeConfig.KEY_INFER));
        }

        public Iterable<List<String>> getAllDataPoints() {
            return IteratorUtils.join(this.observations.getDataPoints(RuntimeConfig.KEY_LEARN), this.observations.getDataPoints(RuntimeConfig.KEY_VALIDATION), this.observations.getDataPoints(RuntimeConfig.KEY_INFER), this.targets.getDataPoints(RuntimeConfig.KEY_LEARN), this.targets.getDataPoints(RuntimeConfig.KEY_VALIDATION), this.targets.getDataPoints(RuntimeConfig.KEY_INFER), this.truth.getDataPoints(RuntimeConfig.KEY_LEARN), this.truth.getDataPoints(RuntimeConfig.KEY_VALIDATION), this.truth.getDataPoints(RuntimeConfig.KEY_INFER));
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof PredicateConfigInfo)) {
                return false;
            }
            PredicateConfigInfo otherInfo = (PredicateConfigInfo)other;
            return this.name.equals(otherInfo.name) && this.arity == otherInfo.arity && this.types.equals(otherInfo.types) && this.forceOpen == otherInfo.forceOpen && this.observations.equals(otherInfo.observations) && this.targets.equals(otherInfo.targets) && this.truth.equals(otherInfo.truth) && (this.function == null ? otherInfo.function == null : this.function.equals(otherInfo.function)) && this.evaluations.equals(otherInfo.evaluations) && this.options.equals(otherInfo.options);
        }
    }

    public static class SplitConfigInfo {
        public RuleSource rules = new RuleList();
        public Map<String, String> options = new HashMap<String, String>();

        public boolean isEmpty() {
            return this.rules.size() == 0 && this.options.size() == 0;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof SplitConfigInfo)) {
                return false;
            }
            SplitConfigInfo otherInfo = (SplitConfigInfo)other;
            return this.rules.equals(otherInfo.rules) && this.options.equals(otherInfo.options);
        }
    }

    public static class RuleList
    implements RuleSource {
        public List<String> rules;

        public RuleList() {
            this.rules = new ArrayList<String>();
        }

        public RuleList(List<String> rules) {
            this.rules = rules;
        }

        public RuleList(String ... rules) {
            this();
            for (String rule : rules) {
                this.rules.add(rule);
            }
        }

        @Override
        public int size() {
            return this.rules == null ? 0 : this.rules.size();
        }

        @Override
        public Iterable<Rule> getRules() {
            ArrayList<Rule> parsedRules = new ArrayList<Rule>(this.rules.size());
            for (String rule : this.rules) {
                try {
                    parsedRules.add(ModelLoader.loadRule(rule));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to parse rule: " + rule, ex);
                }
            }
            return parsedRules;
        }

        @Override
        public void resolvePaths(String relativeBasePath) {
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof RuleList)) {
                return false;
            }
            RuleList otherList = (RuleList)other;
            return this.rules.containsAll(otherList.rules) && otherList.rules.containsAll(this.rules);
        }
    }

    public static class RulePath
    implements RuleSource {
        public String path;

        public RulePath(String path) {
            this.path = path;
        }

        @Override
        public int size() {
            return this.path == null ? 0 : 1;
        }

        @Override
        public Iterable<Rule> getRules() {
            Model model = null;
            try (BufferedReader reader = FileUtils.getBufferedReader(this.path);){
                model = ModelLoader.load(reader);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to load model from file: " + this.path, ex);
            }
            return model.getRules();
        }

        @Override
        public void resolvePaths(String relativeBasePath) {
            this.path = FileUtils.makePath(relativeBasePath, this.path);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof RulePath)) {
                return false;
            }
            return this.path.equals(((RulePath)other).path);
        }
    }

    public static interface RuleSource {
        public Iterable<Rule> getRules();

        public void resolvePaths(String var1);

        public int size();
    }
}

