# pulp_python-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 3.0.0b9
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import pulpcore.client.pulp_python
from pulpcore.client.pulp_python.rest import ApiException
from pprint import pprint

configuration = pulpcore.client.pulp_python.Configuration()
# Configure HTTP basic authorization: Basic
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# Defining host is optional and default to http://pulp
configuration.host = "http://pulp"
# Enter a context with an instance of the API client
with pulpcore.client.pulp_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_python.ContentPackagesApi(api_client)
    relative_path = 'relative_path_example' # str | Path where the artifact is located relative to distributions base_path
filename = 'filename_example' # str | The name of the distribution package, usually of the format: {distribution}-{version}(-{build tag})?-{python tag}-{abi tag}-{platform tag}.{packagetype}
artifact = 'artifact_example' # str | Artifact file representing the physical content (optional)
file = '/path/to/file' # file | An uploaded file that may be turned into the artifact of the content unit. (optional)
repository = 'repository_example' # str | A URI of a repository the new content unit should be associated with. (optional)
summary = 'summary_example' # str | A one-line summary of what the package does. (optional)
description = 'description_example' # str | A longer description of the package that can run to several paragraphs. (optional)
keywords = 'keywords_example' # str | Additional keywords to be used to assist searching for the package in a larger catalog. (optional)
home_page = 'home_page_example' # str | The URL for the package's home page. (optional)
download_url = 'download_url_example' # str | Legacy field denoting the URL from which this package can be downloaded. (optional)
author = 'author_example' # str | Text containing the author's name. Contact information can also be added, separated with newlines. (optional)
author_email = 'author_email_example' # str | The author's e-mail address.  (optional)
maintainer = 'maintainer_example' # str | The maintainer's name at a minimum; additional contact information may be provided. (optional)
maintainer_email = 'maintainer_email_example' # str | The maintainer's e-mail address. (optional)
license = 'license_example' # str | Text indicating the license covering the distribution (optional)
requires_python = 'requires_python_example' # str | The Python version(s) that the distribution is guaranteed to be compatible with. (optional)
project_url = 'project_url_example' # str | A browsable URL for the project and a label for it, separated by a comma. (optional)
platform = 'platform_example' # str | A comma-separated list of platform specifications, summarizing the operating systems supported by the package. (optional)
supported_platform = 'supported_platform_example' # str | Field to specify the OS and CPU for which the binary package was compiled.  (optional)
requires_dist = 'requires_dist_example' # str | A JSON list containing names of some other distutils project required by this distribution. (optional)
provides_dist = 'provides_dist_example' # str | A JSON list containing names of a Distutils project which is contained within this distribution. (optional)
obsoletes_dist = 'obsoletes_dist_example' # str | A JSON list containing names of a distutils project's distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time. (optional)
requires_external = 'requires_external_example' # str | A JSON list containing some dependency in the system that the distribution is to be used. (optional)
classifiers = 'classifiers_example' # str | A JSON list containing classification values for a Python package. (optional)

    try:
        # Create a python package content
        api_response = api_instance.create(relative_path, filename, artifact=artifact, file=file, repository=repository, summary=summary, description=description, keywords=keywords, home_page=home_page, download_url=download_url, author=author, author_email=author_email, maintainer=maintainer, maintainer_email=maintainer_email, license=license, requires_python=requires_python, project_url=project_url, platform=platform, supported_platform=supported_platform, requires_dist=requires_dist, provides_dist=provides_dist, obsoletes_dist=obsoletes_dist, requires_external=requires_external, classifiers=classifiers)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentPackagesApi->create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentPackagesApi* | [**create**](docs/ContentPackagesApi.md#create) | **POST** /pulp/api/v3/content/python/packages/ | Create a python package content
*ContentPackagesApi* | [**list**](docs/ContentPackagesApi.md#list) | **GET** /pulp/api/v3/content/python/packages/ | List python package contents
*ContentPackagesApi* | [**read**](docs/ContentPackagesApi.md#read) | **GET** {python_package_content_href} | Inspect a python package content
*DistributionsPypiApi* | [**create**](docs/DistributionsPypiApi.md#create) | **POST** /pulp/api/v3/distributions/python/pypi/ | Create a python distribution
*DistributionsPypiApi* | [**delete**](docs/DistributionsPypiApi.md#delete) | **DELETE** {python_distribution_href} | Delete a python distribution
*DistributionsPypiApi* | [**list**](docs/DistributionsPypiApi.md#list) | **GET** /pulp/api/v3/distributions/python/pypi/ | List python distributions
*DistributionsPypiApi* | [**partial_update**](docs/DistributionsPypiApi.md#partial_update) | **PATCH** {python_distribution_href} | Partially update a python distribution
*DistributionsPypiApi* | [**read**](docs/DistributionsPypiApi.md#read) | **GET** {python_distribution_href} | Inspect a python distribution
*DistributionsPypiApi* | [**update**](docs/DistributionsPypiApi.md#update) | **PUT** {python_distribution_href} | Update a python distribution
*PublicationsPypiApi* | [**create**](docs/PublicationsPypiApi.md#create) | **POST** /pulp/api/v3/publications/python/pypi/ | Create a python publication
*PublicationsPypiApi* | [**delete**](docs/PublicationsPypiApi.md#delete) | **DELETE** {python_publication_href} | Delete a python publication
*PublicationsPypiApi* | [**list**](docs/PublicationsPypiApi.md#list) | **GET** /pulp/api/v3/publications/python/pypi/ | List python publications
*PublicationsPypiApi* | [**read**](docs/PublicationsPypiApi.md#read) | **GET** {python_publication_href} | Inspect a python publication
*RemotesPythonApi* | [**create**](docs/RemotesPythonApi.md#create) | **POST** /pulp/api/v3/remotes/python/python/ | Create a python remote
*RemotesPythonApi* | [**delete**](docs/RemotesPythonApi.md#delete) | **DELETE** {python_remote_href} | Delete a python remote
*RemotesPythonApi* | [**list**](docs/RemotesPythonApi.md#list) | **GET** /pulp/api/v3/remotes/python/python/ | List python remotes
*RemotesPythonApi* | [**partial_update**](docs/RemotesPythonApi.md#partial_update) | **PATCH** {python_remote_href} | Partially update a python remote
*RemotesPythonApi* | [**read**](docs/RemotesPythonApi.md#read) | **GET** {python_remote_href} | Inspect a python remote
*RemotesPythonApi* | [**update**](docs/RemotesPythonApi.md#update) | **PUT** {python_remote_href} | Update a python remote
*RepositoriesPythonApi* | [**create**](docs/RepositoriesPythonApi.md#create) | **POST** /pulp/api/v3/repositories/python/python/ | Create a python repository
*RepositoriesPythonApi* | [**delete**](docs/RepositoriesPythonApi.md#delete) | **DELETE** {python_repository_href} | Delete a python repository
*RepositoriesPythonApi* | [**list**](docs/RepositoriesPythonApi.md#list) | **GET** /pulp/api/v3/repositories/python/python/ | List python repositorys
*RepositoriesPythonApi* | [**modify**](docs/RepositoriesPythonApi.md#modify) | **POST** {python_repository_href}modify/ | Modify Repository Content
*RepositoriesPythonApi* | [**partial_update**](docs/RepositoriesPythonApi.md#partial_update) | **PATCH** {python_repository_href} | Partially update a python repository
*RepositoriesPythonApi* | [**read**](docs/RepositoriesPythonApi.md#read) | **GET** {python_repository_href} | Inspect a python repository
*RepositoriesPythonApi* | [**sync**](docs/RepositoriesPythonApi.md#sync) | **POST** {python_repository_href}sync/ | Sync from remote
*RepositoriesPythonApi* | [**update**](docs/RepositoriesPythonApi.md#update) | **PUT** {python_repository_href} | Update a python repository
*RepositoriesPythonVersionsApi* | [**delete**](docs/RepositoriesPythonVersionsApi.md#delete) | **DELETE** {python_repository_version_href} | Delete a repository version
*RepositoriesPythonVersionsApi* | [**list**](docs/RepositoriesPythonVersionsApi.md#list) | **GET** {python_repository_href}versions/ | List repository versions
*RepositoriesPythonVersionsApi* | [**read**](docs/RepositoriesPythonVersionsApi.md#read) | **GET** {python_repository_version_href} | Inspect a repository version
*RepositoriesPythonVersionsApi* | [**repair**](docs/RepositoriesPythonVersionsApi.md#repair) | **POST** {python_repository_version_href}repair/ | 


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentSummary](docs/ContentSummary.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [ProjectSpecifier](docs/ProjectSpecifier.md)
 - [PythonPythonDistribution](docs/PythonPythonDistribution.md)
 - [PythonPythonDistributionRead](docs/PythonPythonDistributionRead.md)
 - [PythonPythonPackageContentRead](docs/PythonPythonPackageContentRead.md)
 - [PythonPythonPublication](docs/PythonPythonPublication.md)
 - [PythonPythonPublicationRead](docs/PythonPythonPublicationRead.md)
 - [PythonPythonRemote](docs/PythonPythonRemote.md)
 - [PythonPythonRemoteRead](docs/PythonPythonRemoteRead.md)
 - [PythonPythonRepository](docs/PythonPythonRepository.md)
 - [PythonPythonRepositoryRead](docs/PythonPythonRepositoryRead.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositorySyncURL](docs/RepositorySyncURL.md)
 - [RepositoryVersion](docs/RepositoryVersion.md)
 - [RepositoryVersionRead](docs/RepositoryVersionRead.md)


## Documentation For Authorization


## Basic

- **Type**: HTTP basic authentication


## Author




