# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulp_python.api_client import ApiClient
from pulpcore.client.pulp_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RepositoriesPythonApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, python_python_repository,  **kwargs):  # noqa: E501
        """Create a python repository  # noqa: E501

        PythonRepository represents a single Python repository, to which content can be synced, added, or removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(python_python_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PythonPythonRepository python_python_repository: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PythonPythonRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_with_http_info(python_python_repository,  **kwargs)  # noqa: E501

    def create_with_http_info(self, python_python_repository,  **kwargs):  # noqa: E501
        """Create a python repository  # noqa: E501

        PythonRepository represents a single Python repository, to which content can be synced, added, or removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(python_python_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PythonPythonRepository python_python_repository: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PythonPythonRepositoryResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'python_python_repository'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'python_python_repository' is set
        if self.api_client.client_side_validation and ('python_python_repository' not in local_var_params or  # noqa: E501
                                                        local_var_params['python_python_repository'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `python_python_repository` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'python_python_repository' in local_var_params:
            body_params = local_var_params['python_python_repository']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/repositories/python/python/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PythonPythonRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, python_python_repository_href,  **kwargs):  # noqa: E501
        """Delete a python repository  # noqa: E501

        Trigger an asynchronous delete task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(python_python_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_with_http_info(python_python_repository_href,  **kwargs)  # noqa: E501

    def delete_with_http_info(self, python_python_repository_href,  **kwargs):  # noqa: E501
        """Delete a python repository  # noqa: E501

        Trigger an asynchronous delete task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_with_http_info(python_python_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'python_python_repository_href'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'python_python_repository_href' is set
        if self.api_client.client_side_validation and ('python_python_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['python_python_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `python_python_repository_href` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'python_python_repository_href' in local_var_params:
            path_params['python_python_repository_href'] = local_var_params['python_python_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{python_python_repository_href}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list(self,  **kwargs):  # noqa: E501
        """List python repositorys  # noqa: E501

        PythonRepository represents a single Python repository, to which content can be synced, added, or removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str latest_with_content: Content Unit referenced by HREF
        :param int limit: Number of results to return per page.
        :param str name: Filter results where name matches value
        :param str name__contains: Filter results where name contains value
        :param str name__icontains: Filter results where name contains value
        :param str name__iexact: Filter results where name matches value
        :param list[str] name__in: Filter results where name is in a comma-separated list of values
        :param str name__iregex: Filter results where name matches regex value
        :param str name__istartswith: Filter results where name starts with value
        :param str name__regex: Filter results where name matches regex value
        :param str name__startswith: Filter results where name starts with value
        :param int offset: The initial index from which to return the results.
        :param list[str] ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `name` - Name * `-name` - Name (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `description` - Description * `-description` - Description (descending) * `next_version` - Next version * `-next_version` - Next version (descending) * `retain_repo_versions` - Retain repo versions * `-retain_repo_versions` - Retain repo versions (descending) * `user_hidden` - User hidden * `-user_hidden` - User hidden (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :param list[str] pulp_href__in: Multiple values may be separated by commas.
        :param list[str] pulp_id__in: Multiple values may be separated by commas.
        :param str pulp_label_select: Filter labels by search string
        :param str q:
        :param str remote: Foreign Key referenced by HREF
        :param int retain_repo_versions: Filter results where retain_repo_versions matches value
        :param int retain_repo_versions__gt: Filter results where retain_repo_versions is greater than value
        :param int retain_repo_versions__gte: Filter results where retain_repo_versions is greater than or equal to value
        :param bool retain_repo_versions__isnull: Filter results where retain_repo_versions has a null value
        :param int retain_repo_versions__lt: Filter results where retain_repo_versions is less than value
        :param int retain_repo_versions__lte: Filter results where retain_repo_versions is less than or equal to value
        :param int retain_repo_versions__ne: Filter results where retain_repo_versions not equal to value
        :param list[int] retain_repo_versions__range: Filter results where retain_repo_versions is between two comma separated values
        :param str with_content: Content Unit referenced by HREF
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PaginatedpythonPythonRepositoryResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_with_http_info( **kwargs)  # noqa: E501

    def list_with_http_info(self,  **kwargs):  # noqa: E501
        """List python repositorys  # noqa: E501

        PythonRepository represents a single Python repository, to which content can be synced, added, or removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str latest_with_content: Content Unit referenced by HREF
        :param int limit: Number of results to return per page.
        :param str name: Filter results where name matches value
        :param str name__contains: Filter results where name contains value
        :param str name__icontains: Filter results where name contains value
        :param str name__iexact: Filter results where name matches value
        :param list[str] name__in: Filter results where name is in a comma-separated list of values
        :param str name__iregex: Filter results where name matches regex value
        :param str name__istartswith: Filter results where name starts with value
        :param str name__regex: Filter results where name matches regex value
        :param str name__startswith: Filter results where name starts with value
        :param int offset: The initial index from which to return the results.
        :param list[str] ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `name` - Name * `-name` - Name (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `description` - Description * `-description` - Description (descending) * `next_version` - Next version * `-next_version` - Next version (descending) * `retain_repo_versions` - Retain repo versions * `-retain_repo_versions` - Retain repo versions (descending) * `user_hidden` - User hidden * `-user_hidden` - User hidden (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :param list[str] pulp_href__in: Multiple values may be separated by commas.
        :param list[str] pulp_id__in: Multiple values may be separated by commas.
        :param str pulp_label_select: Filter labels by search string
        :param str q:
        :param str remote: Foreign Key referenced by HREF
        :param int retain_repo_versions: Filter results where retain_repo_versions matches value
        :param int retain_repo_versions__gt: Filter results where retain_repo_versions is greater than value
        :param int retain_repo_versions__gte: Filter results where retain_repo_versions is greater than or equal to value
        :param bool retain_repo_versions__isnull: Filter results where retain_repo_versions has a null value
        :param int retain_repo_versions__lt: Filter results where retain_repo_versions is less than value
        :param int retain_repo_versions__lte: Filter results where retain_repo_versions is less than or equal to value
        :param int retain_repo_versions__ne: Filter results where retain_repo_versions not equal to value
        :param list[int] retain_repo_versions__range: Filter results where retain_repo_versions is between two comma separated values
        :param str with_content: Content Unit referenced by HREF
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PaginatedpythonPythonRepositoryResponseList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'latest_with_content',
            'limit',
            'name',
            'name__contains',
            'name__icontains',
            'name__iexact',
            'name__in',
            'name__iregex',
            'name__istartswith',
            'name__regex',
            'name__startswith',
            'offset',
            'ordering',
            'pulp_href__in',
            'pulp_id__in',
            'pulp_label_select',
            'q',
            'remote',
            'retain_repo_versions',
            'retain_repo_versions__gt',
            'retain_repo_versions__gte',
            'retain_repo_versions__isnull',
            'retain_repo_versions__lt',
            'retain_repo_versions__lte',
            'retain_repo_versions__ne',
            'retain_repo_versions__range',
            'with_content',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'latest_with_content' in local_var_params and local_var_params['latest_with_content'] is not None:  # noqa: E501
            query_params.append(('latest_with_content', local_var_params['latest_with_content']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name__contains' in local_var_params and local_var_params['name__contains'] is not None:  # noqa: E501
            query_params.append(('name__contains', local_var_params['name__contains']))  # noqa: E501
        if 'name__icontains' in local_var_params and local_var_params['name__icontains'] is not None:  # noqa: E501
            query_params.append(('name__icontains', local_var_params['name__icontains']))  # noqa: E501
        if 'name__iexact' in local_var_params and local_var_params['name__iexact'] is not None:  # noqa: E501
            query_params.append(('name__iexact', local_var_params['name__iexact']))  # noqa: E501
        if 'name__in' in local_var_params and local_var_params['name__in'] is not None:  # noqa: E501
            query_params.append(('name__in', local_var_params['name__in']))  # noqa: E501
            collection_formats['name__in'] = 'csv'  # noqa: E501
        if 'name__iregex' in local_var_params and local_var_params['name__iregex'] is not None:  # noqa: E501
            query_params.append(('name__iregex', local_var_params['name__iregex']))  # noqa: E501
        if 'name__istartswith' in local_var_params and local_var_params['name__istartswith'] is not None:  # noqa: E501
            query_params.append(('name__istartswith', local_var_params['name__istartswith']))  # noqa: E501
        if 'name__regex' in local_var_params and local_var_params['name__regex'] is not None:  # noqa: E501
            query_params.append(('name__regex', local_var_params['name__regex']))  # noqa: E501
        if 'name__startswith' in local_var_params and local_var_params['name__startswith'] is not None:  # noqa: E501
            query_params.append(('name__startswith', local_var_params['name__startswith']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'ordering' in local_var_params and local_var_params['ordering'] is not None:  # noqa: E501
            query_params.append(('ordering', local_var_params['ordering']))  # noqa: E501
            collection_formats['ordering'] = 'csv'  # noqa: E501
        if 'pulp_href__in' in local_var_params and local_var_params['pulp_href__in'] is not None:  # noqa: E501
            query_params.append(('pulp_href__in', local_var_params['pulp_href__in']))  # noqa: E501
            collection_formats['pulp_href__in'] = 'csv'  # noqa: E501
        if 'pulp_id__in' in local_var_params and local_var_params['pulp_id__in'] is not None:  # noqa: E501
            query_params.append(('pulp_id__in', local_var_params['pulp_id__in']))  # noqa: E501
            collection_formats['pulp_id__in'] = 'csv'  # noqa: E501
        if 'pulp_label_select' in local_var_params and local_var_params['pulp_label_select'] is not None:  # noqa: E501
            query_params.append(('pulp_label_select', local_var_params['pulp_label_select']))  # noqa: E501
        if 'q' in local_var_params and local_var_params['q'] is not None:  # noqa: E501
            query_params.append(('q', local_var_params['q']))  # noqa: E501
        if 'remote' in local_var_params and local_var_params['remote'] is not None:  # noqa: E501
            query_params.append(('remote', local_var_params['remote']))  # noqa: E501
        if 'retain_repo_versions' in local_var_params and local_var_params['retain_repo_versions'] is not None:  # noqa: E501
            query_params.append(('retain_repo_versions', local_var_params['retain_repo_versions']))  # noqa: E501
        if 'retain_repo_versions__gt' in local_var_params and local_var_params['retain_repo_versions__gt'] is not None:  # noqa: E501
            query_params.append(('retain_repo_versions__gt', local_var_params['retain_repo_versions__gt']))  # noqa: E501
        if 'retain_repo_versions__gte' in local_var_params and local_var_params['retain_repo_versions__gte'] is not None:  # noqa: E501
            query_params.append(('retain_repo_versions__gte', local_var_params['retain_repo_versions__gte']))  # noqa: E501
        if 'retain_repo_versions__isnull' in local_var_params and local_var_params['retain_repo_versions__isnull'] is not None:  # noqa: E501
            query_params.append(('retain_repo_versions__isnull', local_var_params['retain_repo_versions__isnull']))  # noqa: E501
        if 'retain_repo_versions__lt' in local_var_params and local_var_params['retain_repo_versions__lt'] is not None:  # noqa: E501
            query_params.append(('retain_repo_versions__lt', local_var_params['retain_repo_versions__lt']))  # noqa: E501
        if 'retain_repo_versions__lte' in local_var_params and local_var_params['retain_repo_versions__lte'] is not None:  # noqa: E501
            query_params.append(('retain_repo_versions__lte', local_var_params['retain_repo_versions__lte']))  # noqa: E501
        if 'retain_repo_versions__ne' in local_var_params and local_var_params['retain_repo_versions__ne'] is not None:  # noqa: E501
            query_params.append(('retain_repo_versions__ne', local_var_params['retain_repo_versions__ne']))  # noqa: E501
        if 'retain_repo_versions__range' in local_var_params and local_var_params['retain_repo_versions__range'] is not None:  # noqa: E501
            query_params.append(('retain_repo_versions__range', local_var_params['retain_repo_versions__range']))  # noqa: E501
            collection_formats['retain_repo_versions__range'] = 'csv'  # noqa: E501
        if 'with_content' in local_var_params and local_var_params['with_content'] is not None:  # noqa: E501
            query_params.append(('with_content', local_var_params['with_content']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501
            collection_formats['exclude_fields'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/repositories/python/python/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedpythonPythonRepositoryResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify(self, python_python_repository_href, repository_add_remove_content,  **kwargs):  # noqa: E501
        """Modify Repository Content  # noqa: E501

        Trigger an asynchronous task to create a new repository version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify(python_python_repository_href, repository_add_remove_content, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param RepositoryAddRemoveContent repository_add_remove_content: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.modify_with_http_info(python_python_repository_href, repository_add_remove_content,  **kwargs)  # noqa: E501

    def modify_with_http_info(self, python_python_repository_href, repository_add_remove_content,  **kwargs):  # noqa: E501
        """Modify Repository Content  # noqa: E501

        Trigger an asynchronous task to create a new repository version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_with_http_info(python_python_repository_href, repository_add_remove_content, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param RepositoryAddRemoveContent repository_add_remove_content: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'python_python_repository_href',
            'repository_add_remove_content'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'python_python_repository_href' is set
        if self.api_client.client_side_validation and ('python_python_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['python_python_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `python_python_repository_href` when calling `modify`")  # noqa: E501
        # verify the required parameter 'repository_add_remove_content' is set
        if self.api_client.client_side_validation and ('repository_add_remove_content' not in local_var_params or  # noqa: E501
                                                        local_var_params['repository_add_remove_content'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repository_add_remove_content` when calling `modify`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'python_python_repository_href' in local_var_params:
            path_params['python_python_repository_href'] = local_var_params['python_python_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'repository_add_remove_content' in local_var_params:
            body_params = local_var_params['repository_add_remove_content']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{python_python_repository_href}modify/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update(self, python_python_repository_href, patchedpython_python_repository,  **kwargs):  # noqa: E501
        """Update a python repository  # noqa: E501

        Trigger an asynchronous partial update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update(python_python_repository_href, patchedpython_python_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param PatchedpythonPythonRepository patchedpython_python_repository: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_with_http_info(python_python_repository_href, patchedpython_python_repository,  **kwargs)  # noqa: E501

    def partial_update_with_http_info(self, python_python_repository_href, patchedpython_python_repository,  **kwargs):  # noqa: E501
        """Update a python repository  # noqa: E501

        Trigger an asynchronous partial update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_with_http_info(python_python_repository_href, patchedpython_python_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param PatchedpythonPythonRepository patchedpython_python_repository: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'python_python_repository_href',
            'patchedpython_python_repository'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'python_python_repository_href' is set
        if self.api_client.client_side_validation and ('python_python_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['python_python_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `python_python_repository_href` when calling `partial_update`")  # noqa: E501
        # verify the required parameter 'patchedpython_python_repository' is set
        if self.api_client.client_side_validation and ('patchedpython_python_repository' not in local_var_params or  # noqa: E501
                                                        local_var_params['patchedpython_python_repository'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patchedpython_python_repository` when calling `partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'python_python_repository_href' in local_var_params:
            path_params['python_python_repository_href'] = local_var_params['python_python_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patchedpython_python_repository' in local_var_params:
            body_params = local_var_params['patchedpython_python_repository']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{python_python_repository_href}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read(self, python_python_repository_href,  **kwargs):  # noqa: E501
        """Inspect a python repository  # noqa: E501

        PythonRepository represents a single Python repository, to which content can be synced, added, or removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read(python_python_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PythonPythonRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.read_with_http_info(python_python_repository_href,  **kwargs)  # noqa: E501

    def read_with_http_info(self, python_python_repository_href,  **kwargs):  # noqa: E501
        """Inspect a python repository  # noqa: E501

        PythonRepository represents a single Python repository, to which content can be synced, added, or removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_with_http_info(python_python_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param list[str] fields: A list of fields to include in the response.
        :param list[str] exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PythonPythonRepositoryResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'python_python_repository_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'python_python_repository_href' is set
        if self.api_client.client_side_validation and ('python_python_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['python_python_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `python_python_repository_href` when calling `read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'python_python_repository_href' in local_var_params:
            path_params['python_python_repository_href'] = local_var_params['python_python_repository_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
            collection_formats['fields'] = 'multi'  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501
            collection_formats['exclude_fields'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{python_python_repository_href}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PythonPythonRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_label(self, python_python_repository_href, set_label,  **kwargs):  # noqa: E501
        """Set a label  # noqa: E501

        Set a single pulp_label on the object to a specific value or null.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_label(python_python_repository_href, set_label, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param SetLabel set_label: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SetLabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_label_with_http_info(python_python_repository_href, set_label,  **kwargs)  # noqa: E501

    def set_label_with_http_info(self, python_python_repository_href, set_label,  **kwargs):  # noqa: E501
        """Set a label  # noqa: E501

        Set a single pulp_label on the object to a specific value or null.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_label_with_http_info(python_python_repository_href, set_label, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param SetLabel set_label: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SetLabelResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'python_python_repository_href',
            'set_label'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_label" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'python_python_repository_href' is set
        if self.api_client.client_side_validation and ('python_python_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['python_python_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `python_python_repository_href` when calling `set_label`")  # noqa: E501
        # verify the required parameter 'set_label' is set
        if self.api_client.client_side_validation and ('set_label' not in local_var_params or  # noqa: E501
                                                        local_var_params['set_label'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `set_label` when calling `set_label`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'python_python_repository_href' in local_var_params:
            path_params['python_python_repository_href'] = local_var_params['python_python_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_label' in local_var_params:
            body_params = local_var_params['set_label']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{python_python_repository_href}set_label/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SetLabelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def sync(self, python_python_repository_href, repository_sync_url,  **kwargs):  # noqa: E501
        """Sync from remote  # noqa: E501

         Trigger an asynchronous task to sync python content. The sync task will retrieve Python content from the specified `Remote` and update the specified `Respository`, creating a new  `RepositoryVersion`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sync(python_python_repository_href, repository_sync_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param RepositorySyncURL repository_sync_url: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.sync_with_http_info(python_python_repository_href, repository_sync_url,  **kwargs)  # noqa: E501

    def sync_with_http_info(self, python_python_repository_href, repository_sync_url,  **kwargs):  # noqa: E501
        """Sync from remote  # noqa: E501

         Trigger an asynchronous task to sync python content. The sync task will retrieve Python content from the specified `Remote` and update the specified `Respository`, creating a new  `RepositoryVersion`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sync_with_http_info(python_python_repository_href, repository_sync_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param RepositorySyncURL repository_sync_url: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'python_python_repository_href',
            'repository_sync_url'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sync" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'python_python_repository_href' is set
        if self.api_client.client_side_validation and ('python_python_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['python_python_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `python_python_repository_href` when calling `sync`")  # noqa: E501
        # verify the required parameter 'repository_sync_url' is set
        if self.api_client.client_side_validation and ('repository_sync_url' not in local_var_params or  # noqa: E501
                                                        local_var_params['repository_sync_url'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repository_sync_url` when calling `sync`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'python_python_repository_href' in local_var_params:
            path_params['python_python_repository_href'] = local_var_params['python_python_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'repository_sync_url' in local_var_params:
            body_params = local_var_params['repository_sync_url']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{python_python_repository_href}sync/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unset_label(self, python_python_repository_href, unset_label,  **kwargs):  # noqa: E501
        """Unset a label  # noqa: E501

        Unset a single pulp_label on the object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unset_label(python_python_repository_href, unset_label, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param UnsetLabel unset_label: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UnsetLabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.unset_label_with_http_info(python_python_repository_href, unset_label,  **kwargs)  # noqa: E501

    def unset_label_with_http_info(self, python_python_repository_href, unset_label,  **kwargs):  # noqa: E501
        """Unset a label  # noqa: E501

        Unset a single pulp_label on the object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unset_label_with_http_info(python_python_repository_href, unset_label, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param UnsetLabel unset_label: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UnsetLabelResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'python_python_repository_href',
            'unset_label'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unset_label" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'python_python_repository_href' is set
        if self.api_client.client_side_validation and ('python_python_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['python_python_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `python_python_repository_href` when calling `unset_label`")  # noqa: E501
        # verify the required parameter 'unset_label' is set
        if self.api_client.client_side_validation and ('unset_label' not in local_var_params or  # noqa: E501
                                                        local_var_params['unset_label'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `unset_label` when calling `unset_label`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'python_python_repository_href' in local_var_params:
            path_params['python_python_repository_href'] = local_var_params['python_python_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unset_label' in local_var_params:
            body_params = local_var_params['unset_label']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{python_python_repository_href}unset_label/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UnsetLabelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update(self, python_python_repository_href, python_python_repository,  **kwargs):  # noqa: E501
        """Update a python repository  # noqa: E501

        Trigger an asynchronous update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(python_python_repository_href, python_python_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param PythonPythonRepository python_python_repository: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_with_http_info(python_python_repository_href, python_python_repository,  **kwargs)  # noqa: E501

    def update_with_http_info(self, python_python_repository_href, python_python_repository,  **kwargs):  # noqa: E501
        """Update a python repository  # noqa: E501

        Trigger an asynchronous update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(python_python_repository_href, python_python_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str python_python_repository_href: (required)
        :param PythonPythonRepository python_python_repository: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'python_python_repository_href',
            'python_python_repository'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'python_python_repository_href' is set
        if self.api_client.client_side_validation and ('python_python_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['python_python_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `python_python_repository_href` when calling `update`")  # noqa: E501
        # verify the required parameter 'python_python_repository' is set
        if self.api_client.client_side_validation and ('python_python_repository' not in local_var_params or  # noqa: E501
                                                        local_var_params['python_python_repository'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `python_python_repository` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'python_python_repository_href' in local_var_params:
            path_params['python_python_repository_href'] = local_var_params['python_python_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'python_python_repository' in local_var_params:
            body_params = local_var_params['python_python_repository']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{python_python_repository_href}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
