# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class OneOf:
    @staticmethod
    def from_dict(obj, *args, **kwargs):
        """Noop override to fix missing OneOf import/implementation."""
        return obj


class PackageMetadataResponse(BaseModel):
    """
    A Serializer for a package's metadata.
    """ # noqa: E501
    last_serial: StrictInt = Field(description="Cache value from last PyPI sync")
    info: Optional[Any]
    releases: Optional[Any]
    urls: Optional[Any]
    __properties: ClassVar[List[str]] = ["last_serial", "info", "releases", "urls"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PackageMetadataResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if info (nullable) is None
        # and model_fields_set contains the field
        if self.info is None and "info" in self.model_fields_set:
            _dict['info'] = None

        # set to None if releases (nullable) is None
        # and model_fields_set contains the field
        if self.releases is None and "releases" in self.model_fields_set:
            _dict['releases'] = None

        # set to None if urls (nullable) is None
        # and model_fields_set contains the field
        if self.urls is None and "urls" in self.model_fields_set:
            _dict['urls'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PackageMetadataResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "last_serial": obj.get("last_serial"),
            "info": obj.get("info"),
            "releases": obj.get("releases"),
            "urls": obj.get("urls")
        })
        return _obj


