# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from pulpcore.client.pulp_python.models.async_operation_response import AsyncOperationResponse
from pulpcore.client.pulp_python.models.paginatedpython_package_provenance_response_list import PaginatedpythonPackageProvenanceResponseList
from pulpcore.client.pulp_python.models.python_package_provenance_response import PythonPackageProvenanceResponse
from pulpcore.client.pulp_python.models.set_label import SetLabel
from pulpcore.client.pulp_python.models.set_label_response import SetLabelResponse
from pulpcore.client.pulp_python.models.unset_label import UnsetLabel
from pulpcore.client.pulp_python.models.unset_label_response import UnsetLabelResponse

from pulpcore.client.pulp_python.api_client import ApiClient, RequestSerialized
from pulpcore.client.pulp_python.api_response import ApiResponse
from pulpcore.client.pulp_python.rest import RESTResponseType


class ContentProvenanceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create(
        self,
        package: Annotated[StrictStr, Field(description="The package that the provenance is for.")],
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        repository: Annotated[Optional[StrictStr], Field(description="A URI of a repository the new content unit should be associated with.")] = None,
        pulp_labels: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="An uploaded file that may be turned into the content unit.")] = None,
        upload: Annotated[Optional[StrictStr], Field(description="An uncommitted upload that may be turned into the content unit.")] = None,
        file_url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="A url that Pulp can download and turn into the content unit.")] = None,
        verify: Annotated[Optional[StrictBool], Field(description="Verify each attestation in the provenance.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AsyncOperationResponse:
        """Create a package provenance

        Trigger an asynchronous task to create content,optionally create new repository version.

        :param package: The package that the provenance is for. (required)
        :type package: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param repository: A URI of a repository the new content unit should be associated with.
        :type repository: str
        :param pulp_labels: A dictionary of arbitrary key/value pairs used to describe a specific Content instance.
        :type pulp_labels: Dict[str, Optional[str]]
        :param file: An uploaded file that may be turned into the content unit.
        :type file: bytearray
        :param upload: An uncommitted upload that may be turned into the content unit.
        :type upload: str
        :param file_url: A url that Pulp can download and turn into the content unit.
        :type file_url: str
        :param verify: Verify each attestation in the provenance.
        :type verify: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            package=package,
            x_task_diagnostics=x_task_diagnostics,
            repository=repository,
            pulp_labels=pulp_labels,
            file=file,
            upload=upload,
            file_url=file_url,
            verify=verify,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_with_http_info(
        self,
        package: Annotated[StrictStr, Field(description="The package that the provenance is for.")],
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        repository: Annotated[Optional[StrictStr], Field(description="A URI of a repository the new content unit should be associated with.")] = None,
        pulp_labels: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="An uploaded file that may be turned into the content unit.")] = None,
        upload: Annotated[Optional[StrictStr], Field(description="An uncommitted upload that may be turned into the content unit.")] = None,
        file_url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="A url that Pulp can download and turn into the content unit.")] = None,
        verify: Annotated[Optional[StrictBool], Field(description="Verify each attestation in the provenance.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AsyncOperationResponse]:
        """Create a package provenance

        Trigger an asynchronous task to create content,optionally create new repository version.

        :param package: The package that the provenance is for. (required)
        :type package: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param repository: A URI of a repository the new content unit should be associated with.
        :type repository: str
        :param pulp_labels: A dictionary of arbitrary key/value pairs used to describe a specific Content instance.
        :type pulp_labels: Dict[str, Optional[str]]
        :param file: An uploaded file that may be turned into the content unit.
        :type file: bytearray
        :param upload: An uncommitted upload that may be turned into the content unit.
        :type upload: str
        :param file_url: A url that Pulp can download and turn into the content unit.
        :type file_url: str
        :param verify: Verify each attestation in the provenance.
        :type verify: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            package=package,
            x_task_diagnostics=x_task_diagnostics,
            repository=repository,
            pulp_labels=pulp_labels,
            file=file,
            upload=upload,
            file_url=file_url,
            verify=verify,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_without_preload_content(
        self,
        package: Annotated[StrictStr, Field(description="The package that the provenance is for.")],
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        repository: Annotated[Optional[StrictStr], Field(description="A URI of a repository the new content unit should be associated with.")] = None,
        pulp_labels: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="An uploaded file that may be turned into the content unit.")] = None,
        upload: Annotated[Optional[StrictStr], Field(description="An uncommitted upload that may be turned into the content unit.")] = None,
        file_url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="A url that Pulp can download and turn into the content unit.")] = None,
        verify: Annotated[Optional[StrictBool], Field(description="Verify each attestation in the provenance.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a package provenance

        Trigger an asynchronous task to create content,optionally create new repository version.

        :param package: The package that the provenance is for. (required)
        :type package: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param repository: A URI of a repository the new content unit should be associated with.
        :type repository: str
        :param pulp_labels: A dictionary of arbitrary key/value pairs used to describe a specific Content instance.
        :type pulp_labels: Dict[str, Optional[str]]
        :param file: An uploaded file that may be turned into the content unit.
        :type file: bytearray
        :param upload: An uncommitted upload that may be turned into the content unit.
        :type upload: str
        :param file_url: A url that Pulp can download and turn into the content unit.
        :type file_url: str
        :param verify: Verify each attestation in the provenance.
        :type verify: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            package=package,
            x_task_diagnostics=x_task_diagnostics,
            repository=repository,
            pulp_labels=pulp_labels,
            file=file,
            upload=upload,
            file_url=file_url,
            verify=verify,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_serialize(
        self,
        package,
        x_task_diagnostics,
        repository,
        pulp_labels,
        file,
        upload,
        file_url,
        verify,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        if repository is not None:
            _form_params.append(('repository', repository))
        if pulp_labels is not None:
            _form_params.append(('pulp_labels', pulp_labels))
        if file is not None:
            _files['file'] = file
        if upload is not None:
            _form_params.append(('upload', upload))
        if file_url is not None:
            _form_params.append(('file_url', file_url))
        if package is not None:
            _form_params.append(('package', package))
        if verify is not None:
            _form_params.append(('verify', verify))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/pulp/api/v3/content/python/provenance/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `provenance` - Provenance * `-provenance` - Provenance (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        package: Annotated[Optional[StrictStr], Field(description="Filter results where package matches value")] = None,
        package__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where package is in a comma-separated list of values")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        sha256: Annotated[Optional[StrictStr], Field(description="Filter results where sha256 matches value")] = None,
        sha256__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where sha256 is in a comma-separated list of values")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginatedpythonPackageProvenanceResponseList:
        """List package provenances

        PackageProvenance represents a PEP 740 provenance object for a Python package.  Use ?minimal=true to get a human readable representation of the provenance.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `provenance` - Provenance * `-provenance` - Provenance (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param package: Filter results where package matches value
        :type package: str
        :param package__in: Filter results where package is in a comma-separated list of values
        :type package__in: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param sha256: Filter results where sha256 matches value
        :type sha256: str
        :param sha256__in: Filter results where sha256 is in a comma-separated list of values
        :type sha256__in: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            x_task_diagnostics=x_task_diagnostics,
            limit=limit,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            package=package,
            package__in=package__in,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            sha256=sha256,
            sha256__in=sha256__in,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedpythonPackageProvenanceResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_with_http_info(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `provenance` - Provenance * `-provenance` - Provenance (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        package: Annotated[Optional[StrictStr], Field(description="Filter results where package matches value")] = None,
        package__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where package is in a comma-separated list of values")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        sha256: Annotated[Optional[StrictStr], Field(description="Filter results where sha256 matches value")] = None,
        sha256__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where sha256 is in a comma-separated list of values")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginatedpythonPackageProvenanceResponseList]:
        """List package provenances

        PackageProvenance represents a PEP 740 provenance object for a Python package.  Use ?minimal=true to get a human readable representation of the provenance.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `provenance` - Provenance * `-provenance` - Provenance (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param package: Filter results where package matches value
        :type package: str
        :param package__in: Filter results where package is in a comma-separated list of values
        :type package__in: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param sha256: Filter results where sha256 matches value
        :type sha256: str
        :param sha256__in: Filter results where sha256 is in a comma-separated list of values
        :type sha256__in: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            x_task_diagnostics=x_task_diagnostics,
            limit=limit,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            package=package,
            package__in=package__in,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            sha256=sha256,
            sha256__in=sha256__in,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedpythonPackageProvenanceResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_without_preload_content(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `provenance` - Provenance * `-provenance` - Provenance (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        package: Annotated[Optional[StrictStr], Field(description="Filter results where package matches value")] = None,
        package__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where package is in a comma-separated list of values")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        sha256: Annotated[Optional[StrictStr], Field(description="Filter results where sha256 matches value")] = None,
        sha256__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where sha256 is in a comma-separated list of values")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List package provenances

        PackageProvenance represents a PEP 740 provenance object for a Python package.  Use ?minimal=true to get a human readable representation of the provenance.

        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `provenance` - Provenance * `-provenance` - Provenance (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param package: Filter results where package matches value
        :type package: str
        :param package__in: Filter results where package is in a comma-separated list of values
        :type package__in: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param sha256: Filter results where sha256 matches value
        :type sha256: str
        :param sha256__in: Filter results where sha256 is in a comma-separated list of values
        :type sha256__in: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            x_task_diagnostics=x_task_diagnostics,
            limit=limit,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            package=package,
            package__in=package__in,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            sha256=sha256,
            sha256__in=sha256__in,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedpythonPackageProvenanceResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_serialize(
        self,
        x_task_diagnostics,
        limit,
        offset,
        ordering,
        orphaned_for,
        package,
        package__in,
        prn__in,
        pulp_href__in,
        pulp_id__in,
        pulp_label_select,
        q,
        repository_version,
        repository_version_added,
        repository_version_removed,
        sha256,
        sha256__in,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'ordering': 'csv',
            'package__in': 'csv',
            'prn__in': 'csv',
            'pulp_href__in': 'csv',
            'pulp_id__in': 'csv',
            'sha256__in': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if orphaned_for is not None:
            
            _query_params.append(('orphaned_for', orphaned_for))
            
        if package is not None:
            
            _query_params.append(('package', package))
            
        if package__in is not None:
            
            _query_params.append(('package__in', package__in))
            
        if prn__in is not None:
            
            _query_params.append(('prn__in', prn__in))
            
        if pulp_href__in is not None:
            
            _query_params.append(('pulp_href__in', pulp_href__in))
            
        if pulp_id__in is not None:
            
            _query_params.append(('pulp_id__in', pulp_id__in))
            
        if pulp_label_select is not None:
            
            _query_params.append(('pulp_label_select', pulp_label_select))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if repository_version is not None:
            
            _query_params.append(('repository_version', repository_version))
            
        if repository_version_added is not None:
            
            _query_params.append(('repository_version_added', repository_version_added))
            
        if repository_version_removed is not None:
            
            _query_params.append(('repository_version_removed', repository_version_removed))
            
        if sha256 is not None:
            
            _query_params.append(('sha256', sha256))
            
        if sha256__in is not None:
            
            _query_params.append(('sha256__in', sha256__in))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pulp/api/v3/content/python/provenance/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def read(
        self,
        python_package_provenance_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PythonPackageProvenanceResponse:
        """Inspect a package provenance

        PackageProvenance represents a PEP 740 provenance object for a Python package.  Use ?minimal=true to get a human readable representation of the provenance.

        :param python_package_provenance_href: (required)
        :type python_package_provenance_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            python_package_provenance_href=python_package_provenance_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PythonPackageProvenanceResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_with_http_info(
        self,
        python_package_provenance_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PythonPackageProvenanceResponse]:
        """Inspect a package provenance

        PackageProvenance represents a PEP 740 provenance object for a Python package.  Use ?minimal=true to get a human readable representation of the provenance.

        :param python_package_provenance_href: (required)
        :type python_package_provenance_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            python_package_provenance_href=python_package_provenance_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PythonPackageProvenanceResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_without_preload_content(
        self,
        python_package_provenance_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Inspect a package provenance

        PackageProvenance represents a PEP 740 provenance object for a Python package.  Use ?minimal=true to get a human readable representation of the provenance.

        :param python_package_provenance_href: (required)
        :type python_package_provenance_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            python_package_provenance_href=python_package_provenance_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PythonPackageProvenanceResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_serialize(
        self,
        python_package_provenance_href,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_package_provenance_href is not None:
            _path_params['python_package_provenance_href'] = python_package_provenance_href
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{python_package_provenance_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def set_label(
        self,
        python_package_provenance_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SetLabelResponse:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param python_package_provenance_href: (required)
        :type python_package_provenance_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            python_package_provenance_href=python_package_provenance_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def set_label_with_http_info(
        self,
        python_package_provenance_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SetLabelResponse]:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param python_package_provenance_href: (required)
        :type python_package_provenance_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            python_package_provenance_href=python_package_provenance_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def set_label_without_preload_content(
        self,
        python_package_provenance_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param python_package_provenance_href: (required)
        :type python_package_provenance_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            python_package_provenance_href=python_package_provenance_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _set_label_serialize(
        self,
        python_package_provenance_href,
        set_label,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_package_provenance_href is not None:
            _path_params['python_package_provenance_href'] = python_package_provenance_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if set_label is not None:
            _body_params = set_label


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{python_package_provenance_href}set_label/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def unset_label(
        self,
        python_package_provenance_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UnsetLabelResponse:
        """Unset a label

        Unset a single pulp_label on the object.

        :param python_package_provenance_href: (required)
        :type python_package_provenance_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            python_package_provenance_href=python_package_provenance_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def unset_label_with_http_info(
        self,
        python_package_provenance_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UnsetLabelResponse]:
        """Unset a label

        Unset a single pulp_label on the object.

        :param python_package_provenance_href: (required)
        :type python_package_provenance_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            python_package_provenance_href=python_package_provenance_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def unset_label_without_preload_content(
        self,
        python_package_provenance_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Unset a label

        Unset a single pulp_label on the object.

        :param python_package_provenance_href: (required)
        :type python_package_provenance_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            python_package_provenance_href=python_package_provenance_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _unset_label_serialize(
        self,
        python_package_provenance_href,
        unset_label,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_package_provenance_href is not None:
            _path_params['python_package_provenance_href'] = python_package_provenance_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if unset_label is not None:
            _body_params = unset_label


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{python_package_provenance_href}unset_label/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


