# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from pulpcore.client.pulp_python.models.async_operation_response import AsyncOperationResponse
from pulpcore.client.pulp_python.models.paginated_repository_version_response_list import PaginatedRepositoryVersionResponseList
from pulpcore.client.pulp_python.models.repair import Repair
from pulpcore.client.pulp_python.models.repository_version_response import RepositoryVersionResponse

from pulpcore.client.pulp_python.api_client import ApiClient, RequestSerialized
from pulpcore.client.pulp_python.api_response import ApiResponse
from pulpcore.client.pulp_python.rest import RESTResponseType


class RepositoriesPythonVersionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def delete(
        self,
        python_python_repository_version_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AsyncOperationResponse:
        """Delete a repository version

        Trigger an asynchronous task to delete a repository version.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_with_http_info(
        self,
        python_python_repository_version_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AsyncOperationResponse]:
        """Delete a repository version

        Trigger an asynchronous task to delete a repository version.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_without_preload_content(
        self,
        python_python_repository_version_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a repository version

        Trigger an asynchronous task to delete a repository version.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_serialize(
        self,
        python_python_repository_version_href,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_python_repository_version_href is not None:
            _path_params['python_python_repository_version_href'] = python_python_repository_version_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='{python_python_repository_version_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list(
        self,
        python_python_repository_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        content: Annotated[Optional[StrictStr], Field(description="Content Unit referenced by HREF/PRN")] = None,
        content__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        number: Annotated[Optional[StrictInt], Field(description="Filter results where number matches value")] = None,
        number__gt: Annotated[Optional[StrictInt], Field(description="Filter results where number is greater than value")] = None,
        number__gte: Annotated[Optional[StrictInt], Field(description="Filter results where number is greater than or equal to value")] = None,
        number__lt: Annotated[Optional[StrictInt], Field(description="Filter results where number is less than value")] = None,
        number__lte: Annotated[Optional[StrictInt], Field(description="Filter results where number is less than or equal to value")] = None,
        number__range: Annotated[Optional[List[StrictInt]], Field(description="Filter results where number is between two comma separated values")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `number` - Number * `-number` - Number (descending) * `complete` - Complete * `-complete` - Complete (descending) * `info` - Info * `-info` - Info (descending) * `content_ids` - Content ids * `-content_ids` - Content ids (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_created: Annotated[Optional[datetime], Field(description="Filter results where pulp_created matches value")] = None,
        pulp_created__gt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than value")] = None,
        pulp_created__gte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than or equal to value")] = None,
        pulp_created__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where pulp_created has a null value")] = None,
        pulp_created__lt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than value")] = None,
        pulp_created__lte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than or equal to value")] = None,
        pulp_created__range: Annotated[Optional[List[datetime]], Field(description="Filter results where pulp_created is between two comma separated values")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginatedRepositoryVersionResponseList:
        """List repository versions

        PythonRepositoryVersion represents a single Python repository version.

        :param python_python_repository_href: (required)
        :type python_python_repository_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param content: Content Unit referenced by HREF/PRN
        :type content: str
        :param content__in: Multiple values may be separated by commas.
        :type content__in: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param number: Filter results where number matches value
        :type number: int
        :param number__gt: Filter results where number is greater than value
        :type number__gt: int
        :param number__gte: Filter results where number is greater than or equal to value
        :type number__gte: int
        :param number__lt: Filter results where number is less than value
        :type number__lt: int
        :param number__lte: Filter results where number is less than or equal to value
        :type number__lte: int
        :param number__range: Filter results where number is between two comma separated values
        :type number__range: List[int]
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `number` - Number * `-number` - Number (descending) * `complete` - Complete * `-complete` - Complete (descending) * `info` - Info * `-info` - Info (descending) * `content_ids` - Content ids * `-content_ids` - Content ids (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_created: Filter results where pulp_created matches value
        :type pulp_created: datetime
        :param pulp_created__gt: Filter results where pulp_created is greater than value
        :type pulp_created__gt: datetime
        :param pulp_created__gte: Filter results where pulp_created is greater than or equal to value
        :type pulp_created__gte: datetime
        :param pulp_created__isnull: Filter results where pulp_created has a null value
        :type pulp_created__isnull: bool
        :param pulp_created__lt: Filter results where pulp_created is less than value
        :type pulp_created__lt: datetime
        :param pulp_created__lte: Filter results where pulp_created is less than or equal to value
        :type pulp_created__lte: datetime
        :param pulp_created__range: Filter results where pulp_created is between two comma separated values
        :type pulp_created__range: List[datetime]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            python_python_repository_href=python_python_repository_href,
            x_task_diagnostics=x_task_diagnostics,
            content=content,
            content__in=content__in,
            limit=limit,
            number=number,
            number__gt=number__gt,
            number__gte=number__gte,
            number__lt=number__lt,
            number__lte=number__lte,
            number__range=number__range,
            offset=offset,
            ordering=ordering,
            prn__in=prn__in,
            pulp_created=pulp_created,
            pulp_created__gt=pulp_created__gt,
            pulp_created__gte=pulp_created__gte,
            pulp_created__isnull=pulp_created__isnull,
            pulp_created__lt=pulp_created__lt,
            pulp_created__lte=pulp_created__lte,
            pulp_created__range=pulp_created__range,
            pulp_href__in=pulp_href__in,
            q=q,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedRepositoryVersionResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_with_http_info(
        self,
        python_python_repository_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        content: Annotated[Optional[StrictStr], Field(description="Content Unit referenced by HREF/PRN")] = None,
        content__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        number: Annotated[Optional[StrictInt], Field(description="Filter results where number matches value")] = None,
        number__gt: Annotated[Optional[StrictInt], Field(description="Filter results where number is greater than value")] = None,
        number__gte: Annotated[Optional[StrictInt], Field(description="Filter results where number is greater than or equal to value")] = None,
        number__lt: Annotated[Optional[StrictInt], Field(description="Filter results where number is less than value")] = None,
        number__lte: Annotated[Optional[StrictInt], Field(description="Filter results where number is less than or equal to value")] = None,
        number__range: Annotated[Optional[List[StrictInt]], Field(description="Filter results where number is between two comma separated values")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `number` - Number * `-number` - Number (descending) * `complete` - Complete * `-complete` - Complete (descending) * `info` - Info * `-info` - Info (descending) * `content_ids` - Content ids * `-content_ids` - Content ids (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_created: Annotated[Optional[datetime], Field(description="Filter results where pulp_created matches value")] = None,
        pulp_created__gt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than value")] = None,
        pulp_created__gte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than or equal to value")] = None,
        pulp_created__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where pulp_created has a null value")] = None,
        pulp_created__lt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than value")] = None,
        pulp_created__lte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than or equal to value")] = None,
        pulp_created__range: Annotated[Optional[List[datetime]], Field(description="Filter results where pulp_created is between two comma separated values")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginatedRepositoryVersionResponseList]:
        """List repository versions

        PythonRepositoryVersion represents a single Python repository version.

        :param python_python_repository_href: (required)
        :type python_python_repository_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param content: Content Unit referenced by HREF/PRN
        :type content: str
        :param content__in: Multiple values may be separated by commas.
        :type content__in: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param number: Filter results where number matches value
        :type number: int
        :param number__gt: Filter results where number is greater than value
        :type number__gt: int
        :param number__gte: Filter results where number is greater than or equal to value
        :type number__gte: int
        :param number__lt: Filter results where number is less than value
        :type number__lt: int
        :param number__lte: Filter results where number is less than or equal to value
        :type number__lte: int
        :param number__range: Filter results where number is between two comma separated values
        :type number__range: List[int]
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `number` - Number * `-number` - Number (descending) * `complete` - Complete * `-complete` - Complete (descending) * `info` - Info * `-info` - Info (descending) * `content_ids` - Content ids * `-content_ids` - Content ids (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_created: Filter results where pulp_created matches value
        :type pulp_created: datetime
        :param pulp_created__gt: Filter results where pulp_created is greater than value
        :type pulp_created__gt: datetime
        :param pulp_created__gte: Filter results where pulp_created is greater than or equal to value
        :type pulp_created__gte: datetime
        :param pulp_created__isnull: Filter results where pulp_created has a null value
        :type pulp_created__isnull: bool
        :param pulp_created__lt: Filter results where pulp_created is less than value
        :type pulp_created__lt: datetime
        :param pulp_created__lte: Filter results where pulp_created is less than or equal to value
        :type pulp_created__lte: datetime
        :param pulp_created__range: Filter results where pulp_created is between two comma separated values
        :type pulp_created__range: List[datetime]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            python_python_repository_href=python_python_repository_href,
            x_task_diagnostics=x_task_diagnostics,
            content=content,
            content__in=content__in,
            limit=limit,
            number=number,
            number__gt=number__gt,
            number__gte=number__gte,
            number__lt=number__lt,
            number__lte=number__lte,
            number__range=number__range,
            offset=offset,
            ordering=ordering,
            prn__in=prn__in,
            pulp_created=pulp_created,
            pulp_created__gt=pulp_created__gt,
            pulp_created__gte=pulp_created__gte,
            pulp_created__isnull=pulp_created__isnull,
            pulp_created__lt=pulp_created__lt,
            pulp_created__lte=pulp_created__lte,
            pulp_created__range=pulp_created__range,
            pulp_href__in=pulp_href__in,
            q=q,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedRepositoryVersionResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_without_preload_content(
        self,
        python_python_repository_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        content: Annotated[Optional[StrictStr], Field(description="Content Unit referenced by HREF/PRN")] = None,
        content__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        number: Annotated[Optional[StrictInt], Field(description="Filter results where number matches value")] = None,
        number__gt: Annotated[Optional[StrictInt], Field(description="Filter results where number is greater than value")] = None,
        number__gte: Annotated[Optional[StrictInt], Field(description="Filter results where number is greater than or equal to value")] = None,
        number__lt: Annotated[Optional[StrictInt], Field(description="Filter results where number is less than value")] = None,
        number__lte: Annotated[Optional[StrictInt], Field(description="Filter results where number is less than or equal to value")] = None,
        number__range: Annotated[Optional[List[StrictInt]], Field(description="Filter results where number is between two comma separated values")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `number` - Number * `-number` - Number (descending) * `complete` - Complete * `-complete` - Complete (descending) * `info` - Info * `-info` - Info (descending) * `content_ids` - Content ids * `-content_ids` - Content ids (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_created: Annotated[Optional[datetime], Field(description="Filter results where pulp_created matches value")] = None,
        pulp_created__gt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than value")] = None,
        pulp_created__gte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is greater than or equal to value")] = None,
        pulp_created__isnull: Annotated[Optional[StrictBool], Field(description="Filter results where pulp_created has a null value")] = None,
        pulp_created__lt: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than value")] = None,
        pulp_created__lte: Annotated[Optional[datetime], Field(description="Filter results where pulp_created is less than or equal to value")] = None,
        pulp_created__range: Annotated[Optional[List[datetime]], Field(description="Filter results where pulp_created is between two comma separated values")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List repository versions

        PythonRepositoryVersion represents a single Python repository version.

        :param python_python_repository_href: (required)
        :type python_python_repository_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param content: Content Unit referenced by HREF/PRN
        :type content: str
        :param content__in: Multiple values may be separated by commas.
        :type content__in: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param number: Filter results where number matches value
        :type number: int
        :param number__gt: Filter results where number is greater than value
        :type number__gt: int
        :param number__gte: Filter results where number is greater than or equal to value
        :type number__gte: int
        :param number__lt: Filter results where number is less than value
        :type number__lt: int
        :param number__lte: Filter results where number is less than or equal to value
        :type number__lte: int
        :param number__range: Filter results where number is between two comma separated values
        :type number__range: List[int]
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `number` - Number * `-number` - Number (descending) * `complete` - Complete * `-complete` - Complete (descending) * `info` - Info * `-info` - Info (descending) * `content_ids` - Content ids * `-content_ids` - Content ids (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_created: Filter results where pulp_created matches value
        :type pulp_created: datetime
        :param pulp_created__gt: Filter results where pulp_created is greater than value
        :type pulp_created__gt: datetime
        :param pulp_created__gte: Filter results where pulp_created is greater than or equal to value
        :type pulp_created__gte: datetime
        :param pulp_created__isnull: Filter results where pulp_created has a null value
        :type pulp_created__isnull: bool
        :param pulp_created__lt: Filter results where pulp_created is less than value
        :type pulp_created__lt: datetime
        :param pulp_created__lte: Filter results where pulp_created is less than or equal to value
        :type pulp_created__lte: datetime
        :param pulp_created__range: Filter results where pulp_created is between two comma separated values
        :type pulp_created__range: List[datetime]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            python_python_repository_href=python_python_repository_href,
            x_task_diagnostics=x_task_diagnostics,
            content=content,
            content__in=content__in,
            limit=limit,
            number=number,
            number__gt=number__gt,
            number__gte=number__gte,
            number__lt=number__lt,
            number__lte=number__lte,
            number__range=number__range,
            offset=offset,
            ordering=ordering,
            prn__in=prn__in,
            pulp_created=pulp_created,
            pulp_created__gt=pulp_created__gt,
            pulp_created__gte=pulp_created__gte,
            pulp_created__isnull=pulp_created__isnull,
            pulp_created__lt=pulp_created__lt,
            pulp_created__lte=pulp_created__lte,
            pulp_created__range=pulp_created__range,
            pulp_href__in=pulp_href__in,
            q=q,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedRepositoryVersionResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_serialize(
        self,
        python_python_repository_href,
        x_task_diagnostics,
        content,
        content__in,
        limit,
        number,
        number__gt,
        number__gte,
        number__lt,
        number__lte,
        number__range,
        offset,
        ordering,
        prn__in,
        pulp_created,
        pulp_created__gt,
        pulp_created__gte,
        pulp_created__isnull,
        pulp_created__lt,
        pulp_created__lte,
        pulp_created__range,
        pulp_href__in,
        q,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'content__in': 'csv',
            'number__range': 'csv',
            'ordering': 'csv',
            'prn__in': 'csv',
            'pulp_created__range': 'csv',
            'pulp_href__in': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_python_repository_href is not None:
            _path_params['python_python_repository_href'] = python_python_repository_href
        # process the query parameters
        if content is not None:
            
            _query_params.append(('content', content))
            
        if content__in is not None:
            
            _query_params.append(('content__in', content__in))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if number is not None:
            
            _query_params.append(('number', number))
            
        if number__gt is not None:
            
            _query_params.append(('number__gt', number__gt))
            
        if number__gte is not None:
            
            _query_params.append(('number__gte', number__gte))
            
        if number__lt is not None:
            
            _query_params.append(('number__lt', number__lt))
            
        if number__lte is not None:
            
            _query_params.append(('number__lte', number__lte))
            
        if number__range is not None:
            
            _query_params.append(('number__range', number__range))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if prn__in is not None:
            
            _query_params.append(('prn__in', prn__in))
            
        if pulp_created is not None:
            if isinstance(pulp_created, datetime):
                _query_params.append(
                    (
                        'pulp_created',
                        pulp_created.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('pulp_created', pulp_created))
            
        if pulp_created__gt is not None:
            if isinstance(pulp_created__gt, datetime):
                _query_params.append(
                    (
                        'pulp_created__gt',
                        pulp_created__gt.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('pulp_created__gt', pulp_created__gt))
            
        if pulp_created__gte is not None:
            if isinstance(pulp_created__gte, datetime):
                _query_params.append(
                    (
                        'pulp_created__gte',
                        pulp_created__gte.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('pulp_created__gte', pulp_created__gte))
            
        if pulp_created__isnull is not None:
            
            _query_params.append(('pulp_created__isnull', pulp_created__isnull))
            
        if pulp_created__lt is not None:
            if isinstance(pulp_created__lt, datetime):
                _query_params.append(
                    (
                        'pulp_created__lt',
                        pulp_created__lt.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('pulp_created__lt', pulp_created__lt))
            
        if pulp_created__lte is not None:
            if isinstance(pulp_created__lte, datetime):
                _query_params.append(
                    (
                        'pulp_created__lte',
                        pulp_created__lte.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('pulp_created__lte', pulp_created__lte))
            
        if pulp_created__range is not None:
            
            _query_params.append(('pulp_created__range', pulp_created__range))
            
        if pulp_href__in is not None:
            
            _query_params.append(('pulp_href__in', pulp_href__in))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{python_python_repository_href}versions/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def read(
        self,
        python_python_repository_version_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RepositoryVersionResponse:
        """Inspect a repository version

        PythonRepositoryVersion represents a single Python repository version.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RepositoryVersionResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_with_http_info(
        self,
        python_python_repository_version_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RepositoryVersionResponse]:
        """Inspect a repository version

        PythonRepositoryVersion represents a single Python repository version.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RepositoryVersionResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_without_preload_content(
        self,
        python_python_repository_version_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Inspect a repository version

        PythonRepositoryVersion represents a single Python repository version.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RepositoryVersionResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_serialize(
        self,
        python_python_repository_version_href,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_python_repository_version_href is not None:
            _path_params['python_python_repository_version_href'] = python_python_repository_version_href
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{python_python_repository_version_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def repair(
        self,
        python_python_repository_version_href: StrictStr,
        repair: Repair,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AsyncOperationResponse:
        """repair

        Trigger an asynchronous task to repair a repository version.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param repair: (required)
        :type repair: Repair
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._repair_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            repair=repair,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def repair_with_http_info(
        self,
        python_python_repository_version_href: StrictStr,
        repair: Repair,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AsyncOperationResponse]:
        """repair

        Trigger an asynchronous task to repair a repository version.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param repair: (required)
        :type repair: Repair
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._repair_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            repair=repair,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def repair_without_preload_content(
        self,
        python_python_repository_version_href: StrictStr,
        repair: Repair,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """repair

        Trigger an asynchronous task to repair a repository version.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param repair: (required)
        :type repair: Repair
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._repair_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            repair=repair,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _repair_serialize(
        self,
        python_python_repository_version_href,
        repair,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_python_repository_version_href is not None:
            _path_params['python_python_repository_version_href'] = python_python_repository_version_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if repair is not None:
            _body_params = repair


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{python_python_repository_version_href}repair/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def scan(
        self,
        python_python_repository_version_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AsyncOperationResponse:
        """Generate vulnerability report

        Scan a repository version for vulnerabilities.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._scan_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def scan_with_http_info(
        self,
        python_python_repository_version_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AsyncOperationResponse]:
        """Generate vulnerability report

        Scan a repository version for vulnerabilities.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._scan_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def scan_without_preload_content(
        self,
        python_python_repository_version_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generate vulnerability report

        Scan a repository version for vulnerabilities.

        :param python_python_repository_version_href: (required)
        :type python_python_repository_version_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._scan_serialize(
            python_python_repository_version_href=python_python_repository_version_href,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _scan_serialize(
        self,
        python_python_repository_version_href,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_python_repository_version_href is not None:
            _path_params['python_python_repository_version_href'] = python_python_repository_version_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{python_python_repository_version_href}scan/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


