# pulp_python-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 3.7.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_python
from pulpcore.client.pulp_python.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_python.Configuration(
    host = "https://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_python.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulp_python.Configuration(
    host = "https://pulp",
    api_key = {
        'sessionid': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['sessionid'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_python.ContentPackagesApi(api_client)
    relative_path = 'relative_path_example' # str | Path where the artifact is located relative to distributions base_path
artifact = 'artifact_example' # str | Artifact file representing the physical content (optional)
file = '/path/to/file' # file | An uploaded file that may be turned into the artifact of the content unit. (optional)
repository = 'repository_example' # str | A URI of a repository the new content unit should be associated with. (optional)
upload = 'upload_example' # str | An uncommitted upload that may be turned into the artifact of the content unit. (optional)
sha256 = '' # str | The SHA256 digest of this package. (optional) (default to '')
summary = 'summary_example' # str | A one-line summary of what the package does. (optional)
description = 'description_example' # str | A longer description of the package that can run to several paragraphs. (optional)
description_content_type = 'description_content_type_example' # str | A string stating the markup syntax (if any) used in the distribution’s description, so that tools can intelligently render the description. (optional)
keywords = 'keywords_example' # str | Additional keywords to be used to assist searching for the package in a larger catalog. (optional)
home_page = 'home_page_example' # str | The URL for the package's home page. (optional)
download_url = 'download_url_example' # str | Legacy field denoting the URL from which this package can be downloaded. (optional)
author = 'author_example' # str | Text containing the author's name. Contact information can also be added, separated with newlines. (optional)
author_email = 'author_email_example' # str | The author's e-mail address.  (optional)
maintainer = 'maintainer_example' # str | The maintainer's name at a minimum; additional contact information may be provided. (optional)
maintainer_email = 'maintainer_email_example' # str | The maintainer's e-mail address. (optional)
license = 'license_example' # str | Text indicating the license covering the distribution (optional)
requires_python = 'requires_python_example' # str | The Python version(s) that the distribution is guaranteed to be compatible with. (optional)
project_url = 'project_url_example' # str | A browsable URL for the project and a label for it, separated by a comma. (optional)
project_urls = None # object | A dictionary of labels and URLs for the project. (optional)
platform = 'platform_example' # str | A comma-separated list of platform specifications, summarizing the operating systems supported by the package. (optional)
supported_platform = 'supported_platform_example' # str | Field to specify the OS and CPU for which the binary package was compiled.  (optional)
requires_dist = None # object | A JSON list containing names of some other distutils project required by this distribution. (optional)
provides_dist = None # object | A JSON list containing names of a Distutils project which is contained within this distribution. (optional)
obsoletes_dist = None # object | A JSON list containing names of a distutils project's distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time. (optional)
requires_external = None # object | A JSON list containing some dependency in the system that the distribution is to be used. (optional)
classifiers = None # object | A JSON list containing classification values for a Python package. (optional)

    try:
        # Create a python package content
        api_response = api_instance.create(relative_path, artifact=artifact, file=file, repository=repository, upload=upload, sha256=sha256, summary=summary, description=description, description_content_type=description_content_type, keywords=keywords, home_page=home_page, download_url=download_url, author=author, author_email=author_email, maintainer=maintainer, maintainer_email=maintainer_email, license=license, requires_python=requires_python, project_url=project_url, project_urls=project_urls, platform=platform, supported_platform=supported_platform, requires_dist=requires_dist, provides_dist=provides_dist, obsoletes_dist=obsoletes_dist, requires_external=requires_external, classifiers=classifiers)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContentPackagesApi->create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentPackagesApi* | [**create**](docs/ContentPackagesApi.md#create) | **POST** /pulp/api/v3/content/python/packages/ | Create a python package content
*ContentPackagesApi* | [**list**](docs/ContentPackagesApi.md#list) | **GET** /pulp/api/v3/content/python/packages/ | List python package contents
*ContentPackagesApi* | [**read**](docs/ContentPackagesApi.md#read) | **GET** {python_python_package_content_href} | Inspect a python package content
*DistributionsPypiApi* | [**create**](docs/DistributionsPypiApi.md#create) | **POST** /pulp/api/v3/distributions/python/pypi/ | Create a python distribution
*DistributionsPypiApi* | [**delete**](docs/DistributionsPypiApi.md#delete) | **DELETE** {python_python_distribution_href} | Delete a python distribution
*DistributionsPypiApi* | [**list**](docs/DistributionsPypiApi.md#list) | **GET** /pulp/api/v3/distributions/python/pypi/ | List python distributions
*DistributionsPypiApi* | [**partial_update**](docs/DistributionsPypiApi.md#partial_update) | **PATCH** {python_python_distribution_href} | Update a python distribution
*DistributionsPypiApi* | [**read**](docs/DistributionsPypiApi.md#read) | **GET** {python_python_distribution_href} | Inspect a python distribution
*DistributionsPypiApi* | [**update**](docs/DistributionsPypiApi.md#update) | **PUT** {python_python_distribution_href} | Update a python distribution
*PublicationsPypiApi* | [**create**](docs/PublicationsPypiApi.md#create) | **POST** /pulp/api/v3/publications/python/pypi/ | Create a python publication
*PublicationsPypiApi* | [**delete**](docs/PublicationsPypiApi.md#delete) | **DELETE** {python_python_publication_href} | Delete a python publication
*PublicationsPypiApi* | [**list**](docs/PublicationsPypiApi.md#list) | **GET** /pulp/api/v3/publications/python/pypi/ | List python publications
*PublicationsPypiApi* | [**read**](docs/PublicationsPypiApi.md#read) | **GET** {python_python_publication_href} | Inspect a python publication
*PypiApi* | [**read**](docs/PypiApi.md#read) | **GET** /pypi/{path}/ | Get index summary
*PypiLegacyApi* | [**create**](docs/PypiLegacyApi.md#create) | **POST** /pypi/{path}/legacy/ | Upload a package
*PypiMetadataApi* | [**read**](docs/PypiMetadataApi.md#read) | **GET** /pypi/{path}/pypi/{meta}/ | Get package metadata
*PypiSimpleApi* | [**create**](docs/PypiSimpleApi.md#create) | **POST** /pypi/{path}/simple/ | Upload a package
*PypiSimpleApi* | [**read**](docs/PypiSimpleApi.md#read) | **GET** /pypi/{path}/simple/ | Get index simple page
*PypiSimpleApi* | [**read_0**](docs/PypiSimpleApi.md#read_0) | **GET** /pypi/{path}/simple/{package}/ | Get package simple page
*RemotesPythonApi* | [**create**](docs/RemotesPythonApi.md#create) | **POST** /pulp/api/v3/remotes/python/python/ | Create a python remote
*RemotesPythonApi* | [**delete**](docs/RemotesPythonApi.md#delete) | **DELETE** {python_python_remote_href} | Delete a python remote
*RemotesPythonApi* | [**from_bandersnatch**](docs/RemotesPythonApi.md#from_bandersnatch) | **POST** /pulp/api/v3/remotes/python/python/from_bandersnatch/ | Create from Bandersnatch
*RemotesPythonApi* | [**list**](docs/RemotesPythonApi.md#list) | **GET** /pulp/api/v3/remotes/python/python/ | List python remotes
*RemotesPythonApi* | [**partial_update**](docs/RemotesPythonApi.md#partial_update) | **PATCH** {python_python_remote_href} | Update a python remote
*RemotesPythonApi* | [**read**](docs/RemotesPythonApi.md#read) | **GET** {python_python_remote_href} | Inspect a python remote
*RemotesPythonApi* | [**update**](docs/RemotesPythonApi.md#update) | **PUT** {python_python_remote_href} | Update a python remote
*RepositoriesPythonApi* | [**create**](docs/RepositoriesPythonApi.md#create) | **POST** /pulp/api/v3/repositories/python/python/ | Create a python repository
*RepositoriesPythonApi* | [**delete**](docs/RepositoriesPythonApi.md#delete) | **DELETE** {python_python_repository_href} | Delete a python repository
*RepositoriesPythonApi* | [**list**](docs/RepositoriesPythonApi.md#list) | **GET** /pulp/api/v3/repositories/python/python/ | List python repositorys
*RepositoriesPythonApi* | [**modify**](docs/RepositoriesPythonApi.md#modify) | **POST** {python_python_repository_href}modify/ | Modify Repository Content
*RepositoriesPythonApi* | [**partial_update**](docs/RepositoriesPythonApi.md#partial_update) | **PATCH** {python_python_repository_href} | Update a python repository
*RepositoriesPythonApi* | [**read**](docs/RepositoriesPythonApi.md#read) | **GET** {python_python_repository_href} | Inspect a python repository
*RepositoriesPythonApi* | [**sync**](docs/RepositoriesPythonApi.md#sync) | **POST** {python_python_repository_href}sync/ | Sync from remote
*RepositoriesPythonApi* | [**update**](docs/RepositoriesPythonApi.md#update) | **PUT** {python_python_repository_href} | Update a python repository
*RepositoriesPythonVersionsApi* | [**delete**](docs/RepositoriesPythonVersionsApi.md#delete) | **DELETE** {python_python_repository_version_href} | Delete a repository version
*RepositoriesPythonVersionsApi* | [**list**](docs/RepositoriesPythonVersionsApi.md#list) | **GET** {python_python_repository_href}versions/ | List repository versions
*RepositoriesPythonVersionsApi* | [**read**](docs/RepositoriesPythonVersionsApi.md#read) | **GET** {python_python_repository_version_href} | Inspect a repository version
*RepositoriesPythonVersionsApi* | [**repair**](docs/RepositoriesPythonVersionsApi.md#repair) | **POST** {python_python_repository_version_href}repair/ | 


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [ExcludePlatformsEnum](docs/ExcludePlatformsEnum.md)
 - [PackageMetadataResponse](docs/PackageMetadataResponse.md)
 - [PackageTypesEnum](docs/PackageTypesEnum.md)
 - [PackageUpload](docs/PackageUpload.md)
 - [PackageUploadTaskResponse](docs/PackageUploadTaskResponse.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedpythonPythonDistributionResponseList](docs/PaginatedpythonPythonDistributionResponseList.md)
 - [PaginatedpythonPythonPackageContentResponseList](docs/PaginatedpythonPythonPackageContentResponseList.md)
 - [PaginatedpythonPythonPublicationResponseList](docs/PaginatedpythonPythonPublicationResponseList.md)
 - [PaginatedpythonPythonRemoteResponseList](docs/PaginatedpythonPythonRemoteResponseList.md)
 - [PaginatedpythonPythonRepositoryResponseList](docs/PaginatedpythonPythonRepositoryResponseList.md)
 - [PatchedpythonPythonDistribution](docs/PatchedpythonPythonDistribution.md)
 - [PatchedpythonPythonRemote](docs/PatchedpythonPythonRemote.md)
 - [PatchedpythonPythonRepository](docs/PatchedpythonPythonRepository.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [PythonBanderRemote](docs/PythonBanderRemote.md)
 - [PythonPythonDistribution](docs/PythonPythonDistribution.md)
 - [PythonPythonDistributionResponse](docs/PythonPythonDistributionResponse.md)
 - [PythonPythonPackageContent](docs/PythonPythonPackageContent.md)
 - [PythonPythonPackageContentResponse](docs/PythonPythonPackageContentResponse.md)
 - [PythonPythonPublication](docs/PythonPythonPublication.md)
 - [PythonPythonPublicationResponse](docs/PythonPythonPublicationResponse.md)
 - [PythonPythonRemote](docs/PythonPythonRemote.md)
 - [PythonPythonRemoteResponse](docs/PythonPythonRemoteResponse.md)
 - [PythonPythonRepository](docs/PythonPythonRepository.md)
 - [PythonPythonRepositoryResponse](docs/PythonPythonRepositoryResponse.md)
 - [Repair](docs/Repair.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositorySyncURL](docs/RepositorySyncURL.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [SummaryResponse](docs/SummaryResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## Author

pulp-list@redhat.com


