# Generated by Django 4.2.26 on 2025-11-11 21:43

from django.db import migrations, models, transaction


def add_size_to_current_models(apps, schema_editor):
    """Adds the size to current PythonPackageContent models."""
    PythonPackageContent = apps.get_model("python", "PythonPackageContent")
    RemoteArtifact = apps.get_model("core", "RemoteArtifact")
    package_bulk = []
    for python_package in PythonPackageContent.objects.only("pk", "size").iterator():
        content_artifact = python_package.contentartifact_set.first()
        if content_artifact.artifact:
            artifact = content_artifact.artifact
        else:
            artifact = RemoteArtifact.objects.filter(content_artifact=content_artifact).first()
        python_package.size = artifact.size or 0
        package_bulk.append(python_package)
        if len(package_bulk) == 100000:
            with transaction.atomic():
                PythonPackageContent.objects.bulk_update(
                    package_bulk,
                    [
                        "size",
                    ],
                )
                package_bulk = []
    with transaction.atomic():
        PythonPackageContent.objects.bulk_update(
            package_bulk,
            [
                "size",
            ],
        )


class Migration(migrations.Migration):

    dependencies = [
        ("python", "0016_pythonpackagecontent_metadata_sha256"),
    ]

    operations = [
        migrations.AddField(
            model_name="pythonpackagecontent",
            name="size",
            field=models.BigIntegerField(default=0),
        ),
        migrations.RunPython(add_size_to_current_models, migrations.RunPython.noop, elidable=True),
    ]
