# Generated by Django 4.2.23 on 2025-08-12 18:24

import django.contrib.postgres.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    replaces = [
        ("python", "0001_initial"),
        ("python", "0002_pythonpackagecontent_python_version"),
        ("python", "0003_new_sync_filters"),
        ("python", "0004_DATA_swap_distribution_model"),
        ("python", "0005_pythonpackagecontent_sha256"),
        ("python", "0006_pythonrepository_autopublish"),
        ("python", "0007_pythonpackagecontent_mv-2-1"),
        ("python", "0008_pythonpackagecontent_unique_sha256"),
        ("python", "0009_pythondistribution_allow_uploads"),
        ("python", "0010_update_json_field"),
    ]

    initial = True

    dependencies = [
        ("core", "0091_systemid"),
    ]

    operations = [
        migrations.CreateModel(
            name="PythonRemote",
            fields=[
                (
                    "remote_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="python_pythonremote",
                        serialize=False,
                        to="core.remote",
                    ),
                ),
                ("prereleases", models.BooleanField(default=False)),
                ("includes", django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ("excludes", django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                (
                    "exclude_platforms",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(blank=True, max_length=10),
                        choices=[
                            ("windows", "windows"),
                            ("macos", "macos"),
                            ("freebsd", "freebsd"),
                            ("linux", "linux"),
                        ],
                        default=list,
                        size=None,
                    ),
                ),
                ("keep_latest_packages", models.IntegerField(default=0)),
                (
                    "package_types",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(blank=True, max_length=15),
                        choices=[
                            ("bdist_dmg", "bdist_dmg"),
                            ("bdist_dumb", "bdist_dumb"),
                            ("bdist_egg", "bdist_egg"),
                            ("bdist_msi", "bdist_msi"),
                            ("bdist_rpm", "bdist_rpm"),
                            ("bdist_wheel", "bdist_wheel"),
                            ("bdist_wininst", "bdist_wininst"),
                            ("sdist", "sdist"),
                        ],
                        default=list,
                        size=None,
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.remote",),
        ),
        migrations.CreateModel(
            name="PythonPublication",
            fields=[
                (
                    "publication_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="python_pythonpublication",
                        serialize=False,
                        to="core.publication",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.publication",),
        ),
        migrations.CreateModel(
            name="PythonDistribution",
            fields=[
                (
                    "distribution_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="python_pythondistribution",
                        serialize=False,
                        to="core.distribution",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.distribution",),
        ),
        migrations.CreateModel(
            name="PythonRepository",
            fields=[
                (
                    "repository_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="python_pythonrepository",
                        serialize=False,
                        to="core.repository",
                    ),
                ),
                ("autopublish", models.BooleanField(default=False)),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.repository",),
        ),
        migrations.CreateModel(
            name="PythonPackageContent",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="python_pythonpackagecontent",
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("filename", models.TextField(db_index=True)),
                (
                    "packagetype",
                    models.TextField(
                        choices=[
                            ("bdist_dmg", "bdist_dmg"),
                            ("bdist_dumb", "bdist_dumb"),
                            ("bdist_egg", "bdist_egg"),
                            ("bdist_msi", "bdist_msi"),
                            ("bdist_rpm", "bdist_rpm"),
                            ("bdist_wheel", "bdist_wheel"),
                            ("bdist_wininst", "bdist_wininst"),
                            ("sdist", "sdist"),
                        ]
                    ),
                ),
                ("name", models.TextField()),
                ("version", models.TextField()),
                ("metadata_version", models.TextField()),
                ("summary", models.TextField()),
                ("description", models.TextField()),
                ("keywords", models.TextField()),
                ("home_page", models.TextField()),
                ("download_url", models.TextField()),
                ("author", models.TextField()),
                ("author_email", models.TextField()),
                ("maintainer", models.TextField()),
                ("maintainer_email", models.TextField()),
                ("license", models.TextField()),
                ("requires_python", models.TextField()),
                ("project_url", models.TextField()),
                ("platform", models.TextField()),
                ("supported_platform", models.TextField()),
                ("requires_dist", django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ("provides_dist", django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ("obsoletes_dist", django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ("requires_external", django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ("classifiers", django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ("python_version", models.TextField()),
                ("sha256", models.CharField(db_index=True, max_length=64, unique=True)),
                ("description_content_type", models.TextField()),
                ("project_urls", django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "unique_together": {("sha256",)},
            },
            bases=("core.content",),
        ),
        migrations.AddField(
            model_name="pythondistribution",
            name="allow_uploads",
            field=models.BooleanField(default=True),
        ),
        migrations.AlterField(
            model_name="pythonpackagecontent",
            name="classifiers",
            field=models.JSONField(default=list),
        ),
        migrations.AlterField(
            model_name="pythonpackagecontent",
            name="obsoletes_dist",
            field=models.JSONField(default=list),
        ),
        migrations.AlterField(
            model_name="pythonpackagecontent",
            name="project_urls",
            field=models.JSONField(default=dict),
        ),
        migrations.AlterField(
            model_name="pythonpackagecontent",
            name="provides_dist",
            field=models.JSONField(default=list),
        ),
        migrations.AlterField(
            model_name="pythonpackagecontent",
            name="requires_dist",
            field=models.JSONField(default=list),
        ),
        migrations.AlterField(
            model_name="pythonpackagecontent",
            name="requires_external",
            field=models.JSONField(default=list),
        ),
        migrations.AlterField(
            model_name="pythonremote",
            name="excludes",
            field=models.JSONField(default=list),
        ),
        migrations.AlterField(
            model_name="pythonremote",
            name="includes",
            field=models.JSONField(default=list),
        ),
    ]
