from pulpcore.plugin.models import RepositoryVersion
from pulpcore.plugin.sync import sync_to_async_iterable

from pulp_python.app.models import PythonPackageContent


async def get_repo_version_content(repo_version_pk: str):
    """
    Retrieve Python package content from a repository version for vulnerability scanning.
    """
    repo_version = await RepositoryVersion.objects.aget(pk=repo_version_pk)
    content_units = PythonPackageContent.objects.filter(pk__in=repo_version.content).only(
        "name", "version"
    )
    ecosystem = "PyPI"
    async for content in sync_to_async_iterable(content_units):
        repo_content_osv_data = _build_osv_data(content.name, ecosystem, content.version)
        repo_content_osv_data["repo_version"] = repo_version
        repo_content_osv_data["content"] = content
        yield repo_content_osv_data


def _build_osv_data(name, ecosystem, version=None):
    """
    Build an OSV data structure for vulnerability queries.
    """
    osv_data = {"package": {"name": name, "ecosystem": ecosystem}}
    if version:
        osv_data["version"] = version
    return osv_data
