import pytest

from pulp_python.tests.functional.constants import (
    PYPI_URL,
    VULNERABILITY_REPORT_TEST_PACKAGE_NAME,
    VULNERABILITY_REPORT_TEST_PACKAGES,
)


@pytest.mark.parallel
def test_vulnerability_report(
    pulpcore_bindings, python_bindings, python_repo, python_remote_factory, monitor_task
):

    # Sync the test repository.
    remote = python_remote_factory(url=PYPI_URL, includes=VULNERABILITY_REPORT_TEST_PACKAGES)
    sync_data = dict(remote=remote.pulp_href)
    response = python_bindings.RepositoriesPythonApi.sync(python_repo.pulp_href, sync_data)
    monitor_task(response.task)

    # get repo latest version
    repo = python_bindings.RepositoriesPythonApi.read(python_repo.pulp_href)
    latest_version_href = repo.latest_version_href

    # scan
    response = python_bindings.RepositoriesPythonVersionsApi.scan(
        python_python_repository_version_href=latest_version_href
    )
    monitor_task(response.task)

    # checks
    vulns_list = pulpcore_bindings.VulnReportApi.list()
    assert len(vulns_list.results) > 0
    for results in vulns_list.results:
        assert len(results.vulns) > 0
        for vuln in results.vulns:
            assert VULNERABILITY_REPORT_TEST_PACKAGE_NAME.lower() in (
                affected["package"]["name"] for affected in vuln["affected"]
            )

    repo_version = python_bindings.RepositoriesPythonVersionsApi.read(latest_version_href)
    assert repo_version.vuln_report is not None

    python_packages = python_bindings.ContentPackagesApi.list(
        name=VULNERABILITY_REPORT_TEST_PACKAGE_NAME, repository_version=latest_version_href
    )
    for content in python_packages.results:
        assert content.vuln_report is not None
