# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawWebhooksClient, RawWebhooksClient
from .types.create_webhook_link_response import CreateWebhookLinkResponse


class WebhooksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWebhooksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWebhooksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWebhooksClient
        """
        return self._raw_client

    def create_webhook_link(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateWebhookLinkResponse:
        """
        Generates a temporary link to the Svix webhook portal where users can manage their webhook endpoints and view message logs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateWebhookLinkResponse
            Webhook portal link created

        Examples
        --------
        from pulse import Pulse

        client = Pulse(
            api_key="YOUR_API_KEY",
        )
        client.webhooks.create_webhook_link()
        """
        _response = self._raw_client.create_webhook_link(request_options=request_options)
        return _response.data


class AsyncWebhooksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWebhooksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWebhooksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWebhooksClient
        """
        return self._raw_client

    async def create_webhook_link(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateWebhookLinkResponse:
        """
        Generates a temporary link to the Svix webhook portal where users can manage their webhook endpoints and view message logs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateWebhookLinkResponse
            Webhook portal link created

        Examples
        --------
        import asyncio

        from pulse import AsyncPulse

        client = AsyncPulse(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.webhooks.create_webhook_link()


        asyncio.run(main())
        """
        _response = await self._raw_client.create_webhook_link(request_options=request_options)
        return _response.data
