# 🛠️ py-agent-tool

**Development and debugging tools for the Intelligent Agents Platform**

[![PyPI](https://img.shields.io/pypi/v/py-agent-tool)](https://pypi.org/project/py-agent-tool/)
[![Python](https://img.shields.io/pypi/pyversions/py-agent-tool)](https://pypi.org/project/py-agent-tool/)
[![Status](https://img.shields.io/badge/Status-In%20Development-orange)](https://pypi.org/project/py-agent-tool/)

## 🚧 Currently Under Development

**py-agent-tool** provides essential development and debugging utilities for the **Intelligent Agents Platform (IAP)**. Build, test, and debug your MCP applications with professional-grade tools.

## 🎯 What's Coming

- 🔍 MCP connection testing and validation
- 📊 Performance monitoring and profiling
- 🧪 Testing frameworks and mock servers
- 🔧 CLI tools for development workflow
- 📝 Code generation and scaffolding

## 🚀 Get Started Now

While **py-agent-tool** is under development, start building with:

```bash
pip install py-agent-client
```

## 🏗️ Part of IAP Ecosystem

```
py-agent-core      🚧 Foundation
├── py-agent-client     ✅ Available Now!
├── py-agent-server     🚧 Coming Soon
├── py-agent-tool       🚧 In Development (You are here)
└── py-agent-resources  🚧 Coming Soon
```

## 📅 Development Status

| Tool | Status | Expected |
|------|--------|----------|
| Connection Tester | 🚧 In Progress | Q3 2025 |
| Performance Monitor | 📋 Planned | Q4 2025 |
| CLI Interface | 📋 Planned | Q1 2026 |

## 🔮 Preview

```bash
# Coming soon to py-agent-tool
py-agent-tool test-connection ws://localhost:8080
py-agent-tool validate-server --config server.json
py-agent-tool generate-client --template basic
py-agent-tool monitor --dashboard
```

## 📚 Resources

- 📖 **[Documentation](https://github.com/fmonfasani/intelligent-agents-platform/wiki)**
- 🔗 **[GitHub Repository](https://github.com/fmonfasani/intelligent-agents-platform)**
- 🐛 **[Report Issues](https://github.com/fmonfasani/intelligent-agents-platform/issues)**

## 📧 Contact

**Federico Monfasani** - fmonfasani@gmail.com

---

**🚀 Professional development tools coming soon!**