/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class JavacTaskImpl
extends BasicJavacTask {
    private Main compilerMain;
    private JavaCompiler compiler;
    private Locale locale;
    private String[] args;
    private String[] classNames;
    private List<JavaFileObject> fileObjects;
    private Map<JavaFileObject, JCTree.JCCompilationUnit> notYetEntered;
    private ListBuffer<Env<AttrContext>> genList;
    private final AtomicBoolean used = new AtomicBoolean();
    private Iterable<? extends Processor> processors;
    private Main.Result result = null;
    private boolean parsed = false;

    JavacTaskImpl(Main main, String[] stringArray, String[] stringArray2, Context context, List<JavaFileObject> list) {
        super(null, false);
        this.compilerMain = main;
        this.args = stringArray;
        this.classNames = stringArray2;
        this.context = context;
        this.fileObjects = list;
        this.setLocale(Locale.getDefault());
        main.getClass();
        stringArray.getClass();
        list.getClass();
    }

    JavacTaskImpl(Main main, Iterable<String> iterable, Context context, Iterable<String> iterable2, Iterable<? extends JavaFileObject> iterable3) {
        this(main, JavacTaskImpl.toArray(iterable), JavacTaskImpl.toArray(iterable2), context, JavacTaskImpl.toList(iterable3));
    }

    private static String[] toArray(Iterable<String> iterable) {
        ListBuffer<String> listBuffer = new ListBuffer<String>();
        if (iterable != null) {
            for (String string : iterable) {
                listBuffer.append(string);
            }
        }
        return listBuffer.toArray(new String[listBuffer.length()]);
    }

    private static List<JavaFileObject> toList(Iterable<? extends JavaFileObject> iterable) {
        if (iterable == null) {
            return List.nil();
        }
        ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        for (JavaFileObject javaFileObject : iterable) {
            listBuffer.append(javaFileObject);
        }
        return listBuffer.toList();
    }

    public Main.Result doCall() {
        if (!this.used.getAndSet(true)) {
            this.initContext();
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            this.compilerMain.setAPIMode(true);
            this.result = this.compilerMain.compile(this.args, this.classNames, this.context, this.fileObjects, this.processors);
            this.cleanup();
            return this.result;
        }
        throw new IllegalStateException("multiple calls to method 'call'");
    }

    @Override
    public Boolean call() {
        return this.doCall().isOK();
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> iterable) {
        iterable.getClass();
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.processors = iterable;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.locale = locale;
    }

    private void prepareCompiler() throws IOException {
        if (this.used.getAndSet(true)) {
            if (this.compiler == null) {
                throw new IllegalStateException();
            }
        } else {
            this.initContext();
            this.compilerMain.log = Log.instance(this.context);
            this.compilerMain.setOptions(Options.instance(this.context));
            this.compilerMain.filenames = new LinkedHashSet<File>();
            Collection<File> collection = this.compilerMain.processArgs(CommandLine.parse(this.args), this.classNames);
            if (collection != null && !collection.isEmpty()) {
                String string = String.valueOf(this.toString(collection, " "));
                throw new IllegalArgumentException(string.length() != 0 ? "Malformed arguments ".concat(string) : new String("Malformed arguments "));
            }
            this.compiler = JavaCompiler.instance(this.context);
            this.compiler.keepComments = true;
            this.compiler.genEndPos = true;
            this.compiler.initProcessAnnotations(this.processors);
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            for (JavaFileObject javaFileObject : this.fileObjects) {
                this.notYetEntered.put(javaFileObject, null);
            }
            this.genList = new ListBuffer();
            this.args = null;
            this.classNames = null;
        }
    }

    <T> String toString(Iterable<T> iterable, String string) {
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        for (T t : iterable) {
            stringBuilder.append(string2);
            stringBuilder.append(t.toString());
            string2 = string;
        }
        return stringBuilder.toString();
    }

    private void initContext() {
        this.context.put(JavacTask.class, this);
        this.context.put(Locale.class, this.locale);
    }

    void cleanup() {
        if (this.compiler != null) {
            this.compiler.close();
        }
        this.compiler = null;
        this.compilerMain = null;
        this.args = null;
        this.classNames = null;
        this.context = null;
        this.fileObjects = null;
        this.notYetEntered = null;
    }

    public JavaFileObject asJavaFileObject(File file) {
        JavacFileManager javacFileManager = (JavacFileManager)this.context.get(JavaFileManager.class);
        return javacFileManager.getRegularFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<? extends CompilationUnitTree> parse() throws IOException {
        try {
            this.prepareCompiler();
            List<JCTree.JCCompilationUnit> list = this.compiler.parseFiles(this.fileObjects);
            for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
                JavaFileObject javaFileObject = jCCompilationUnit.getSourceFile();
                if (!this.notYetEntered.containsKey(javaFileObject)) continue;
                this.notYetEntered.put(javaFileObject, jCCompilationUnit);
            }
            List<JCTree.JCCompilationUnit> list2 = list;
            return list2;
        }
        finally {
            this.parsed = true;
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
        }
    }

    public Iterable<? extends TypeElement> enter() throws IOException {
        return this.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends TypeElement> enter(Iterable<? extends CompilationUnitTree> iterable) throws IOException {
        Object object;
        if (iterable == null && this.notYetEntered != null && this.notYetEntered.isEmpty()) {
            return List.nil();
        }
        this.prepareCompiler();
        ListBuffer<JCTree.JCCompilationUnit> listBuffer = null;
        if (iterable == null) {
            if (this.notYetEntered.size() > 0) {
                if (!this.parsed) {
                    this.parse();
                }
                for (JavaFileObject object2 : this.fileObjects) {
                    object = this.notYetEntered.remove(object2);
                    if (object == null) continue;
                    if (listBuffer == null) {
                        listBuffer = new ListBuffer();
                    }
                    listBuffer.append((JCTree.JCCompilationUnit)object);
                }
                this.notYetEntered.clear();
            }
        } else {
            for (CompilationUnitTree compilationUnitTree : iterable) {
                if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
                    if (listBuffer == null) {
                        listBuffer = new ListBuffer<JCTree.JCCompilationUnit>();
                    }
                    listBuffer.append((JCTree.JCCompilationUnit)compilationUnitTree);
                    this.notYetEntered.remove(compilationUnitTree.getSourceFile());
                    continue;
                }
                throw new IllegalArgumentException(compilationUnitTree.toString());
            }
        }
        if (listBuffer == null) {
            return List.nil();
        }
        try {
            List<JCTree.JCCompilationUnit> list = this.compiler.enterTrees(listBuffer.toList());
            if (this.notYetEntered.isEmpty()) {
                this.compiler = this.compiler.processAnnotations(list);
            }
            ListBuffer<Symbol.ClassSymbol> listBuffer2 = new ListBuffer<Symbol.ClassSymbol>();
            object = list.iterator();
            while (object.hasNext()) {
                JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)object.next();
                for (JCTree jCTree : jCCompilationUnit.defs) {
                    if (!jCTree.hasTag(JCTree.Tag.CLASSDEF)) continue;
                    JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree;
                    if (jCClassDecl.sym == null) continue;
                    listBuffer2.append(jCClassDecl.sym);
                }
            }
            object = listBuffer2.toList();
            return object;
        }
        finally {
            this.compiler.log.flush();
        }
    }

    @Override
    public Iterable<? extends Element> analyze() throws IOException {
        return this.analyze(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends Element> analyze(Iterable<? extends TypeElement> iterable) throws IOException {
        this.enter(null);
        final ListBuffer<Element> listBuffer = new ListBuffer<Element>();
        try {
            if (iterable == null) {
                this.handleFlowResults(this.compiler.flow(this.compiler.attribute(this.compiler.todo)), listBuffer);
            } else {
                Filter filter = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.handleFlowResults(JavacTaskImpl.this.compiler.flow(JavacTaskImpl.this.compiler.attribute(env)), listBuffer);
                    }
                };
                filter.run(this.compiler.todo, iterable);
            }
        }
        finally {
            this.compiler.log.flush();
        }
        return listBuffer;
    }

    private void handleFlowResults(Queue<Env<AttrContext>> queue, ListBuffer<Element> listBuffer) {
        for (Env env : queue) {
            switch (env.tree.getTag()) {
                case CLASSDEF: {
                    JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)env.tree;
                    if (jCClassDecl.sym == null) break;
                    listBuffer.append(jCClassDecl.sym);
                    break;
                }
                case TOPLEVEL: {
                    JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)env.tree;
                    if (jCCompilationUnit.packge == null) break;
                    listBuffer.append(jCCompilationUnit.packge);
                }
            }
        }
        this.genList.addAll((Collection<Env<AttrContext>>)queue);
    }

    @Override
    public Iterable<? extends JavaFileObject> generate() throws IOException {
        return this.generate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends JavaFileObject> generate(Iterable<? extends TypeElement> iterable) throws IOException {
        final ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        try {
            this.analyze(null);
            if (iterable == null) {
                this.compiler.generate(this.compiler.desugar(this.genList), listBuffer);
                this.genList.clear();
            } else {
                Filter filter = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.compiler.generate(JavacTaskImpl.this.compiler.desugar(ListBuffer.of(env)), listBuffer);
                    }
                };
                filter.run(this.genList, iterable);
            }
            if (this.genList.isEmpty()) {
                this.compiler.reportDeferredDiagnostics();
                this.cleanup();
            }
        }
        finally {
            if (this.compiler != null) {
                this.compiler.log.flush();
            }
        }
        return listBuffer;
    }

    @Override
    public TypeMirror getTypeMirror(Iterable<? extends Tree> iterable) {
        Tree tree = null;
        Iterator<? extends Tree> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Tree tree2;
            tree = tree2 = iterator.next();
        }
        return ((JCTree)tree).type;
    }

    @Override
    public JavacElements getElements() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacElements.instance(this.context);
    }

    @Override
    public JavacTypes getTypes() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacTypes.instance(this.context);
    }

    public Iterable<? extends Tree> pathFor(CompilationUnitTree compilationUnitTree, Tree tree) {
        return TreeInfo.pathFor((JCTree)tree, (JCTree.JCCompilationUnit)compilationUnitTree).reverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type parseType(String string, TypeElement typeElement) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject javaFileObject = this.compiler.log.useSource(null);
        ParserFactory parserFactory = ParserFactory.instance(this.context);
        Attr attr = Attr.instance(this.context);
        try {
            CharBuffer charBuffer = CharBuffer.wrap(String.valueOf(string).concat("\u0000").toCharArray(), 0, string.length());
            JavacParser javacParser = parserFactory.newParser(charBuffer, false, false, false);
            JCTree.JCExpression jCExpression = javacParser.parseType();
            Type type = attr.attribType((JCTree)jCExpression, (Symbol.TypeSymbol)((Object)typeElement));
            return type;
        }
        finally {
            this.compiler.log.useSource(javaFileObject);
        }
    }

    abstract class Filter {
        Filter() {
        }

        void run(Queue<Env<AttrContext>> queue, Iterable<? extends TypeElement> iterable) {
            HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
            for (TypeElement object : iterable) {
                hashSet.add(object);
            }
            ListBuffer<Env<AttrContext>> listBuffer = new ListBuffer();
            while (queue.peek() != null) {
                Env<AttrContext> env = queue.remove();
                Symbol.ClassSymbol classSymbol = env.enclClass.sym;
                if (classSymbol != null && hashSet.contains(classSymbol.outermostClass())) {
                    this.process(env);
                    continue;
                }
                listBuffer = listBuffer.append(env);
            }
            queue.addAll((Collection<Env<AttrContext>>)listBuffer);
        }

        abstract void process(Env<AttrContext> var1);
    }
}

