/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.api.Messages;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Locale;

public abstract class Printer
implements Type.Visitor<String, Locale>,
Symbol.Visitor<String, Locale> {
    List<Type> seenCaptured = List.nil();
    static final int PRIME = 997;

    protected Printer() {
    }

    protected abstract String localize(Locale var1, String var2, Object ... var3);

    protected abstract String capturedVarId(Type.CapturedType var1, Locale var2);

    public static Printer createStandardPrinter(final Messages messages) {
        return new Printer(){

            @Override
            protected String localize(Locale locale, String string, Object ... objectArray) {
                return messages.getLocalizedString(locale, string, objectArray);
            }

            @Override
            protected String capturedVarId(Type.CapturedType capturedType, Locale locale) {
                long l = ((long)capturedType.hashCode() & 0xFFFFFFFFL) % 997L;
                return new StringBuilder(20).append(l).toString();
            }
        };
    }

    public String visitTypes(List<Type> list, Locale locale) {
        ListBuffer<String> listBuffer = new ListBuffer<String>();
        for (Type type : list) {
            listBuffer.append(this.visit(type, locale));
        }
        return listBuffer.toList().toString();
    }

    public String visitSymbols(List<Symbol> list, Locale locale) {
        ListBuffer<String> listBuffer = new ListBuffer<String>();
        for (Symbol symbol : list) {
            listBuffer.append(this.visit(symbol, locale));
        }
        return listBuffer.toList().toString();
    }

    public String visit(Type type, Locale locale) {
        return type.accept(this, locale);
    }

    public String visit(Symbol symbol, Locale locale) {
        return symbol.accept(this, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String visitCapturedType(Type.CapturedType capturedType, Locale locale) {
        if (this.seenCaptured.contains(capturedType)) {
            return this.localize(locale, "compiler.misc.type.captureof.1", this.capturedVarId(capturedType, locale));
        }
        try {
            this.seenCaptured = this.seenCaptured.prepend(capturedType);
            String string = this.localize(locale, "compiler.misc.type.captureof", this.capturedVarId(capturedType, locale), this.visit(capturedType.wildcard, locale));
            return string;
        }
        finally {
            this.seenCaptured = this.seenCaptured.tail;
        }
    }

    @Override
    public String visitForAll(Type.ForAll forAll, Locale locale) {
        String string = String.valueOf(String.valueOf(this.visitTypes(forAll.tvars, locale)));
        String string2 = String.valueOf(String.valueOf(this.visit(forAll.qtype, locale)));
        return new StringBuilder(2 + string.length() + string2.length()).append("<").append(string).append(">").append(string2).toString();
    }

    @Override
    public String visitUndetVar(Type.UndetVar undetVar, Locale locale) {
        if (undetVar.inst != null) {
            return this.visit(undetVar.inst, locale);
        }
        return String.valueOf(this.visit(undetVar.qtype, locale)).concat("?");
    }

    @Override
    public String visitArrayType(Type.ArrayType arrayType, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        this.printBaseElementType(arrayType, stringBuilder, locale);
        this.printBrackets(arrayType, stringBuilder, locale);
        return stringBuilder.toString();
    }

    void printBaseElementType(Type type, StringBuilder stringBuilder, Locale locale) {
        Type type2 = type;
        while (type2.hasTag(TypeTag.ARRAY)) {
            type2 = type2.unannotatedType();
            type2 = ((Type.ArrayType)type2).elemtype;
        }
        stringBuilder.append(this.visit(type2, locale));
    }

    void printBrackets(Type type, StringBuilder stringBuilder, Locale locale) {
        Type type2 = type;
        while (type2.hasTag(TypeTag.ARRAY)) {
            if (type2.isAnnotated()) {
                stringBuilder.append(' ');
                stringBuilder.append(type2.getAnnotationMirrors());
                stringBuilder.append(' ');
            }
            stringBuilder.append("[]");
            type2 = type2.unannotatedType();
            type2 = ((Type.ArrayType)type2).elemtype;
        }
    }

    @Override
    public String visitClassType(Type.ClassType classType, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        if (classType.getEnclosingType().hasTag(TypeTag.CLASS) && classType.tsym.owner.kind == 2) {
            stringBuilder.append(this.visit(classType.getEnclosingType(), locale));
            stringBuilder.append('.');
            stringBuilder.append(this.className(classType, false, locale));
        } else {
            stringBuilder.append(this.className(classType, true, locale));
        }
        if (((List)classType.getTypeArguments()).nonEmpty()) {
            stringBuilder.append('<');
            stringBuilder.append(this.visitTypes((List<Type>)classType.getTypeArguments(), locale));
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Override
    public String visitMethodType(Type.MethodType methodType, Locale locale) {
        String string = String.valueOf(String.valueOf(this.printMethodArgs(methodType.argtypes, false, locale)));
        String string2 = String.valueOf(String.valueOf(this.visit(methodType.restype, locale)));
        return new StringBuilder(2 + string.length() + string2.length()).append("(").append(string).append(")").append(string2).toString();
    }

    @Override
    public String visitPackageType(Type.PackageType packageType, Locale locale) {
        return packageType.tsym.getQualifiedName().toString();
    }

    @Override
    public String visitWildcardType(Type.WildcardType wildcardType, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)wildcardType.kind);
        if (wildcardType.kind != BoundKind.UNBOUND) {
            stringBuilder.append(this.visit(wildcardType.type, locale));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visitErrorType(Type.ErrorType errorType, Locale locale) {
        return this.visitType((Type)errorType, locale);
    }

    @Override
    public String visitTypeVar(Type.TypeVar typeVar, Locale locale) {
        return this.visitType((Type)typeVar, locale);
    }

    @Override
    public String visitAnnotatedType(Type.AnnotatedType annotatedType, Locale locale) {
        if (((List)annotatedType.getAnnotationMirrors()).nonEmpty()) {
            if (annotatedType.unannotatedType().hasTag(TypeTag.ARRAY)) {
                StringBuilder stringBuilder = new StringBuilder();
                this.printBaseElementType(annotatedType, stringBuilder, locale);
                this.printBrackets(annotatedType, stringBuilder, locale);
                return stringBuilder.toString();
            }
            if (annotatedType.unannotatedType().hasTag(TypeTag.CLASS) && annotatedType.unannotatedType().getEnclosingType() != Type.noType) {
                String string = String.valueOf(String.valueOf(this.visit(annotatedType.unannotatedType().getEnclosingType(), locale)));
                String string2 = String.valueOf(String.valueOf(annotatedType.getAnnotationMirrors()));
                String string3 = String.valueOf(String.valueOf(this.className((Type.ClassType)annotatedType.unannotatedType(), false, locale)));
                return new StringBuilder(3 + string.length() + string2.length() + string3.length()).append(string).append(". ").append(string2).append(" ").append(string3).toString();
            }
            String string = String.valueOf(String.valueOf(annotatedType.getAnnotationMirrors()));
            String string4 = String.valueOf(String.valueOf(this.visit(annotatedType.unannotatedType(), locale)));
            return new StringBuilder(1 + string.length() + string4.length()).append(string).append(" ").append(string4).toString();
        }
        return this.visit(annotatedType.unannotatedType(), locale);
    }

    @Override
    public String visitType(Type type, Locale locale) {
        String string = type.tsym == null || type.tsym.name == null ? this.localize(locale, "compiler.misc.type.none", new Object[0]) : type.tsym.name.toString();
        return string;
    }

    protected String className(Type.ClassType classType, boolean bl, Locale locale) {
        Symbol.TypeSymbol typeSymbol = classType.tsym;
        if (typeSymbol.name.length() == 0 && (typeSymbol.flags() & 0x1000000L) != 0L) {
            StringBuilder stringBuilder = new StringBuilder(this.visit(classType.supertype_field, locale));
            List<Type> list = classType.interfaces_field;
            while (list.nonEmpty()) {
                stringBuilder.append('&');
                stringBuilder.append(this.visit((Type)list.head, locale));
                list = list.tail;
            }
            return stringBuilder.toString();
        }
        if (typeSymbol.name.length() == 0) {
            Type.ClassType classType2 = (Type.ClassType)classType.tsym.type;
            String string = classType2 == null ? this.localize(locale, "compiler.misc.anonymous.class", new Object[]{null}) : (classType2.interfaces_field != null && classType2.interfaces_field.nonEmpty() ? this.localize(locale, "compiler.misc.anonymous.class", this.visit((Type)classType2.interfaces_field.head, locale)) : this.localize(locale, "compiler.misc.anonymous.class", this.visit(classType2.supertype_field, locale)));
            return string;
        }
        if (bl) {
            return typeSymbol.getQualifiedName().toString();
        }
        return typeSymbol.name.toString();
    }

    protected String printMethodArgs(List<Type> list, boolean bl, Locale locale) {
        if (!bl) {
            return this.visitTypes(list, locale);
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (list.tail.nonEmpty()) {
            stringBuilder.append(this.visit((Type)list.head, locale));
            list = list.tail;
            stringBuilder.append(',');
        }
        if (((Type)list.head).unannotatedType().hasTag(TypeTag.ARRAY)) {
            stringBuilder.append(this.visit(((Type.ArrayType)((Type)list.head).unannotatedType()).elemtype, locale));
            if (((List)((Type)list.head).getAnnotationMirrors()).nonEmpty()) {
                stringBuilder.append(' ');
                stringBuilder.append(((Type)list.head).getAnnotationMirrors());
                stringBuilder.append(' ');
            }
            stringBuilder.append("...");
        } else {
            stringBuilder.append(this.visit((Type)list.head, locale));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visitClassSymbol(Symbol.ClassSymbol classSymbol, Locale locale) {
        return classSymbol.name.isEmpty() ? this.localize(locale, "compiler.misc.anonymous.class", classSymbol.flatname) : classSymbol.fullname.toString();
    }

    @Override
    public String visitMethodSymbol(Symbol.MethodSymbol methodSymbol, Locale locale) {
        String string;
        if (methodSymbol.isStaticOrInstanceInit()) {
            return methodSymbol.owner.name.toString();
        }
        String string2 = string = methodSymbol.name == methodSymbol.name.table.names.init ? methodSymbol.owner.name.toString() : methodSymbol.name.toString();
        if (methodSymbol.type != null) {
            String string3;
            String string4;
            if (methodSymbol.type.hasTag(TypeTag.FORALL)) {
                string4 = String.valueOf(String.valueOf(this.visitTypes(methodSymbol.type.getTypeArguments(), locale)));
                string3 = String.valueOf(String.valueOf(string));
                string = new StringBuilder(2 + string4.length() + string3.length()).append("<").append(string4).append(">").append(string3).toString();
            }
            string4 = String.valueOf(string);
            string3 = String.valueOf(String.valueOf(this.printMethodArgs(methodSymbol.type.getParameterTypes(), (methodSymbol.flags() & 0x400000000L) != 0L, locale)));
            string = new StringBuilder(2 + string4.length() + string3.length()).append(string4).append("(").append(string3).append(")").toString();
        }
        return string;
    }

    @Override
    public String visitOperatorSymbol(Symbol.OperatorSymbol operatorSymbol, Locale locale) {
        return this.visitMethodSymbol((Symbol.MethodSymbol)operatorSymbol, locale);
    }

    @Override
    public String visitPackageSymbol(Symbol.PackageSymbol packageSymbol, Locale locale) {
        return packageSymbol.isUnnamed() ? this.localize(locale, "compiler.misc.unnamed.package", new Object[0]) : packageSymbol.fullname.toString();
    }

    @Override
    public String visitTypeSymbol(Symbol.TypeSymbol typeSymbol, Locale locale) {
        return this.visitSymbol((Symbol)typeSymbol, locale);
    }

    @Override
    public String visitVarSymbol(Symbol.VarSymbol varSymbol, Locale locale) {
        return this.visitSymbol((Symbol)varSymbol, locale);
    }

    @Override
    public String visitSymbol(Symbol symbol, Locale locale) {
        return symbol.name.toString();
    }
}

