/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import java.util.Map;
import javax.tools.JavaFileObject;

public class SymbolMetadata {
    private static final List<Attribute.Compound> DECL_NOT_STARTED = List.of(null);
    private static final List<Attribute.Compound> DECL_IN_PROGRESS = List.of(null);
    private List<Attribute.Compound> attributes = DECL_NOT_STARTED;
    private List<Attribute.TypeCompound> type_attributes = List.nil();
    private List<Attribute.TypeCompound> init_type_attributes = List.nil();
    private List<Attribute.TypeCompound> clinit_type_attributes = List.nil();
    private final Symbol sym;

    public SymbolMetadata(Symbol symbol) {
        this.sym = symbol;
    }

    public List<Attribute.Compound> getDeclarationAttributes() {
        return this.filterDeclSentinels(this.attributes);
    }

    public List<Attribute.TypeCompound> getTypeAttributes() {
        return this.type_attributes;
    }

    public List<Attribute.TypeCompound> getInitTypeAttributes() {
        return this.init_type_attributes;
    }

    public List<Attribute.TypeCompound> getClassInitTypeAttributes() {
        return this.clinit_type_attributes;
    }

    public void setDeclarationAttributes(List<Attribute.Compound> list) {
        Assert.check(this.pendingCompletion() || !this.isStarted());
        if (list == null) {
            throw new NullPointerException();
        }
        this.attributes = list;
    }

    public void setTypeAttributes(List<Attribute.TypeCompound> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.type_attributes = list;
    }

    public void setInitTypeAttributes(List<Attribute.TypeCompound> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.init_type_attributes = list;
    }

    public void setClassInitTypeAttributes(List<Attribute.TypeCompound> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.clinit_type_attributes = list;
    }

    public void setAttributes(SymbolMetadata symbolMetadata) {
        if (symbolMetadata == null) {
            throw new NullPointerException();
        }
        this.setDeclarationAttributes(symbolMetadata.getDeclarationAttributes());
        this.setTypeAttributes(symbolMetadata.getTypeAttributes());
        this.setInitTypeAttributes(symbolMetadata.getInitTypeAttributes());
        this.setClassInitTypeAttributes(symbolMetadata.getClassInitTypeAttributes());
    }

    public void setDeclarationAttributesWithCompletion(Annotate.AnnotateRepeatedContext<Attribute.Compound> annotateRepeatedContext) {
        Assert.check(this.pendingCompletion() || !this.isStarted() && this.sym.kind == 1);
        this.setDeclarationAttributes(this.getAttributesForCompletion(annotateRepeatedContext));
    }

    public void appendTypeAttributesWithCompletion(Annotate.AnnotateRepeatedContext<Attribute.TypeCompound> annotateRepeatedContext) {
        this.appendUniqueTypes(this.getAttributesForCompletion(annotateRepeatedContext));
    }

    private <T extends Attribute.Compound> List<T> getAttributesForCompletion(final Annotate.AnnotateRepeatedContext<T> annotateRepeatedContext) {
        Map map = annotateRepeatedContext.annotated;
        boolean bl = false;
        List<Object> list = List.nil();
        for (ListBuffer listBuffer : map.values()) {
            Placeholder<T> placeholder;
            if (listBuffer.size() == 1) {
                list = list.prepend(listBuffer.first());
                continue;
            }
            Placeholder<T> placeholder2 = placeholder = new Placeholder<T>(annotateRepeatedContext, listBuffer.toList(), this.sym);
            list = list.prepend(placeholder2);
            bl = true;
        }
        if (bl) {
            annotateRepeatedContext.annotateRepeated(new Annotate.Worker(){

                @Override
                public String toString() {
                    String string = String.valueOf(String.valueOf(SymbolMetadata.this.sym));
                    String string2 = String.valueOf(String.valueOf(((SymbolMetadata)SymbolMetadata.this).sym.owner));
                    return new StringBuilder(34 + string.length() + string2.length()).append("repeated annotation pass of: ").append(string).append(" in: ").append(string2).toString();
                }

                @Override
                public void run() {
                    SymbolMetadata.this.complete(annotateRepeatedContext);
                }
            });
        }
        return list.reverse();
    }

    public SymbolMetadata reset() {
        this.attributes = DECL_IN_PROGRESS;
        return this;
    }

    public boolean isEmpty() {
        return !this.isStarted() || this.pendingCompletion() || this.attributes.isEmpty();
    }

    public boolean isTypesEmpty() {
        return this.type_attributes.isEmpty();
    }

    public boolean pendingCompletion() {
        return this.attributes == DECL_IN_PROGRESS;
    }

    public SymbolMetadata append(List<Attribute.Compound> list) {
        this.attributes = this.filterDeclSentinels(this.attributes);
        if (!list.isEmpty()) {
            this.attributes = this.attributes.isEmpty() ? list : this.attributes.appendList(list);
        }
        return this;
    }

    public SymbolMetadata appendUniqueTypes(List<Attribute.TypeCompound> list) {
        if (!list.isEmpty()) {
            if (this.type_attributes.isEmpty()) {
                this.type_attributes = list;
            } else {
                for (Attribute.TypeCompound typeCompound : list) {
                    if (this.type_attributes.contains(typeCompound)) continue;
                    this.type_attributes = this.type_attributes.append(typeCompound);
                }
            }
        }
        return this;
    }

    public SymbolMetadata appendInitTypeAttributes(List<Attribute.TypeCompound> list) {
        if (!list.isEmpty()) {
            this.init_type_attributes = this.init_type_attributes.isEmpty() ? list : this.init_type_attributes.appendList(list);
        }
        return this;
    }

    public SymbolMetadata appendClassInitTypeAttributes(List<Attribute.TypeCompound> list) {
        if (!list.isEmpty()) {
            this.clinit_type_attributes = this.clinit_type_attributes.isEmpty() ? list : this.clinit_type_attributes.appendList(list);
        }
        return this;
    }

    public SymbolMetadata prepend(List<Attribute.Compound> list) {
        this.attributes = this.filterDeclSentinels(this.attributes);
        if (!list.isEmpty()) {
            this.attributes = this.attributes.isEmpty() ? list : this.attributes.prependList(list);
        }
        return this;
    }

    private List<Attribute.Compound> filterDeclSentinels(List<Attribute.Compound> list) {
        return list == DECL_IN_PROGRESS || list == DECL_NOT_STARTED ? List.nil() : list;
    }

    private boolean isStarted() {
        return this.attributes != DECL_NOT_STARTED;
    }

    private List<Attribute.Compound> getPlaceholders() {
        List<Attribute.Compound> list = List.nil();
        for (Attribute.Compound compound : this.filterDeclSentinels(this.attributes)) {
            if (!(compound instanceof Placeholder)) continue;
            list = list.prepend(compound);
        }
        return list.reverse();
    }

    private List<Attribute.TypeCompound> getTypePlaceholders() {
        List<Attribute.TypeCompound> list = List.nil();
        for (Attribute.TypeCompound typeCompound : this.type_attributes) {
            if (!(typeCompound instanceof Placeholder)) continue;
            list = list.prepend(typeCompound);
        }
        return list.reverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Attribute.Compound> void complete(Annotate.AnnotateRepeatedContext<T> annotateRepeatedContext) {
        Log log = annotateRepeatedContext.log;
        Env<AttrContext> env = annotateRepeatedContext.env;
        JavaFileObject javaFileObject = log.useSource(env.toplevel.sourcefile);
        try {
            if (annotateRepeatedContext.isTypeCompound) {
                Assert.check(!this.isTypesEmpty());
                if (this.isTypesEmpty()) {
                    return;
                }
                List<Object> list = List.nil();
                for (Attribute.TypeCompound typeCompound : this.getTypeAttributes()) {
                    if (typeCompound instanceof Placeholder) {
                        Placeholder placeholder = (Placeholder)typeCompound;
                        Attribute.TypeCompound typeCompound2 = (Attribute.TypeCompound)this.replaceOne(placeholder, placeholder.getRepeatedContext());
                        if (null == typeCompound2) continue;
                        list = list.prepend(typeCompound2);
                        continue;
                    }
                    list = list.prepend(typeCompound);
                }
                this.type_attributes = list.reverse();
                Assert.check(this.getTypePlaceholders().isEmpty());
            } else {
                Assert.check(!this.pendingCompletion());
                if (this.isEmpty()) {
                    return;
                }
                List<Object> list = List.nil();
                for (Attribute.Compound compound : this.getDeclarationAttributes()) {
                    if (compound instanceof Placeholder) {
                        T t = this.replaceOne((Placeholder)compound, annotateRepeatedContext);
                        if (null == t) continue;
                        list = list.prepend(t);
                        continue;
                    }
                    list = list.prepend(compound);
                }
                this.attributes = list.reverse();
                Assert.check(this.getPlaceholders().isEmpty());
            }
        }
        finally {
            log.useSource(javaFileObject);
        }
    }

    private <T extends Attribute.Compound> T replaceOne(Placeholder<T> placeholder, Annotate.AnnotateRepeatedContext<T> annotateRepeatedContext) {
        ListBuffer listBuffer;
        Log log = annotateRepeatedContext.log;
        T t = annotateRepeatedContext.processRepeatedAnnotations(placeholder.getPlaceholderFor(), this.sym);
        if (t != null && (listBuffer = annotateRepeatedContext.annotated.get(((Attribute.Compound)t).type.tsym)) != null) {
            log.error(annotateRepeatedContext.pos.get(listBuffer.first()), "invalid.repeatable.annotation.repeated.and.container.present", ((Attribute.Compound)listBuffer.first()).type.tsym);
        }
        return t;
    }

    private static class Placeholder<T extends Attribute.Compound>
    extends Attribute.TypeCompound {
        private final Annotate.AnnotateRepeatedContext<T> ctx;
        private final List<T> placeholderFor;
        private final Symbol on;

        public Placeholder(Annotate.AnnotateRepeatedContext<T> annotateRepeatedContext, List<T> list, Symbol symbol) {
            super(symbol.type, List.nil(), annotateRepeatedContext.isTypeCompound ? ((Attribute.TypeCompound)list.head).position : new TypeAnnotationPosition());
            this.ctx = annotateRepeatedContext;
            this.placeholderFor = list;
            this.on = symbol;
        }

        @Override
        public String toString() {
            String string = String.valueOf(String.valueOf(this.placeholderFor));
            String string2 = String.valueOf(String.valueOf(this.on));
            return new StringBuilder(20 + string.length() + string2.length()).append("<placeholder: ").append(string).append(" on: ").append(string2).append(">").toString();
        }

        public List<T> getPlaceholderFor() {
            return this.placeholderFor;
        }

        public Annotate.AnnotateRepeatedContext<T> getRepeatedContext() {
            return this.ctx;
        }
    }
}

