/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Printer;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Warner;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.tools.JavaFileObject;

public class Types {
    protected static final Context.Key<Types> typesKey = new Context.Key();
    final Symtab syms;
    final JavacMessages messages;
    final Names names;
    final boolean allowBoxing;
    final boolean allowCovariantReturns;
    final boolean allowObjectToPrimitiveCast;
    final boolean allowDefaultMethods;
    final ClassReader reader;
    final Check chk;
    final Enter enter;
    JCDiagnostic.Factory diags;
    List<Warner> warnStack = List.nil();
    final Name capturedName;
    private final FunctionDescriptorLookupError functionDescriptorLookupError;
    public final Warner noWarnings;
    private final MapVisitor<Void> upperBound = new MapVisitor<Void>(){

        @Override
        public Type visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            if (wildcardType.isSuperBound()) {
                return wildcardType.bound == null ? Types.this.syms.objectType : wildcardType.bound.bound;
            }
            return this.visit(wildcardType.type);
        }

        @Override
        public Type visitCapturedType(Type.CapturedType capturedType, Void void_) {
            return this.visit(capturedType.bound);
        }
    };
    private final MapVisitor<Void> lowerBound = new MapVisitor<Void>(){

        @Override
        public Type visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            return wildcardType.isExtendsBound() ? Types.this.syms.botType : this.visit(wildcardType.type);
        }

        @Override
        public Type visitCapturedType(Type.CapturedType capturedType, Void void_) {
            return this.visit(capturedType.getLowerBound());
        }
    };
    private final UnaryVisitor<Boolean> isUnbounded = new UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type type, Void void_) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type.ClassType classType, Void void_) {
            List<Type> list = classType.tsym.type.allparams();
            List<Type> list2 = classType.allparams();
            while (list.nonEmpty()) {
                Type.WildcardType wildcardType = new Type.WildcardType(Types.this.syms.objectType, BoundKind.UNBOUND, Types.this.syms.boundClass, (Type.TypeVar)((Type)list.head).unannotatedType());
                if (!Types.this.containsType((Type)list2.head, wildcardType)) {
                    return false;
                }
                list = list.tail;
                list2 = list2.tail;
            }
            return true;
        }
    };
    private final SimpleVisitor<Type, Symbol> asSub = new SimpleVisitor<Type, Symbol>(){

        @Override
        public Type visitType(Type type, Symbol symbol) {
            return null;
        }

        @Override
        public Type visitClassType(Type.ClassType classType, Symbol symbol) {
            if (classType.tsym == symbol) {
                return classType;
            }
            Type type = Types.this.asSuper(symbol.type, classType.tsym);
            if (type == null) {
                return null;
            }
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            ListBuffer<Type> listBuffer2 = new ListBuffer<Type>();
            try {
                Types.this.adapt(type, classType, listBuffer, listBuffer2);
            }
            catch (AdaptFailure adaptFailure) {
                return null;
            }
            Type type2 = Types.this.subst(symbol.type, listBuffer.toList(), listBuffer2.toList());
            if (!Types.this.isSubtype(type2, classType)) {
                return null;
            }
            ListBuffer listBuffer3 = new ListBuffer();
            List<Type> list = symbol.type.allparams();
            while (list.nonEmpty()) {
                if (type2.contains((Type)list.head) && !classType.contains((Type)list.head)) {
                    listBuffer3.append(list.head);
                }
                list = list.tail;
            }
            if (listBuffer3.nonEmpty()) {
                if (classType.isRaw()) {
                    type2 = Types.this.erasure(type2);
                } else {
                    list = listBuffer3.toList();
                    ListBuffer<Type.WildcardType> listBuffer4 = new ListBuffer<Type.WildcardType>();
                    List<Type> list2 = list;
                    while (list2.nonEmpty()) {
                        listBuffer4.append(new Type.WildcardType(Types.this.syms.objectType, BoundKind.UNBOUND, Types.this.syms.boundClass, (Type.TypeVar)((Type)list2.head).unannotatedType()));
                        list2 = list2.tail;
                    }
                    type2 = Types.this.subst(type2, list, listBuffer4.toList());
                }
            }
            return type2;
        }

        @Override
        public Type visitErrorType(Type.ErrorType errorType, Symbol symbol) {
            return errorType;
        }
    };
    private DescriptorCache descCache = new DescriptorCache();
    private Filter<Symbol> bridgeFilter = new Filter<Symbol>(){

        @Override
        public boolean accepts(Symbol symbol) {
            return symbol.kind == 16 && symbol.name != Types.this.names.init && symbol.name != Types.this.names.clinit && (symbol.flags() & 0x1000L) == 0L;
        }
    };
    private TypeRelation isSubtype = new TypeRelation(){
        private Set<TypePair> cache = new HashSet<TypePair>();

        @Override
        public Boolean visitType(Type type, Type type2) {
            switch (type.getTag()) {
                case BYTE: {
                    return !type2.hasTag(TypeTag.CHAR) && type.getTag().isSubRangeOf(type2.getTag());
                }
                case CHAR: {
                    return !type2.hasTag(TypeTag.SHORT) && type.getTag().isSubRangeOf(type2.getTag());
                }
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return type.getTag().isSubRangeOf(type2.getTag());
                }
                case BOOLEAN: 
                case VOID: {
                    return type.hasTag(type2.getTag());
                }
                case TYPEVAR: {
                    return Types.this.isSubtypeNoCapture(type.getUpperBound(), type2);
                }
                case BOT: {
                    return type2.hasTag(TypeTag.BOT) || type2.hasTag(TypeTag.CLASS) || type2.hasTag(TypeTag.ARRAY) || type2.hasTag(TypeTag.TYPEVAR);
                }
                case WILDCARD: 
                case NONE: {
                    return false;
                }
            }
            String string = String.valueOf(String.valueOf((Object)type.getTag()));
            throw new AssertionError((Object)new StringBuilder(10 + string.length()).append("isSubtype ").append(string).toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean containsTypeRecursive(Type type, Type type2) {
            TypePair typePair = new TypePair(type, type2);
            if (this.cache.add(typePair)) {
                try {
                    boolean bl = Types.this.containsType(type.getTypeArguments(), type2.getTypeArguments());
                    return bl;
                }
                finally {
                    this.cache.remove(typePair);
                }
            }
            return Types.this.containsType(type.getTypeArguments(), this.rewriteSupers(type2).getTypeArguments());
        }

        private Type rewriteSupers(Type type) {
            if (!type.isParameterized()) {
                return type;
            }
            ListBuffer listBuffer = new ListBuffer();
            ListBuffer listBuffer2 = new ListBuffer();
            Types.this.adaptSelf(type, listBuffer, listBuffer2);
            if (listBuffer.isEmpty()) {
                return type;
            }
            ListBuffer<Type> listBuffer3 = new ListBuffer<Type>();
            boolean bl = false;
            for (Type type2 : listBuffer2.toList()) {
                Type type3 = this.rewriteSupers(type2);
                if (type3.isSuperBound() && !type3.isExtendsBound()) {
                    type3 = new Type.WildcardType(Types.this.syms.objectType, BoundKind.UNBOUND, Types.this.syms.boundClass);
                    bl = true;
                } else if (type3 != type2) {
                    type3 = new Type.WildcardType(Types.this.upperBound(type3), BoundKind.EXTENDS, Types.this.syms.boundClass);
                    bl = true;
                }
                listBuffer3.append(type3);
            }
            if (bl) {
                return Types.this.subst(type.tsym.type, listBuffer.toList(), listBuffer3.toList());
            }
            return type;
        }

        @Override
        public Boolean visitClassType(Type.ClassType classType, Type type) {
            Type type2 = Types.this.asSuper(classType, type.tsym);
            return type2 != null && type2.tsym == type.tsym && (!type.isParameterized() || this.containsTypeRecursive(type, type2)) && Types.this.isSubtypeNoCapture(type2.getEnclosingType(), type.getEnclosingType());
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType arrayType, Type type) {
            if (type.hasTag(TypeTag.ARRAY)) {
                if (arrayType.elemtype.isPrimitive()) {
                    return Types.this.isSameType(arrayType.elemtype, Types.this.elemtype(type));
                }
                return Types.this.isSubtypeNoCapture(arrayType.elemtype, Types.this.elemtype(type));
            }
            if (type.hasTag(TypeTag.CLASS)) {
                Name name = type.tsym.getQualifiedName();
                return name == Types.this.names.java_lang_Object || name == Types.this.names.java_lang_Cloneable || name == Types.this.names.java_io_Serializable;
            }
            return false;
        }

        @Override
        public Boolean visitUndetVar(Type.UndetVar undetVar, Type type) {
            if (undetVar == type || undetVar.qtype == type || type.hasTag(TypeTag.ERROR) || type.hasTag(TypeTag.UNKNOWN)) {
                return true;
            }
            if (type.hasTag(TypeTag.BOT)) {
                return false;
            }
            undetVar.addBound(Type.UndetVar.InferenceBound.UPPER, type, Types.this);
            return true;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType errorType, Type type) {
            return true;
        }
    };
    TypeRelation isSameTypeLoose = new LooseSameTypeVisitor();
    TypeRelation isSameTypeStrict = new SameTypeVisitor(){

        @Override
        boolean sameTypeVars(Type.TypeVar typeVar, Type.TypeVar typeVar2) {
            return typeVar == typeVar2;
        }

        @Override
        protected boolean containsTypes(List<Type> list, List<Type> list2) {
            return Types.this.isSameTypes(list, list2, true);
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType wildcardType, Type type) {
            if (!type.hasTag(TypeTag.WILDCARD)) {
                return false;
            }
            Type.WildcardType wildcardType2 = (Type.WildcardType)type.unannotatedType();
            return wildcardType.kind == wildcardType2.kind && Types.this.isSameType(wildcardType.type, wildcardType2.type, true);
        }
    };
    TypeRelation isSameAnnotatedType = new LooseSameTypeVisitor(){

        @Override
        public Boolean visitAnnotatedType(Type.AnnotatedType annotatedType, Type type) {
            if (!type.isAnnotated()) {
                return false;
            }
            if (!((AbstractCollection)((Object)annotatedType.getAnnotationMirrors())).containsAll(type.getAnnotationMirrors())) {
                return false;
            }
            if (!((AbstractCollection)((Object)type.getAnnotationMirrors())).containsAll(annotatedType.getAnnotationMirrors())) {
                return false;
            }
            return (Boolean)this.visit(annotatedType.unannotatedType(), type);
        }
    };
    private TypeRelation containsType = new TypeRelation(){

        private Type U(Type type) {
            while (type.hasTag(TypeTag.WILDCARD)) {
                Type.WildcardType wildcardType = (Type.WildcardType)type.unannotatedType();
                if (wildcardType.isSuperBound()) {
                    return wildcardType.bound == null ? Types.this.syms.objectType : wildcardType.bound.bound;
                }
                type = wildcardType.type;
            }
            return type;
        }

        private Type L(Type type) {
            while (type.hasTag(TypeTag.WILDCARD)) {
                Type.WildcardType wildcardType = (Type.WildcardType)type.unannotatedType();
                if (wildcardType.isExtendsBound()) {
                    return Types.this.syms.botType;
                }
                type = wildcardType.type;
            }
            return type;
        }

        @Override
        public Boolean visitType(Type type, Type type2) {
            if (type2.isPartial()) {
                return Types.this.containedBy(type2, type);
            }
            return Types.this.isSameType(type, type2);
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType wildcardType, Type type) {
            if (type.isPartial()) {
                return Types.this.containedBy(type, wildcardType);
            }
            return Types.this.isSameWildcard(wildcardType, type) || Types.this.isCaptureOf(type, wildcardType) || (wildcardType.isExtendsBound() || Types.this.isSubtypeNoCapture(this.L(wildcardType), Types.this.lowerBound(type))) && (wildcardType.isSuperBound() || Types.this.isSubtypeNoCapture(Types.this.upperBound(type), this.U(wildcardType)));
        }

        @Override
        public Boolean visitUndetVar(Type.UndetVar undetVar, Type type) {
            if (!type.hasTag(TypeTag.WILDCARD)) {
                return Types.this.isSameType(undetVar, type);
            }
            return false;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType errorType, Type type) {
            return true;
        }
    };
    private TypeRelation isCastable = new TypeRelation(){

        @Override
        public Boolean visitType(Type type, Type type2) {
            if (type2.hasTag(TypeTag.ERROR)) {
                return true;
            }
            switch (type.getTag()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return type2.isNumeric();
                }
                case BOOLEAN: {
                    return type2.hasTag(TypeTag.BOOLEAN);
                }
                case VOID: {
                    return false;
                }
                case BOT: {
                    return Types.this.isSubtype(type, type2);
                }
            }
            throw new AssertionError();
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType wildcardType, Type type) {
            return Types.this.isCastable(Types.this.upperBound(wildcardType), type, (Warner)Types.this.warnStack.head);
        }

        @Override
        public Boolean visitClassType(Type.ClassType classType, Type type) {
            if (type.hasTag(TypeTag.ERROR) || type.hasTag(TypeTag.BOT)) {
                return true;
            }
            if (type.hasTag(TypeTag.TYPEVAR)) {
                if (Types.this.isCastable(classType, type.getUpperBound(), Types.this.noWarnings)) {
                    ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                    return true;
                }
                return false;
            }
            if (classType.isCompound() || type.isCompound()) {
                return !classType.isCompound() ? this.visitIntersectionType((Type.IntersectionClassType)type.unannotatedType(), classType, true) : this.visitIntersectionType((Type.IntersectionClassType)classType.unannotatedType(), type, false);
            }
            if (type.hasTag(TypeTag.CLASS) || type.hasTag(TypeTag.ARRAY)) {
                boolean bl = Types.this.isSubtype(Types.this.erasure(classType), Types.this.erasure(type));
                if (bl || Types.this.isSubtype(Types.this.erasure(type), Types.this.erasure(classType))) {
                    Type type2;
                    if (!bl && type.hasTag(TypeTag.ARRAY)) {
                        if (!Types.this.isReifiable(type)) {
                            ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                        }
                        return true;
                    }
                    if (type.isRaw()) {
                        return true;
                    }
                    if (classType.isRaw()) {
                        if (!Types.this.isUnbounded(type)) {
                            ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                        }
                        return true;
                    }
                    Type type3 = bl ? classType : type;
                    Type type4 = bl ? type : classType;
                    Type type5 = Types.this.rewriteQuantifiers(type3, true, false);
                    Type type6 = Types.this.rewriteQuantifiers(type3, false, false);
                    Type type7 = Types.this.rewriteQuantifiers(type4, true, false);
                    Type type8 = Types.this.rewriteQuantifiers(type4, false, false);
                    Type type9 = Types.this.asSub(type8, type6.tsym);
                    Type type10 = type2 = type9 == null ? null : Types.this.asSub(type7, type5.tsym);
                    if (type2 == null) {
                        type5 = Types.this.rewriteQuantifiers(type3, true, true);
                        type6 = Types.this.rewriteQuantifiers(type3, false, true);
                        type7 = Types.this.rewriteQuantifiers(type4, true, true);
                        type8 = Types.this.rewriteQuantifiers(type4, false, true);
                        type9 = Types.this.asSub(type8, type6.tsym);
                        Type type11 = type2 = type9 == null ? null : Types.this.asSub(type7, type5.tsym);
                    }
                    if (type2 != null) {
                        if (type3.tsym != type2.tsym || type3.tsym != type9.tsym) {
                            String string = String.valueOf(String.valueOf(type3.tsym));
                            String string2 = String.valueOf(String.valueOf(type2.tsym));
                            String string3 = String.valueOf(String.valueOf(type9.tsym));
                            Assert.error(new StringBuilder(8 + string.length() + string2.length() + string3.length()).append(string).append(" != ").append(string2).append(" != ").append(string3).toString());
                        }
                        if (!(Types.this.disjointTypes(type5.allparams(), type2.allparams()) || Types.this.disjointTypes(type5.allparams(), type9.allparams()) || Types.this.disjointTypes(type6.allparams(), type2.allparams()) || Types.this.disjointTypes(type6.allparams(), type9.allparams()))) {
                            if (bl ? Types.this.giveWarning(type3, type4) : Types.this.giveWarning(type4, type3)) {
                                ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                            }
                            return true;
                        }
                    }
                    if (Types.this.isReifiable(type)) {
                        return Types.this.isSubtypeUnchecked(type3, type4);
                    }
                    return Types.this.isSubtypeUnchecked(type3, type4, (Warner)Types.this.warnStack.head);
                }
                if (type.hasTag(TypeTag.CLASS)) {
                    if ((type.tsym.flags() & 0x200L) != 0L) {
                        return (classType.tsym.flags() & 0x10L) == 0L ? Types.this.sideCast(classType, type, (Warner)Types.this.warnStack.head) : Types.this.sideCastFinal(classType, type, (Warner)Types.this.warnStack.head);
                    }
                    if ((classType.tsym.flags() & 0x200L) != 0L) {
                        return (type.tsym.flags() & 0x10L) == 0L ? Types.this.sideCast(classType, type, (Warner)Types.this.warnStack.head) : Types.this.sideCastFinal(classType, type, (Warner)Types.this.warnStack.head);
                    }
                    return false;
                }
            }
            return false;
        }

        boolean visitIntersectionType(Type.IntersectionClassType intersectionClassType, Type type, boolean bl) {
            Warner warner = Types.this.noWarnings;
            for (Type type2 : intersectionClassType.getComponents()) {
                warner.clear();
                if (!(bl ? !Types.this.isCastable(type, type2, warner) : !Types.this.isCastable(type2, type, warner))) continue;
                return false;
            }
            if (warner.hasLint(Lint.LintCategory.UNCHECKED)) {
                ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
            }
            return true;
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType arrayType, Type type) {
            switch (type.getTag()) {
                case BOT: 
                case ERROR: {
                    return true;
                }
                case TYPEVAR: {
                    if (Types.this.isCastable(type, arrayType, Types.this.noWarnings)) {
                        ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                        return true;
                    }
                    return false;
                }
                case CLASS: {
                    return Types.this.isSubtype(arrayType, type);
                }
                case ARRAY: {
                    if (Types.this.elemtype(arrayType).isPrimitive() || Types.this.elemtype(type).isPrimitive()) {
                        return Types.this.elemtype(arrayType).hasTag(Types.this.elemtype(type).getTag());
                    }
                    return (Boolean)this.visit(Types.this.elemtype(arrayType), Types.this.elemtype(type));
                }
            }
            return false;
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar typeVar, Type type) {
            switch (type.getTag()) {
                case BOT: 
                case ERROR: {
                    return true;
                }
                case TYPEVAR: {
                    if (Types.this.isSubtype(typeVar, type)) {
                        return true;
                    }
                    if (Types.this.isCastable(typeVar.bound, type, Types.this.noWarnings)) {
                        ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                        return true;
                    }
                    return false;
                }
            }
            return Types.this.isCastable(typeVar.bound, type, (Warner)Types.this.warnStack.head);
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType errorType, Type type) {
            return true;
        }
    };
    private TypeRelation disjointType = new TypeRelation(){
        private Set<TypePair> cache = new HashSet<TypePair>();

        @Override
        public Boolean visitType(Type type, Type type2) {
            if (type2.hasTag(TypeTag.WILDCARD)) {
                return (Boolean)this.visit(type2, type);
            }
            return this.notSoftSubtypeRecursive(type, type2) || this.notSoftSubtypeRecursive(type2, type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isCastableRecursive(Type type, Type type2) {
            TypePair typePair = new TypePair(type, type2);
            if (this.cache.add(typePair)) {
                try {
                    boolean bl = Types.this.isCastable(type, type2);
                    return bl;
                }
                finally {
                    this.cache.remove(typePair);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean notSoftSubtypeRecursive(Type type, Type type2) {
            TypePair typePair = new TypePair(type, type2);
            if (this.cache.add(typePair)) {
                try {
                    boolean bl = Types.this.notSoftSubtype(type, type2);
                    return bl;
                }
                finally {
                    this.cache.remove(typePair);
                }
            }
            return false;
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType wildcardType, Type type) {
            if (wildcardType.isUnbound()) {
                return false;
            }
            if (!type.hasTag(TypeTag.WILDCARD)) {
                if (wildcardType.isExtendsBound()) {
                    return this.notSoftSubtypeRecursive(type, wildcardType.type);
                }
                return this.notSoftSubtypeRecursive(wildcardType.type, type);
            }
            if (type.isUnbound()) {
                return false;
            }
            if (wildcardType.isExtendsBound()) {
                if (type.isExtendsBound()) {
                    return !this.isCastableRecursive(wildcardType.type, Types.this.upperBound(type));
                }
                if (type.isSuperBound()) {
                    return this.notSoftSubtypeRecursive(Types.this.lowerBound(type), wildcardType.type);
                }
            } else if (wildcardType.isSuperBound() && type.isExtendsBound()) {
                return this.notSoftSubtypeRecursive(wildcardType.type, Types.this.upperBound(type));
            }
            return false;
        }
    };
    private final Type.Mapping lowerBoundMapping = new Type.Mapping("lowerBound"){

        @Override
        public Type apply(Type type) {
            return Types.this.lowerBound(type);
        }
    };
    private UnaryVisitor<Boolean> isReifiable = new UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type type, Void void_) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type.ClassType classType, Void void_) {
            if (classType.isCompound()) {
                return false;
            }
            if (!classType.isParameterized()) {
                return true;
            }
            for (Type type : classType.allparams()) {
                if (type.isUnbound()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType arrayType, Void void_) {
            return (Boolean)this.visit(arrayType.elemtype);
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar typeVar, Void void_) {
            return false;
        }
    };
    private Type.Mapping elemTypeFun = new Type.Mapping("elemTypeFun"){

        @Override
        public Type apply(Type type) {
            return Types.this.elemtype(type);
        }
    };
    private SimpleVisitor<Type, Symbol> asSuper = new SimpleVisitor<Type, Symbol>(){

        @Override
        public Type visitType(Type type, Symbol symbol) {
            return null;
        }

        @Override
        public Type visitClassType(Type.ClassType classType, Symbol symbol) {
            List list;
            if (classType.tsym == symbol) {
                return classType;
            }
            Type type = Types.this.supertype(classType);
            if ((type.hasTag(TypeTag.CLASS) || type.hasTag(TypeTag.TYPEVAR) || type.hasTag(TypeTag.ERROR)) && (list = Types.this.asSuper(type, symbol)) != null) {
                return list;
            }
            if ((symbol.flags() & 0x200L) != 0L) {
                list = Types.this.interfaces(classType);
                while (list.nonEmpty()) {
                    Type type2 = Types.this.asSuper((Type)list.head, symbol);
                    if (type2 != null) {
                        return type2;
                    }
                    list = list.tail;
                }
            }
            return null;
        }

        @Override
        public Type visitArrayType(Type.ArrayType arrayType, Symbol symbol) {
            return Types.this.isSubtype(arrayType, symbol.type) ? symbol.type : null;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar typeVar, Symbol symbol) {
            if (typeVar.tsym == symbol) {
                return typeVar;
            }
            return Types.this.asSuper(typeVar.bound, symbol);
        }

        @Override
        public Type visitErrorType(Type.ErrorType errorType, Symbol symbol) {
            return errorType;
        }
    };
    private SimpleVisitor<Type, Symbol> memberType = new SimpleVisitor<Type, Symbol>(){

        @Override
        public Type visitType(Type type, Symbol symbol) {
            return symbol.type;
        }

        @Override
        public Type visitWildcardType(Type.WildcardType wildcardType, Symbol symbol) {
            return Types.this.memberType(Types.this.upperBound(wildcardType), symbol);
        }

        @Override
        public Type visitClassType(Type.ClassType classType, Symbol symbol) {
            Symbol symbol2 = symbol.owner;
            long l = symbol.flags();
            if ((l & 8L) == 0L && symbol2.type.isParameterized()) {
                Type type = Types.this.asOuterSuper(classType, symbol2);
                Type type2 = type = classType.isCompound() ? Types.this.capture(type) : type;
                if (type != null) {
                    List<Type> list = symbol2.type.allparams();
                    List<Type> list2 = type.allparams();
                    if (list.nonEmpty()) {
                        if (list2.isEmpty()) {
                            return Types.this.erasure(symbol.type);
                        }
                        return Types.this.subst(symbol.type, list, list2);
                    }
                }
            }
            return symbol.type;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar typeVar, Symbol symbol) {
            return Types.this.memberType(typeVar.bound, symbol);
        }

        @Override
        public Type visitErrorType(Type.ErrorType errorType, Symbol symbol) {
            return errorType;
        }
    };
    private SimpleVisitor<Type, Boolean> erasure = new SimpleVisitor<Type, Boolean>(){

        @Override
        public Type visitType(Type type, Boolean bl) {
            if (type.isPrimitive()) {
                return type;
            }
            return type.map(bl != false ? Types.this.erasureRecFun : Types.this.erasureFun);
        }

        @Override
        public Type visitWildcardType(Type.WildcardType wildcardType, Boolean bl) {
            return Types.this.erasure(Types.this.upperBound(wildcardType), bl);
        }

        @Override
        public Type visitClassType(Type.ClassType classType, Boolean bl) {
            Type type = classType.tsym.erasure(Types.this);
            if (bl.booleanValue()) {
                type = new Type.ErasedClassType(type.getEnclosingType(), type.tsym);
            }
            return type;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar typeVar, Boolean bl) {
            return Types.this.erasure(typeVar.bound, bl);
        }

        @Override
        public Type visitErrorType(Type.ErrorType errorType, Boolean bl) {
            return errorType;
        }

        @Override
        public Type visitAnnotatedType(Type.AnnotatedType annotatedType, Boolean bl) {
            Type type = Types.this.erasure(annotatedType.unannotatedType(), bl);
            if (type.isAnnotated()) {
                type = ((Type.AnnotatedType)type).unannotatedType();
            }
            return type.annotatedType((List<Attribute.TypeCompound>)annotatedType.getAnnotationMirrors());
        }
    };
    private Type.Mapping erasureFun = new Type.Mapping("erasure"){

        @Override
        public Type apply(Type type) {
            return Types.this.erasure(type);
        }
    };
    private Type.Mapping erasureRecFun = new Type.Mapping("erasureRecursive"){

        @Override
        public Type apply(Type type) {
            return Types.this.erasureRecursive(type);
        }
    };
    private UnaryVisitor<Type> supertype = new UnaryVisitor<Type>(){

        @Override
        public Type visitType(Type type, Void void_) {
            return null;
        }

        @Override
        public Type visitClassType(Type.ClassType classType, Void void_) {
            if (classType.supertype_field == null) {
                Type type = ((Symbol.ClassSymbol)classType.tsym).getSuperclass();
                if (classType.isInterface()) {
                    type = ((Type.ClassType)classType.tsym.type).supertype_field;
                }
                if (classType.supertype_field == null) {
                    List<Type> list = Types.this.classBound(classType).allparams();
                    List<Type> list2 = classType.tsym.type.allparams();
                    classType.supertype_field = classType.hasErasedSupertypes() ? Types.this.erasureRecursive(type) : (list2.nonEmpty() ? Types.this.subst(type, list2, list) : type);
                }
            }
            return classType.supertype_field;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar typeVar, Void void_) {
            if (typeVar.bound.hasTag(TypeTag.TYPEVAR) || !typeVar.bound.isCompound() && !typeVar.bound.isInterface()) {
                return typeVar.bound;
            }
            return Types.this.supertype(typeVar.bound);
        }

        @Override
        public Type visitArrayType(Type.ArrayType arrayType, Void void_) {
            if (arrayType.elemtype.isPrimitive() || Types.this.isSameType(arrayType.elemtype, Types.this.syms.objectType)) {
                return Types.this.arraySuperType();
            }
            return new Type.ArrayType(Types.this.supertype(arrayType.elemtype), arrayType.tsym);
        }

        @Override
        public Type visitErrorType(Type.ErrorType errorType, Void void_) {
            return Type.noType;
        }
    };
    private UnaryVisitor<List<Type>> interfaces = new UnaryVisitor<List<Type>>(){

        @Override
        public List<Type> visitType(Type type, Void void_) {
            return List.nil();
        }

        @Override
        public List<Type> visitClassType(Type.ClassType classType, Void void_) {
            if (classType.interfaces_field == null) {
                java.util.List list = ((Symbol.ClassSymbol)classType.tsym).getInterfaces();
                if (classType.interfaces_field == null) {
                    Assert.check(classType != classType.tsym.type, classType);
                    List<Type> list2 = classType.allparams();
                    List<Type> list3 = classType.tsym.type.allparams();
                    classType.interfaces_field = classType.hasErasedSupertypes() ? Types.this.erasureRecursive((List<Type>)list) : (list3.nonEmpty() ? Types.this.upperBounds(Types.this.subst((List<Type>)list, list3, list2)) : list);
                }
            }
            return classType.interfaces_field;
        }

        @Override
        public List<Type> visitTypeVar(Type.TypeVar typeVar, Void void_) {
            if (typeVar.bound.isCompound()) {
                return Types.this.interfaces(typeVar.bound);
            }
            if (typeVar.bound.isInterface()) {
                return List.of(typeVar.bound);
            }
            return List.nil();
        }
    };
    private final UnaryVisitor<List<Type>> directSupertypes = new UnaryVisitor<List<Type>>(){

        @Override
        public List<Type> visitType(Type type, Void void_) {
            if (!type.isCompound()) {
                Type type2 = Types.this.supertype(type);
                return type2 == Type.noType || type2 == type || type2 == null ? Types.this.interfaces(type) : Types.this.interfaces(type).prepend(type2);
            }
            return this.visitIntersectionType((Type.IntersectionClassType)type);
        }

        private List<Type> visitIntersectionType(Type.IntersectionClassType intersectionClassType) {
            return intersectionClassType.getExplicitComponents();
        }
    };
    Map<Type, Boolean> isDerivedRawCache = new HashMap<Type, Boolean>();
    private UnaryVisitor<Type> classBound = new UnaryVisitor<Type>(){

        @Override
        public Type visitType(Type type, Void void_) {
            return type;
        }

        @Override
        public Type visitClassType(Type.ClassType classType, Void void_) {
            Type type = Types.this.classBound(classType.getEnclosingType());
            if (type != classType.getEnclosingType()) {
                return new Type.ClassType(type, (List<Type>)classType.getTypeArguments(), classType.tsym);
            }
            return classType;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar typeVar, Void void_) {
            return Types.this.classBound(Types.this.supertype(typeVar));
        }

        @Override
        public Type visitErrorType(Type.ErrorType errorType, Void void_) {
            return errorType;
        }
    };
    private ImplementationCache implCache = new ImplementationCache();
    private MembersClosureCache membersCache = new MembersClosureCache();
    TypeRelation hasSameArgs_strict = new HasSameArgs(true);
    TypeRelation hasSameArgs_nonstrict = new HasSameArgs(false);
    private static final Type.Mapping newInstanceFun = new Type.Mapping("newInstanceFun"){

        @Override
        public Type apply(Type type) {
            return new Type.TypeVar(type.tsym, type.getUpperBound(), type.getLowerBound());
        }
    };
    private final MapVisitor<List<Type>> methodWithParameters = new MapVisitor<List<Type>>(){

        @Override
        public Type visitType(Type type, List<Type> list) {
            String string = String.valueOf(String.valueOf(type));
            throw new IllegalArgumentException(new StringBuilder(19 + string.length()).append("Not a method type: ").append(string).toString());
        }

        @Override
        public Type visitMethodType(Type.MethodType methodType, List<Type> list) {
            return new Type.MethodType(list, methodType.restype, methodType.thrown, methodType.tsym);
        }

        @Override
        public Type visitForAll(Type.ForAll forAll, List<Type> list) {
            return new Type.ForAll(forAll.tvars, forAll.qtype.accept(this, list));
        }
    };
    private final MapVisitor<List<Type>> methodWithThrown = new MapVisitor<List<Type>>(){

        @Override
        public Type visitType(Type type, List<Type> list) {
            String string = String.valueOf(String.valueOf(type));
            throw new IllegalArgumentException(new StringBuilder(19 + string.length()).append("Not a method type: ").append(string).toString());
        }

        @Override
        public Type visitMethodType(Type.MethodType methodType, List<Type> list) {
            return new Type.MethodType(methodType.argtypes, methodType.restype, list, methodType.tsym);
        }

        @Override
        public Type visitForAll(Type.ForAll forAll, List<Type> list) {
            return new Type.ForAll(forAll.tvars, forAll.qtype.accept(this, list));
        }
    };
    private final MapVisitor<Type> methodWithReturn = new MapVisitor<Type>(){

        @Override
        public Type visitType(Type type, Type type2) {
            String string = String.valueOf(String.valueOf(type));
            throw new IllegalArgumentException(new StringBuilder(19 + string.length()).append("Not a method type: ").append(string).toString());
        }

        @Override
        public Type visitMethodType(Type.MethodType methodType, Type type) {
            return new Type.MethodType(methodType.argtypes, type, methodType.thrown, methodType.tsym);
        }

        @Override
        public Type visitForAll(Type.ForAll forAll, Type type) {
            return new Type.ForAll(forAll.tvars, forAll.qtype.accept(this, type));
        }
    };
    private Map<Type, List<Type>> closureCache = new HashMap<Type, List<Type>>();
    Set<TypePair> mergeCache = new HashSet<TypePair>();
    private Type arraySuperType = null;
    private static final UnaryVisitor<Integer> hashCode = new UnaryVisitor<Integer>(){

        @Override
        public Integer visitType(Type type, Void void_) {
            return type.getTag().ordinal();
        }

        @Override
        public Integer visitClassType(Type.ClassType classType, Void void_) {
            int n = (Integer)this.visit(classType.getEnclosingType());
            n *= 127;
            n += classType.tsym.flatName().hashCode();
            for (Type type : classType.getTypeArguments()) {
                n *= 127;
                n += ((Integer)this.visit(type)).intValue();
            }
            return n;
        }

        @Override
        public Integer visitMethodType(Type.MethodType methodType, Void void_) {
            int n = TypeTag.METHOD.ordinal();
            List<Type> list = methodType.argtypes;
            while (list.tail != null) {
                n = (n << 5) + (Integer)this.visit((Type)list.head);
                list = list.tail;
            }
            return (n << 5) + (Integer)this.visit(methodType.restype);
        }

        @Override
        public Integer visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            int n = wildcardType.kind.hashCode();
            if (wildcardType.type != null) {
                n *= 127;
                n += ((Integer)this.visit(wildcardType.type)).intValue();
            }
            return n;
        }

        @Override
        public Integer visitArrayType(Type.ArrayType arrayType, Void void_) {
            return (Integer)this.visit(arrayType.elemtype) + 12;
        }

        @Override
        public Integer visitTypeVar(Type.TypeVar typeVar, Void void_) {
            return System.identityHashCode(typeVar.tsym);
        }

        @Override
        public Integer visitUndetVar(Type.UndetVar undetVar, Void void_) {
            return System.identityHashCode(undetVar);
        }

        @Override
        public Integer visitErrorType(Type.ErrorType errorType, Void void_) {
            return 0;
        }
    };

    public static Types instance(Context context) {
        Types types = context.get(typesKey);
        if (types == null) {
            types = new Types(context);
        }
        return types;
    }

    protected Types(Context context) {
        context.put(typesKey, this);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        Source source = Source.instance(context);
        this.allowBoxing = source.allowBoxing();
        this.allowCovariantReturns = source.allowCovariantReturns();
        this.allowObjectToPrimitiveCast = source.allowObjectToPrimitiveCast();
        this.allowDefaultMethods = source.allowDefaultMethods();
        this.reader = ClassReader.instance(context);
        this.chk = Check.instance(context);
        this.enter = Enter.instance(context);
        this.capturedName = this.names.fromString("<captured wildcard>");
        this.messages = JavacMessages.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.functionDescriptorLookupError = new FunctionDescriptorLookupError();
        this.noWarnings = new Warner(null);
    }

    public Type upperBound(Type type) {
        return this.upperBound.visit(type).unannotatedType();
    }

    public Type lowerBound(Type type) {
        return this.lowerBound.visit(type);
    }

    public boolean isUnbounded(Type type) {
        return this.isUnbounded.visit(type);
    }

    public Type asSub(Type type, Symbol symbol) {
        return (Type)this.asSub.visit(type, symbol);
    }

    public boolean isConvertible(Type type, Type type2, Warner warner) {
        boolean bl;
        if (type.hasTag(TypeTag.ERROR)) {
            return true;
        }
        boolean bl2 = type.isPrimitive();
        if (bl2 == (bl = type2.isPrimitive())) {
            return this.isSubtypeUnchecked(type, type2, warner);
        }
        if (!this.allowBoxing) {
            return false;
        }
        return bl2 ? this.isSubtype(this.boxedClass((Type)type).type, type2) : this.isSubtype(this.unboxedType(type), type2);
    }

    public boolean isConvertible(Type type, Type type2) {
        return this.isConvertible(type, type2, this.noWarnings);
    }

    public Symbol findDescriptorSymbol(Symbol.TypeSymbol typeSymbol) throws FunctionDescriptorLookupError {
        return this.descCache.get(typeSymbol).getSymbol();
    }

    public Type findDescriptorType(Type type) throws FunctionDescriptorLookupError {
        return this.descCache.get(type.tsym).getType(type);
    }

    public boolean isFunctionalInterface(Symbol.TypeSymbol typeSymbol) {
        try {
            this.findDescriptorSymbol(typeSymbol);
            return true;
        }
        catch (FunctionDescriptorLookupError functionDescriptorLookupError) {
            return false;
        }
    }

    public boolean isFunctionalInterface(Type type) {
        try {
            this.findDescriptorType(type);
            return true;
        }
        catch (FunctionDescriptorLookupError functionDescriptorLookupError) {
            return false;
        }
    }

    public Type removeWildcards(Type type) {
        Type type2 = this.capture(type);
        if (type2 != type) {
            Type type3 = type.tsym.type;
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            List<Type> list = type.getTypeArguments();
            List<Type> list2 = type2.getTypeArguments();
            for (Type type4 : type3.getTypeArguments()) {
                if (((Type)list.head).hasTag(TypeTag.WILDCARD)) {
                    Type type5;
                    Type.WildcardType wildcardType = (Type.WildcardType)((Type)list.head).unannotatedType();
                    switch (wildcardType.kind) {
                        case EXTENDS: 
                        case UNBOUND: {
                            Type.CapturedType capturedType = (Type.CapturedType)((Type)list2.head).unannotatedType();
                            type5 = capturedType.bound.containsAny(type2.getTypeArguments()) ? wildcardType.type : capturedType.bound;
                            break;
                        }
                        default: {
                            type5 = wildcardType.type;
                        }
                    }
                    listBuffer.append(type5);
                } else {
                    listBuffer.append((Type)list.head);
                }
                list = list.tail;
                list2 = list2.tail;
            }
            return this.subst(type3, type3.getTypeArguments(), listBuffer.toList());
        }
        return type;
    }

    public Symbol.ClassSymbol makeFunctionalInterfaceClass(Env<AttrContext> env, Name name, List<Type> list, long l) {
        if (list.isEmpty() || !this.isFunctionalInterface((Type)list.head)) {
            return null;
        }
        Symbol symbol = this.findDescriptorSymbol(((Type)list.head).tsym);
        Type type = this.findDescriptorType((Type)list.head);
        Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(l, name, env.enclClass.sym.outermostClass());
        classSymbol.completer = null;
        classSymbol.members_field = new Scope(classSymbol);
        Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(symbol.flags(), symbol.name, type, classSymbol);
        classSymbol.members_field.enter(methodSymbol);
        Type.ClassType classType = new Type.ClassType(Type.noType, List.nil(), classSymbol);
        classType.supertype_field = this.syms.objectType;
        classType.interfaces_field = list;
        classSymbol.type = classType;
        classSymbol.sourcefile = ((Symbol.ClassSymbol)classSymbol.owner).sourcefile;
        return classSymbol;
    }

    public List<Symbol> functionalInterfaceBridges(Symbol.TypeSymbol typeSymbol) {
        Assert.check(this.isFunctionalInterface(typeSymbol));
        Symbol symbol = this.findDescriptorSymbol(typeSymbol);
        Scope.CompoundScope compoundScope = this.membersClosure(typeSymbol.type, false);
        ListBuffer<Symbol> listBuffer = new ListBuffer<Symbol>();
        block0: for (Symbol symbol2 : compoundScope.getElementsByName(symbol.name, this.bridgeFilter)) {
            if (symbol2 == symbol || !symbol.overrides(symbol2, typeSymbol, this, false)) continue;
            for (Symbol symbol3 : listBuffer) {
                if (!this.isSameType(symbol3.erasure(this), symbol2.erasure(this)) && (!symbol3.overrides(symbol2, typeSymbol, this, false) || !this.pendingBridges((Symbol.ClassSymbol)typeSymbol, symbol3.enclClass()) && ((Symbol.MethodSymbol)symbol2).binaryImplementation((Symbol.ClassSymbol)symbol3.owner, this) == null)) continue;
                continue block0;
            }
            listBuffer.add(symbol2);
        }
        return listBuffer.toList();
    }

    private boolean pendingBridges(Symbol.ClassSymbol classSymbol, Symbol.TypeSymbol typeSymbol) {
        if (classSymbol.classfile != null && classSymbol.classfile.getKind() == JavaFileObject.Kind.CLASS && this.enter.getEnv(classSymbol) == null) {
            return false;
        }
        if (classSymbol == typeSymbol) {
            return true;
        }
        for (Type type : this.interfaces(classSymbol.type)) {
            if (!this.pendingBridges((Symbol.ClassSymbol)type.tsym, typeSymbol)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubtypeUnchecked(Type type, Type type2) {
        return this.isSubtypeUnchecked(type, type2, this.noWarnings);
    }

    public boolean isSubtypeUnchecked(Type type, Type type2, Warner warner) {
        boolean bl = this.isSubtypeUncheckedInternal(type, type2, warner);
        if (bl) {
            this.checkUnsafeVarargsConversion(type, type2, warner);
        }
        return bl;
    }

    private boolean isSubtypeUncheckedInternal(Type type, Type type2, Warner warner) {
        Type type3;
        if (type.hasTag(TypeTag.ARRAY) && type2.hasTag(TypeTag.ARRAY)) {
            type = type.unannotatedType();
            type2 = type2.unannotatedType();
            if (((Type.ArrayType)type).elemtype.isPrimitive()) {
                return this.isSameType(this.elemtype(type), this.elemtype(type2));
            }
            return this.isSubtypeUnchecked(this.elemtype(type), this.elemtype(type2), warner);
        }
        if (this.isSubtype(type, type2)) {
            return true;
        }
        if (type.hasTag(TypeTag.TYPEVAR)) {
            return this.isSubtypeUnchecked(type.getUpperBound(), type2, warner);
        }
        if (!type2.isRaw() && (type3 = this.asSuper(type, type2.tsym)) != null && type3.isRaw()) {
            if (this.isReifiable(type2)) {
                warner.silentWarn(Lint.LintCategory.UNCHECKED);
            } else {
                warner.warn(Lint.LintCategory.UNCHECKED);
            }
            return true;
        }
        return false;
    }

    private void checkUnsafeVarargsConversion(Type type, Type type2, Warner warner) {
        if (!type.hasTag(TypeTag.ARRAY) || this.isReifiable(type)) {
            return;
        }
        type = type.unannotatedType();
        type2 = type2.unannotatedType();
        Type.ArrayType arrayType = (Type.ArrayType)type;
        boolean bl = false;
        switch (type2.getTag()) {
            case ARRAY: {
                Type.ArrayType arrayType2 = (Type.ArrayType)type2;
                bl = arrayType.isVarargs() && !arrayType2.isVarargs() && !this.isReifiable(arrayType);
                break;
            }
            case CLASS: {
                bl = arrayType.isVarargs();
            }
        }
        if (bl) {
            warner.warn(Lint.LintCategory.VARARGS);
        }
    }

    public final boolean isSubtype(Type type, Type type2) {
        return this.isSubtype(type, type2, true);
    }

    public final boolean isSubtypeNoCapture(Type type, Type type2) {
        return this.isSubtype(type, type2, false);
    }

    public boolean isSubtype(Type type, Type type2, boolean bl) {
        if (type == type2) {
            return true;
        }
        if ((type = type.unannotatedType()) == (type2 = type2.unannotatedType())) {
            return true;
        }
        if (type2.isPartial()) {
            return this.isSuperType(type2, type);
        }
        if (type2.isCompound()) {
            for (Type type3 : this.interfaces(type2).prepend(this.supertype(type2))) {
                if (this.isSubtype(type, type3, bl)) continue;
                return false;
            }
            return true;
        }
        Type type4 = this.lowerBound(type2);
        if (type2 != type4) {
            return this.isSubtype(bl ? this.capture(type) : type, type4, false);
        }
        return (Boolean)this.isSubtype.visit(bl ? this.capture(type) : type, type2);
    }

    public boolean isSubtypeUnchecked(Type type, List<Type> list, Warner warner) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (!this.isSubtypeUnchecked(type, (Type)list2.head, warner)) {
                return false;
            }
            list2 = list2.tail;
        }
        return true;
    }

    public boolean isSubtypes(List<Type> list, List<Type> list2) {
        while (list.tail != null && list2.tail != null && this.isSubtype((Type)list.head, (Type)list2.head)) {
            list = list.tail;
            list2 = list2.tail;
        }
        return list.tail == null && list2.tail == null;
    }

    public boolean isSubtypesUnchecked(List<Type> list, List<Type> list2, Warner warner) {
        while (list.tail != null && list2.tail != null && this.isSubtypeUnchecked((Type)list.head, (Type)list2.head, warner)) {
            list = list.tail;
            list2 = list2.tail;
        }
        return list.tail == null && list2.tail == null;
    }

    public boolean isSuperType(Type type, Type type2) {
        switch (type.getTag()) {
            case ERROR: {
                return true;
            }
            case UNDETVAR: {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                if (type == type2 || undetVar.qtype == type2 || type2.hasTag(TypeTag.ERROR) || type2.hasTag(TypeTag.BOT)) {
                    return true;
                }
                undetVar.addBound(Type.UndetVar.InferenceBound.LOWER, type2, this);
                return true;
            }
        }
        return this.isSubtype(type2, type);
    }

    public boolean isSameTypes(List<Type> list, List<Type> list2) {
        return this.isSameTypes(list, list2, false);
    }

    public boolean isSameTypes(List<Type> list, List<Type> list2, boolean bl) {
        while (list.tail != null && list2.tail != null && this.isSameType((Type)list.head, (Type)list2.head, bl)) {
            list = list.tail;
            list2 = list2.tail;
        }
        return list.tail == null && list2.tail == null;
    }

    public boolean isSignaturePolymorphic(Symbol.MethodSymbol methodSymbol) {
        List<Type> list = methodSymbol.type.getParameterTypes();
        return (methodSymbol.flags_field & 0x100L) != 0L && methodSymbol.owner == this.syms.methodHandleType.tsym && list.tail.tail == null && ((Type)list.head).hasTag(TypeTag.ARRAY) && methodSymbol.type.getReturnType().tsym == this.syms.objectType.tsym && ((Type.ArrayType)list.head).elemtype.tsym == this.syms.objectType.tsym;
    }

    public boolean isSameType(Type type, Type type2) {
        return this.isSameType(type, type2, false);
    }

    public boolean isSameType(Type type, Type type2, boolean bl) {
        return bl ? (Boolean)this.isSameTypeStrict.visit(type, type2) : (Boolean)this.isSameTypeLoose.visit(type, type2);
    }

    public boolean isSameAnnotatedType(Type type, Type type2) {
        return (Boolean)this.isSameAnnotatedType.visit(type, type2);
    }

    public boolean containedBy(Type type, Type type2) {
        switch (type.getTag()) {
            case UNDETVAR: {
                if (type2.hasTag(TypeTag.WILDCARD)) {
                    Type.UndetVar undetVar = (Type.UndetVar)type;
                    Type.WildcardType wildcardType = (Type.WildcardType)type2.unannotatedType();
                    switch (wildcardType.kind) {
                        case EXTENDS: 
                        case UNBOUND: {
                            Type type3 = this.upperBound(type2);
                            undetVar.addBound(Type.UndetVar.InferenceBound.UPPER, type3, this);
                            break;
                        }
                        case SUPER: {
                            Type type4 = this.lowerBound(type2);
                            undetVar.addBound(Type.UndetVar.InferenceBound.LOWER, type4, this);
                            break;
                        }
                    }
                    return true;
                }
                return this.isSameType(type, type2);
            }
            case ERROR: {
                return true;
            }
        }
        return this.containsType(type2, type);
    }

    boolean containsType(List<Type> list, List<Type> list2) {
        while (list.nonEmpty() && list2.nonEmpty() && this.containsType((Type)list.head, (Type)list2.head)) {
            list = list.tail;
            list2 = list2.tail;
        }
        return list.isEmpty() && list2.isEmpty();
    }

    public boolean containsType(Type type, Type type2) {
        return (Boolean)this.containsType.visit(type, type2);
    }

    public boolean isCaptureOf(Type type, Type.WildcardType wildcardType) {
        if (!type.hasTag(TypeTag.TYPEVAR) || !((Type.TypeVar)type.unannotatedType()).isCaptured()) {
            return false;
        }
        return this.isSameWildcard(wildcardType, ((Type.CapturedType)type.unannotatedType()).wildcard);
    }

    public boolean isSameWildcard(Type.WildcardType wildcardType, Type type) {
        if (!type.hasTag(TypeTag.WILDCARD)) {
            return false;
        }
        Type.WildcardType wildcardType2 = (Type.WildcardType)type.unannotatedType();
        return wildcardType2.kind == wildcardType.kind && wildcardType2.type == wildcardType.type;
    }

    public boolean containsTypeEquivalent(List<Type> list, List<Type> list2) {
        while (list.nonEmpty() && list2.nonEmpty() && this.containsTypeEquivalent((Type)list.head, (Type)list2.head)) {
            list = list.tail;
            list2 = list2.tail;
        }
        return list.isEmpty() && list2.isEmpty();
    }

    public boolean isEqualityComparable(Type type, Type type2, Warner warner) {
        if (type2.isNumeric() && type.isNumeric()) {
            return true;
        }
        boolean bl = type2.isPrimitive();
        boolean bl2 = type.isPrimitive();
        if (!bl && !bl2) {
            return this.isCastable(type, type2, warner) || this.isCastable(type2, type, warner);
        }
        return false;
    }

    public boolean isCastable(Type type, Type type2) {
        return this.isCastable(type, type2, this.noWarnings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCastable(Type type, Type type2, Warner warner) {
        if (type == type2) {
            return true;
        }
        if (type.isPrimitive() != type2.isPrimitive()) {
            return this.allowBoxing && (this.isConvertible(type, type2, warner) || this.allowObjectToPrimitiveCast && type2.isPrimitive() && this.isSubtype(this.boxedClass((Type)type2).type, type));
        }
        if (warner != this.warnStack.head) {
            try {
                this.warnStack = this.warnStack.prepend(warner);
                this.checkUnsafeVarargsConversion(type, type2, warner);
                boolean bl = (Boolean)this.isCastable.visit(type, type2);
                return bl;
            }
            finally {
                this.warnStack = this.warnStack.tail;
            }
        }
        return (Boolean)this.isCastable.visit(type, type2);
    }

    public boolean disjointTypes(List<Type> list, List<Type> list2) {
        while (list.tail != null && list2.tail != null) {
            if (this.disjointType((Type)list.head, (Type)list2.head)) {
                return true;
            }
            list = list.tail;
            list2 = list2.tail;
        }
        return false;
    }

    public boolean disjointType(Type type, Type type2) {
        return (Boolean)this.disjointType.visit(type, type2);
    }

    public List<Type> lowerBoundArgtypes(Type type) {
        return this.lowerBounds(type.getParameterTypes());
    }

    public List<Type> lowerBounds(List<Type> list) {
        return Type.map(list, this.lowerBoundMapping);
    }

    public boolean notSoftSubtype(Type type, Type type2) {
        if (type == type2) {
            return false;
        }
        if (type.hasTag(TypeTag.TYPEVAR)) {
            Type.TypeVar typeVar = (Type.TypeVar)type;
            return !this.isCastable(typeVar.bound, this.relaxBound(type2), this.noWarnings);
        }
        if (!type2.hasTag(TypeTag.WILDCARD)) {
            type2 = this.upperBound(type2);
        }
        return !this.isSubtype(type, this.relaxBound(type2));
    }

    private Type relaxBound(Type type) {
        if (type.hasTag(TypeTag.TYPEVAR)) {
            while (type.hasTag(TypeTag.TYPEVAR)) {
                type = type.getUpperBound();
            }
            type = this.rewriteQuantifiers(type, true, true);
        }
        return type;
    }

    public boolean isReifiable(Type type) {
        return this.isReifiable.visit(type);
    }

    public boolean isArray(Type type) {
        while (type.hasTag(TypeTag.WILDCARD)) {
            type = this.upperBound(type);
        }
        return type.hasTag(TypeTag.ARRAY);
    }

    public Type elemtype(Type type) {
        switch (type.getTag()) {
            case WILDCARD: {
                return this.elemtype(this.upperBound(type));
            }
            case ARRAY: {
                type = type.unannotatedType();
                return ((Type.ArrayType)type).elemtype;
            }
            case FORALL: {
                return this.elemtype(((Type.ForAll)type).qtype);
            }
            case ERROR: {
                return type;
            }
        }
        return null;
    }

    public Type elemtypeOrType(Type type) {
        Type type2 = this.elemtype(type);
        return type2 != null ? type2 : type;
    }

    public int dimensions(Type type) {
        int n = 0;
        while (type.hasTag(TypeTag.ARRAY)) {
            ++n;
            type = this.elemtype(type);
        }
        return n;
    }

    public Type.ArrayType makeArrayType(Type type) {
        if (type.hasTag(TypeTag.VOID) || type.hasTag(TypeTag.PACKAGE)) {
            String string = String.valueOf(type.toString());
            Assert.error(string.length() != 0 ? "Type t must not be a VOID or PACKAGE type, ".concat(string) : new String("Type t must not be a VOID or PACKAGE type, "));
        }
        return new Type.ArrayType(type, this.syms.arrayClass);
    }

    public Type asSuper(Type type, Symbol symbol) {
        return (Type)this.asSuper.visit(type, symbol);
    }

    public Type asOuterSuper(Type type, Symbol symbol) {
        switch (type.getTag()) {
            case CLASS: {
                do {
                    Type type2;
                    if ((type2 = this.asSuper(type, symbol)) == null) continue;
                    return type2;
                } while ((type = type.getEnclosingType()).hasTag(TypeTag.CLASS));
                return null;
            }
            case ARRAY: {
                return this.isSubtype(type, symbol.type) ? symbol.type : null;
            }
            case TYPEVAR: {
                return this.asSuper(type, symbol);
            }
            case ERROR: {
                return type;
            }
        }
        return null;
    }

    public Type asEnclosingSuper(Type type, Symbol symbol) {
        switch (type.getTag()) {
            case CLASS: {
                Type type2;
                do {
                    Type type3;
                    if ((type3 = this.asSuper(type, symbol)) == null) continue;
                    return type3;
                } while ((type = (type2 = type.getEnclosingType()).hasTag(TypeTag.CLASS) ? type2 : (type.tsym.owner.enclClass() != null ? type.tsym.owner.enclClass().type : Type.noType)).hasTag(TypeTag.CLASS));
                return null;
            }
            case ARRAY: {
                return this.isSubtype(type, symbol.type) ? symbol.type : null;
            }
            case TYPEVAR: {
                return this.asSuper(type, symbol);
            }
            case ERROR: {
                return type;
            }
        }
        return null;
    }

    public Type memberType(Type type, Symbol symbol) {
        return (symbol.flags() & 8L) != 0L ? symbol.type : (Type)this.memberType.visit(type, symbol);
    }

    public boolean isAssignable(Type type, Type type2) {
        return this.isAssignable(type, type2, this.noWarnings);
    }

    public boolean isAssignable(Type type, Type type2, Warner warner) {
        if (type.hasTag(TypeTag.ERROR)) {
            return true;
        }
        if (type.getTag().isSubRangeOf(TypeTag.INT) && type.constValue() != null) {
            int n = ((Number)type.constValue()).intValue();
            switch (type2.getTag()) {
                case BYTE: {
                    if (-128 > n || n > 127) break;
                    return true;
                }
                case CHAR: {
                    if (0 > n || n > 65535) break;
                    return true;
                }
                case SHORT: {
                    if (Short.MIN_VALUE > n || n > Short.MAX_VALUE) break;
                    return true;
                }
                case INT: {
                    return true;
                }
                case CLASS: {
                    switch (this.unboxedType(type2).getTag()) {
                        case BYTE: 
                        case CHAR: 
                        case SHORT: {
                            return this.isAssignable(type, this.unboxedType(type2), warner);
                        }
                    }
                }
            }
        }
        return this.isConvertible(type, type2, warner);
    }

    public Type erasure(Type type) {
        return this.eraseNotNeeded(type) ? type : this.erasure(type, false);
    }

    private boolean eraseNotNeeded(Type type) {
        return type.isPrimitive() || this.syms.stringType.tsym == type.tsym;
    }

    private Type erasure(Type type, boolean bl) {
        if (type.isPrimitive()) {
            return type;
        }
        return (Type)this.erasure.visit(type, bl);
    }

    public List<Type> erasure(List<Type> list) {
        return Type.map(list, this.erasureFun);
    }

    public Type erasureRecursive(Type type) {
        return this.erasure(type, true);
    }

    public List<Type> erasureRecursive(List<Type> list) {
        return Type.map(list, this.erasureRecFun);
    }

    public Type makeCompoundType(List<Type> list) {
        return this.makeCompoundType(list, ((Type)list.head).tsym.isInterface());
    }

    public Type makeCompoundType(List<Type> list, boolean bl) {
        Assert.check(list.nonEmpty());
        Type type = (Type)list.head;
        if (bl) {
            list = list.prepend(this.syms.objectType);
        }
        Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(0x41001401L, Type.moreInfo ? this.names.fromString(list.toString()) : this.names.empty, null, this.syms.noSymbol);
        classSymbol.type = new Type.IntersectionClassType(list, classSymbol, bl);
        classSymbol.erasure_field = ((Type)list.head).hasTag(TypeTag.TYPEVAR) ? this.syms.objectType : this.erasure(type);
        classSymbol.members_field = new Scope(classSymbol);
        return classSymbol.type;
    }

    public Type makeCompoundType(Type type, Type type2) {
        return this.makeCompoundType(List.of(type, type2));
    }

    public Type supertype(Type type) {
        return this.supertype.visit(type);
    }

    public List<Type> interfaces(Type type) {
        return this.interfaces.visit(type);
    }

    public List<Type> directSupertypes(Type type) {
        return this.directSupertypes.visit(type);
    }

    public boolean isDirectSuperInterface(Symbol.TypeSymbol typeSymbol, Symbol.TypeSymbol typeSymbol2) {
        for (Type type : this.interfaces(typeSymbol2.type)) {
            if (typeSymbol != type.tsym) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedRaw(Type type) {
        Boolean bl = this.isDerivedRawCache.get(type);
        if (bl == null) {
            bl = this.isDerivedRawInternal(type);
            this.isDerivedRawCache.put(type, bl);
        }
        return bl;
    }

    public boolean isDerivedRawInternal(Type type) {
        if (type.isErroneous()) {
            return false;
        }
        return type.isRaw() || this.supertype(type) != null && this.isDerivedRaw(this.supertype(type)) || this.isDerivedRaw(this.interfaces(type));
    }

    public boolean isDerivedRaw(List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty() && !this.isDerivedRaw((Type)list2.head)) {
            list2 = list2.tail;
        }
        return list2.nonEmpty();
    }

    public void setBounds(Type.TypeVar typeVar, List<Type> list) {
        this.setBounds(typeVar, list, ((Type)list.head).tsym.isInterface());
    }

    public void setBounds(Type.TypeVar typeVar, List<Type> list, boolean bl) {
        typeVar.bound = list.tail.isEmpty() ? (Type)list.head : this.makeCompoundType(list, bl);
        typeVar.rank_field = -1;
    }

    public List<Type> getBounds(Type.TypeVar typeVar) {
        if (typeVar.bound.hasTag(TypeTag.NONE)) {
            return List.nil();
        }
        if (typeVar.bound.isErroneous() || !typeVar.bound.isCompound()) {
            return List.of(typeVar.bound);
        }
        if ((this.erasure((Type)typeVar).tsym.flags() & 0x200L) == 0L) {
            return this.interfaces(typeVar).prepend(this.supertype(typeVar));
        }
        return this.interfaces(typeVar);
    }

    public Type classBound(Type type) {
        return this.classBound.visit(type);
    }

    public boolean isSubSignature(Type type, Type type2) {
        return this.isSubSignature(type, type2, true);
    }

    public boolean isSubSignature(Type type, Type type2, boolean bl) {
        return this.hasSameArgs(type, type2, bl) || this.hasSameArgs(type, this.erasure(type2), bl);
    }

    public boolean overrideEquivalent(Type type, Type type2) {
        return this.hasSameArgs(type, type2) || this.hasSameArgs(type, this.erasure(type2)) || this.hasSameArgs(this.erasure(type), type2);
    }

    public boolean overridesObjectMethod(Symbol.TypeSymbol typeSymbol, Symbol symbol) {
        Scope.Entry entry = this.syms.objectType.tsym.members().lookup(symbol.name);
        while (entry.scope != null) {
            if (symbol.overrides(entry.sym, typeSymbol, this, true)) {
                return true;
            }
            entry = entry.next();
        }
        return false;
    }

    public Symbol.MethodSymbol implementation(Symbol.MethodSymbol methodSymbol, Symbol.TypeSymbol typeSymbol, boolean bl, Filter<Symbol> filter) {
        return this.implCache.get(methodSymbol, typeSymbol, bl, filter);
    }

    public Scope.CompoundScope membersClosure(Type type, boolean bl) {
        return (Scope.CompoundScope)this.membersCache.visit(type, bl);
    }

    public List<Symbol.MethodSymbol> interfaceCandidates(Type type, Symbol.MethodSymbol methodSymbol) {
        MethodFilter methodFilter = new MethodFilter(methodSymbol, type);
        List<Symbol.MethodSymbol> list = List.nil();
        for (Symbol symbol : this.membersClosure(type, false).getElements(methodFilter)) {
            if (!type.tsym.isInterface() && !symbol.owner.isInterface()) {
                return List.of((Symbol.MethodSymbol)symbol);
            }
            if (list.contains(symbol)) continue;
            list = list.prepend((Symbol.MethodSymbol)symbol);
        }
        return this.prune(list);
    }

    public List<Symbol.MethodSymbol> prune(List<Symbol.MethodSymbol> list) {
        ListBuffer<Symbol.MethodSymbol> listBuffer = new ListBuffer<Symbol.MethodSymbol>();
        for (Symbol.MethodSymbol methodSymbol : list) {
            boolean bl = true;
            for (Symbol.MethodSymbol methodSymbol2 : list) {
                if (methodSymbol == methodSymbol2 || methodSymbol2.owner == methodSymbol.owner || this.asSuper(methodSymbol2.owner.type, methodSymbol.owner) == null) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            listBuffer.append(methodSymbol);
        }
        return listBuffer.toList();
    }

    public boolean hasSameArgs(Type type, Type type2) {
        return this.hasSameArgs(type, type2, true);
    }

    public boolean hasSameArgs(Type type, Type type2, boolean bl) {
        return this.hasSameArgs(type, type2, bl ? this.hasSameArgs_strict : this.hasSameArgs_nonstrict);
    }

    private boolean hasSameArgs(Type type, Type type2, TypeRelation typeRelation) {
        return (Boolean)typeRelation.visit(type, type2);
    }

    public List<Type> subst(List<Type> list, List<Type> list2, List<Type> list3) {
        return new Subst(list2, list3).subst(list);
    }

    public Type subst(Type type, List<Type> list, List<Type> list2) {
        return new Subst(list, list2).subst(type);
    }

    /*
     * WARNING - void declaration
     */
    public List<Type> substBounds(List<Type> list, List<Type> list2, List<Type> list3) {
        void var7_10;
        if (list.isEmpty()) {
            return list;
        }
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        boolean bl = false;
        for (Type list42 : list) {
            Type.TypeVar typeVar = (Type.TypeVar)list42;
            Type type = this.subst(typeVar.bound, list2, list3);
            if (type != typeVar.bound) {
                bl = true;
            }
            listBuffer.append(type);
        }
        if (!bl) {
            return list;
        }
        ListBuffer listBuffer2 = new ListBuffer();
        for (Type type : list) {
            listBuffer2.append(new Type.TypeVar(type.tsym, null, this.syms.botType));
        }
        List list4 = listBuffer.toList();
        list2 = list;
        list3 = listBuffer2.toList();
        while (!var7_10.isEmpty()) {
            var7_10.head = this.subst((Type)var7_10.head, list2, list3);
            List list5 = var7_10.tail;
        }
        List list6 = listBuffer.toList();
        for (Type type : listBuffer2.toList()) {
            void var7_13;
            Type.TypeVar typeVar = (Type.TypeVar)type;
            typeVar.bound = (Type)var7_13.head;
            List list7 = var7_13.tail;
        }
        return listBuffer2.toList();
    }

    public Type.TypeVar substBound(Type.TypeVar typeVar, List<Type> list, List<Type> list2) {
        Type type = this.subst(typeVar.bound, list, list2);
        if (type == typeVar.bound) {
            return typeVar;
        }
        Type.TypeVar typeVar2 = new Type.TypeVar(typeVar.tsym, null, this.syms.botType);
        typeVar2.bound = this.subst(type, List.of(typeVar), List.of(typeVar2));
        return typeVar2;
    }

    public boolean hasSameBounds(Type.ForAll forAll, Type.ForAll forAll2) {
        List<Type> list = forAll.tvars;
        List<Type> list2 = forAll2.tvars;
        while (list.nonEmpty() && list2.nonEmpty() && this.isSameType(((Type)list.head).getUpperBound(), this.subst(((Type)list2.head).getUpperBound(), forAll2.tvars, forAll.tvars))) {
            list = list.tail;
            list2 = list2.tail;
        }
        return list.isEmpty() && list2.isEmpty();
    }

    public List<Type> newInstances(List<Type> list) {
        List<Type> list2;
        List<Type> list3 = list2 = Type.map(list, newInstanceFun);
        while (list3.nonEmpty()) {
            Type.TypeVar typeVar = (Type.TypeVar)list3.head;
            typeVar.bound = this.subst(typeVar.bound, list, list2);
            list3 = list3.tail;
        }
        return list2;
    }

    public Type createMethodTypeWithParameters(Type type, List<Type> list) {
        return (Type)type.accept(this.methodWithParameters, list);
    }

    public Type createMethodTypeWithThrown(Type type, List<Type> list) {
        return (Type)type.accept(this.methodWithThrown, list);
    }

    public Type createMethodTypeWithReturn(Type type, Type type2) {
        return (Type)type.accept(this.methodWithReturn, type2);
    }

    public Type createErrorType(Type type) {
        return new Type.ErrorType(type, this.syms.errSymbol);
    }

    public Type createErrorType(Symbol.ClassSymbol classSymbol, Type type) {
        return new Type.ErrorType(classSymbol, type);
    }

    public Type createErrorType(Name name, Symbol.TypeSymbol typeSymbol, Type type) {
        return new Type.ErrorType(name, typeSymbol, type);
    }

    public int rank(Type type) {
        type = type.unannotatedType();
        switch (type.getTag()) {
            case CLASS: {
                Type.ClassType classType = (Type.ClassType)type;
                if (classType.rank_field < 0) {
                    Name name = classType.tsym.getQualifiedName();
                    if (name == this.names.java_lang_Object) {
                        classType.rank_field = 0;
                    } else {
                        int n = this.rank(this.supertype(classType));
                        List<Type> list = this.interfaces(classType);
                        while (list.nonEmpty()) {
                            if (this.rank((Type)list.head) > n) {
                                n = this.rank((Type)list.head);
                            }
                            list = list.tail;
                        }
                        classType.rank_field = n + 1;
                    }
                }
                return classType.rank_field;
            }
            case TYPEVAR: {
                Type.TypeVar typeVar = (Type.TypeVar)type;
                if (typeVar.rank_field < 0) {
                    int n = this.rank(this.supertype(typeVar));
                    List<Type> list = this.interfaces(typeVar);
                    while (list.nonEmpty()) {
                        if (this.rank((Type)list.head) > n) {
                            n = this.rank((Type)list.head);
                        }
                        list = list.tail;
                    }
                    typeVar.rank_field = n + 1;
                }
                return typeVar.rank_field;
            }
            case ERROR: {
                return 0;
            }
        }
        throw new AssertionError();
    }

    public String toString(Type type, Locale locale) {
        return Printer.createStandardPrinter(this.messages).visit(type, locale);
    }

    public String toString(Symbol symbol, Locale locale) {
        return Printer.createStandardPrinter(this.messages).visit(symbol, locale);
    }

    @Deprecated
    public String toString(Type type) {
        if (type.hasTag(TypeTag.FORALL)) {
            Type.ForAll forAll = (Type.ForAll)type;
            String string = String.valueOf(String.valueOf(this.typaramsString(forAll.tvars)));
            String string2 = String.valueOf(String.valueOf(forAll.qtype));
            return new StringBuilder(0 + string.length() + string2.length()).append(string).append(string2).toString();
        }
        String string = String.valueOf(String.valueOf(type));
        return new StringBuilder(0 + string.length()).append(string).toString();
    }

    private String typaramsString(List<Type> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        boolean bl = true;
        for (Type type : list) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            this.appendTyparamString((Type.TypeVar)type.unannotatedType(), stringBuilder);
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    private void appendTyparamString(Type.TypeVar typeVar, StringBuilder stringBuilder) {
        stringBuilder.append(typeVar);
        if (typeVar.bound == null || typeVar.bound.tsym.getQualifiedName() == this.names.java_lang_Object) {
            return;
        }
        stringBuilder.append(" extends ");
        Type type = typeVar.bound;
        if (!type.isCompound()) {
            stringBuilder.append(type);
        } else if ((this.erasure((Type)typeVar).tsym.flags() & 0x200L) == 0L) {
            stringBuilder.append(this.supertype(typeVar));
            for (Type type2 : this.interfaces(typeVar)) {
                stringBuilder.append('&');
                stringBuilder.append(type2);
            }
        } else {
            boolean bl = true;
            for (Type type3 : this.interfaces(typeVar)) {
                if (!bl) {
                    stringBuilder.append('&');
                }
                bl = false;
                stringBuilder.append(type3);
            }
        }
    }

    public List<Type> closure(Type type) {
        List<Type> list = this.closureCache.get(type);
        if (list == null) {
            Type type2 = this.supertype(type);
            list = !type.isCompound() ? (type2.hasTag(TypeTag.CLASS) ? this.insert(this.closure(type2), type) : (type2.hasTag(TypeTag.TYPEVAR) ? this.closure(type2).prepend(type) : List.of(type))) : this.closure(this.supertype(type));
            List<Type> list2 = this.interfaces(type);
            while (list2.nonEmpty()) {
                list = this.union(list, this.closure((Type)list2.head));
                list2 = list2.tail;
            }
            this.closureCache.put(type, list);
        }
        return list;
    }

    public List<Type> insert(List<Type> list, Type type) {
        if (list.isEmpty() || type.tsym.precedes(((Type)list.head).tsym, this)) {
            return list.prepend(type);
        }
        if (((Type)list.head).tsym.precedes(type.tsym, this)) {
            return this.insert(list.tail, type).prepend((Type)list.head);
        }
        return list;
    }

    public List<Type> union(List<Type> list, List<Type> list2) {
        if (list.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list;
        }
        if (((Type)list.head).tsym.precedes(((Type)list2.head).tsym, this)) {
            return this.union(list.tail, list2).prepend((Type)list.head);
        }
        if (((Type)list2.head).tsym.precedes(((Type)list.head).tsym, this)) {
            return this.union(list, list2.tail).prepend((Type)list2.head);
        }
        return this.union(list.tail, list2.tail).prepend((Type)list.head);
    }

    public List<Type> intersect(List<Type> list, List<Type> list2) {
        if (list == list2) {
            return list;
        }
        if (list.isEmpty() || list2.isEmpty()) {
            return List.nil();
        }
        if (((Type)list.head).tsym.precedes(((Type)list2.head).tsym, this)) {
            return this.intersect(list.tail, list2);
        }
        if (((Type)list2.head).tsym.precedes(((Type)list.head).tsym, this)) {
            return this.intersect(list, list2.tail);
        }
        if (this.isSameType((Type)list.head, (Type)list2.head)) {
            return this.intersect(list.tail, list2.tail).prepend((Type)list.head);
        }
        if (((Type)list.head).tsym == ((Type)list2.head).tsym && ((Type)list.head).hasTag(TypeTag.CLASS) && ((Type)list2.head).hasTag(TypeTag.CLASS)) {
            if (((Type)list.head).isParameterized() && ((Type)list2.head).isParameterized()) {
                Type type = this.merge((Type)list.head, (Type)list2.head);
                return this.intersect(list.tail, list2.tail).prepend(type);
            }
            if (((Type)list.head).isRaw() || ((Type)list2.head).isRaw()) {
                return this.intersect(list.tail, list2.tail).prepend(this.erasure((Type)list.head));
            }
        }
        return this.intersect(list.tail, list2.tail);
    }

    private Type merge(Type type, Type type2) {
        Type.ClassType classType = (Type.ClassType)type;
        List list = classType.getTypeArguments();
        Type.ClassType classType2 = (Type.ClassType)type2;
        List list2 = classType2.getTypeArguments();
        ListBuffer listBuffer = new ListBuffer();
        List<Type> list3 = classType.tsym.type.getTypeArguments();
        while (list.nonEmpty() && list2.nonEmpty() && list3.nonEmpty()) {
            if (this.containsType((Type)list.head, (Type)list2.head)) {
                listBuffer.append(list.head);
            } else if (this.containsType((Type)list2.head, (Type)list.head)) {
                listBuffer.append(list2.head);
            } else {
                Type.WildcardType wildcardType;
                TypePair typePair = new TypePair(type, type2);
                if (this.mergeCache.add(typePair)) {
                    wildcardType = new Type.WildcardType(this.lub(this.upperBound((Type)list.head), this.upperBound((Type)list2.head)), BoundKind.EXTENDS, this.syms.boundClass);
                    this.mergeCache.remove(typePair);
                } else {
                    wildcardType = new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
                }
                listBuffer.append(((Type)wildcardType).withTypeVar((Type)list3.head));
            }
            list = list.tail;
            list2 = list2.tail;
            list3 = list3.tail;
        }
        Assert.check(list.isEmpty() && list2.isEmpty() && list3.isEmpty());
        return new Type.ClassType(classType.getEnclosingType(), listBuffer.toList(), classType.tsym);
    }

    private Type compoundMin(List<Type> list) {
        if (list.isEmpty()) {
            return this.syms.objectType;
        }
        List<Type> list2 = this.closureMin(list);
        if (list2.isEmpty()) {
            return null;
        }
        if (list2.tail.isEmpty()) {
            return (Type)list2.head;
        }
        return this.makeCompoundType(list2);
    }

    private List<Type> closureMin(List<Type> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        ListBuffer<Type> listBuffer2 = new ListBuffer<Type>();
        while (!list.isEmpty()) {
            Type type = (Type)list.head;
            if (type.isInterface()) {
                listBuffer2.append(type);
            } else {
                listBuffer.append(type);
            }
            ListBuffer<Type> listBuffer3 = new ListBuffer<Type>();
            for (Type type2 : list.tail) {
                if (this.isSubtypeNoCapture(type, type2)) continue;
                listBuffer3.append(type2);
            }
            list = listBuffer3.toList();
        }
        return listBuffer.appendList(listBuffer2).toList();
    }

    public Type lub(Type type, Type type2) {
        return this.lub(List.of(type, type2));
    }

    /*
     * WARNING - void declaration
     */
    public Type lub(List<Type> list) {
        int n = 0;
        block10: for (Type type : list) {
            switch (type.getTag()) {
                case CLASS: {
                    n |= 2;
                    continue block10;
                }
                case ARRAY: {
                    n |= 1;
                    continue block10;
                }
                case TYPEVAR: {
                    void list22;
                    Type type2;
                    while ((type2 = list22.getUpperBound()).hasTag(TypeTag.TYPEVAR)) {
                    }
                    if (type2.hasTag(TypeTag.ARRAY)) {
                        n |= 1;
                        continue block10;
                    }
                    n |= 2;
                    continue block10;
                }
            }
            if (!type.isPrimitive()) continue;
            return this.syms.errType;
        }
        switch (n) {
            case 0: {
                return this.syms.botType;
            }
            case 1: {
                List<Type> list3 = Type.map(list, this.elemTypeFun);
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    Type type = (Type)iterator.next();
                    if (!type.isPrimitive()) continue;
                    Type type3 = (Type)list.head;
                    for (Type type4 : list.tail) {
                        if (this.isSameType(type3, type4)) continue;
                        return this.arraySuperType();
                    }
                    return type3;
                }
                return new Type.ArrayType(this.lub(list3), this.syms.arrayClass);
            }
            case 2: {
                void var6_9;
                Object object2;
                while (!((Type)list.head).hasTag(TypeTag.CLASS) && !((Type)list.head).hasTag(TypeTag.TYPEVAR)) {
                    list = list.tail;
                }
                Assert.check(!list.isEmpty());
                List<Type> list2 = this.erasedSupertypes((Type)list.head);
                for (Object object2 : list.tail) {
                    if (!((Type)object2).hasTag(TypeTag.CLASS) && !((Type)object2).hasTag(TypeTag.TYPEVAR)) continue;
                    List<Type> list3 = this.intersect((List<Type>)var6_9, this.erasedSupertypes((Type)object2));
                }
                List<Type> list4 = this.closureMin((List<Type>)var6_9);
                object2 = List.nil();
                Iterator iterator = list4.iterator();
                while (iterator.hasNext()) {
                    Type type = (Type)iterator.next();
                    List<Type> list5 = List.of(this.asSuper((Type)list.head, type.tsym));
                    for (Type type5 : list) {
                        list5 = this.intersect(list5, List.of(this.asSuper(type5, type.tsym)));
                    }
                    object2 = ((List)object2).appendList(list5);
                }
                return this.compoundMin((List<Type>)object2);
            }
        }
        List<Type> list6 = List.of(this.arraySuperType());
        for (Type type : list) {
            if (type.hasTag(TypeTag.ARRAY)) continue;
            list6 = list6.prepend(type);
        }
        return this.lub(list6);
    }

    List<Type> erasedSupertypes(Type type) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type2 : this.closure(type)) {
            if (type2.hasTag(TypeTag.TYPEVAR)) {
                listBuffer.append(type2);
                continue;
            }
            listBuffer.append(this.erasure(type2));
        }
        return listBuffer.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type arraySuperType() {
        if (this.arraySuperType == null) {
            Types types = this;
            synchronized (types) {
                if (this.arraySuperType == null) {
                    this.arraySuperType = this.makeCompoundType(List.of(this.syms.serializableType, this.syms.cloneableType), true);
                }
            }
        }
        return this.arraySuperType;
    }

    public Type glb(List<Type> list) {
        Type type = (Type)list.head;
        for (Type type2 : list.tail) {
            if (type.isErroneous()) {
                return type;
            }
            type = this.glb(type, type2);
        }
        return type;
    }

    public Type glb(Type type, Type type2) {
        if (type2 == null) {
            return type;
        }
        if (type.isPrimitive() || type2.isPrimitive()) {
            return this.syms.errType;
        }
        if (this.isSubtypeNoCapture(type, type2)) {
            return type;
        }
        if (this.isSubtypeNoCapture(type2, type)) {
            return type2;
        }
        List<Type> list = this.union(this.closure(type), this.closure(type2));
        List<Type> list2 = this.closureMin(list);
        if (list2.isEmpty()) {
            return this.syms.objectType;
        }
        if (list2.tail.isEmpty()) {
            return (Type)list2.head;
        }
        int n = 0;
        for (Type type3 : list2) {
            if (type3.isInterface()) continue;
            ++n;
        }
        if (n > 1) {
            return this.createErrorType(type);
        }
        return this.makeCompoundType(list2);
    }

    public int hashCode(Type type) {
        return hashCode.visit(type);
    }

    public boolean resultSubtype(Type type, Type type2, Warner warner) {
        List<Type> list = type.getTypeArguments();
        List<Type> list2 = type2.getTypeArguments();
        Type type3 = type.getReturnType();
        Type type4 = this.subst(type2.getReturnType(), list2, list);
        return this.covariantReturnType(type3, type4, warner);
    }

    public boolean returnTypeSubstitutable(Type type, Type type2) {
        if (this.hasSameArgs(type, type2)) {
            return this.resultSubtype(type, type2, this.noWarnings);
        }
        return this.covariantReturnType(type.getReturnType(), this.erasure(type2.getReturnType()), this.noWarnings);
    }

    public boolean returnTypeSubstitutable(Type type, Type type2, Type type3, Warner warner) {
        if (this.isSameType(type.getReturnType(), type3)) {
            return true;
        }
        if (type.getReturnType().isPrimitive() || type3.isPrimitive()) {
            return false;
        }
        if (this.hasSameArgs(type, type2)) {
            return this.covariantReturnType(type.getReturnType(), type3, warner);
        }
        if (!this.allowCovariantReturns) {
            return false;
        }
        if (this.isSubtypeUnchecked(type.getReturnType(), type3, warner)) {
            return true;
        }
        if (!this.isSubtype(type.getReturnType(), this.erasure(type3))) {
            return false;
        }
        warner.warn(Lint.LintCategory.UNCHECKED);
        return true;
    }

    public boolean covariantReturnType(Type type, Type type2, Warner warner) {
        return this.isSameType(type, type2) || this.allowCovariantReturns && !type.isPrimitive() && !type2.isPrimitive() && this.isAssignable(type, type2, warner);
    }

    public Symbol.ClassSymbol boxedClass(Type type) {
        return this.reader.enterClass(this.syms.boxedName[type.getTag().ordinal()]);
    }

    public Type boxedTypeOrType(Type type) {
        return type.isPrimitive() ? this.boxedClass((Type)type).type : type;
    }

    public Type unboxedType(Type type) {
        if (this.allowBoxing) {
            for (int i = 0; i < this.syms.boxedName.length; ++i) {
                Name name = this.syms.boxedName[i];
                if (name == null || this.asSuper(type, this.reader.enterClass(name)) == null) continue;
                return this.syms.typeOfTag[i];
            }
        }
        return Type.noType;
    }

    public Type unboxedTypeOrType(Type type) {
        Type type2 = this.unboxedType(type);
        return type2.hasTag(TypeTag.NONE) ? type : type2;
    }

    public List<Type> capture(List<Type> list) {
        List<Type> list2 = List.nil();
        for (Type type : list) {
            list2 = list2.prepend(this.capture(type));
        }
        return list2.reverse();
    }

    public Type capture(Type type) {
        Type type2;
        Type type3;
        if (!type.hasTag(TypeTag.CLASS)) {
            return type;
        }
        if (type.getEnclosingType() != Type.noType && (type3 = this.capture(type.getEnclosingType())) != type.getEnclosingType()) {
            type2 = this.memberType(type3, type.tsym);
            type = this.subst(type2, type.tsym.type.getTypeArguments(), type.getTypeArguments());
        }
        if (((Type.ClassType)(type3 = (Type.ClassType)(type = type.unannotatedType()))).isRaw() || !((Type.ClassType)type3).isParameterized()) {
            return type3;
        }
        type2 = (Type.ClassType)((Symbol.TypeSymbol)((Type.ClassType)type3).asElement()).asType();
        List<Type> list = ((Type.ClassType)type2).getTypeArguments();
        List list2 = ((Type.ClassType)type3).getTypeArguments();
        List<Type> list3 = this.freshTypeVariables(list2);
        List<Type> list4 = list;
        List list5 = list2;
        List<Type> list6 = list3;
        boolean bl = false;
        while (!(list4.isEmpty() || list5.isEmpty() || list6.isEmpty())) {
            if (list6.head != list5.head) {
                bl = true;
                Type.WildcardType wildcardType = (Type.WildcardType)((Type)list5.head).unannotatedType();
                Type type4 = ((Type)list4.head).getUpperBound();
                Type.CapturedType capturedType = (Type.CapturedType)((Type)list6.head).unannotatedType();
                if (type4 == null) {
                    type4 = this.syms.objectType;
                }
                switch (wildcardType.kind) {
                    case UNBOUND: {
                        capturedType.bound = this.subst(type4, list, list3);
                        capturedType.lower = this.syms.botType;
                        break;
                    }
                    case EXTENDS: {
                        capturedType.bound = this.glb(wildcardType.getExtendsBound(), this.subst(type4, list, list3));
                        capturedType.lower = this.syms.botType;
                        break;
                    }
                    case SUPER: {
                        capturedType.bound = this.subst(type4, list, list3);
                        capturedType.lower = wildcardType.getSuperBound();
                    }
                }
                if (capturedType.bound == capturedType.lower) {
                    list6.head = capturedType.bound;
                }
            }
            list4 = list4.tail;
            list5 = list5.tail;
            list6 = list6.tail;
        }
        if (!(list4.isEmpty() && list5.isEmpty() && list6.isEmpty())) {
            return this.erasure(type);
        }
        if (bl) {
            return new Type.ClassType(((Type.ClassType)type3).getEnclosingType(), list3, ((Type.ClassType)type3).tsym);
        }
        return type;
    }

    public List<Type> freshTypeVariables(List<Type> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : list) {
            if (type.hasTag(TypeTag.WILDCARD)) {
                Type type2 = ((Type.WildcardType)(type = type.unannotatedType())).getExtendsBound();
                if (type2 == null) {
                    type2 = this.syms.objectType;
                }
                listBuffer.append(new Type.CapturedType(this.capturedName, this.syms.noSymbol, type2, this.syms.botType, (Type.WildcardType)type));
                continue;
            }
            listBuffer.append(type);
        }
        return listBuffer.toList();
    }

    private List<Type> upperBounds(List<Type> list) {
        if (list.isEmpty()) {
            return list;
        }
        Type type = this.upperBound((Type)list.head);
        List<Type> list2 = this.upperBounds(list.tail);
        if (type != list.head || list2 != list.tail) {
            return list2.prepend(type);
        }
        return list;
    }

    private boolean sideCast(Type type, Type type2, Warner warner) {
        boolean bl = false;
        Type type3 = type2;
        if ((type2.tsym.flags() & 0x200L) == 0L) {
            Assert.check((type.tsym.flags() & 0x200L) != 0L);
            bl = true;
            type2 = type;
            type = type3;
        }
        List<Type> list = this.superClosure(type2, this.erasure(type));
        boolean bl2 = list.isEmpty();
        while (list.nonEmpty()) {
            Type type4 = this.asSuper(type, ((Type)list.head).tsym);
            Type type5 = (Type)list.head;
            if (this.disjointTypes(type4.getTypeArguments(), type5.getTypeArguments())) {
                return false;
            }
            bl2 = bl2 || (bl ? this.giveWarning(type5, type4) : this.giveWarning(type4, type5));
            list = list.tail;
        }
        if (bl2 && !this.isReifiable(bl ? type : type2)) {
            warner.warn(Lint.LintCategory.UNCHECKED);
        }
        if (!this.allowCovariantReturns) {
            this.chk.checkCompatibleAbstracts(warner.pos(), type, type2);
        }
        return true;
    }

    private boolean sideCastFinal(Type type, Type type2, Warner warner) {
        boolean bl = false;
        Type type3 = type2;
        if ((type2.tsym.flags() & 0x200L) == 0L) {
            Assert.check((type.tsym.flags() & 0x200L) != 0L);
            bl = true;
            type2 = type;
            type = type3;
        }
        Assert.check((type.tsym.flags() & 0x10L) != 0L);
        Type type4 = this.asSuper(type, type2.tsym);
        if (type4 == null) {
            return false;
        }
        Type type5 = type2;
        if (this.disjointTypes(type4.getTypeArguments(), type5.getTypeArguments())) {
            return false;
        }
        if (!this.allowCovariantReturns) {
            this.chk.checkCompatibleAbstracts(warner.pos(), type, type2);
        }
        if (!this.isReifiable(type3) && (bl ? this.giveWarning(type5, type4) : this.giveWarning(type4, type5))) {
            warner.warn(Lint.LintCategory.UNCHECKED);
        }
        return true;
    }

    private boolean giveWarning(Type type, Type type2) {
        List<Type> list = type2.isCompound() ? ((Type.IntersectionClassType)type2.unannotatedType()).getComponents() : List.of(type2);
        for (Type type3 : list) {
            Type type4 = this.asSub(type, type3.tsym);
            if (!type3.isParameterized() || this.isUnbounded(type3) || this.isSubtype(type, type3) || type4 != null && this.containsType(type3.allparams(), type4.allparams())) continue;
            return true;
        }
        return false;
    }

    private List<Type> superClosure(Type type, Type type2) {
        List<Type> list = List.nil();
        List<Type> list2 = this.interfaces(type);
        while (list2.nonEmpty()) {
            list = this.isSubtype(type2, this.erasure((Type)list2.head)) ? this.insert(list, (Type)list2.head) : this.union(list, this.superClosure((Type)list2.head, type2));
            list2 = list2.tail;
        }
        return list;
    }

    private boolean containsTypeEquivalent(Type type, Type type2) {
        return this.isSameType(type, type2) || this.containsType(type, type2) && this.containsType(type2, type);
    }

    public void adapt(Type type, Type type2, ListBuffer<Type> listBuffer, ListBuffer<Type> listBuffer2) throws AdaptFailure {
        new Adapter(listBuffer, listBuffer2).adapt(type, type2);
    }

    private void adaptSelf(Type type, ListBuffer<Type> listBuffer, ListBuffer<Type> listBuffer2) {
        try {
            this.adapt(type.tsym.type, type, listBuffer, listBuffer2);
        }
        catch (AdaptFailure adaptFailure) {
            throw new AssertionError((Object)adaptFailure);
        }
    }

    private Type rewriteQuantifiers(Type type, boolean bl, boolean bl2) {
        return (Type)new Rewriter(bl, bl2).visit(type);
    }

    private Type.WildcardType makeExtendsWildcard(Type type, Type.TypeVar typeVar) {
        if (type == this.syms.objectType) {
            return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass, typeVar);
        }
        return new Type.WildcardType(type, BoundKind.EXTENDS, this.syms.boundClass, typeVar);
    }

    private Type.WildcardType makeSuperWildcard(Type type, Type.TypeVar typeVar) {
        if (type.hasTag(TypeTag.BOT)) {
            return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass, typeVar);
        }
        return new Type.WildcardType(type, BoundKind.SUPER, this.syms.boundClass, typeVar);
    }

    public Attribute.RetentionPolicy getRetention(Attribute.Compound compound) {
        return this.getRetention(compound.type.tsym);
    }

    public Attribute.RetentionPolicy getRetention(Symbol symbol) {
        Attribute attribute;
        Attribute.RetentionPolicy retentionPolicy = Attribute.RetentionPolicy.CLASS;
        Attribute.Compound compound = symbol.attribute(this.syms.retentionType.tsym);
        if (compound != null && (attribute = compound.member(this.names.value)) != null && attribute instanceof Attribute.Enum) {
            Name name = ((Attribute.Enum)attribute).value.name;
            if (name == this.names.SOURCE) {
                retentionPolicy = Attribute.RetentionPolicy.SOURCE;
            } else if (name == this.names.CLASS) {
                retentionPolicy = Attribute.RetentionPolicy.CLASS;
            } else if (name == this.names.RUNTIME) {
                retentionPolicy = Attribute.RetentionPolicy.RUNTIME;
            }
        }
        return retentionPolicy;
    }

    public static abstract class SignatureGenerator {
        private final Types types;

        protected abstract void append(char var1);

        protected abstract void append(byte[] var1);

        protected abstract void append(Name var1);

        protected void classReference(Symbol.ClassSymbol classSymbol) {
        }

        protected SignatureGenerator(Types types) {
            this.types = types;
        }

        public void assembleSig(Type type) {
            type = type.unannotatedType();
            block0 : switch (type.getTag()) {
                case BYTE: {
                    this.append('B');
                    break;
                }
                case SHORT: {
                    this.append('S');
                    break;
                }
                case CHAR: {
                    this.append('C');
                    break;
                }
                case INT: {
                    this.append('I');
                    break;
                }
                case LONG: {
                    this.append('J');
                    break;
                }
                case FLOAT: {
                    this.append('F');
                    break;
                }
                case DOUBLE: {
                    this.append('D');
                    break;
                }
                case BOOLEAN: {
                    this.append('Z');
                    break;
                }
                case VOID: {
                    this.append('V');
                    break;
                }
                case CLASS: {
                    this.append('L');
                    this.assembleClassSig(type);
                    this.append(';');
                    break;
                }
                case ARRAY: {
                    Type.ArrayType arrayType = (Type.ArrayType)type;
                    this.append('[');
                    this.assembleSig(arrayType.elemtype);
                    break;
                }
                case METHOD: {
                    Type.MethodType methodType = (Type.MethodType)type;
                    this.append('(');
                    this.assembleSig(methodType.argtypes);
                    this.append(')');
                    this.assembleSig(methodType.restype);
                    if (!this.hasTypeVar(methodType.thrown)) break;
                    List<Type> list = methodType.thrown;
                    while (list.nonEmpty()) {
                        this.append('^');
                        this.assembleSig((Type)list.head);
                        list = list.tail;
                    }
                    break;
                }
                case WILDCARD: {
                    Type.WildcardType wildcardType = (Type.WildcardType)type;
                    switch (wildcardType.kind) {
                        case SUPER: {
                            this.append('-');
                            this.assembleSig(wildcardType.type);
                            break block0;
                        }
                        case EXTENDS: {
                            this.append('+');
                            this.assembleSig(wildcardType.type);
                            break block0;
                        }
                        case UNBOUND: {
                            this.append('*');
                            break block0;
                        }
                    }
                    throw new AssertionError((Object)wildcardType.kind);
                }
                case TYPEVAR: {
                    this.append('T');
                    this.append(type.tsym.name);
                    this.append(';');
                    break;
                }
                case FORALL: {
                    Type.ForAll forAll = (Type.ForAll)type;
                    this.assembleParamsSig(forAll.tvars);
                    this.assembleSig(forAll.qtype);
                    break;
                }
                default: {
                    String string = String.valueOf(String.valueOf((Object)type.getTag()));
                    throw new AssertionError((Object)new StringBuilder(8 + string.length()).append("typeSig ").append(string).toString());
                }
            }
        }

        public boolean hasTypeVar(List<Type> list) {
            while (list.nonEmpty()) {
                if (((Type)list.head).hasTag(TypeTag.TYPEVAR)) {
                    return true;
                }
                list = list.tail;
            }
            return false;
        }

        public void assembleClassSig(Type type) {
            type = type.unannotatedType();
            Type.ClassType classType = (Type.ClassType)type;
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)classType.tsym;
            this.classReference(classSymbol);
            Type type2 = classType.getEnclosingType();
            if (type2.allparams().nonEmpty()) {
                boolean bl = classSymbol.owner.kind == 16 || classSymbol.name == this.types.names.empty;
                this.assembleClassSig(bl ? this.types.erasure(type2) : type2);
                this.append('.');
                Assert.check(classSymbol.flatname.startsWith(classSymbol.owner.enclClass().flatname));
                this.append(bl ? classSymbol.flatname.subName(classSymbol.owner.enclClass().flatname.getByteLength() + 1, classSymbol.flatname.getByteLength()) : classSymbol.name);
            } else {
                this.append(ClassFile.externalize(classSymbol.flatname));
            }
            if (((List)classType.getTypeArguments()).nonEmpty()) {
                this.append('<');
                this.assembleSig((List<Type>)classType.getTypeArguments());
                this.append('>');
            }
        }

        public void assembleParamsSig(List<Type> list) {
            this.append('<');
            List<Type> list2 = list;
            while (list2.nonEmpty()) {
                Type.TypeVar typeVar = (Type.TypeVar)list2.head;
                this.append(typeVar.tsym.name);
                List<Type> list3 = this.types.getBounds(typeVar);
                if ((((Type)list3.head).tsym.flags() & 0x200L) != 0L) {
                    this.append(':');
                }
                List<Type> list4 = list3;
                while (list4.nonEmpty()) {
                    this.append(':');
                    this.assembleSig((Type)list4.head);
                    list4 = list4.tail;
                }
                list2 = list2.tail;
            }
            this.append('>');
        }

        private void assembleSig(List<Type> list) {
            List<Type> list2 = list;
            while (list2.nonEmpty()) {
                this.assembleSig((Type)list2.head);
                list2 = list2.tail;
            }
        }
    }

    public static class MapVisitor<S>
    extends DefaultTypeVisitor<Type, S> {
        public final Type visit(Type type) {
            return (Type)type.accept(this, null);
        }

        @Override
        public Type visitType(Type type, S s) {
            return type;
        }
    }

    public static abstract class UnaryVisitor<R>
    extends SimpleVisitor<R, Void> {
        public final R visit(Type type) {
            return type.accept(this, null);
        }
    }

    public static abstract class TypeRelation
    extends SimpleVisitor<Boolean, Type> {
    }

    public static abstract class SimpleVisitor<R, S>
    extends DefaultTypeVisitor<R, S> {
        @Override
        public R visitCapturedType(Type.CapturedType capturedType, S s) {
            return this.visitTypeVar(capturedType, s);
        }

        @Override
        public R visitForAll(Type.ForAll forAll, S s) {
            return this.visit(forAll.qtype, s);
        }

        @Override
        public R visitUndetVar(Type.UndetVar undetVar, S s) {
            return this.visit(undetVar.qtype, s);
        }
    }

    public static abstract class DefaultSymbolVisitor<R, S>
    implements Symbol.Visitor<R, S> {
        public final R visit(Symbol symbol, S s) {
            return symbol.accept(this, s);
        }

        @Override
        public R visitClassSymbol(Symbol.ClassSymbol classSymbol, S s) {
            return this.visitSymbol(classSymbol, s);
        }

        @Override
        public R visitMethodSymbol(Symbol.MethodSymbol methodSymbol, S s) {
            return this.visitSymbol(methodSymbol, s);
        }

        @Override
        public R visitOperatorSymbol(Symbol.OperatorSymbol operatorSymbol, S s) {
            return this.visitSymbol(operatorSymbol, s);
        }

        @Override
        public R visitPackageSymbol(Symbol.PackageSymbol packageSymbol, S s) {
            return this.visitSymbol(packageSymbol, s);
        }

        @Override
        public R visitTypeSymbol(Symbol.TypeSymbol typeSymbol, S s) {
            return this.visitSymbol(typeSymbol, s);
        }

        @Override
        public R visitVarSymbol(Symbol.VarSymbol varSymbol, S s) {
            return this.visitSymbol(varSymbol, s);
        }
    }

    public static abstract class DefaultTypeVisitor<R, S>
    implements Type.Visitor<R, S> {
        public final R visit(Type type, S s) {
            return type.accept(this, s);
        }

        @Override
        public R visitClassType(Type.ClassType classType, S s) {
            return this.visitType(classType, s);
        }

        @Override
        public R visitWildcardType(Type.WildcardType wildcardType, S s) {
            return this.visitType(wildcardType, s);
        }

        @Override
        public R visitArrayType(Type.ArrayType arrayType, S s) {
            return this.visitType(arrayType, s);
        }

        @Override
        public R visitMethodType(Type.MethodType methodType, S s) {
            return this.visitType(methodType, s);
        }

        @Override
        public R visitPackageType(Type.PackageType packageType, S s) {
            return this.visitType(packageType, s);
        }

        @Override
        public R visitTypeVar(Type.TypeVar typeVar, S s) {
            return this.visitType(typeVar, s);
        }

        @Override
        public R visitCapturedType(Type.CapturedType capturedType, S s) {
            return this.visitType(capturedType, s);
        }

        @Override
        public R visitForAll(Type.ForAll forAll, S s) {
            return this.visitType(forAll, s);
        }

        @Override
        public R visitUndetVar(Type.UndetVar undetVar, S s) {
            return this.visitType(undetVar, s);
        }

        @Override
        public R visitErrorType(Type.ErrorType errorType, S s) {
            return this.visitType(errorType, s);
        }

        @Override
        public R visitAnnotatedType(Type.AnnotatedType annotatedType, S s) {
            return this.visit(annotatedType.unannotatedType(), s);
        }
    }

    public static class UniqueType {
        public final Type type;
        final Types types;

        public UniqueType(Type type, Types types) {
            this.type = type;
            this.types = types;
        }

        public int hashCode() {
            return this.types.hashCode(this.type);
        }

        public boolean equals(Object object) {
            return object instanceof UniqueType && this.types.isSameAnnotatedType(this.type, ((UniqueType)object).type);
        }

        public String toString() {
            return this.type.toString();
        }
    }

    class Rewriter
    extends UnaryVisitor<Type> {
        boolean high;
        boolean rewriteTypeVars;

        Rewriter(boolean bl, boolean bl2) {
            this.high = bl;
            this.rewriteTypeVars = bl2;
        }

        @Override
        public Type visitClassType(Type.ClassType classType, Void void_) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            boolean bl = false;
            for (Type type : classType.allparams()) {
                Type type2;
                if (type != (type2 = (Type)this.visit(type))) {
                    bl = true;
                }
                listBuffer.append(type2);
            }
            if (bl) {
                return Types.this.subst(classType.tsym.type, classType.tsym.type.allparams(), listBuffer.toList());
            }
            return classType;
        }

        @Override
        public Type visitType(Type type, Void void_) {
            return this.high ? Types.this.upperBound(type) : Types.this.lowerBound(type);
        }

        @Override
        public Type visitCapturedType(Type.CapturedType capturedType, Void void_) {
            Type type = capturedType.wildcard.type;
            Type type2 = type.contains(capturedType) ? Types.this.erasure(type) : (Type)this.visit(type);
            return this.rewriteAsWildcardType((Type)this.visit(type2), capturedType.wildcard.bound, capturedType.wildcard.kind);
        }

        @Override
        public Type visitTypeVar(Type.TypeVar typeVar, Void void_) {
            if (this.rewriteTypeVars) {
                Type type = typeVar.bound.contains(typeVar) ? Types.this.erasure(typeVar.bound) : (Type)this.visit(typeVar.bound);
                return this.rewriteAsWildcardType(type, typeVar, BoundKind.EXTENDS);
            }
            return typeVar;
        }

        @Override
        public Type visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            Type type = (Type)this.visit(wildcardType.type);
            return wildcardType.type == type ? wildcardType : this.rewriteAsWildcardType(type, wildcardType.bound, wildcardType.kind);
        }

        private Type rewriteAsWildcardType(Type type, Type.TypeVar typeVar, BoundKind boundKind) {
            switch (boundKind) {
                case EXTENDS: {
                    return this.high ? Types.this.makeExtendsWildcard(this.B(type), typeVar) : Types.this.makeExtendsWildcard(Types.this.syms.objectType, typeVar);
                }
                case SUPER: {
                    return this.high ? Types.this.makeSuperWildcard(Types.this.syms.botType, typeVar) : Types.this.makeSuperWildcard(this.B(type), typeVar);
                }
                case UNBOUND: {
                    return Types.this.makeExtendsWildcard(Types.this.syms.objectType, typeVar);
                }
            }
            String string = String.valueOf(String.valueOf((Object)boundKind));
            Assert.error(new StringBuilder(19 + string.length()).append("Invalid bound kind ").append(string).toString());
            return null;
        }

        Type B(Type type) {
            while (type.hasTag(TypeTag.WILDCARD)) {
                Type.WildcardType wildcardType = (Type.WildcardType)type.unannotatedType();
                type = this.high ? wildcardType.getExtendsBound() : wildcardType.getSuperBound();
                if (type != null) continue;
                type = this.high ? Types.this.syms.objectType : Types.this.syms.botType;
            }
            return type;
        }
    }

    public static class AdaptFailure
    extends RuntimeException {
        static final long serialVersionUID = -7490231548272701566L;
    }

    class Adapter
    extends SimpleVisitor<Void, Type> {
        ListBuffer<Type> from;
        ListBuffer<Type> to;
        Map<Symbol, Type> mapping;
        private Set<TypePair> cache = new HashSet<TypePair>();

        Adapter(ListBuffer<Type> listBuffer, ListBuffer<Type> listBuffer2) {
            this.from = listBuffer;
            this.to = listBuffer2;
            this.mapping = new HashMap<Symbol, Type>();
        }

        public void adapt(Type type, Type type2) throws AdaptFailure {
            this.visit(type, type2);
            List<Type> list = this.from.toList();
            List<Type> list2 = this.to.toList();
            while (!list.isEmpty()) {
                Type type3 = this.mapping.get(((Type)list.head).tsym);
                if (list2.head != type3) {
                    list2.head = type3;
                }
                list = list.tail;
                list2 = list2.tail;
            }
        }

        @Override
        public Void visitClassType(Type.ClassType classType, Type type) throws AdaptFailure {
            if (type.hasTag(TypeTag.CLASS)) {
                this.adaptRecursive(classType.allparams(), type.allparams());
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType arrayType, Type type) throws AdaptFailure {
            if (type.hasTag(TypeTag.ARRAY)) {
                this.adaptRecursive(Types.this.elemtype(arrayType), Types.this.elemtype(type));
            }
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType wildcardType, Type type) throws AdaptFailure {
            if (wildcardType.isExtendsBound()) {
                this.adaptRecursive(Types.this.upperBound(wildcardType), Types.this.upperBound(type));
            } else if (wildcardType.isSuperBound()) {
                this.adaptRecursive(Types.this.lowerBound(wildcardType), Types.this.lowerBound(type));
            }
            return null;
        }

        @Override
        public Void visitTypeVar(Type.TypeVar typeVar, Type type) throws AdaptFailure {
            Type type2 = this.mapping.get(typeVar.tsym);
            if (type2 != null) {
                if (type2.isSuperBound() && type.isSuperBound()) {
                    type2 = Types.this.isSubtype(Types.this.lowerBound(type2), Types.this.lowerBound(type)) ? type : type2;
                } else if (type2.isExtendsBound() && type.isExtendsBound()) {
                    type2 = Types.this.isSubtype(Types.this.upperBound(type2), Types.this.upperBound(type)) ? type2 : type;
                } else if (!Types.this.isSameType(type2, type)) {
                    throw new AdaptFailure();
                }
            } else {
                type2 = type;
                this.from.append(typeVar);
                this.to.append(type);
            }
            this.mapping.put(typeVar.tsym, type2);
            return null;
        }

        @Override
        public Void visitType(Type type, Type type2) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adaptRecursive(Type type, Type type2) {
            TypePair typePair = new TypePair(type, type2);
            if (this.cache.add(typePair)) {
                try {
                    this.visit(type, type2);
                }
                finally {
                    this.cache.remove(typePair);
                }
            }
        }

        private void adaptRecursive(List<Type> list, List<Type> list2) {
            if (list.length() == list2.length()) {
                while (list.nonEmpty()) {
                    this.adaptRecursive((Type)list.head, (Type)list2.head);
                    list = list.tail;
                    list2 = list2.tail;
                }
            }
        }
    }

    class TypePair {
        final Type t1;
        final Type t2;

        TypePair(Type type, Type type2) {
            this.t1 = type;
            this.t2 = type2;
        }

        public int hashCode() {
            return 127 * Types.this.hashCode(this.t1) + Types.this.hashCode(this.t2);
        }

        public boolean equals(Object object) {
            if (!(object instanceof TypePair)) {
                return false;
            }
            TypePair typePair = (TypePair)object;
            return Types.this.isSameType(this.t1, typePair.t1) && Types.this.isSameType(this.t2, typePair.t2);
        }
    }

    private class Subst
    extends UnaryVisitor<Type> {
        List<Type> from;
        List<Type> to;

        public Subst(List<Type> list, List<Type> list2) {
            int n;
            int n2 = list2.length();
            for (n = list.length(); n > n2; --n) {
                list = list.tail;
            }
            while (n < n2) {
                --n2;
                list2 = list2.tail;
            }
            this.from = list;
            this.to = list2;
        }

        Type subst(Type type) {
            if (this.from.tail == null) {
                return type;
            }
            return (Type)this.visit(type);
        }

        List<Type> subst(List<Type> list) {
            if (this.from.tail == null) {
                return list;
            }
            boolean bl = false;
            if (list.nonEmpty() && this.from.nonEmpty()) {
                Type type = this.subst((Type)list.head);
                List<Type> list2 = this.subst(list.tail);
                if (type != list.head || list2 != list.tail) {
                    return list2.prepend(type);
                }
            }
            return list;
        }

        @Override
        public Type visitType(Type type, Void void_) {
            return type;
        }

        @Override
        public Type visitMethodType(Type.MethodType methodType, Void void_) {
            List<Type> list = this.subst(methodType.argtypes);
            Type type = this.subst(methodType.restype);
            List<Type> list2 = this.subst(methodType.thrown);
            if (list == methodType.argtypes && type == methodType.restype && list2 == methodType.thrown) {
                return methodType;
            }
            return new Type.MethodType(list, type, list2, methodType.tsym);
        }

        @Override
        public Type visitTypeVar(Type.TypeVar typeVar, Void void_) {
            List<Type> list = this.from;
            List<Type> list2 = this.to;
            while (list.nonEmpty()) {
                if (typeVar == list.head) {
                    return ((Type)list2.head).withTypeVar(typeVar);
                }
                list = list.tail;
                list2 = list2.tail;
            }
            return typeVar;
        }

        @Override
        public Type visitClassType(Type.ClassType classType, Void void_) {
            if (!classType.isCompound()) {
                java.util.List list = classType.getTypeArguments();
                List<Type> list2 = this.subst((List<Type>)list);
                Type type = classType.getEnclosingType();
                Type type2 = this.subst(type);
                if (list2 == list && type2 == type) {
                    return classType;
                }
                return new Type.ClassType(type2, list2, classType.tsym);
            }
            Type type = this.subst(Types.this.supertype(classType));
            List list = Types.this.upperBounds(this.subst(Types.this.interfaces(classType)));
            if (type == Types.this.supertype(classType) && list == Types.this.interfaces(classType)) {
                return classType;
            }
            return Types.this.makeCompoundType(list.prepend(type));
        }

        @Override
        public Type visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            Type type = wildcardType.type;
            if (wildcardType.kind != BoundKind.UNBOUND) {
                type = this.subst(type);
            }
            if (type == wildcardType.type) {
                return wildcardType;
            }
            if (wildcardType.isExtendsBound() && type.isExtendsBound()) {
                type = Types.this.upperBound(type);
            }
            return new Type.WildcardType(type, wildcardType.kind, Types.this.syms.boundClass, wildcardType.bound);
        }

        @Override
        public Type visitArrayType(Type.ArrayType arrayType, Void void_) {
            Type type = this.subst(arrayType.elemtype);
            if (type == arrayType.elemtype) {
                return arrayType;
            }
            return new Type.ArrayType(type, arrayType.tsym);
        }

        @Override
        public Type visitForAll(Type.ForAll forAll, Void void_) {
            List<Type> list;
            if (Type.containsAny(this.to, forAll.tvars)) {
                list = Types.this.newInstances(forAll.tvars);
                forAll = new Type.ForAll(list, Types.this.subst(forAll.qtype, forAll.tvars, list));
            }
            list = Types.this.substBounds(forAll.tvars, this.from, this.to);
            Type type = this.subst(forAll.qtype);
            if (list == forAll.tvars && type == forAll.qtype) {
                return forAll;
            }
            if (list == forAll.tvars) {
                return new Type.ForAll(list, type);
            }
            return new Type.ForAll(list, Types.this.subst(type, forAll.tvars, list));
        }

        @Override
        public Type visitErrorType(Type.ErrorType errorType, Void void_) {
            return errorType;
        }
    }

    private class HasSameArgs
    extends TypeRelation {
        boolean strict;

        public HasSameArgs(boolean bl) {
            this.strict = bl;
        }

        @Override
        public Boolean visitType(Type type, Type type2) {
            throw new AssertionError();
        }

        @Override
        public Boolean visitMethodType(Type.MethodType methodType, Type type) {
            return type.hasTag(TypeTag.METHOD) && Types.this.containsTypeEquivalent(methodType.argtypes, type.getParameterTypes());
        }

        @Override
        public Boolean visitForAll(Type.ForAll forAll, Type type) {
            if (!type.hasTag(TypeTag.FORALL)) {
                return this.strict ? false : this.visitMethodType(forAll.asMethodType(), type);
            }
            Type.ForAll forAll2 = (Type.ForAll)type;
            return Types.this.hasSameBounds(forAll, forAll2) && (Boolean)this.visit(forAll.qtype, Types.this.subst(forAll2.qtype, forAll2.tvars, forAll.tvars)) != false;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType errorType, Type type) {
            return false;
        }
    }

    private class MethodFilter
    implements Filter<Symbol> {
        Symbol msym;
        Type site;

        MethodFilter(Symbol symbol, Type type) {
            this.msym = symbol;
            this.site = type;
        }

        @Override
        public boolean accepts(Symbol symbol) {
            return symbol.kind == 16 && symbol.name == this.msym.name && (symbol.flags() & 0x1000L) == 0L && symbol.isInheritedIn(this.site.tsym, Types.this) && Types.this.overrideEquivalent(Types.this.memberType(this.site, symbol), Types.this.memberType(this.site, this.msym));
        }
    }

    class MembersClosureCache
    extends SimpleVisitor<Scope.CompoundScope, Boolean> {
        private WeakHashMap<Symbol.TypeSymbol, Entry> _map = new WeakHashMap();
        List<Symbol.TypeSymbol> seenTypes = List.nil();

        MembersClosureCache() {
        }

        @Override
        public Scope.CompoundScope visitType(Type type, Boolean bl) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Scope.CompoundScope visitClassType(Type.ClassType classType, Boolean bl) {
            if (this.seenTypes.contains(classType.tsym)) {
                return new Scope.CompoundScope(classType.tsym);
            }
            try {
                Scope.CompoundScope compoundScope;
                this.seenTypes = this.seenTypes.prepend(classType.tsym);
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)classType.tsym;
                Entry entry = this._map.get(classSymbol);
                if (entry == null || !entry.matches(bl)) {
                    compoundScope = new Scope.CompoundScope(classSymbol);
                    if (!bl.booleanValue()) {
                        for (Type type : Types.this.interfaces(classType)) {
                            compoundScope.addSubScope((Scope)this.visit(type, bl));
                        }
                    }
                    compoundScope.addSubScope((Scope)this.visit(Types.this.supertype(classType), bl));
                    compoundScope.addSubScope(classSymbol.members());
                    entry = new Entry(bl, compoundScope);
                    this._map.put(classSymbol, entry);
                }
                compoundScope = entry.compoundScope;
                return compoundScope;
            }
            finally {
                this.seenTypes = this.seenTypes.tail;
            }
        }

        @Override
        public Scope.CompoundScope visitTypeVar(Type.TypeVar typeVar, Boolean bl) {
            return (Scope.CompoundScope)this.visit(typeVar.getUpperBound(), bl);
        }

        class Entry {
            final boolean skipInterfaces;
            final Scope.CompoundScope compoundScope;

            public Entry(boolean bl, Scope.CompoundScope compoundScope) {
                this.skipInterfaces = bl;
                this.compoundScope = compoundScope;
            }

            boolean matches(boolean bl) {
                return this.skipInterfaces == bl;
            }
        }
    }

    class ImplementationCache {
        private WeakHashMap<Symbol.MethodSymbol, SoftReference<Map<Symbol.TypeSymbol, Entry>>> _map = new WeakHashMap();

        ImplementationCache() {
        }

        Symbol.MethodSymbol get(Symbol.MethodSymbol methodSymbol, Symbol.TypeSymbol typeSymbol, boolean bl, Filter<Symbol> filter) {
            Map<Symbol.TypeSymbol, Entry> map;
            SoftReference<Map<Symbol.TypeSymbol, Entry>> softReference = this._map.get(methodSymbol);
            Map<Symbol.TypeSymbol, Entry> map2 = map = softReference != null ? softReference.get() : null;
            if (map == null) {
                map = new HashMap<Symbol.TypeSymbol, Entry>();
                this._map.put(methodSymbol, new SoftReference<Map<Symbol.TypeSymbol, Entry>>(map));
            }
            Entry entry = map.get(typeSymbol);
            Scope.CompoundScope compoundScope = Types.this.membersClosure(typeSymbol.type, true);
            if (entry == null || !entry.matches(filter, bl, compoundScope.getMark())) {
                Symbol.MethodSymbol methodSymbol2 = this.implementationInternal(methodSymbol, typeSymbol, bl, filter);
                map.put(typeSymbol, new Entry(methodSymbol2, filter, bl, compoundScope.getMark()));
                return methodSymbol2;
            }
            return entry.cachedImpl;
        }

        private Symbol.MethodSymbol implementationInternal(Symbol.MethodSymbol methodSymbol, Symbol.TypeSymbol typeSymbol, boolean bl, Filter<Symbol> filter) {
            Type type = typeSymbol.type;
            while (type.hasTag(TypeTag.CLASS) || type.hasTag(TypeTag.TYPEVAR)) {
                while (type.hasTag(TypeTag.TYPEVAR)) {
                    type = type.getUpperBound();
                }
                Symbol.TypeSymbol typeSymbol2 = type.tsym;
                Scope.Entry entry = typeSymbol2.members().lookup(methodSymbol.name, filter);
                while (entry.scope != null) {
                    if (entry.sym != null && entry.sym.overrides(methodSymbol, typeSymbol, Types.this, bl)) {
                        return (Symbol.MethodSymbol)entry.sym;
                    }
                    entry = entry.next(filter);
                }
                type = Types.this.supertype(type);
            }
            return null;
        }

        class Entry {
            final Symbol.MethodSymbol cachedImpl;
            final Filter<Symbol> implFilter;
            final boolean checkResult;
            final int prevMark;

            public Entry(Symbol.MethodSymbol methodSymbol, Filter<Symbol> filter, boolean bl, int n) {
                this.cachedImpl = methodSymbol;
                this.implFilter = filter;
                this.checkResult = bl;
                this.prevMark = n;
            }

            boolean matches(Filter<Symbol> filter, boolean bl, int n) {
                return this.implFilter == filter && this.checkResult == bl && this.prevMark == n;
            }
        }
    }

    private class LooseSameTypeVisitor
    extends SameTypeVisitor {
        private LooseSameTypeVisitor() {
        }

        @Override
        boolean sameTypeVars(Type.TypeVar typeVar, Type.TypeVar typeVar2) {
            return typeVar.tsym == typeVar2.tsym && (Boolean)this.visit(typeVar.getUpperBound(), typeVar2.getUpperBound()) != false;
        }

        @Override
        protected boolean containsTypes(List<Type> list, List<Type> list2) {
            return Types.this.containsTypeEquivalent(list, list2);
        }
    }

    abstract class SameTypeVisitor
    extends TypeRelation {
        SameTypeVisitor() {
        }

        @Override
        public Boolean visitType(Type type, Type type2) {
            if (type == type2) {
                return true;
            }
            if (type2.isPartial()) {
                return (Boolean)this.visit(type2, type);
            }
            switch (type.getTag()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: 
                case BOT: 
                case NONE: {
                    return type.hasTag(type2.getTag());
                }
                case TYPEVAR: {
                    if (type2.hasTag(TypeTag.TYPEVAR)) {
                        return this.sameTypeVars((Type.TypeVar)type.unannotatedType(), (Type.TypeVar)type2.unannotatedType());
                    }
                    return type2.isSuperBound() && !type2.isExtendsBound() && (Boolean)this.visit(type, Types.this.upperBound(type2)) != false;
                }
            }
            String string = String.valueOf(String.valueOf((Object)type.getTag()));
            throw new AssertionError((Object)new StringBuilder(11 + string.length()).append("isSameType ").append(string).toString());
        }

        abstract boolean sameTypeVars(Type.TypeVar var1, Type.TypeVar var2);

        @Override
        public Boolean visitWildcardType(Type.WildcardType wildcardType, Type type) {
            if (type.isPartial()) {
                return (Boolean)this.visit(type, wildcardType);
            }
            return false;
        }

        @Override
        public Boolean visitClassType(Type.ClassType classType, Type type) {
            if (classType == type) {
                return true;
            }
            if (type.isPartial()) {
                return (Boolean)this.visit(type, classType);
            }
            if (type.isSuperBound() && !type.isExtendsBound()) {
                return (Boolean)this.visit(classType, Types.this.upperBound(type)) != false && (Boolean)this.visit(classType, Types.this.lowerBound(type)) != false;
            }
            if (classType.isCompound() && type.isCompound()) {
                if (!((Boolean)this.visit(Types.this.supertype(classType), Types.this.supertype(type))).booleanValue()) {
                    return false;
                }
                HashSet<UniqueType> hashSet = new HashSet<UniqueType>();
                for (Type type2 : Types.this.interfaces(classType)) {
                    hashSet.add(new UniqueType(type2.unannotatedType(), Types.this));
                }
                for (Type type2 : Types.this.interfaces(type)) {
                    if (hashSet.remove(new UniqueType(type2.unannotatedType(), Types.this))) continue;
                    return false;
                }
                return hashSet.isEmpty();
            }
            return classType.tsym == type.tsym && (Boolean)this.visit(classType.getEnclosingType(), type.getEnclosingType()) != false && this.containsTypes((List<Type>)classType.getTypeArguments(), type.getTypeArguments());
        }

        protected abstract boolean containsTypes(List<Type> var1, List<Type> var2);

        @Override
        public Boolean visitArrayType(Type.ArrayType arrayType, Type type) {
            if (arrayType == type) {
                return true;
            }
            if (type.isPartial()) {
                return (Boolean)this.visit(type, arrayType);
            }
            return type.hasTag(TypeTag.ARRAY) && Types.this.containsTypeEquivalent(arrayType.elemtype, Types.this.elemtype(type));
        }

        @Override
        public Boolean visitMethodType(Type.MethodType methodType, Type type) {
            return Types.this.hasSameArgs(methodType, type) && (Boolean)this.visit(methodType.getReturnType(), type.getReturnType()) != false;
        }

        @Override
        public Boolean visitPackageType(Type.PackageType packageType, Type type) {
            return packageType == type;
        }

        @Override
        public Boolean visitForAll(Type.ForAll forAll, Type type) {
            if (!type.hasTag(TypeTag.FORALL)) {
                return false;
            }
            Type.ForAll forAll2 = (Type.ForAll)type;
            return Types.this.hasSameBounds(forAll, forAll2) && (Boolean)this.visit(forAll.qtype, Types.this.subst(forAll2.qtype, forAll2.tvars, forAll.tvars)) != false;
        }

        @Override
        public Boolean visitUndetVar(Type.UndetVar undetVar, Type type) {
            if (type.hasTag(TypeTag.WILDCARD)) {
                return false;
            }
            if (undetVar == type || undetVar.qtype == type || type.hasTag(TypeTag.ERROR) || type.hasTag(TypeTag.UNKNOWN)) {
                return true;
            }
            undetVar.addBound(Type.UndetVar.InferenceBound.EQ, type, Types.this);
            return true;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType errorType, Type type) {
            return true;
        }
    }

    class DescriptorFilter
    implements Filter<Symbol> {
        Symbol.TypeSymbol origin;

        DescriptorFilter(Symbol.TypeSymbol typeSymbol) {
            this.origin = typeSymbol;
        }

        @Override
        public boolean accepts(Symbol symbol) {
            return symbol.kind == 16 && (symbol.flags() & 0x80000000400L) == 1024L && !Types.this.overridesObjectMethod(this.origin, symbol) && (((Symbol.MethodSymbol)Types.this.interfaceCandidates((Type)this.origin.type, (Symbol.MethodSymbol)((Symbol.MethodSymbol)symbol)).head).flags() & 0x80000000000L) == 0L;
        }
    }

    class DescriptorCache {
        private WeakHashMap<Symbol.TypeSymbol, Entry> _map = new WeakHashMap();

        DescriptorCache() {
        }

        FunctionDescriptor get(Symbol.TypeSymbol typeSymbol) throws FunctionDescriptorLookupError {
            Entry entry = this._map.get(typeSymbol);
            Scope.CompoundScope compoundScope = Types.this.membersClosure(typeSymbol.type, false);
            if (entry == null || !entry.matches(compoundScope.getMark())) {
                FunctionDescriptor functionDescriptor = this.findDescriptorInternal(typeSymbol, compoundScope);
                this._map.put(typeSymbol, new Entry(functionDescriptor, compoundScope.getMark()));
                return functionDescriptor;
            }
            return entry.cachedDescRes;
        }

        public FunctionDescriptor findDescriptorInternal(Symbol.TypeSymbol typeSymbol, Scope.CompoundScope compoundScope) throws FunctionDescriptorLookupError {
            Object object;
            if (!typeSymbol.isInterface() || (typeSymbol.flags() & 0x2000L) != 0L) {
                throw this.failure("not.a.functional.intf", typeSymbol);
            }
            ListBuffer<Symbol> listBuffer = new ListBuffer<Symbol>();
            for (Symbol object2 : compoundScope.getElements(new DescriptorFilter(typeSymbol))) {
                object = Types.this.memberType(typeSymbol.type, object2);
                if (listBuffer.isEmpty() || object2.name == ((Symbol)listBuffer.first()).name && Types.this.overrideEquivalent((Type)object, Types.this.memberType(typeSymbol.type, (Symbol)listBuffer.first()))) {
                    listBuffer.append(object2);
                    continue;
                }
                throw this.failure("not.a.functional.intf.1", typeSymbol, Types.this.diags.fragment("incompatible.abstracts", Kinds.kindName(typeSymbol), typeSymbol));
            }
            if (listBuffer.isEmpty()) {
                throw this.failure("not.a.functional.intf.1", typeSymbol, Types.this.diags.fragment("no.abstracts", Kinds.kindName(typeSymbol), typeSymbol));
            }
            if (listBuffer.size() == 1) {
                return new FunctionDescriptor((Symbol)listBuffer.first());
            }
            FunctionDescriptor functionDescriptor = this.mergeDescriptors(typeSymbol, listBuffer.toList());
            if (functionDescriptor == null) {
                ListBuffer<JCDiagnostic> listBuffer2 = new ListBuffer<JCDiagnostic>();
                for (Symbol symbol : listBuffer) {
                    String string = symbol.type.getThrownTypes().nonEmpty() ? "descriptor.throws" : "descriptor";
                    listBuffer2.append(Types.this.diags.fragment(string, symbol.name, symbol.type.getParameterTypes(), symbol.type.getReturnType(), symbol.type.getThrownTypes()));
                }
                object = new JCDiagnostic.MultilineDiagnostic(Types.this.diags.fragment("incompatible.descs.in.functional.intf", Kinds.kindName(typeSymbol), typeSymbol), listBuffer2.toList());
                throw this.failure((JCDiagnostic)object);
            }
            return functionDescriptor;
        }

        /*
         * WARNING - void declaration
         */
        private FunctionDescriptor mergeDescriptors(Symbol.TypeSymbol typeSymbol, List<Symbol> list) {
            void var7_16;
            Type type;
            void var5_8;
            Object object;
            List<Symbol> list3 = List.nil();
            block0: for (Symbol object22 : list) {
                Type type2 = Types.this.memberType(typeSymbol.type, object22);
                for (Symbol symbol : list) {
                    object = Types.this.memberType(typeSymbol.type, symbol);
                    if (Types.this.isSubSignature(type2, (Type)object)) continue;
                    continue block0;
                }
                list3 = list3.prepend(object22);
            }
            if (list3.isEmpty()) {
                return null;
            }
            boolean bl = false;
            Object var5_7 = null;
            while (var5_8 == null) {
                block3: for (Symbol symbol : list3) {
                    Type type3 = Types.this.memberType(typeSymbol.type, symbol);
                    for (Symbol symbol2 : list) {
                        type = Types.this.memberType(typeSymbol.type, symbol2);
                        if (!(bl ? !Types.this.returnTypeSubstitutable(type3, type) : !this.isSubtypeInternal(type3.getReturnType(), type.getReturnType()))) continue;
                        continue block3;
                    }
                    Symbol symbol3 = symbol;
                }
                if (bl) break;
                bl = true;
            }
            if (var5_8 == null) {
                return null;
            }
            boolean bl2 = !var5_8.type.hasTag(TypeTag.FORALL);
            Object var7_15 = null;
            Type type4 = Types.this.memberType(typeSymbol.type, (Symbol)var5_8);
            for (Symbol symbol2 : list) {
                type = Types.this.memberType(typeSymbol.type, symbol2);
                List<Type> list2 = type.getThrownTypes();
                if (bl2) {
                    list2 = Types.this.erasure(list2);
                } else {
                    Type.ForAll forAll = (Type.ForAll)type4;
                    Type.ForAll forAll2 = (Type.ForAll)type;
                    list2 = Types.this.subst(list2, forAll2.tvars, forAll.tvars);
                }
                List<Type> list4 = var7_16 == null ? list2 : Types.this.chk.intersect(list2, (List<Type>)var7_16);
            }
            object = var7_16;
            return new FunctionDescriptor((Symbol)var5_8, (List)object){
                final /* synthetic */ List val$thrown1;
                {
                    this.val$thrown1 = list;
                    super(symbol);
                }

                @Override
                public Type getType(Type type) {
                    Type type2 = Types.this.memberType(type, this.getSymbol());
                    return Types.this.createMethodTypeWithThrown(type2, this.val$thrown1);
                }
            };
        }

        boolean isSubtypeInternal(Type type, Type type2) {
            return type.isPrimitive() && type2.isPrimitive() ? Types.this.isSameType(type2, type) : Types.this.isSubtype(type, type2);
        }

        FunctionDescriptorLookupError failure(String string, Object ... objectArray) {
            return this.failure(Types.this.diags.fragment(string, objectArray));
        }

        FunctionDescriptorLookupError failure(JCDiagnostic jCDiagnostic) {
            return Types.this.functionDescriptorLookupError.setMessage(jCDiagnostic);
        }

        class Entry {
            final FunctionDescriptor cachedDescRes;
            final int prevMark;

            public Entry(FunctionDescriptor functionDescriptor, int n) {
                this.cachedDescRes = functionDescriptor;
                this.prevMark = n;
            }

            boolean matches(int n) {
                return this.prevMark == n;
            }
        }

        class FunctionDescriptor {
            Symbol descSym;

            FunctionDescriptor(Symbol symbol) {
                this.descSym = symbol;
            }

            public Symbol getSymbol() {
                return this.descSym;
            }

            public Type getType(Type type) {
                if (!Types.this.chk.checkValidGenericType(type = Types.this.removeWildcards(type))) {
                    throw DescriptorCache.this.failure(Types.this.diags.fragment("no.suitable.functional.intf.inst", type));
                }
                return Types.this.memberType(type, this.descSym);
            }
        }
    }

    public static class FunctionDescriptorLookupError
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        JCDiagnostic diagnostic = null;

        FunctionDescriptorLookupError() {
        }

        FunctionDescriptorLookupError setMessage(JCDiagnostic jCDiagnostic) {
            this.diagnostic = jCDiagnostic;
            return this;
        }

        public JCDiagnostic getDiagnostic() {
            return this.diagnostic;
        }
    }
}

