/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LambdaToMethod
extends TreeTranslator {
    private Attr attr;
    private JCDiagnostic.Factory diags;
    private Log log;
    private Lower lower;
    private Names names;
    private Symtab syms;
    private Resolve rs;
    private TreeMaker make;
    private Types types;
    private TransTypes transTypes;
    private Env<AttrContext> attrEnv;
    private LambdaAnalyzerPreprocessor analyzer;
    private Map<JCTree, LambdaAnalyzerPreprocessor.TranslationContext<?>> contextMap;
    private LambdaAnalyzerPreprocessor.TranslationContext<?> context;
    private KlassInfo kInfo;
    private boolean dumpLambdaToMethodStats;
    public static final int FLAG_SERIALIZABLE = 1;
    public static final int FLAG_MARKERS = 2;
    public static final int FLAG_BRIDGES = 4;
    protected static final Context.Key<LambdaToMethod> unlambdaKey = new Context.Key();

    public static LambdaToMethod instance(Context context) {
        LambdaToMethod lambdaToMethod = context.get(unlambdaKey);
        if (lambdaToMethod == null) {
            lambdaToMethod = new LambdaToMethod(context);
        }
        return lambdaToMethod;
    }

    private LambdaToMethod(Context context) {
        context.put(unlambdaKey, this);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.lower = Lower.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.rs = Resolve.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.analyzer = new LambdaAnalyzerPreprocessor();
        Options options = Options.instance(context);
        this.dumpLambdaToMethodStats = options.isSet("dumpLambdaToMethodStats");
        this.attr = Attr.instance(context);
    }

    @Override
    public <T extends JCTree> T translate(T t) {
        LambdaAnalyzerPreprocessor.TranslationContext<?> translationContext = this.contextMap.get(t);
        return this.translate(t, translationContext != null ? translationContext : this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends JCTree> T translate(T t, LambdaAnalyzerPreprocessor.TranslationContext<?> translationContext) {
        LambdaAnalyzerPreprocessor.TranslationContext<?> translationContext2 = this.context;
        try {
            this.context = translationContext;
            T t2 = super.translate(t);
            return t2;
        }
        finally {
            this.context = translationContext2;
        }
    }

    <T extends JCTree> List<T> translate(List<T> list, LambdaAnalyzerPreprocessor.TranslationContext<?> translationContext) {
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        for (JCTree jCTree : list) {
            listBuffer.append(this.translate(jCTree, translationContext));
        }
        return listBuffer.toList();
    }

    public JCTree translateTopLevelClass(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
        this.make = treeMaker;
        this.attrEnv = env;
        this.context = null;
        this.contextMap = new HashMap();
        return this.translate(jCTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        if (jCClassDecl.sym.owner.kind == 1) {
            jCClassDecl = this.analyzer.analyzeAndPreprocessClass(jCClassDecl);
        }
        KlassInfo klassInfo = this.kInfo;
        try {
            this.kInfo = new KlassInfo(jCClassDecl);
            super.visitClassDef(jCClassDecl);
            if (!this.kInfo.deserializeCases.isEmpty()) {
                int n = this.make.pos;
                try {
                    this.make.at(jCClassDecl);
                    this.kInfo.addMethod(this.makeDeserializeMethod(jCClassDecl.sym));
                }
                finally {
                    this.make.at(n);
                }
            }
            List list = this.kInfo.appendedMethodList.toList();
            jCClassDecl.defs = jCClassDecl.defs.appendList(list);
            for (JCTree jCTree : list) {
                jCClassDecl.sym.members().enter(((JCTree.JCMethodDecl)jCTree).sym);
            }
            this.result = jCClassDecl;
        }
        finally {
            this.kInfo = klassInfo;
        }
    }

    @Override
    public void visitLambda(JCTree.JCLambda jCLambda) {
        LambdaAnalyzerPreprocessor.LambdaTranslationContext lambdaTranslationContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)lambdaTranslationContext.translatedSym;
        Type.MethodType methodType = (Type.MethodType)methodSymbol.type;
        Object object = lambdaTranslationContext.owner;
        ListBuffer<Object> listBuffer = new ListBuffer<Object>();
        List<JCTree.JCExpression> list = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound typeCompound : ((Symbol)object).getRawTypeAttributes()) {
            if (typeCompound.position.onLambda == jCLambda) {
                ((ListBuffer)((Object)list)).append((JCTree.JCExpression)((Object)typeCompound));
                continue;
            }
            listBuffer.append(typeCompound);
        }
        if (((ListBuffer)((Object)list)).nonEmpty()) {
            ((Symbol)object).setTypeAttributes(listBuffer.toList());
            methodSymbol.setTypeAttributes(((ListBuffer)((Object)list)).toList());
        }
        object = this.make.MethodDef(this.make.Modifiers(methodSymbol.flags_field), methodSymbol.name, this.make.QualIdent(methodType.getReturnType().tsym), List.nil(), lambdaTranslationContext.syntheticParams, methodType.getThrownTypes() == null ? List.nil() : this.make.Types((List<Type>)methodType.getThrownTypes()), null, null);
        ((JCTree.JCMethodDecl)object).sym = methodSymbol;
        ((JCTree.JCMethodDecl)object).type = methodType;
        ((JCTree.JCMethodDecl)object).body = this.translate(this.makeLambdaBody(jCLambda, (JCTree.JCMethodDecl)object));
        this.kInfo.addMethod((JCTree)object);
        listBuffer = new ListBuffer();
        if (!methodSymbol.isStatic()) {
            listBuffer.append(this.makeThis((Type)methodSymbol.owner.enclClass().asType(), lambdaTranslationContext.owner.enclClass()));
        }
        for (Symbol symbol : lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.CAPTURED_VAR).keySet()) {
            if (symbol == lambdaTranslationContext.self) continue;
            JCTree.JCExpression jCExpression = this.make.Ident(symbol).setType(symbol.type);
            listBuffer.append(jCExpression);
        }
        list = this.translate(listBuffer.toList(), lambdaTranslationContext.prev);
        int n = this.referenceKind(methodSymbol);
        this.result = this.makeMetafactoryIndyCall(this.context, n, methodSymbol, list);
    }

    private JCTree.JCIdent makeThis(Type type, Symbol symbol) {
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0x200001010L, this.names._this, type, symbol);
        return this.make.Ident(varSymbol);
    }

    @Override
    public void visitReference(JCTree.JCMemberReference jCMemberReference) {
        JCTree.JCExpression jCExpression;
        Symbol symbol;
        LambdaAnalyzerPreprocessor.ReferenceTranslationContext referenceTranslationContext = (LambdaAnalyzerPreprocessor.ReferenceTranslationContext)this.context;
        Symbol symbol2 = referenceTranslationContext.needsBridge() ? referenceTranslationContext.bridgeSym : (symbol = referenceTranslationContext.isSignaturePolymorphic() ? referenceTranslationContext.sigPolySym : jCMemberReference.sym);
        if (referenceTranslationContext.needsBridge()) {
            this.bridgeMemberReference(jCMemberReference, referenceTranslationContext);
        }
        switch (jCMemberReference.kind) {
            case IMPLICIT_INNER: 
            case SUPER: {
                jCExpression = this.makeThis((Type)referenceTranslationContext.owner.enclClass().asType(), referenceTranslationContext.owner.enclClass());
                break;
            }
            case BOUND: {
                jCExpression = jCMemberReference.getQualifierExpression();
                jCExpression = this.attr.makeNullCheck(jCExpression);
                break;
            }
            case UNBOUND: 
            case STATIC: 
            case TOPLEVEL: 
            case ARRAY_CTOR: {
                jCExpression = null;
                break;
            }
            default: {
                throw new InternalError("Should not have an invalid kind");
            }
        }
        List<JCTree.JCExpression> list = jCExpression == null ? List.nil() : this.translate(List.of(jCExpression), referenceTranslationContext.prev);
        this.result = this.makeMetafactoryIndyCall(referenceTranslationContext, referenceTranslationContext.referenceKind(), symbol, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        if (this.context == null || !this.analyzer.lambdaIdentSymbolFilter(jCIdent.sym)) {
            super.visitIdent(jCIdent);
        } else {
            int n = this.make.pos;
            try {
                this.make.at(jCIdent);
                LambdaAnalyzerPreprocessor.LambdaTranslationContext lambdaTranslationContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
                JCTree jCTree = lambdaTranslationContext.translate(jCIdent);
                if (jCTree != null) {
                    this.result = jCTree;
                } else {
                    super.visitIdent(jCIdent);
                }
            }
            finally {
                this.make.at(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        LambdaAnalyzerPreprocessor.LambdaTranslationContext lambdaTranslationContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
        if (this.context != null && lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.LOCAL_VAR).containsKey(jCVariableDecl.sym)) {
            JCTree.JCExpression jCExpression = this.translate(jCVariableDecl.init);
            int n = this.make.pos;
            try {
                this.result = this.make.at(jCVariableDecl).VarDef((Symbol.VarSymbol)lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.LOCAL_VAR).get(jCVariableDecl.sym), jCExpression);
            }
            finally {
                this.make.at(n);
            }
        }
        if (this.context != null && lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.TYPE_VAR).containsKey(jCVariableDecl.sym)) {
            JCTree.JCExpression jCExpression = this.translate(jCVariableDecl.init);
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)lambdaTranslationContext.getSymbolMap(LambdaSymbolKind.TYPE_VAR).get(jCVariableDecl.sym);
            int n = this.make.pos;
            try {
                this.result = this.make.at(jCVariableDecl).VarDef(varSymbol, jCExpression);
            }
            finally {
                this.make.at(n);
            }
            Scope scope = jCVariableDecl.sym.owner.members();
            if (scope != null) {
                scope.remove(jCVariableDecl.sym);
                scope.enter(varSymbol);
            }
        } else {
            super.visitVarDef(jCVariableDecl);
        }
    }

    private JCTree.JCBlock makeLambdaBody(JCTree.JCLambda jCLambda, JCTree.JCMethodDecl jCMethodDecl) {
        return jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION ? this.makeLambdaExpressionBody((JCTree.JCExpression)jCLambda.body, jCMethodDecl) : this.makeLambdaStatementBody((JCTree.JCBlock)jCLambda.body, jCMethodDecl, jCLambda.canCompleteNormally);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCBlock makeLambdaExpressionBody(JCTree.JCExpression jCExpression, JCTree.JCMethodDecl jCMethodDecl) {
        Type type = jCMethodDecl.type.getReturnType();
        boolean bl = jCExpression.type.hasTag(TypeTag.VOID);
        boolean bl2 = type.hasTag(TypeTag.VOID);
        boolean bl3 = this.types.isSameType(type, this.types.boxedClass((Type)this.syms.voidType).type);
        int n = this.make.pos;
        try {
            if (bl2) {
                JCTree.JCExpressionStatement jCExpressionStatement = this.make.at(jCExpression).Exec(jCExpression);
                JCTree.JCBlock jCBlock = this.make.Block(0L, List.of(jCExpressionStatement));
                return jCBlock;
            }
            if (bl && bl3) {
                ListBuffer<JCTree.JCStatement> listBuffer = new ListBuffer<JCTree.JCStatement>();
                listBuffer.append(this.make.at(jCExpression).Exec(jCExpression));
                listBuffer.append(this.make.Return(this.make.Literal(TypeTag.BOT, null).setType(this.syms.botType)));
                JCTree.JCBlock jCBlock = this.make.Block(0L, listBuffer.toList());
                return jCBlock;
            }
            JCTree.JCExpression jCExpression2 = this.transTypes.coerce(this.attrEnv, jCExpression, type);
            JCTree.JCBlock jCBlock = this.make.at(jCExpression2).Block(0L, List.of(this.make.Return(jCExpression2)));
            return jCBlock;
        }
        finally {
            this.make.at(n);
        }
    }

    private JCTree.JCBlock makeLambdaStatementBody(JCTree.JCBlock jCBlock, final JCTree.JCMethodDecl jCMethodDecl, boolean bl) {
        final Type type = jCMethodDecl.type.getReturnType();
        final boolean bl2 = type.hasTag(TypeTag.VOID);
        boolean bl3 = this.types.isSameType(type, this.types.boxedClass((Type)this.syms.voidType).type);
        class LambdaBodyTranslator
        extends TreeTranslator {
            LambdaBodyTranslator() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
                this.result = jCClassDecl;
            }

            @Override
            public void visitLambda(JCTree.JCLambda jCLambda) {
                this.result = jCLambda;
            }

            @Override
            public void visitReturn(JCTree.JCReturn jCReturn) {
                boolean bl;
                boolean bl22 = bl = jCReturn.expr == null;
                if (bl2 && !bl) {
                    Symbol.VarSymbol varSymbol = LambdaToMethod.this.makeSyntheticVar(0L, LambdaToMethod.this.names.fromString("$loc"), jCReturn.expr.type, jCMethodDecl.sym);
                    JCTree.JCVariableDecl jCVariableDecl = LambdaToMethod.this.make.VarDef(varSymbol, jCReturn.expr);
                    this.result = LambdaToMethod.this.make.Block(0L, List.of(jCVariableDecl, LambdaToMethod.this.make.Return(null)));
                } else if (!bl2 || !bl) {
                    jCReturn.expr = LambdaToMethod.this.transTypes.coerce(LambdaToMethod.this.attrEnv, jCReturn.expr, type);
                    this.result = jCReturn;
                } else {
                    this.result = jCReturn;
                }
            }
        }
        JCTree.JCBlock jCBlock2 = new LambdaBodyTranslator().translate(jCBlock);
        if (bl && bl3) {
            jCBlock2.stats = jCBlock2.stats.append(this.make.Return(this.make.Literal(TypeTag.BOT, null).setType(this.syms.botType)));
        }
        return jCBlock2;
    }

    private JCTree.JCMethodDecl makeDeserializeMethod(Symbol symbol) {
        JCTree jCTree2;
        ListBuffer<JCTree.JCCase> listBuffer = new ListBuffer<JCTree.JCCase>();
        ListBuffer<JCTree.JCBreak> listBuffer2 = new ListBuffer<JCTree.JCBreak>();
        for (Map.Entry object2 : this.kInfo.deserializeCases.entrySet()) {
            jCTree2 = this.make.Break(null);
            listBuffer2.add((JCTree.JCBreak)jCTree2);
            List<JCTree.JCStatement> list = ((ListBuffer)object2.getValue()).append(jCTree2).toList();
            listBuffer.add(this.make.Case(this.make.Literal(object2.getKey()), list));
        }
        JCTree.JCSwitch jCSwitch = this.make.Switch(this.deserGetter("getImplMethodName", this.syms.stringType), listBuffer.toList());
        for (JCTree jCTree2 : listBuffer2) {
            jCTree2.target = jCSwitch;
        }
        JCTree.JCBlock jCBlock = this.make.Block(0L, List.of(jCSwitch, this.make.Throw(this.makeNewClass(this.syms.illegalArgumentExceptionType, List.of(this.make.Literal("Invalid lambda deserialization"))))));
        jCTree2 = this.make.MethodDef(this.make.Modifiers(this.kInfo.deserMethodSym.flags()), this.names.deserializeLambda, this.make.QualIdent(((KlassInfo)this.kInfo).deserMethodSym.getReturnType().tsym), List.nil(), List.of(this.make.VarDef(this.kInfo.deserParamSym, null)), List.nil(), jCBlock, null);
        ((JCTree.JCMethodDecl)jCTree2).sym = this.kInfo.deserMethodSym;
        ((JCTree.JCMethodDecl)jCTree2).type = ((KlassInfo)this.kInfo).deserMethodSym.type;
        return jCTree2;
    }

    JCTree.JCNewClass makeNewClass(Type type, List<JCTree.JCExpression> list, Symbol symbol) {
        JCTree.JCNewClass jCNewClass = this.make.NewClass(null, null, this.make.QualIdent(type.tsym), list, null);
        jCNewClass.constructor = symbol;
        jCNewClass.type = type;
        return jCNewClass;
    }

    JCTree.JCNewClass makeNewClass(Type type, List<JCTree.JCExpression> list) {
        return this.makeNewClass(type, list, this.rs.resolveConstructor(null, this.attrEnv, type, TreeInfo.types(list), List.nil()));
    }

    private void addDeserializationCase(int n, Symbol symbol, Type type, Symbol.MethodSymbol methodSymbol, JCDiagnostic.DiagnosticPosition diagnosticPosition, List<Object> list, Type.MethodType methodType) {
        ListBuffer listBuffer3;
        String string = this.classSig(type);
        String string2 = ((Name)methodSymbol.getSimpleName()).toString();
        String string3 = this.typeSig(this.types.erasure(methodSymbol.type));
        String string4 = this.classSig(this.types.erasure(symbol.owner.type));
        String string5 = symbol.getQualifiedName().toString();
        String string6 = this.typeSig(this.types.erasure(symbol.type));
        JCTree.JCExpression jCExpression = this.eqTest(this.syms.intType, this.deserGetter("getImplMethodKind", this.syms.intType), this.make.Literal(n));
        ListBuffer<JCTree.JCTypeCast> listBuffer2 = new ListBuffer<JCTree.JCTypeCast>();
        int n2 = 0;
        for (ListBuffer listBuffer3 : methodType.getParameterTypes()) {
            List<JCTree.JCExpression> list2 = new ListBuffer<JCTree.JCLiteral>().append(this.make.Literal(n2)).toList();
            List<Type> list3 = new ListBuffer<Type.JCPrimitiveType>().append(this.syms.intType).toList();
            listBuffer2.add(this.make.TypeCast(this.types.erasure((Type)((Object)listBuffer3)), this.deserGetter("getCapturedArg", this.syms.objectType, list3, list2)));
            ++n2;
        }
        JCTree.JCIf jCIf = this.make.If(this.deserTest(this.deserTest(this.deserTest(this.deserTest(this.deserTest(jCExpression, "getFunctionalInterfaceClass", string), "getFunctionalInterfaceMethodName", string2), "getFunctionalInterfaceMethodSignature", string3), "getImplClass", string4), "getImplMethodSignature", string6), this.make.Return(this.makeIndyCall(diagnosticPosition, this.syms.lambdaMetafactory, this.names.altMetafactory, list, methodType, listBuffer2.toList(), methodSymbol.name)), null);
        listBuffer3 = (ListBuffer)this.kInfo.deserializeCases.get(string5);
        if (listBuffer3 == null) {
            listBuffer3 = new ListBuffer();
            this.kInfo.deserializeCases.put(string5, listBuffer3);
        }
        listBuffer3.append(jCIf);
    }

    private JCTree.JCExpression eqTest(Type type, JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        JCTree.JCBinary jCBinary = this.make.Binary(JCTree.Tag.EQ, jCExpression, jCExpression2);
        jCBinary.operator = this.rs.resolveBinaryOperator(null, JCTree.Tag.EQ, this.attrEnv, type, type);
        jCBinary.setType(this.syms.booleanType);
        return jCBinary;
    }

    private JCTree.JCExpression deserTest(JCTree.JCExpression jCExpression, String string, String string2) {
        Type.MethodType methodType = new Type.MethodType(List.of(this.syms.objectType), this.syms.booleanType, List.nil(), this.syms.methodClass);
        Symbol symbol = this.rs.resolveQualifiedMethod(null, this.attrEnv, this.syms.objectType, this.names.equals, List.of(this.syms.objectType), List.nil());
        JCTree.JCMethodInvocation jCMethodInvocation = this.make.Apply(List.nil(), this.make.Select(this.deserGetter(string, this.syms.stringType), symbol).setType(methodType), List.of(this.make.Literal(string2)));
        jCMethodInvocation.setType(this.syms.booleanType);
        JCTree.JCBinary jCBinary = this.make.Binary(JCTree.Tag.AND, jCExpression, jCMethodInvocation);
        jCBinary.operator = this.rs.resolveBinaryOperator(null, JCTree.Tag.AND, this.attrEnv, this.syms.booleanType, this.syms.booleanType);
        jCBinary.setType(this.syms.booleanType);
        return jCBinary;
    }

    private JCTree.JCExpression deserGetter(String string, Type type) {
        return this.deserGetter(string, type, List.nil(), List.nil());
    }

    private JCTree.JCExpression deserGetter(String string, Type type, List<Type> list, List<JCTree.JCExpression> list2) {
        Type.MethodType methodType = new Type.MethodType(list, type, List.nil(), this.syms.methodClass);
        Symbol symbol = this.rs.resolveQualifiedMethod(null, this.attrEnv, this.syms.serializedLambdaType, this.names.fromString(string), list, List.nil());
        return this.make.Apply(List.nil(), this.make.Select(this.make.Ident(this.kInfo.deserParamSym).setType(this.syms.serializedLambdaType), symbol).setType(methodType), list2).setType(type);
    }

    private Symbol.MethodSymbol makePrivateSyntheticMethod(long l, Name name, Type type, Symbol symbol) {
        return new Symbol.MethodSymbol(l | 0x1000L | 2L, name, type, symbol);
    }

    private Symbol.VarSymbol makeSyntheticVar(long l, String string, Type type, Symbol symbol) {
        return this.makeSyntheticVar(l, this.names.fromString(string), type, symbol);
    }

    private Symbol.VarSymbol makeSyntheticVar(long l, Name name, Type type, Symbol symbol) {
        return new Symbol.VarSymbol(l | 0x1000L, name, type, symbol);
    }

    private void setVarargsIfNeeded(JCTree jCTree, Type type) {
        if (type != null) {
            switch (jCTree.getTag()) {
                case APPLY: {
                    ((JCTree.JCMethodInvocation)jCTree).varargsElement = type;
                    break;
                }
                case NEWCLASS: {
                    ((JCTree.JCNewClass)jCTree).varargsElement = type;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private List<JCTree.JCExpression> convertArgs(Symbol symbol, List<JCTree.JCExpression> list, Type type) {
        Assert.check(symbol.kind == 16);
        List<Type> list2 = this.types.erasure(symbol.type).getParameterTypes();
        if (type != null) {
            Assert.check((symbol.flags() & 0x400000000L) != 0L);
        }
        return this.transTypes.translateArgs(list, list2, type, this.attrEnv);
    }

    private void bridgeMemberReference(JCTree.JCMemberReference jCMemberReference, LambdaAnalyzerPreprocessor.ReferenceTranslationContext referenceTranslationContext) {
        this.kInfo.addMethod(new MemberReferenceBridger(jCMemberReference, referenceTranslationContext).bridge());
    }

    private Type.MethodType typeToMethodType(Type type) {
        Type type2 = this.types.erasure(type);
        return new Type.MethodType(type2.getParameterTypes(), type2.getReturnType(), type2.getThrownTypes(), this.syms.methodClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression makeMetafactoryIndyCall(LambdaAnalyzerPreprocessor.TranslationContext<?> translationContext, int n, Symbol symbol, List<JCTree.JCExpression> list) {
        Name name;
        Object t = translationContext.tree;
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)this.types.findDescriptorSymbol(((JCTree.JCFunctionalExpression)t).type.tsym);
        List<Object> list2 = List.of(this.typeToMethodType(methodSymbol.type), new Pool.MethodHandle(n, symbol, this.types), this.typeToMethodType(((JCTree.JCFunctionalExpression)t).getDescriptorType(this.types)));
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (JCTree.JCExpression object2 : list) {
            listBuffer.append(object2.type);
        }
        Type.MethodType methodType = new Type.MethodType(listBuffer.toList(), ((JCTree.JCFunctionalExpression)t).type, List.nil(), this.syms.methodClass);
        Name name2 = name = translationContext.needsAltMetafactory() ? this.names.altMetafactory : this.names.metafactory;
        if (translationContext.needsAltMetafactory()) {
            ListBuffer<Symbol.TypeSymbol> listBuffer2 = new ListBuffer<Symbol.TypeSymbol>();
            for (Type bl : ((JCTree.JCFunctionalExpression)t).targets.tail) {
                if (bl.tsym == this.syms.serializableType.tsym) continue;
                listBuffer2.append(bl.tsym);
            }
            int n2 = translationContext.isSerializable() ? 1 : 0;
            boolean bl = listBuffer2.nonEmpty();
            boolean bl2 = translationContext.bridges.nonEmpty();
            if (bl) {
                n2 |= 2;
            }
            if (bl2) {
                n2 |= 4;
            }
            list2 = list2.append(n2);
            if (bl) {
                list2 = list2.append(listBuffer2.length());
                list2 = list2.appendList(listBuffer2.toList());
            }
            if (bl2) {
                list2 = list2.append(translationContext.bridges.length() - 1);
                for (Symbol symbol2 : translationContext.bridges) {
                    Type type = symbol2.erasure(this.types);
                    if (this.types.isSameType(type, methodSymbol.erasure(this.types))) continue;
                    list2 = list2.append(symbol2.erasure(this.types));
                }
            }
            if (translationContext.isSerializable()) {
                int n3 = this.make.pos;
                try {
                    this.make.at(this.kInfo.clazz);
                    this.addDeserializationCase(n, symbol, ((JCTree.JCFunctionalExpression)t).type, methodSymbol, (JCDiagnostic.DiagnosticPosition)t, list2, methodType);
                }
                finally {
                    this.make.at(n3);
                }
            }
        }
        return this.makeIndyCall((JCDiagnostic.DiagnosticPosition)t, this.syms.lambdaMetafactory, name, list2, methodType, list, methodSymbol.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression makeIndyCall(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Name name, List<Object> list, Type.MethodType methodType, List<JCTree.JCExpression> list2, Name name2) {
        int n = this.make.pos;
        try {
            this.make.at(diagnosticPosition);
            List<Type> list3 = List.of(this.syms.methodHandleLookupType, this.syms.stringType, this.syms.methodTypeType).appendList(this.bsmStaticArgToTypes(list));
            Symbol.MethodSymbol methodSymbol = this.rs.resolveInternalMethod(diagnosticPosition, this.attrEnv, type, name, list3, List.nil());
            Symbol.DynamicMethodSymbol dynamicMethodSymbol = new Symbol.DynamicMethodSymbol(name2, this.syms.noSymbol, methodSymbol.isStatic() ? 6 : 5, methodSymbol, methodType, list.toArray());
            JCTree.JCFieldAccess jCFieldAccess = this.make.Select(this.make.QualIdent(type.tsym), name);
            jCFieldAccess.sym = dynamicMethodSymbol;
            jCFieldAccess.type = methodType.getReturnType();
            JCTree.JCMethodInvocation jCMethodInvocation = this.make.Apply(List.nil(), jCFieldAccess, list2);
            jCMethodInvocation.type = methodType.getReturnType();
            JCTree.JCMethodInvocation jCMethodInvocation2 = jCMethodInvocation;
            return jCMethodInvocation2;
        }
        finally {
            this.make.at(n);
        }
    }

    private List<Type> bsmStaticArgToTypes(List<Object> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Object object : list) {
            listBuffer.append(this.bsmStaticArgToType(object));
        }
        return listBuffer.toList();
    }

    private Type bsmStaticArgToType(Object object) {
        Assert.checkNonNull(object);
        if (object instanceof Symbol.ClassSymbol) {
            return this.syms.classType;
        }
        if (object instanceof Integer) {
            return this.syms.intType;
        }
        if (object instanceof Long) {
            return this.syms.longType;
        }
        if (object instanceof Float) {
            return this.syms.floatType;
        }
        if (object instanceof Double) {
            return this.syms.doubleType;
        }
        if (object instanceof String) {
            return this.syms.stringType;
        }
        if (object instanceof Pool.MethodHandle) {
            return this.syms.methodHandleType;
        }
        if (object instanceof Type.MethodType) {
            return this.syms.methodTypeType;
        }
        String string = String.valueOf(String.valueOf(object.getClass()));
        Assert.error(new StringBuilder(15 + string.length()).append("bad static arg ").append(string).toString());
        return null;
    }

    private int referenceKind(Symbol symbol) {
        if (symbol.isConstructor()) {
            return 8;
        }
        if (symbol.isStatic()) {
            return 6;
        }
        if ((symbol.flags() & 2L) != 0L) {
            return 7;
        }
        if (symbol.enclClass().isInterface()) {
            return 9;
        }
        return 5;
    }

    private String typeSig(Type type) {
        L2MSignatureGenerator l2MSignatureGenerator = new L2MSignatureGenerator();
        l2MSignatureGenerator.assembleSig(type);
        return l2MSignatureGenerator.toString();
    }

    private String classSig(Type type) {
        L2MSignatureGenerator l2MSignatureGenerator = new L2MSignatureGenerator();
        l2MSignatureGenerator.assembleClassSig(type);
        return l2MSignatureGenerator.toString();
    }

    private class L2MSignatureGenerator
    extends Types.SignatureGenerator {
        StringBuilder sb;

        L2MSignatureGenerator() {
            super(LambdaToMethod.this.types);
            this.sb = new StringBuilder();
        }

        @Override
        protected void append(char c) {
            this.sb.append(c);
        }

        @Override
        protected void append(byte[] byArray) {
            this.sb.append(new String(byArray));
        }

        @Override
        protected void append(Name name) {
            this.sb.append(name.toString());
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    static enum LambdaSymbolKind {
        PARAM,
        LOCAL_VAR,
        CAPTURED_VAR,
        CAPTURED_THIS,
        TYPE_VAR;

    }

    class LambdaAnalyzerPreprocessor
    extends TreeTranslator {
        private List<Frame> frameStack;
        private int lambdaCount = 0;
        private SyntheticMethodNameCounter syntheticMethodNameCounts = new SyntheticMethodNameCounter();
        private Map<Symbol, JCTree.JCClassDecl> localClassDefs;
        private Map<Symbol.ClassSymbol, Symbol> clinits = new HashMap<Symbol.ClassSymbol, Symbol>();

        LambdaAnalyzerPreprocessor() {
        }

        private JCTree.JCClassDecl analyzeAndPreprocessClass(JCTree.JCClassDecl jCClassDecl) {
            this.frameStack = List.nil();
            this.localClassDefs = new HashMap<Symbol, JCTree.JCClassDecl>();
            return this.translate(jCClassDecl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            List<Frame> list = this.frameStack;
            try {
                if (this.frameStack.nonEmpty() && ((Frame)this.frameStack.head).tree.hasTag(JCTree.Tag.CLASSDEF)) {
                    this.frameStack = this.frameStack.prepend(new Frame(jCBlock));
                }
                super.visitBlock(jCBlock);
            }
            finally {
                this.frameStack = list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            List<Frame> list = this.frameStack;
            SyntheticMethodNameCounter syntheticMethodNameCounter = this.syntheticMethodNameCounts;
            Map<Symbol.ClassSymbol, Symbol> map = this.clinits;
            DiagnosticSource diagnosticSource = LambdaToMethod.this.log.currentSource();
            try {
                LambdaToMethod.this.log.useSource(jCClassDecl.sym.sourcefile);
                this.syntheticMethodNameCounts = new SyntheticMethodNameCounter();
                map = new HashMap<Symbol.ClassSymbol, Symbol>();
                if (jCClassDecl.sym.owner.kind == 16) {
                    this.localClassDefs.put(jCClassDecl.sym, jCClassDecl);
                }
                if (this.directlyEnclosingLambda() != null) {
                    jCClassDecl.sym.owner = this.owner();
                    if (jCClassDecl.sym.hasOuterInstance()) {
                        TranslationContext<?> translationContext = this.context();
                        while (translationContext != null) {
                            if (((JCTree)translationContext.tree).getTag() == JCTree.Tag.LAMBDA) {
                                ((LambdaTranslationContext)translationContext).addSymbol(jCClassDecl.sym.type.getEnclosingType().tsym, LambdaSymbolKind.CAPTURED_THIS);
                            }
                            translationContext = translationContext.prev;
                        }
                    }
                }
                this.frameStack = this.frameStack.prepend(new Frame(jCClassDecl));
                super.visitClassDef(jCClassDecl);
            }
            finally {
                LambdaToMethod.this.log.useSource(diagnosticSource.getFile());
                this.frameStack = list;
                this.syntheticMethodNameCounts = syntheticMethodNameCounter;
                this.clinits = map;
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            if (this.context() != null && this.lambdaIdentSymbolFilter(jCIdent.sym)) {
                if (jCIdent.sym.kind == 4 && jCIdent.sym.owner.kind == 16 && jCIdent.type.constValue() == null) {
                    TranslationContext<?> translationContext = this.context();
                    while (translationContext != null) {
                        if (((JCTree)translationContext.tree).getTag() == JCTree.Tag.LAMBDA) {
                            JCTree jCTree = this.capturedDecl(translationContext.depth, jCIdent.sym);
                            if (jCTree == null) break;
                            ((LambdaTranslationContext)translationContext).addSymbol(jCIdent.sym, LambdaSymbolKind.CAPTURED_VAR);
                        }
                        translationContext = translationContext.prev;
                    }
                } else if (jCIdent.sym.owner.kind == 2) {
                    TranslationContext<?> translationContext = this.context();
                    while (translationContext != null) {
                        if (((JCTree)translationContext.tree).hasTag(JCTree.Tag.LAMBDA)) {
                            JCTree jCTree = this.capturedDecl(translationContext.depth, jCIdent.sym);
                            if (jCTree == null) break;
                            switch (jCTree.getTag()) {
                                case CLASSDEF: {
                                    JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree;
                                    ((LambdaTranslationContext)translationContext).addSymbol(jCClassDecl.sym, LambdaSymbolKind.CAPTURED_THIS);
                                    break;
                                }
                                default: {
                                    Assert.error("bad block kind");
                                }
                            }
                        }
                        translationContext = translationContext.prev;
                    }
                }
            }
            super.visitIdent(jCIdent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            List<Frame> list = this.frameStack;
            try {
                LambdaTranslationContext lambdaTranslationContext = (LambdaTranslationContext)this.makeLambdaContext(jCLambda);
                this.frameStack = this.frameStack.prepend(new Frame(jCLambda));
                for (JCTree.JCVariableDecl jCVariableDecl : jCLambda.params) {
                    lambdaTranslationContext.addSymbol(jCVariableDecl.sym, LambdaSymbolKind.PARAM);
                    ((Frame)this.frameStack.head).addLocal(jCVariableDecl.sym);
                }
                LambdaToMethod.this.contextMap.put(jCLambda, lambdaTranslationContext);
                super.visitLambda(jCLambda);
                lambdaTranslationContext.complete();
            }
            finally {
                this.frameStack = list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            List<Frame> list = this.frameStack;
            try {
                this.frameStack = this.frameStack.prepend(new Frame(jCMethodDecl));
                super.visitMethodDef(jCMethodDecl);
            }
            finally {
                this.frameStack = list;
            }
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            LambdaTranslationContext lambdaTranslationContext;
            if (this.lambdaNewClassFilter(this.context(), jCNewClass)) {
                lambdaTranslationContext = this.context();
                while (lambdaTranslationContext != null) {
                    if (((JCTree)lambdaTranslationContext.tree).getTag() == JCTree.Tag.LAMBDA) {
                        ((LambdaTranslationContext)lambdaTranslationContext).addSymbol(jCNewClass.type.getEnclosingType().tsym, LambdaSymbolKind.CAPTURED_THIS);
                    }
                    lambdaTranslationContext = lambdaTranslationContext.prev;
                }
            }
            if (this.context() != null && jCNewClass.type.tsym.owner.kind == 16) {
                lambdaTranslationContext = (LambdaTranslationContext)this.context();
                this.captureLocalClassDefs(jCNewClass.type.tsym, lambdaTranslationContext);
            }
            super.visitNewClass(jCNewClass);
        }

        void captureLocalClassDefs(Symbol symbol, final LambdaTranslationContext lambdaTranslationContext) {
            JCTree.JCClassDecl jCClassDecl = this.localClassDefs.get(symbol);
            if (jCClassDecl != null && jCClassDecl.pos < ((JCTree.JCLambda)lambdaTranslationContext.tree).pos) {
                Lower lower = LambdaToMethod.this.lower;
                lower.getClass();
                Lower.BasicFreeVarCollector basicFreeVarCollector = new Lower.BasicFreeVarCollector(lower){

                    @Override
                    void addFreeVars(Symbol.ClassSymbol classSymbol) {
                        LambdaAnalyzerPreprocessor.this.captureLocalClassDefs(classSymbol, lambdaTranslationContext);
                    }

                    @Override
                    void visitSymbol(Symbol symbol) {
                        if (symbol.kind == 4 && symbol.owner.kind == 16 && ((Symbol.VarSymbol)symbol).getConstValue() == null) {
                            TranslationContext<?> translationContext = LambdaAnalyzerPreprocessor.this.context();
                            while (translationContext != null) {
                                if (((JCTree)translationContext.tree).getTag() == JCTree.Tag.LAMBDA) {
                                    JCTree jCTree = LambdaAnalyzerPreprocessor.this.capturedDecl(translationContext.depth, symbol);
                                    if (jCTree == null) break;
                                    ((LambdaTranslationContext)translationContext).addSymbol(symbol, LambdaSymbolKind.CAPTURED_VAR);
                                }
                                translationContext = translationContext.prev;
                            }
                        }
                    }
                };
                basicFreeVarCollector.scan(jCClassDecl);
            }
        }

        @Override
        public void visitReference(JCTree.JCMemberReference jCMemberReference) {
            if (jCMemberReference.getMode() == MemberReferenceTree.ReferenceMode.NEW && jCMemberReference.kind != JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR && jCMemberReference.sym.owner.isLocal()) {
                JCTree jCTree;
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)jCMemberReference.sym;
                List<JCTree.JCVariableDecl> list = ((Type.MethodType)methodSymbol.type).getParameterTypes();
                Type type = methodSymbol.owner.type;
                Symbol symbol = this.owner();
                ListBuffer<JCTree.JCNewClass> listBuffer = new ListBuffer<JCTree.JCNewClass>();
                int n = 0;
                List<JCTree.JCVariableDecl> list2 = list;
                while (list2.nonEmpty()) {
                    jCTree = LambdaToMethod.this.make.Param(LambdaToMethod.this.make.paramName(n++), (Type)list2.head, symbol);
                    ((JCTree.JCVariableDecl)jCTree).sym.pos = jCMemberReference.pos;
                    listBuffer.append((JCTree.JCNewClass)jCTree);
                    list2 = list2.tail;
                }
                list2 = listBuffer.toList();
                jCTree = LambdaToMethod.this.makeNewClass(type, LambdaToMethod.this.make.Idents(list2));
                jCTree.pos = jCMemberReference.pos;
                JCTree.JCLambda jCLambda = LambdaToMethod.this.make.Lambda(list2, jCTree);
                jCLambda.targets = jCMemberReference.targets;
                jCLambda.type = jCMemberReference.type;
                jCLambda.pos = jCMemberReference.pos;
                this.visitLambda(jCLambda);
            } else {
                super.visitReference(jCMemberReference);
                LambdaToMethod.this.contextMap.put(jCMemberReference, this.makeReferenceContext(jCMemberReference));
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            if (this.context() != null && jCFieldAccess.sym.kind == 4 && (jCFieldAccess.sym.name == ((LambdaToMethod)LambdaToMethod.this).names._this || jCFieldAccess.sym.name == ((LambdaToMethod)LambdaToMethod.this).names._super)) {
                TranslationContext<?> translationContext = this.context();
                while (translationContext != null) {
                    if (((JCTree)translationContext.tree).hasTag(JCTree.Tag.LAMBDA)) {
                        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)this.capturedDecl(translationContext.depth, jCFieldAccess.sym);
                        if (jCClassDecl == null) break;
                        ((LambdaTranslationContext)translationContext).addSymbol(jCClassDecl.sym, LambdaSymbolKind.CAPTURED_THIS);
                    }
                    translationContext = translationContext.prev;
                }
            }
            super.visitSelect(jCFieldAccess);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            Object object;
            LambdaTranslationContext lambdaTranslationContext;
            TranslationContext<?> translationContext = this.context();
            LambdaTranslationContext lambdaTranslationContext2 = lambdaTranslationContext = translationContext != null && translationContext instanceof LambdaTranslationContext ? (LambdaTranslationContext)translationContext : null;
            if (lambdaTranslationContext != null) {
                if (((Frame)this.frameStack.head).tree.hasTag(JCTree.Tag.LAMBDA)) {
                    lambdaTranslationContext.addSymbol(jCVariableDecl.sym, LambdaSymbolKind.LOCAL_VAR);
                }
                object = jCVariableDecl.sym.asType();
                if (this.inClassWithinLambda() && !LambdaToMethod.this.types.isSameType(LambdaToMethod.this.types.erasure((Type)object), (Type)object)) {
                    lambdaTranslationContext.addSymbol(jCVariableDecl.sym, LambdaSymbolKind.TYPE_VAR);
                }
            }
            object = this.frameStack;
            try {
                if (jCVariableDecl.sym.owner.kind == 16) {
                    ((Frame)this.frameStack.head).addLocal(jCVariableDecl.sym);
                }
                this.frameStack = this.frameStack.prepend(new Frame(jCVariableDecl));
                super.visitVarDef(jCVariableDecl);
            }
            finally {
                this.frameStack = object;
            }
        }

        private Symbol owner() {
            return this.owner(false);
        }

        private Symbol owner(boolean bl) {
            List<Frame> list = this.frameStack;
            block7: while (list.nonEmpty()) {
                switch (((Frame)list.head).tree.getTag()) {
                    case VARDEF: {
                        if (((JCTree.JCVariableDecl)((Frame)list.head).tree).sym.isLocal()) {
                            list = list.tail;
                            continue block7;
                        }
                        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)((Frame)list.tail.head).tree;
                        return this.initSym(jCClassDecl.sym, ((JCTree.JCVariableDecl)((Frame)list.head).tree).sym.flags() & 8L);
                    }
                    case BLOCK: {
                        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)((Frame)list.tail.head).tree;
                        return this.initSym(jCClassDecl.sym, ((JCTree.JCBlock)((Frame)list.head).tree).flags & 8L);
                    }
                    case CLASSDEF: {
                        return ((JCTree.JCClassDecl)((Frame)list.head).tree).sym;
                    }
                    case METHODDEF: {
                        return ((JCTree.JCMethodDecl)((Frame)list.head).tree).sym;
                    }
                    case LAMBDA: {
                        if (bl) break;
                        return ((LambdaTranslationContext)((LambdaToMethod)LambdaToMethod.this).contextMap.get((Object)((Frame)list.head).tree)).translatedSym;
                    }
                }
                list = list.tail;
            }
            Assert.error();
            return null;
        }

        private Symbol initSym(Symbol.ClassSymbol classSymbol, long l) {
            boolean bl;
            boolean bl2 = bl = (l & 8L) != 0L;
            if (bl) {
                Symbol.MethodSymbol methodSymbol = LambdaToMethod.this.attr.removeClinit(classSymbol);
                if (methodSymbol != null) {
                    this.clinits.put(classSymbol, methodSymbol);
                    return methodSymbol;
                }
                methodSymbol = (Symbol.MethodSymbol)this.clinits.get(classSymbol);
                if (methodSymbol == null) {
                    methodSymbol = LambdaToMethod.this.makePrivateSyntheticMethod(8L, ((LambdaToMethod)LambdaToMethod.this).names.clinit, new Type.MethodType(List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.voidType, List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.methodClass), classSymbol);
                    this.clinits.put(classSymbol, methodSymbol);
                }
                return methodSymbol;
            }
            Iterator<Symbol> iterator = classSymbol.members_field.getElementsByName(((LambdaToMethod)LambdaToMethod.this).names.init).iterator();
            if (iterator.hasNext()) {
                Symbol symbol = iterator.next();
                return symbol;
            }
            Assert.error("init not found");
            return null;
        }

        private JCTree directlyEnclosingLambda() {
            if (this.frameStack.isEmpty()) {
                return null;
            }
            List<Frame> list = this.frameStack;
            while (list.nonEmpty()) {
                switch (((Frame)list.head).tree.getTag()) {
                    case CLASSDEF: 
                    case METHODDEF: {
                        return null;
                    }
                    case LAMBDA: {
                        return ((Frame)list.head).tree;
                    }
                }
                list = list.tail;
            }
            Assert.error();
            return null;
        }

        private boolean inClassWithinLambda() {
            if (this.frameStack.isEmpty()) {
                return false;
            }
            List<Frame> list = this.frameStack;
            boolean bl = false;
            block4: while (list.nonEmpty()) {
                switch (((Frame)list.head).tree.getTag()) {
                    case LAMBDA: {
                        return bl;
                    }
                    case CLASSDEF: {
                        bl = true;
                        list = list.tail;
                        continue block4;
                    }
                }
                list = list.tail;
            }
            return false;
        }

        private JCTree capturedDecl(int n, Symbol symbol) {
            int n2 = this.frameStack.size() - 1;
            for (Frame frame : this.frameStack) {
                switch (frame.tree.getTag()) {
                    case CLASSDEF: {
                        Symbol.ClassSymbol classSymbol = ((JCTree.JCClassDecl)frame.tree).sym;
                        if (!symbol.isMemberOf(classSymbol, LambdaToMethod.this.types)) break;
                        return n2 > n ? null : frame.tree;
                    }
                    case VARDEF: {
                        if (((JCTree.JCVariableDecl)frame.tree).sym != symbol || symbol.owner.kind != 16) break;
                        return n2 > n ? null : frame.tree;
                    }
                    case BLOCK: 
                    case METHODDEF: 
                    case LAMBDA: {
                        if (frame.locals == null || !frame.locals.contains(symbol)) break;
                        return n2 > n ? null : frame.tree;
                    }
                    default: {
                        String string = String.valueOf(String.valueOf((Object)frame.tree.getTag()));
                        Assert.error(new StringBuilder(14 + string.length()).append("bad decl kind ").append(string).toString());
                    }
                }
                --n2;
            }
            return null;
        }

        private TranslationContext<?> context() {
            for (Frame frame : this.frameStack) {
                TranslationContext translationContext = (TranslationContext)LambdaToMethod.this.contextMap.get(frame.tree);
                if (translationContext == null) continue;
                return translationContext;
            }
            return null;
        }

        private boolean lambdaIdentSymbolFilter(Symbol symbol) {
            return (symbol.kind == 4 || symbol.kind == 16) && !symbol.isStatic() && symbol.name != ((LambdaToMethod)LambdaToMethod.this).names.init;
        }

        private boolean lambdaNewClassFilter(TranslationContext<?> translationContext, JCTree.JCNewClass jCNewClass) {
            if (translationContext != null && jCNewClass.encl == null && jCNewClass.def == null && !jCNewClass.type.getEnclosingType().hasTag(TypeTag.NONE)) {
                Type type = jCNewClass.type.getEnclosingType();
                Type type2 = translationContext.owner.enclClass().type;
                while (!type2.hasTag(TypeTag.NONE)) {
                    if (type2.tsym.isSubClass(type.tsym, LambdaToMethod.this.types)) {
                        return true;
                    }
                    type2 = type2.getEnclosingType();
                }
                return false;
            }
            return false;
        }

        private TranslationContext<JCTree.JCLambda> makeLambdaContext(JCTree.JCLambda jCLambda) {
            return new LambdaTranslationContext(jCLambda);
        }

        private TranslationContext<JCTree.JCMemberReference> makeReferenceContext(JCTree.JCMemberReference jCMemberReference) {
            return new ReferenceTranslationContext(jCMemberReference);
        }

        private class ReferenceTranslationContext
        extends TranslationContext<JCTree.JCMemberReference> {
            final boolean isSuper;
            final Symbol bridgeSym;
            final Symbol sigPolySym;

            ReferenceTranslationContext(JCTree.JCMemberReference jCMemberReference) {
                super(LambdaAnalyzerPreprocessor.this, (JCTree.JCFunctionalExpression)jCMemberReference);
                this.isSuper = jCMemberReference.hasKind(JCTree.JCMemberReference.ReferenceKind.SUPER);
                this.bridgeSym = this.needsBridge() ? LambdaToMethod.this.makePrivateSyntheticMethod(this.isSuper ? 0L : 8L, this.referenceBridgeName(), null, this.owner.enclClass()) : null;
                Symbol symbol = this.sigPolySym = this.isSignaturePolymorphic() ? LambdaToMethod.this.makePrivateSyntheticMethod(jCMemberReference.sym.flags(), jCMemberReference.sym.name, this.bridgedRefSig(), jCMemberReference.sym.enclClass()) : null;
                if (LambdaToMethod.this.dumpLambdaToMethodStats) {
                    String string = this.bridgeSym == null ? "mref.stat" : "mref.stat.1";
                    LambdaToMethod.this.log.note(jCMemberReference, string, this.needsAltMetafactory(), this.bridgeSym);
                }
            }

            int referenceKind() {
                return LambdaToMethod.this.referenceKind(this.needsBridge() ? this.bridgeSym : ((JCTree.JCMemberReference)this.tree).sym);
            }

            boolean needsVarArgsConversion() {
                return ((JCTree.JCMemberReference)this.tree).varargsElement != null;
            }

            private String referenceBridgeDisambiguation() {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.owner.type != null) {
                    stringBuilder.append(LambdaToMethod.this.typeSig(this.owner.type));
                    stringBuilder.append(":");
                }
                stringBuilder.append(LambdaToMethod.this.classSig(((JCTree.JCMemberReference)this.tree).sym.owner.type));
                stringBuilder.append(((JCTree.JCMemberReference)this.tree).sym.isStatic() ? " S " : " I ");
                stringBuilder.append(LambdaToMethod.this.typeSig(((JCTree.JCMemberReference)this.tree).sym.erasure(LambdaToMethod.this.types)));
                return stringBuilder.toString();
            }

            private Name referenceBridgeName() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(((LambdaToMethod)LambdaToMethod.this).names.lambda);
                stringBuilder.append("MR$");
                stringBuilder.append(this.enclosingMethodName());
                stringBuilder.append('$');
                stringBuilder.append(this.syntheticMethodNameComponent(((JCTree.JCMemberReference)this.tree).sym.name));
                stringBuilder.append('$');
                String string = this.referenceBridgeDisambiguation();
                stringBuilder.append(Integer.toHexString(string.hashCode()));
                stringBuilder.append('$');
                stringBuilder.append(LambdaAnalyzerPreprocessor.this.syntheticMethodNameCounts.getIndex(stringBuilder));
                String string2 = stringBuilder.toString();
                return LambdaToMethod.this.names.fromString(string2);
            }

            boolean isArrayOp() {
                return ((JCTree.JCMemberReference)this.tree).sym.owner == ((LambdaToMethod)LambdaToMethod.this).syms.arrayClass;
            }

            boolean receiverAccessible() {
                return ((JCTree.JCMemberReference)this.tree).ownerAccessible;
            }

            boolean isPrivateInOtherClass() {
                return (((JCTree.JCMemberReference)this.tree).sym.flags() & 2L) != 0L && !LambdaToMethod.this.types.isSameType(LambdaToMethod.this.types.erasure((Type)((JCTree.JCMemberReference)this.tree).sym.enclClass().asType()), LambdaToMethod.this.types.erasure((Type)this.owner.enclClass().asType()));
            }

            final boolean isSignaturePolymorphic() {
                return ((JCTree.JCMemberReference)this.tree).sym.kind == 16 && LambdaToMethod.this.types.isSignaturePolymorphic((Symbol.MethodSymbol)((JCTree.JCMemberReference)this.tree).sym);
            }

            final boolean needsBridge() {
                return this.isSuper || this.needsVarArgsConversion() || this.isArrayOp() || this.isPrivateInOtherClass() || !this.receiverAccessible();
            }

            Type generatedRefSig() {
                return LambdaToMethod.this.types.erasure(((JCTree.JCMemberReference)this.tree).sym.type);
            }

            Type bridgedRefSig() {
                return LambdaToMethod.this.types.erasure(((LambdaToMethod)LambdaToMethod.this).types.findDescriptorSymbol((Symbol.TypeSymbol)((Type)((JCTree.JCMemberReference)this.tree).targets.head).tsym).type);
            }
        }

        private class LambdaTranslationContext
        extends TranslationContext<JCTree.JCLambda> {
            final Symbol self;
            final Symbol assignedTo;
            Map<LambdaSymbolKind, Map<Symbol, Symbol>> translatedSymbols;
            Symbol translatedSym;
            List<JCTree.JCVariableDecl> syntheticParams;

            LambdaTranslationContext(JCTree.JCLambda jCLambda) {
                super(LambdaAnalyzerPreprocessor.this, (JCTree.JCFunctionalExpression)jCLambda);
                Frame frame = (Frame)((LambdaAnalyzerPreprocessor)LambdaAnalyzerPreprocessor.this).frameStack.head;
                switch (frame.tree.getTag()) {
                    case VARDEF: {
                        this.assignedTo = this.self = ((JCTree.JCVariableDecl)frame.tree).sym;
                        break;
                    }
                    case ASSIGN: {
                        this.self = null;
                        this.assignedTo = TreeInfo.symbol(((JCTree.JCAssign)frame.tree).getVariable());
                        break;
                    }
                    default: {
                        this.self = null;
                        this.assignedTo = null;
                    }
                }
                this.translatedSym = LambdaToMethod.this.makePrivateSyntheticMethod(0L, null, null, this.owner.enclClass());
                if (LambdaToMethod.this.dumpLambdaToMethodStats) {
                    LambdaToMethod.this.log.note(jCLambda, "lambda.stat", this.needsAltMetafactory(), this.translatedSym);
                }
                this.translatedSymbols = new EnumMap<LambdaSymbolKind, Map<Symbol, Symbol>>(LambdaSymbolKind.class);
                this.translatedSymbols.put(LambdaSymbolKind.PARAM, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.LOCAL_VAR, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.CAPTURED_VAR, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.CAPTURED_THIS, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.TYPE_VAR, new LinkedHashMap());
            }

            private String serializedLambdaDisambiguation() {
                StringBuilder stringBuilder = new StringBuilder();
                Assert.check(this.owner.type != null || LambdaAnalyzerPreprocessor.this.directlyEnclosingLambda() != null);
                if (this.owner.type != null) {
                    stringBuilder.append(LambdaToMethod.this.typeSig(this.owner.type));
                    stringBuilder.append(":");
                }
                stringBuilder.append(((LambdaToMethod)LambdaToMethod.this).types.findDescriptorSymbol((Symbol.TypeSymbol)((JCTree.JCLambda)this.tree).type.tsym).owner.flatName());
                stringBuilder.append(" ");
                if (this.assignedTo != null) {
                    stringBuilder.append(this.assignedTo.flatName());
                    stringBuilder.append("=");
                }
                for (Symbol symbol : this.getSymbolMap(LambdaSymbolKind.CAPTURED_VAR).keySet()) {
                    if (symbol == this.self) continue;
                    stringBuilder.append(LambdaToMethod.this.typeSig(symbol.type));
                    stringBuilder.append(" ");
                    stringBuilder.append(symbol.flatName());
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }

            private Name lambdaName() {
                String string = String.valueOf(String.valueOf(this.enclosingMethodName()));
                int n = LambdaAnalyzerPreprocessor.this.lambdaCount++;
                return ((LambdaToMethod)LambdaToMethod.this).names.lambda.append(LambdaToMethod.this.names.fromString(new StringBuilder(12 + string.length()).append(string).append("$").append(n).toString()));
            }

            private Name serializedLambdaName() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(((LambdaToMethod)LambdaToMethod.this).names.lambda);
                stringBuilder.append(this.enclosingMethodName());
                stringBuilder.append('$');
                String string = this.serializedLambdaDisambiguation();
                stringBuilder.append(Integer.toHexString(string.hashCode()));
                stringBuilder.append('$');
                stringBuilder.append(LambdaAnalyzerPreprocessor.this.syntheticMethodNameCounts.getIndex(stringBuilder));
                String string2 = stringBuilder.toString();
                return LambdaToMethod.this.names.fromString(string2);
            }

            Symbol translate(Name name, final Symbol symbol, LambdaSymbolKind lambdaSymbolKind) {
                Symbol symbol2;
                switch (lambdaSymbolKind) {
                    case CAPTURED_THIS: {
                        symbol2 = symbol;
                        break;
                    }
                    case TYPE_VAR: {
                        symbol2 = new Symbol.VarSymbol(symbol.flags(), name, LambdaToMethod.this.types.erasure(symbol.type), symbol.owner);
                        ((Symbol.VarSymbol)symbol2).pos = ((Symbol.VarSymbol)symbol).pos;
                        break;
                    }
                    case CAPTURED_VAR: {
                        symbol2 = new Symbol.VarSymbol(0x200001010L, name, LambdaToMethod.this.types.erasure(symbol.type), this.translatedSym){

                            @Override
                            public Symbol baseSymbol() {
                                return symbol;
                            }
                        };
                        break;
                    }
                    case LOCAL_VAR: {
                        symbol2 = new Symbol.VarSymbol(16L, name, LambdaToMethod.this.types.erasure(symbol.type), this.translatedSym);
                        ((Symbol.VarSymbol)symbol2).pos = ((Symbol.VarSymbol)symbol).pos;
                        break;
                    }
                    case PARAM: {
                        symbol2 = new Symbol.VarSymbol(0x200000010L, name, LambdaToMethod.this.types.erasure(symbol.type), this.translatedSym);
                        ((Symbol.VarSymbol)symbol2).pos = ((Symbol.VarSymbol)symbol).pos;
                        break;
                    }
                    default: {
                        symbol2 = LambdaToMethod.this.makeSyntheticVar(16L, name, LambdaToMethod.this.types.erasure(symbol.type), this.translatedSym);
                        ((Symbol.VarSymbol)symbol2).pos = ((Symbol.VarSymbol)symbol).pos;
                    }
                }
                if (symbol2 != symbol) {
                    symbol2.setDeclarationAttributes(symbol.getRawAttributes());
                    symbol2.setTypeAttributes(symbol.getRawTypeAttributes());
                }
                return symbol2;
            }

            void addSymbol(Symbol symbol, LambdaSymbolKind lambdaSymbolKind) {
                Name name;
                Map<Symbol, Symbol> map = this.getSymbolMap(lambdaSymbolKind);
                switch (lambdaSymbolKind) {
                    case CAPTURED_THIS: {
                        int n = map.size();
                        name = LambdaToMethod.this.names.fromString(new StringBuilder(16).append("encl$").append(n).toString());
                        break;
                    }
                    case CAPTURED_VAR: {
                        int n = map.size();
                        name = LambdaToMethod.this.names.fromString(new StringBuilder(15).append("cap$").append(n).toString());
                        break;
                    }
                    case LOCAL_VAR: {
                        name = symbol.name;
                        break;
                    }
                    case PARAM: {
                        name = symbol.name;
                        break;
                    }
                    case TYPE_VAR: {
                        name = symbol.name;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (!map.containsKey(symbol)) {
                    map.put(symbol, this.translate(name, symbol, lambdaSymbolKind));
                }
            }

            Map<Symbol, Symbol> getSymbolMap(LambdaSymbolKind lambdaSymbolKind) {
                Map<Symbol, Symbol> map = this.translatedSymbols.get((Object)lambdaSymbolKind);
                Assert.checkNonNull(map);
                return map;
            }

            JCTree translate(JCTree.JCIdent jCIdent) {
                for (Map<Symbol, Symbol> map : this.translatedSymbols.values()) {
                    if (!map.containsKey(jCIdent.sym)) continue;
                    Symbol symbol = map.get(jCIdent.sym);
                    JCTree.JCExpression jCExpression = LambdaToMethod.this.make.Ident(symbol).setType(jCIdent.type);
                    symbol.setTypeAttributes(jCIdent.sym.getRawTypeAttributes());
                    return jCExpression;
                }
                return null;
            }

            void complete() {
                boolean bl;
                if (this.syntheticParams != null) {
                    return;
                }
                boolean bl2 = this.translatedSym.owner.isInterface();
                boolean bl3 = bl = !this.getSymbolMap(LambdaSymbolKind.CAPTURED_THIS).isEmpty();
                this.translatedSym.flags_field = 0x2000000001002L | (bl ? (bl2 ? 0x80000000000L : 0L) : 8L);
                ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
                for (Symbol symbol : this.getSymbolMap(LambdaSymbolKind.CAPTURED_VAR).values()) {
                    listBuffer.append(LambdaToMethod.this.make.VarDef((Symbol.VarSymbol)symbol, null));
                }
                for (Symbol symbol : this.getSymbolMap(LambdaSymbolKind.PARAM).values()) {
                    listBuffer.append(LambdaToMethod.this.make.VarDef((Symbol.VarSymbol)symbol, null));
                }
                this.syntheticParams = listBuffer.toList();
                this.translatedSym.name = this.isSerializable() ? this.serializedLambdaName() : this.lambdaName();
                this.translatedSym.type = LambdaToMethod.this.types.createMethodTypeWithParameters(this.generatedLambdaSig(), TreeInfo.types(this.syntheticParams));
            }

            Type generatedLambdaSig() {
                return LambdaToMethod.this.types.erasure(((JCTree.JCLambda)this.tree).getDescriptorType(LambdaToMethod.this.types));
            }
        }

        private static abstract class TranslationContext<T extends JCTree.JCFunctionalExpression> {
            final T tree;
            final Symbol owner;
            final int depth;
            final TranslationContext<?> prev;
            final List<Symbol> bridges;
            final /* synthetic */ LambdaAnalyzerPreprocessor this$1;

            TranslationContext(T t) {
                this.this$1 = var1_1;
                this.tree = t;
                this.owner = ((LambdaAnalyzerPreprocessor)var1_1).owner();
                this.depth = ((LambdaAnalyzerPreprocessor)var1_1).frameStack.size() - 1;
                this.prev = ((LambdaAnalyzerPreprocessor)var1_1).context();
                Symbol.ClassSymbol classSymbol = var1_1.LambdaToMethod.this.types.makeFunctionalInterfaceClass(var1_1.LambdaToMethod.this.attrEnv, ((LambdaToMethod)var1_1.LambdaToMethod.this).names.empty, ((JCTree.JCFunctionalExpression)t).targets, 1536L);
                this.bridges = var1_1.LambdaToMethod.this.types.functionalInterfaceBridges(classSymbol);
            }

            boolean needsAltMetafactory() {
                return ((JCTree.JCFunctionalExpression)this.tree).targets.length() > 1 || this.isSerializable() || this.bridges.length() > 1;
            }

            boolean isSerializable() {
                for (Type type : ((JCTree.JCFunctionalExpression)this.tree).targets) {
                    if (this.this$1.LambdaToMethod.this.types.asSuper(type, ((LambdaToMethod)this.this$1.LambdaToMethod.this).syms.serializableType.tsym) == null) continue;
                    return true;
                }
                return false;
            }

            String enclosingMethodName() {
                return this.syntheticMethodNameComponent(this.owner.name);
            }

            String syntheticMethodNameComponent(Name name) {
                if (name == null) {
                    return "null";
                }
                String string = name.toString();
                if (string.equals("<clinit>")) {
                    string = "static";
                } else if (string.equals("<init>")) {
                    string = "new";
                }
                return string;
            }
        }

        private class Frame {
            final JCTree tree;
            List<Symbol> locals;

            public Frame(JCTree jCTree) {
                this.tree = jCTree;
            }

            void addLocal(Symbol symbol) {
                if (this.locals == null) {
                    this.locals = List.nil();
                }
                this.locals = this.locals.prepend(symbol);
            }
        }

        private class SyntheticMethodNameCounter {
            private Map<String, Integer> map = new HashMap<String, Integer>();

            private SyntheticMethodNameCounter() {
            }

            int getIndex(StringBuilder stringBuilder) {
                String string = stringBuilder.toString();
                Integer n = this.map.get(string);
                if (n == null) {
                    n = 0;
                }
                n = n + 1;
                this.map.put(string, n);
                return n;
            }
        }
    }

    private class MemberReferenceBridger {
        private final JCTree.JCMemberReference tree;
        private final LambdaAnalyzerPreprocessor.ReferenceTranslationContext localContext;
        private final ListBuffer<JCTree.JCExpression> args = new ListBuffer();
        private final ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer();

        MemberReferenceBridger(JCTree.JCMemberReference jCMemberReference, LambdaAnalyzerPreprocessor.ReferenceTranslationContext referenceTranslationContext) {
            this.tree = jCMemberReference;
            this.localContext = referenceTranslationContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JCTree.JCMethodDecl bridge() {
            int n = ((LambdaToMethod)LambdaToMethod.this).make.pos;
            try {
                int n2;
                LambdaToMethod.this.make.at(this.tree);
                Type type = this.localContext.bridgedRefSig();
                List<Type> list = type.getParameterTypes();
                Type type2 = null;
                switch (this.tree.kind) {
                    case IMPLICIT_INNER: {
                        type2 = this.tree.sym.owner.type.getEnclosingType();
                        break;
                    }
                    case BOUND: {
                        type2 = this.tree.getQualifierExpression().type;
                        break;
                    }
                    case UNBOUND: {
                        type2 = (Type)list.head;
                        list = list.tail;
                    }
                }
                Symbol.VarSymbol varSymbol = type2 == null ? null : this.addParameter("rec$", type2, false);
                List<Type> list2 = this.tree.sym.type.getParameterTypes();
                int n3 = list2.size();
                int n4 = list.size();
                int n5 = this.localContext.needsVarArgsConversion() ? n3 - 1 : n3;
                List<Type> list3 = list2;
                int n6 = 0;
                while (list3.nonEmpty() && n6 < n5) {
                    n2 = n6++;
                    this.addParameter(new StringBuilder(13).append("x$").append(n2).toString(), (Type)list3.head, true);
                    list3 = list3.tail;
                }
                n6 = n5;
                while (n6 < n4) {
                    n2 = n6++;
                    this.addParameter(new StringBuilder(15).append("xva$").append(n2).toString(), this.tree.varargsElement, true);
                }
                JCTree.JCMethodDecl jCMethodDecl = LambdaToMethod.this.make.MethodDef(LambdaToMethod.this.make.Modifiers(this.localContext.bridgeSym.flags()), this.localContext.bridgeSym.name, LambdaToMethod.this.make.QualIdent(type.getReturnType().tsym), List.nil(), this.params.toList(), this.tree.sym.type.getThrownTypes() == null ? List.nil() : LambdaToMethod.this.make.Types(this.tree.sym.type.getThrownTypes()), null, null);
                jCMethodDecl.sym = (Symbol.MethodSymbol)this.localContext.bridgeSym;
                jCMethodDecl.type = this.localContext.bridgeSym.type = LambdaToMethod.this.types.createMethodTypeWithParameters(type, TreeInfo.types(this.params.toList()));
                JCTree.JCExpression jCExpression = this.tree.getMode() == MemberReferenceTree.ReferenceMode.INVOKE ? this.bridgeExpressionInvoke(this.makeReceiver(varSymbol)) : this.bridgeExpressionNew();
                jCMethodDecl.body = LambdaToMethod.this.makeLambdaExpressionBody(jCExpression, jCMethodDecl);
                JCTree.JCMethodDecl jCMethodDecl2 = jCMethodDecl;
                return jCMethodDecl2;
            }
            finally {
                LambdaToMethod.this.make.at(n);
            }
        }

        private JCTree.JCExpression makeReceiver(Symbol.VarSymbol varSymbol) {
            if (varSymbol == null) {
                return null;
            }
            JCTree.JCExpression jCExpression = LambdaToMethod.this.make.Ident(varSymbol);
            Type type = this.tree.sym.enclClass().type;
            if (!varSymbol.type.tsym.isSubClass(type.tsym, LambdaToMethod.this.types)) {
                jCExpression = LambdaToMethod.this.make.TypeCast(LambdaToMethod.this.make.Type(type), jCExpression).setType(type);
            }
            return jCExpression;
        }

        private JCTree.JCExpression bridgeExpressionInvoke(JCTree.JCExpression jCExpression) {
            JCTree.JCExpression jCExpression2 = this.tree.sym.isStatic() ? LambdaToMethod.this.make.Type(this.tree.sym.owner.type) : (jCExpression != null ? jCExpression : this.tree.getQualifierExpression());
            JCTree.JCFieldAccess jCFieldAccess = LambdaToMethod.this.make.Select(jCExpression2, this.tree.sym.name);
            jCFieldAccess.sym = this.tree.sym;
            jCFieldAccess.type = this.tree.sym.erasure(LambdaToMethod.this.types);
            JCTree.JCExpression jCExpression3 = LambdaToMethod.this.make.Apply(List.nil(), jCFieldAccess, LambdaToMethod.this.convertArgs(this.tree.sym, this.args.toList(), this.tree.varargsElement)).setType(this.tree.sym.erasure(LambdaToMethod.this.types).getReturnType());
            jCExpression3 = LambdaToMethod.this.transTypes.coerce(jCExpression3, this.localContext.generatedRefSig().getReturnType());
            LambdaToMethod.this.setVarargsIfNeeded(jCExpression3, this.tree.varargsElement);
            return jCExpression3;
        }

        private JCTree.JCExpression bridgeExpressionNew() {
            if (this.tree.kind == JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR) {
                JCTree.JCNewArray jCNewArray = LambdaToMethod.this.make.NewArray(LambdaToMethod.this.make.Type(LambdaToMethod.this.types.elemtype(this.tree.getQualifierExpression().type)), List.of(LambdaToMethod.this.make.Ident(this.params.first())), null);
                jCNewArray.type = this.tree.getQualifierExpression().type;
                return jCNewArray;
            }
            JCTree.JCExpression jCExpression = null;
            switch (this.tree.kind) {
                case IMPLICIT_INNER: 
                case UNBOUND: {
                    jCExpression = LambdaToMethod.this.make.Ident(this.params.first());
                }
            }
            JCTree.JCNewClass jCNewClass = LambdaToMethod.this.make.NewClass(jCExpression, List.nil(), LambdaToMethod.this.make.Type(this.tree.getQualifierExpression().type), LambdaToMethod.this.convertArgs(this.tree.sym, this.args.toList(), this.tree.varargsElement), null);
            jCNewClass.constructor = this.tree.sym;
            jCNewClass.constructorType = this.tree.sym.erasure(LambdaToMethod.this.types);
            jCNewClass.type = this.tree.getQualifierExpression().type;
            LambdaToMethod.this.setVarargsIfNeeded(jCNewClass, this.tree.varargsElement);
            return jCNewClass;
        }

        private Symbol.VarSymbol addParameter(String string, Type type, boolean bl) {
            Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0L, LambdaToMethod.this.names.fromString(string), type, this.localContext.bridgeSym);
            this.params.append(LambdaToMethod.this.make.VarDef(varSymbol, null));
            if (bl) {
                this.args.append(LambdaToMethod.this.make.Ident(varSymbol));
            }
            return varSymbol;
        }
    }

    private class KlassInfo {
        private ListBuffer<JCTree> appendedMethodList;
        private final Map<String, ListBuffer<JCTree.JCStatement>> deserializeCases;
        private final Symbol.MethodSymbol deserMethodSym;
        private final Symbol.VarSymbol deserParamSym;
        private final JCTree.JCClassDecl clazz;

        private KlassInfo(JCTree.JCClassDecl jCClassDecl) {
            this.clazz = jCClassDecl;
            this.appendedMethodList = new ListBuffer();
            this.deserializeCases = new HashMap<String, ListBuffer<JCTree.JCStatement>>();
            Type.MethodType methodType = new Type.MethodType(List.of(((LambdaToMethod)LambdaToMethod.this).syms.serializedLambdaType), ((LambdaToMethod)LambdaToMethod.this).syms.objectType, List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.methodClass);
            this.deserMethodSym = LambdaToMethod.this.makePrivateSyntheticMethod(8L, ((LambdaToMethod)LambdaToMethod.this).names.deserializeLambda, methodType, jCClassDecl.sym);
            this.deserParamSym = new Symbol.VarSymbol(16L, LambdaToMethod.this.names.fromString("lambda"), ((LambdaToMethod)LambdaToMethod.this).syms.serializedLambdaType, this.deserMethodSym);
        }

        private void addMethod(JCTree jCTree) {
            this.appendedMethodList = this.appendedMethodList.prepend(jCTree);
        }
    }
}

