/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class ZipFileIndex {
    private static final String MIN_CHAR = String.valueOf('\u0000');
    private static final String MAX_CHAR = String.valueOf('\uffff');
    public static final long NOT_MODIFIED = Long.MIN_VALUE;
    private static final boolean NON_BATCH_MODE = System.getProperty("nonBatchMode") != null;
    private Map<RelativePath.RelativeDirectory, DirectoryEntry> directories = Collections.emptyMap();
    private Set<RelativePath.RelativeDirectory> allDirs = Collections.emptySet();
    final File zipFile;
    private Reference<File> absFileRef;
    long zipFileLastModified = Long.MIN_VALUE;
    private RandomAccessFile zipRandomFile;
    private Entry[] entries;
    private boolean readFromIndex = false;
    private File zipIndexFile = null;
    private boolean triedToReadIndex = false;
    final RelativePath.RelativeDirectory symbolFilePrefix;
    private final int symbolFilePrefixLength;
    private boolean hasPopulatedData = false;
    long lastReferenceTimeStamp = Long.MIN_VALUE;
    private final boolean usePreindexedCache;
    private final String preindexedCacheLocation;
    private boolean writeIndex = false;
    private Map<String, SoftReference<RelativePath.RelativeDirectory>> relativeDirectoryCache = new HashMap<String, SoftReference<RelativePath.RelativeDirectory>>();
    private SoftReference<Inflater> inflaterRef;

    public synchronized boolean isOpen() {
        return this.zipRandomFile != null;
    }

    ZipFileIndex(File file, RelativePath.RelativeDirectory relativeDirectory, boolean bl, boolean bl2, String string) throws IOException {
        this.zipFile = file;
        this.symbolFilePrefix = relativeDirectory;
        this.symbolFilePrefixLength = relativeDirectory == null ? 0 : relativeDirectory.getPath().getBytes("UTF-8").length;
        this.writeIndex = bl;
        this.usePreindexedCache = bl2;
        this.preindexedCacheLocation = string;
        if (file != null) {
            this.zipFileLastModified = file.lastModified();
        }
        this.checkIndex();
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.zipFile));
        return new StringBuilder(14 + string.length()).append("ZipFileIndex[").append(string).append("]").toString();
    }

    protected void finalize() throws Throwable {
        this.closeFile();
        super.finalize();
    }

    private boolean isUpToDate() {
        return this.zipFile != null && (!NON_BATCH_MODE || this.zipFileLastModified == this.zipFile.lastModified()) && this.hasPopulatedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndex() throws IOException {
        boolean bl = true;
        if (!this.isUpToDate()) {
            this.closeFile();
            bl = false;
        }
        if (this.zipRandomFile != null || bl) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return;
        }
        this.hasPopulatedData = true;
        if (this.readIndex()) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return;
        }
        this.directories = Collections.emptyMap();
        this.allDirs = Collections.emptySet();
        try {
            this.openFile();
            long l = this.zipRandomFile.length();
            ZipDirectory zipDirectory = new ZipDirectory(this.zipRandomFile, 0L, l, this);
            zipDirectory.buildIndex();
        }
        finally {
            if (this.zipRandomFile != null) {
                this.closeFile();
            }
        }
        this.lastReferenceTimeStamp = System.currentTimeMillis();
    }

    private void openFile() throws FileNotFoundException {
        if (this.zipRandomFile == null && this.zipFile != null) {
            this.zipRandomFile = new RandomAccessFile(this.zipFile, "r");
        }
    }

    private void cleanupState() {
        this.entries = Entry.EMPTY_ARRAY;
        this.directories = Collections.emptyMap();
        this.zipFileLastModified = Long.MIN_VALUE;
        this.allDirs = Collections.emptySet();
    }

    public synchronized void close() {
        this.writeIndex();
        this.closeFile();
    }

    private void closeFile() {
        if (this.zipRandomFile != null) {
            try {
                this.zipRandomFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipRandomFile = null;
        }
    }

    synchronized Entry getZipIndexEntry(RelativePath relativePath) {
        try {
            this.checkIndex();
            DirectoryEntry directoryEntry = this.directories.get(relativePath.dirname());
            String string = relativePath.basename();
            return directoryEntry == null ? null : directoryEntry.getEntry(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public synchronized List<String> getFiles(RelativePath.RelativeDirectory relativeDirectory) {
        try {
            List list;
            this.checkIndex();
            DirectoryEntry directoryEntry = this.directories.get(relativeDirectory);
            List list2 = list = directoryEntry == null ? null : directoryEntry.getFiles();
            if (list == null) {
                return List.nil();
            }
            return list;
        }
        catch (IOException iOException) {
            return List.nil();
        }
    }

    public synchronized java.util.List<String> getDirectories(RelativePath.RelativeDirectory relativeDirectory) {
        try {
            List list;
            this.checkIndex();
            DirectoryEntry directoryEntry = this.directories.get(relativeDirectory);
            List list2 = list = directoryEntry == null ? null : directoryEntry.getDirectories();
            if (list == null) {
                return List.nil();
            }
            return list;
        }
        catch (IOException iOException) {
            return List.nil();
        }
    }

    public synchronized Set<RelativePath.RelativeDirectory> getAllDirectories() {
        try {
            this.checkIndex();
            if (this.allDirs == Collections.EMPTY_SET) {
                this.allDirs = new LinkedHashSet<RelativePath.RelativeDirectory>(this.directories.keySet());
            }
            return this.allDirs;
        }
        catch (IOException iOException) {
            return Collections.emptySet();
        }
    }

    public synchronized boolean contains(RelativePath relativePath) {
        try {
            this.checkIndex();
            return this.getZipIndexEntry(relativePath) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized boolean isDirectory(RelativePath relativePath) throws IOException {
        if (relativePath.getPath().length() == 0) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return true;
        }
        this.checkIndex();
        return this.directories.get(relativePath) != null;
    }

    public synchronized long getLastModified(RelativePath.RelativeFile relativeFile) throws IOException {
        Entry entry = this.getZipIndexEntry(relativeFile);
        if (entry == null) {
            throw new FileNotFoundException();
        }
        return entry.getLastModified();
    }

    public synchronized int length(RelativePath.RelativeFile relativeFile) throws IOException {
        Entry entry = this.getZipIndexEntry(relativeFile);
        if (entry == null) {
            throw new FileNotFoundException();
        }
        if (entry.isDir) {
            return 0;
        }
        byte[] byArray = this.getHeader(entry);
        if (ZipFileIndex.get2ByteLittleEndian(byArray, 8) == 0) {
            return entry.compressedSize;
        }
        return entry.size;
    }

    public synchronized byte[] read(RelativePath.RelativeFile relativeFile) throws IOException {
        Entry entry = this.getZipIndexEntry(relativeFile);
        if (entry == null) {
            String string = String.valueOf(relativeFile.path);
            throw new FileNotFoundException(string.length() != 0 ? "Path not found in ZIP: ".concat(string) : new String("Path not found in ZIP: "));
        }
        return this.read(entry);
    }

    synchronized byte[] read(Entry entry) throws IOException {
        this.openFile();
        byte[] byArray = this.readBytes(entry);
        this.closeFile();
        return byArray;
    }

    public synchronized int read(RelativePath.RelativeFile relativeFile, byte[] byArray) throws IOException {
        Entry entry = this.getZipIndexEntry(relativeFile);
        if (entry == null) {
            throw new FileNotFoundException();
        }
        return this.read(entry, byArray);
    }

    synchronized int read(Entry entry, byte[] byArray) throws IOException {
        int n = this.readBytes(entry, byArray);
        return n;
    }

    private byte[] readBytes(Entry entry) throws IOException {
        byte[] byArray = this.getHeader(entry);
        int n = entry.compressedSize;
        byte[] byArray2 = new byte[n];
        this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(byArray, 26) + ZipFileIndex.get2ByteLittleEndian(byArray, 28));
        this.zipRandomFile.readFully(byArray2, 0, n);
        if (ZipFileIndex.get2ByteLittleEndian(byArray, 8) == 0) {
            return byArray2;
        }
        int n2 = entry.size;
        byte[] byArray3 = new byte[n2];
        if (this.inflate(byArray2, byArray3) != n2) {
            throw new ZipException("corrupted zip file");
        }
        return byArray3;
    }

    private int readBytes(Entry entry, byte[] byArray) throws IOException {
        byte[] byArray2 = this.getHeader(entry);
        if (ZipFileIndex.get2ByteLittleEndian(byArray2, 8) == 0) {
            int n;
            this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(byArray2, 26) + ZipFileIndex.get2ByteLittleEndian(byArray2, 28));
            int n2 = byArray.length;
            for (int i = 0; i < n2 && (n = this.zipRandomFile.read(byArray, i, n2 - i)) != -1; i += n) {
            }
            return entry.size;
        }
        int n = entry.compressedSize;
        byte[] byArray3 = new byte[n];
        this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(byArray2, 26) + ZipFileIndex.get2ByteLittleEndian(byArray2, 28));
        this.zipRandomFile.readFully(byArray3, 0, n);
        int n3 = this.inflate(byArray3, byArray);
        if (n3 == -1) {
            throw new ZipException("corrupted zip file");
        }
        return entry.size;
    }

    private byte[] getHeader(Entry entry) throws IOException {
        this.zipRandomFile.seek(entry.offset);
        byte[] byArray = new byte[30];
        this.zipRandomFile.readFully(byArray);
        if (ZipFileIndex.get4ByteLittleEndian(byArray, 0) != 67324752) {
            throw new ZipException("corrupted zip file");
        }
        if ((ZipFileIndex.get2ByteLittleEndian(byArray, 6) & 1) != 0) {
            throw new ZipException("encrypted zip file");
        }
        return byArray;
    }

    private int inflate(byte[] byArray, byte[] byArray2) {
        Inflater inflater;
        Inflater inflater2 = inflater = this.inflaterRef == null ? null : this.inflaterRef.get();
        if (inflater == null) {
            inflater = new Inflater(true);
            this.inflaterRef = new SoftReference<Inflater>(inflater);
        }
        inflater.reset();
        inflater.setInput(byArray);
        try {
            return inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            return -1;
        }
    }

    private static int get2ByteLittleEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8);
    }

    private static int get4ByteLittleEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZipFileLastModified() throws IOException {
        ZipFileIndex zipFileIndex = this;
        synchronized (zipFileIndex) {
            this.checkIndex();
            return this.zipFileLastModified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readIndex() {
        if (this.triedToReadIndex || !this.usePreindexedCache) {
            return false;
        }
        boolean bl = false;
        ZipFileIndex zipFileIndex = this;
        synchronized (zipFileIndex) {
            this.triedToReadIndex = true;
            RandomAccessFile randomAccessFile = null;
            try {
                File file = this.getIndexFile();
                randomAccessFile = new RandomAccessFile(file, "r");
                long l = randomAccessFile.readLong();
                if (this.zipFile.lastModified() != l) {
                    bl = false;
                } else {
                    this.directories = new LinkedHashMap<RelativePath.RelativeDirectory, DirectoryEntry>();
                    int n = randomAccessFile.readInt();
                    for (int i = 0; i < n; ++i) {
                        int n2 = randomAccessFile.readInt();
                        byte[] byArray = new byte[n2];
                        randomAccessFile.read(byArray);
                        RelativePath.RelativeDirectory relativeDirectory = this.getRelativeDirectory(new String(byArray, "UTF-8"));
                        DirectoryEntry directoryEntry = new DirectoryEntry(relativeDirectory, this);
                        directoryEntry.numEntries = randomAccessFile.readInt();
                        directoryEntry.writtenOffsetOffset = randomAccessFile.readLong();
                        this.directories.put(relativeDirectory, directoryEntry);
                    }
                    bl = true;
                    this.zipFileLastModified = l;
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (bl) {
                this.readFromIndex = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeIndex() {
        boolean bl = false;
        if (this.readFromIndex || !this.usePreindexedCache) {
            return true;
        }
        if (!this.writeIndex) {
            return true;
        }
        File file = this.getIndexFile();
        if (file == null) {
            return false;
        }
        RandomAccessFile randomAccessFile = null;
        long l = 0L;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.writeLong(this.zipFileLastModified);
            l += 8L;
            ArrayList<DirectoryEntry> arrayList = new ArrayList<DirectoryEntry>();
            HashMap<RelativePath.RelativeDirectory, Long> hashMap = new HashMap<RelativePath.RelativeDirectory, Long>();
            randomAccessFile.writeInt(this.directories.keySet().size());
            l += 4L;
            for (RelativePath.RelativeDirectory object : this.directories.keySet()) {
                DirectoryEntry directoryEntry = this.directories.get(object);
                arrayList.add(directoryEntry);
                byte[] byArray = object.getPath().getBytes("UTF-8");
                int n = byArray.length;
                randomAccessFile.writeInt(n);
                l += 4L;
                randomAccessFile.write(byArray);
                l += (long)n;
                java.util.List<Entry> list = directoryEntry.getEntriesAsCollection();
                randomAccessFile.writeInt(list.size());
                hashMap.put(object, new Long(l += 4L));
                directoryEntry.writtenOffsetOffset = 0L;
                randomAccessFile.writeLong(0L);
                l += 8L;
            }
            for (DirectoryEntry directoryEntry : arrayList) {
                long l2 = randomAccessFile.getFilePointer();
                long l3 = (Long)hashMap.get(directoryEntry.dirName);
                randomAccessFile.seek(l3);
                randomAccessFile.writeLong(l);
                randomAccessFile.seek(l2);
                java.util.List<Entry> list = directoryEntry.getEntriesAsCollection();
                for (Entry entry : list) {
                    byte[] byArray = entry.name.getBytes("UTF-8");
                    int n = byArray.length;
                    randomAccessFile.writeInt(n);
                    l += 4L;
                    randomAccessFile.write(byArray);
                    l += (long)n;
                    randomAccessFile.writeByte(entry.isDir ? 1 : 0);
                    ++l;
                    randomAccessFile.writeInt(entry.offset);
                    l += 4L;
                    randomAccessFile.writeInt(entry.size);
                    l += 4L;
                    randomAccessFile.writeInt(entry.compressedSize);
                    l += 4L;
                    randomAccessFile.writeLong(entry.getLastModified());
                    l += 8L;
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeZipIndex() {
        ZipFileIndex zipFileIndex = this;
        synchronized (zipFileIndex) {
            return this.writeIndex();
        }
    }

    private File getIndexFile() {
        if (this.zipIndexFile == null) {
            if (this.zipFile == null) {
                return null;
            }
            String string = String.valueOf(String.valueOf(this.preindexedCacheLocation == null ? "" : this.preindexedCacheLocation));
            String string2 = String.valueOf(String.valueOf(this.zipFile.getName()));
            this.zipIndexFile = new File(new StringBuilder(6 + string.length() + string2.length()).append(string).append(string2).append(".index").toString());
        }
        return this.zipIndexFile;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    File getAbsoluteFile() {
        File file;
        File file2 = file = this.absFileRef == null ? null : this.absFileRef.get();
        if (file == null) {
            file = this.zipFile.getAbsoluteFile();
            this.absFileRef = new SoftReference<File>(file);
        }
        return file;
    }

    private RelativePath.RelativeDirectory getRelativeDirectory(String string) {
        RelativePath.RelativeDirectory relativeDirectory;
        SoftReference<RelativePath.RelativeDirectory> softReference = this.relativeDirectoryCache.get(string);
        if (softReference != null && (relativeDirectory = softReference.get()) != null) {
            return relativeDirectory;
        }
        relativeDirectory = new RelativePath.RelativeDirectory(string);
        this.relativeDirectoryCache.put(string, new SoftReference<RelativePath.RelativeDirectory>(relativeDirectory));
        return relativeDirectory;
    }

    static /* synthetic */ Entry[] access$802(ZipFileIndex zipFileIndex, Entry[] entryArray) {
        zipFileIndex.entries = entryArray;
        return entryArray;
    }

    static final class ZipFormatException
    extends IOException {
        private static final long serialVersionUID = 8000196834066748623L;

        protected ZipFormatException(String string) {
            super(string);
        }

        protected ZipFormatException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    static class Entry
    implements Comparable<Entry> {
        public static final Entry[] EMPTY_ARRAY = new Entry[0];
        RelativePath.RelativeDirectory dir;
        boolean isDir;
        String name;
        int offset;
        int size;
        int compressedSize;
        long javatime;
        private int nativetime;

        public Entry(RelativePath relativePath) {
            this(relativePath.dirname(), relativePath.basename());
        }

        public Entry(RelativePath.RelativeDirectory relativeDirectory, String string) {
            this.dir = relativeDirectory;
            this.name = string;
        }

        public String getName() {
            return new RelativePath.RelativeFile(this.dir, this.name).getPath();
        }

        public String getFileName() {
            return this.name;
        }

        public long getLastModified() {
            if (this.javatime == 0L) {
                this.javatime = Entry.dosToJavaTime(this.nativetime);
            }
            return this.javatime;
        }

        private static long dosToJavaTime(int n) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, (n >> 25 & 0x7F) + 1980);
            calendar.set(2, (n >> 21 & 0xF) - 1);
            calendar.set(5, n >> 16 & 0x1F);
            calendar.set(11, n >> 11 & 0x1F);
            calendar.set(12, n >> 5 & 0x3F);
            calendar.set(13, n << 1 & 0x3E);
            calendar.set(14, 0);
            return calendar.getTimeInMillis();
        }

        void setNativeTime(int n) {
            this.nativetime = n;
        }

        public boolean isDirectory() {
            return this.isDir;
        }

        @Override
        public int compareTo(Entry entry) {
            int n;
            RelativePath.RelativeDirectory relativeDirectory = entry.dir;
            if (this.dir != relativeDirectory && (n = this.dir.compareTo(relativeDirectory)) != 0) {
                return n;
            }
            return this.name.compareTo(entry.name);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.dir.equals(entry.dir) && this.name.equals(entry.name);
        }

        public int hashCode() {
            int n = 7;
            n = 97 * n + (this.dir != null ? this.dir.hashCode() : 0);
            n = 97 * n + (this.name != null ? this.name.hashCode() : 0);
            return n;
        }

        public String toString() {
            String string;
            if (this.isDir) {
                String string2 = String.valueOf(String.valueOf(this.dir));
                String string3 = String.valueOf(String.valueOf(this.name));
                string = new StringBuilder(7 + string2.length() + string3.length()).append("Dir:").append(string2).append(" : ").append(string3).toString();
            } else {
                String string4 = String.valueOf(String.valueOf(this.dir));
                String string5 = String.valueOf(String.valueOf(this.name));
                string = new StringBuilder(1 + string4.length() + string5.length()).append(string4).append(":").append(string5).toString();
            }
            return string;
        }
    }

    static class DirectoryEntry {
        private boolean filesInited = false;
        private boolean directoriesInited = false;
        private boolean zipFileEntriesInited;
        private boolean entriesInited = false;
        private long writtenOffsetOffset = 0L;
        private RelativePath.RelativeDirectory dirName;
        private List<String> zipFileEntriesFiles = List.nil();
        private List<String> zipFileEntriesDirectories = List.nil();
        private List<Entry> zipFileEntries = List.nil();
        private java.util.List<Entry> entries = new ArrayList<Entry>();
        private ZipFileIndex zipFileIndex;
        private int numEntries;

        DirectoryEntry(RelativePath.RelativeDirectory relativeDirectory, ZipFileIndex zipFileIndex) {
            this.dirName = relativeDirectory;
            this.zipFileIndex = zipFileIndex;
        }

        private List<String> getFiles() {
            if (!this.filesInited) {
                this.initEntries();
                for (Entry entry : this.entries) {
                    if (entry.isDir) continue;
                    this.zipFileEntriesFiles = this.zipFileEntriesFiles.append(entry.name);
                }
                this.filesInited = true;
            }
            return this.zipFileEntriesFiles;
        }

        private List<String> getDirectories() {
            if (!this.directoriesInited) {
                this.initEntries();
                for (Entry entry : this.entries) {
                    if (!entry.isDir) continue;
                    this.zipFileEntriesDirectories = this.zipFileEntriesDirectories.append(entry.name);
                }
                this.directoriesInited = true;
            }
            return this.zipFileEntriesDirectories;
        }

        private List<Entry> getEntries() {
            if (!this.zipFileEntriesInited) {
                this.initEntries();
                this.zipFileEntries = List.nil();
                for (Entry entry : this.entries) {
                    this.zipFileEntries = this.zipFileEntries.append(entry);
                }
                this.zipFileEntriesInited = true;
            }
            return this.zipFileEntries;
        }

        private Entry getEntry(String string) {
            this.initEntries();
            int n = Collections.binarySearch(this.entries, new Entry(this.dirName, string));
            if (n < 0) {
                return null;
            }
            return this.entries.get(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initEntries() {
            if (this.entriesInited) {
                return;
            }
            if (!this.zipFileIndex.readFromIndex) {
                int n = -Arrays.binarySearch(this.zipFileIndex.entries, new Entry(this.dirName, MIN_CHAR)) - 1;
                int n2 = -Arrays.binarySearch(this.zipFileIndex.entries, new Entry(this.dirName, MAX_CHAR)) - 1;
                for (int i = n; i < n2; ++i) {
                    this.entries.add(this.zipFileIndex.entries[i]);
                }
            } else {
                File file = this.zipFileIndex.getIndexFile();
                if (file != null) {
                    RandomAccessFile randomAccessFile = null;
                    try {
                        randomAccessFile = new RandomAccessFile(file, "r");
                        randomAccessFile.seek(this.writtenOffsetOffset);
                        for (int i = 0; i < this.numEntries; ++i) {
                            int n = randomAccessFile.readInt();
                            byte[] byArray = new byte[n];
                            randomAccessFile.read(byArray);
                            String string = new String(byArray, "UTF-8");
                            boolean bl = randomAccessFile.readByte() != 0;
                            int n3 = randomAccessFile.readInt();
                            int n4 = randomAccessFile.readInt();
                            int n5 = randomAccessFile.readInt();
                            long l = randomAccessFile.readLong();
                            Entry entry = new Entry(this.dirName, string);
                            entry.isDir = bl;
                            entry.offset = n3;
                            entry.size = n4;
                            entry.compressedSize = n5;
                            entry.javatime = l;
                            this.entries.add(entry);
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        try {
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            this.entriesInited = true;
        }

        java.util.List<Entry> getEntriesAsCollection() {
            this.initEntries();
            return this.entries;
        }
    }

    private class ZipDirectory {
        private RelativePath.RelativeDirectory lastDir;
        private int lastStart;
        private int lastLen;
        byte[] zipDir;
        RandomAccessFile zipRandomFile = null;
        ZipFileIndex zipFileIndex = null;

        public ZipDirectory(RandomAccessFile randomAccessFile, long l, long l2, ZipFileIndex zipFileIndex2) throws IOException {
            this.zipRandomFile = randomAccessFile;
            this.zipFileIndex = zipFileIndex2;
            this.hasValidHeader();
            this.findCENRecord(l, l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasValidHeader() throws IOException {
            long l = this.zipRandomFile.getFilePointer();
            try {
                if (this.zipRandomFile.read() == 80 && this.zipRandomFile.read() == 75 && this.zipRandomFile.read() == 3 && this.zipRandomFile.read() == 4) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.zipRandomFile.seek(l);
            }
            throw new ZipFormatException("invalid zip magic");
        }

        private void findCENRecord(long l, long l2) throws IOException {
            long l3 = l2 - l;
            int n = 1024;
            byte[] byArray = new byte[n];
            long l4 = l2 - l;
            while (l4 >= 22L) {
                int n2;
                if (l4 < (long)n) {
                    n = (int)l4;
                }
                long l5 = l4 - (long)n;
                this.zipRandomFile.seek(l + l5);
                this.zipRandomFile.readFully(byArray, 0, n);
                for (n2 = n - 22; n2 >= 0 && (byArray[n2] != 80 || byArray[n2 + 1] != 75 || byArray[n2 + 2] != 5 || byArray[n2 + 3] != 6 || l5 + (long)n2 + 22L + (long)ZipFileIndex.get2ByteLittleEndian(byArray, n2 + 20) != l3); --n2) {
                }
                if (n2 >= 0) {
                    this.zipDir = new byte[ZipFileIndex.get4ByteLittleEndian(byArray, n2 + 12)];
                    int n3 = ZipFileIndex.get4ByteLittleEndian(byArray, n2 + 16);
                    if (n3 < 0 || ZipFileIndex.get2ByteLittleEndian(byArray, n2 + 10) == 65535) {
                        throw new ZipFormatException("detected a zip64 archive");
                    }
                    this.zipRandomFile.seek(l + (long)n3);
                    this.zipRandomFile.readFully(this.zipDir, 0, this.zipDir.length);
                    return;
                }
                l4 = l5 + 21L;
            }
            throw new ZipException("cannot read zip file");
        }

        private void buildIndex() throws IOException {
            int n = this.zipDir.length;
            if (n > 0) {
                ZipFileIndex.this.directories = new LinkedHashMap();
                ArrayList<Entry> arrayList = new ArrayList<Entry>();
                int n2 = 0;
                while (n2 < n) {
                    n2 = this.readEntry(n2, arrayList, ZipFileIndex.this.directories);
                }
                for (RelativePath.RelativeDirectory relativeDirectory : ZipFileIndex.this.directories.keySet()) {
                    RelativePath.RelativeDirectory relativeDirectory2 = ZipFileIndex.this.getRelativeDirectory(relativeDirectory.dirname().getPath());
                    String string = relativeDirectory.basename();
                    Entry entry = new Entry(relativeDirectory2, string);
                    entry.isDir = true;
                    arrayList.add(entry);
                }
                ZipFileIndex.access$802(ZipFileIndex.this, arrayList.toArray(new Entry[arrayList.size()]));
                Arrays.sort(ZipFileIndex.this.entries);
            } else {
                ZipFileIndex.this.cleanupState();
            }
        }

        private int readEntry(int n, java.util.List<Entry> list, Map<RelativePath.RelativeDirectory, DirectoryEntry> map) throws IOException {
            int n2;
            int n3;
            if (ZipFileIndex.get4ByteLittleEndian(this.zipDir, n) != 33639248) {
                throw new ZipException("cannot read zip file entry");
            }
            int n4 = n3 = n + 46;
            int n5 = n4 + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 28);
            if (this.zipFileIndex.symbolFilePrefixLength != 0 && n5 - n4 >= ZipFileIndex.this.symbolFilePrefixLength) {
                n3 += this.zipFileIndex.symbolFilePrefixLength;
                n4 += this.zipFileIndex.symbolFilePrefixLength;
            }
            for (int i = n4; i < n5; ++i) {
                n2 = this.zipDir[i];
                if (n2 == 92) {
                    this.zipDir[i] = 47;
                    n4 = i + 1;
                    continue;
                }
                if (n2 != 47) continue;
                n4 = i + 1;
            }
            RelativePath.RelativeDirectory relativeDirectory = null;
            if (n4 == n3) {
                relativeDirectory = ZipFileIndex.this.getRelativeDirectory("");
            } else if (this.lastDir != null && this.lastLen == n4 - n3 - 1) {
                n2 = this.lastLen - 1;
                while (this.zipDir[this.lastStart + n2] == this.zipDir[n3 + n2]) {
                    if (n2 == 0) {
                        relativeDirectory = this.lastDir;
                        break;
                    }
                    --n2;
                }
            }
            if (relativeDirectory == null) {
                this.lastStart = n3;
                this.lastLen = n4 - n3 - 1;
                this.lastDir = relativeDirectory = ZipFileIndex.this.getRelativeDirectory(new String(this.zipDir, n3, this.lastLen, "UTF-8"));
                RelativePath.RelativeDirectory relativeDirectory2 = relativeDirectory;
                while (map.get(relativeDirectory2) == null) {
                    map.put(relativeDirectory2, new DirectoryEntry(relativeDirectory2, this.zipFileIndex));
                    if (relativeDirectory2.path.indexOf("/") != relativeDirectory2.path.length() - 1) {
                        relativeDirectory2 = ZipFileIndex.this.getRelativeDirectory(relativeDirectory2.dirname().getPath());
                        continue;
                    }
                    break;
                }
            } else if (map.get(relativeDirectory) == null) {
                map.put(relativeDirectory, new DirectoryEntry(relativeDirectory, this.zipFileIndex));
            }
            if (n4 != n5) {
                Entry entry = new Entry(relativeDirectory, new String(this.zipDir, n4, n5 - n4, "UTF-8"));
                entry.setNativeTime(ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 12));
                entry.compressedSize = ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 20);
                entry.size = ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 24);
                entry.offset = ZipFileIndex.get4ByteLittleEndian(this.zipDir, n + 42);
                list.add(entry);
            }
            return n + 46 + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 28) + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 30) + ZipFileIndex.get2ByteLittleEndian(this.zipDir, n + 32);
        }
    }
}

