/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.ZipFileIndex;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Set;
import javax.tools.JavaFileObject;

public class ZipFileIndexArchive
implements JavacFileManager.Archive {
    private final ZipFileIndex zfIndex;
    private JavacFileManager fileManager;

    public ZipFileIndexArchive(JavacFileManager javacFileManager, ZipFileIndex zipFileIndex) throws IOException {
        this.fileManager = javacFileManager;
        this.zfIndex = zipFileIndex;
    }

    @Override
    public boolean contains(RelativePath relativePath) {
        return this.zfIndex.contains(relativePath);
    }

    @Override
    public List<String> getFiles(RelativePath.RelativeDirectory relativeDirectory) {
        return this.zfIndex.getFiles(relativeDirectory);
    }

    @Override
    public JavaFileObject getFileObject(RelativePath.RelativeDirectory relativeDirectory, String string) {
        RelativePath.RelativeFile relativeFile = new RelativePath.RelativeFile(relativeDirectory, string);
        ZipFileIndex.Entry entry = this.zfIndex.getZipIndexEntry(relativeFile);
        ZipFileIndexFileObject zipFileIndexFileObject = new ZipFileIndexFileObject(this.fileManager, this.zfIndex, entry, this.zfIndex.getZipFile());
        return zipFileIndexFileObject;
    }

    @Override
    public Set<RelativePath.RelativeDirectory> getSubdirectories() {
        return this.zfIndex.getAllDirectories();
    }

    @Override
    public void close() throws IOException {
        this.zfIndex.close();
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.zfIndex));
        return new StringBuilder(21 + string.length()).append("ZipFileIndexArchive[").append(string).append("]").toString();
    }

    public static class ZipFileIndexFileObject
    extends BaseFileObject {
        private String name;
        ZipFileIndex zfIndex;
        ZipFileIndex.Entry entry;
        InputStream inputStream = null;
        File zipName;

        ZipFileIndexFileObject(JavacFileManager javacFileManager, ZipFileIndex zipFileIndex, ZipFileIndex.Entry entry, File file) {
            super(javacFileManager);
            this.name = entry.getFileName();
            this.zfIndex = zipFileIndex;
            this.entry = entry;
            this.zipName = file;
        }

        @Override
        public URI toUri() {
            return ZipFileIndexFileObject.createJarUri(this.zipName, this.getPrefixedEntryName());
        }

        @Override
        public String getName() {
            String string = String.valueOf(String.valueOf(this.zipName));
            String string2 = String.valueOf(String.valueOf(this.getPrefixedEntryName()));
            return new StringBuilder(2 + string.length() + string2.length()).append(string).append("(").append(string2).append(")").toString();
        }

        @Override
        public String getShortName() {
            String string = String.valueOf(String.valueOf(this.zipName.getName()));
            String string2 = String.valueOf(String.valueOf(this.entry.getName()));
            return new StringBuilder(2 + string.length() + string2.length()).append(string).append("(").append(string2).append(")").toString();
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return ZipFileIndexFileObject.getKind(this.entry.getName());
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.inputStream == null) {
                Assert.checkNonNull(this.entry);
                this.inputStream = new ByteArrayInputStream(this.zfIndex.read(this.entry));
            }
            return this.inputStream;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharBuffer getCharContent(boolean bl) throws IOException {
            CharBuffer charBuffer = this.fileManager.getCachedContent(this);
            if (charBuffer == null) {
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.zfIndex.read(this.entry));){
                    ByteBuffer byteBuffer = this.fileManager.makeByteBuffer(byteArrayInputStream);
                    JavaFileObject javaFileObject = this.fileManager.log.useSource(this);
                    try {
                        charBuffer = this.fileManager.decode(byteBuffer, bl);
                    }
                    finally {
                        this.fileManager.log.useSource(javaFileObject);
                    }
                    this.fileManager.recycleByteBuffer(byteBuffer);
                    if (!bl) {
                        this.fileManager.cache(this, charBuffer);
                    }
                }
            }
            return charBuffer;
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            return this.entry.getLastModified();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected CharsetDecoder getDecoder(boolean bl) {
            return this.fileManager.getDecoder(this.fileManager.getEncodingName(), bl);
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> iterable) {
            String string;
            String string2 = this.entry.getName();
            if (this.zfIndex.symbolFilePrefix != null && string2.startsWith(string = this.zfIndex.symbolFilePrefix.path)) {
                string2 = string2.substring(string.length());
            }
            return ZipFileIndexFileObject.removeExtension(string2).replace('/', '.');
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            string.getClass();
            if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
                return false;
            }
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(kind.extension);
            return this.name.equals(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ZipFileIndexFileObject)) {
                return false;
            }
            ZipFileIndexFileObject zipFileIndexFileObject = (ZipFileIndexFileObject)object;
            return this.zfIndex.getAbsoluteFile().equals(zipFileIndexFileObject.zfIndex.getAbsoluteFile()) && this.name.equals(zipFileIndexFileObject.name);
        }

        @Override
        public int hashCode() {
            return this.zfIndex.getAbsoluteFile().hashCode() + this.name.hashCode();
        }

        private String getPrefixedEntryName() {
            if (this.zfIndex.symbolFilePrefix != null) {
                String string = String.valueOf(this.zfIndex.symbolFilePrefix.path);
                String string2 = String.valueOf(this.entry.getName());
                return string2.length() != 0 ? string.concat(string2) : new String(string);
            }
            return this.entry.getName();
        }
    }
}

