/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.CRTable;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.LVTRanges;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Bits;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Position;
import java.util.ArrayList;

public class Code {
    public final boolean debugCode;
    public final boolean needStackMap;
    final Types types;
    final Symtab syms;
    public int max_stack = 0;
    public int max_locals = 0;
    public byte[] code = new byte[64];
    public int cp = 0;
    ListBuffer<char[]> catchInfo = new ListBuffer();
    List<char[]> lineInfo = List.nil();
    public CRTable crt;
    public boolean fatcode;
    private boolean alive = true;
    State state;
    private boolean fixedPc = false;
    public int nextreg = 0;
    Chain pendingJumps = null;
    int pendingStatPos = -1;
    boolean pendingStackMap = false;
    StackMapFormat stackMap;
    boolean varDebugInfo;
    boolean lineDebugInfo;
    Position.LineMap lineMap;
    final Pool pool;
    final Symbol.MethodSymbol meth;
    final LVTRanges lvtRanges;
    StackMapFrame[] stackMapBuffer = null;
    ClassWriter.StackMapTableFrame[] stackMapTableBuffer = null;
    int stackMapBufferSize = 0;
    int lastStackMapPC = -1;
    StackMapFrame lastFrame = null;
    StackMapFrame frameBeforeLast = null;
    static final Type jsrReturnValue = new Type.JCPrimitiveType(TypeTag.INT, null);
    LocalVar[] lvar;
    LocalVar[] varBuffer;
    int varBufferSize;

    public boolean checkLimits(JCDiagnostic.DiagnosticPosition diagnosticPosition, Log log) {
        if (this.cp > 65535) {
            log.error(diagnosticPosition, "limit.code", new Object[0]);
            return true;
        }
        if (this.max_locals > 65535) {
            log.error(diagnosticPosition, "limit.locals", new Object[0]);
            return true;
        }
        if (this.max_stack > 65535) {
            log.error(diagnosticPosition, "limit.stack", new Object[0]);
            return true;
        }
        return false;
    }

    public Code(Symbol.MethodSymbol methodSymbol, boolean bl, Position.LineMap lineMap, boolean bl2, StackMapFormat stackMapFormat, boolean bl3, CRTable cRTable, Symtab symtab, Types types, Pool pool, LVTRanges lVTRanges) {
        this.meth = methodSymbol;
        this.fatcode = bl;
        this.lineMap = lineMap;
        this.lineDebugInfo = lineMap != null;
        this.varDebugInfo = bl2;
        this.crt = cRTable;
        this.syms = symtab;
        this.types = types;
        this.debugCode = bl3;
        this.stackMap = stackMapFormat;
        switch (stackMapFormat) {
            case CLDC: 
            case JSR202: {
                this.needStackMap = true;
                break;
            }
            default: {
                this.needStackMap = false;
            }
        }
        this.state = new State();
        this.lvar = new LocalVar[20];
        this.pool = pool;
        this.lvtRanges = lVTRanges;
    }

    public static int typecode(Type type) {
        switch (type.getTag()) {
            case BYTE: {
                return 5;
            }
            case SHORT: {
                return 7;
            }
            case CHAR: {
                return 6;
            }
            case INT: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case FLOAT: {
                return 2;
            }
            case DOUBLE: {
                return 3;
            }
            case BOOLEAN: {
                return 5;
            }
            case VOID: {
                return 8;
            }
            case CLASS: 
            case ARRAY: 
            case METHOD: 
            case BOT: 
            case TYPEVAR: 
            case UNINITIALIZED_THIS: 
            case UNINITIALIZED_OBJECT: {
                return 4;
            }
        }
        String string = String.valueOf(String.valueOf((Object)type.getTag()));
        throw new AssertionError((Object)new StringBuilder(9 + string.length()).append("typecode ").append(string).toString());
    }

    public static int truncate(int n) {
        switch (n) {
            case 5: 
            case 6: 
            case 7: {
                return 0;
            }
        }
        return n;
    }

    public static int width(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return 2;
            }
            case 8: {
                return 0;
            }
        }
        return 1;
    }

    public static int width(Type type) {
        return type == null ? 1 : Code.width(Code.typecode(type));
    }

    public static int width(List<Type> list) {
        int n = 0;
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            n += Code.width((Type)list2.head);
            list2 = list2.tail;
        }
        return n;
    }

    public static int arraycode(Type type) {
        switch (type.getTag()) {
            case BYTE: {
                return 8;
            }
            case BOOLEAN: {
                return 4;
            }
            case SHORT: {
                return 9;
            }
            case CHAR: {
                return 5;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 11;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case CLASS: {
                return 0;
            }
            case ARRAY: {
                return 1;
            }
        }
        String string = String.valueOf(String.valueOf(type));
        throw new AssertionError((Object)new StringBuilder(10 + string.length()).append("arraycode ").append(string).toString());
    }

    public int curCP() {
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        if (this.pendingStatPos != -1) {
            this.markStatBegin();
        }
        this.fixedPc = true;
        return this.cp;
    }

    private void emit1(int n) {
        if (!this.alive) {
            return;
        }
        this.code = ArrayUtils.ensureCapacity(this.code, this.cp);
        this.code[this.cp++] = (byte)n;
    }

    private void emit2(int n) {
        if (!this.alive) {
            return;
        }
        if (this.cp + 2 > this.code.length) {
            this.emit1(n >> 8);
            this.emit1(n);
        } else {
            this.code[this.cp++] = (byte)(n >> 8);
            this.code[this.cp++] = (byte)n;
        }
    }

    public void emit4(int n) {
        if (!this.alive) {
            return;
        }
        if (this.cp + 4 > this.code.length) {
            this.emit1(n >> 24);
            this.emit1(n >> 16);
            this.emit1(n >> 8);
            this.emit1(n);
        } else {
            this.code[this.cp++] = (byte)(n >> 24);
            this.code[this.cp++] = (byte)(n >> 16);
            this.code[this.cp++] = (byte)(n >> 8);
            this.code[this.cp++] = (byte)n;
        }
    }

    private void emitop(int n) {
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        if (this.alive) {
            if (this.pendingStatPos != -1) {
                this.markStatBegin();
            }
            if (this.pendingStackMap) {
                this.pendingStackMap = false;
                this.emitStackMap();
            }
            if (this.debugCode) {
                int n2 = this.cp;
                int n3 = this.state.stacksize;
                String string = String.valueOf(String.valueOf(Code.mnem(n)));
                System.err.println(new StringBuilder(36 + string.length()).append("emit@").append(n2).append(" stack=").append(n3).append(": ").append(string).toString());
            }
            this.emit1(n);
        }
    }

    void postop() {
        Assert.check(this.alive || this.state.stacksize == 0);
    }

    public void emitLdc(int n) {
        if (n <= 255) {
            this.emitop1(18, n);
        } else {
            this.emitop2(19, n);
        }
    }

    public void emitMultianewarray(int n, int n2, Type type) {
        this.emitop(197);
        if (!this.alive) {
            return;
        }
        this.emit2(n2);
        this.emit1(n);
        this.state.pop(n);
        this.state.push(type);
    }

    public void emitNewarray(int n, Type type) {
        this.emitop(188);
        if (!this.alive) {
            return;
        }
        this.emit1(n);
        this.state.pop(1);
        this.state.push(type);
    }

    public void emitAnewarray(int n, Type type) {
        this.emitop(189);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        this.state.pop(1);
        this.state.push(type);
    }

    public void emitInvokeinterface(int n, Type type) {
        int n2 = Code.width(type.getParameterTypes());
        this.emitop(185);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        this.emit1(n2 + 1);
        this.emit1(0);
        this.state.pop(n2 + 1);
        this.state.push(type.getReturnType());
    }

    public void emitInvokespecial(int n, Type type) {
        int n2 = Code.width(type.getParameterTypes());
        this.emitop(183);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        Symbol symbol = (Symbol)this.pool.pool[n];
        this.state.pop(n2);
        if (symbol.isConstructor()) {
            this.state.markInitialized((UninitializedType)this.state.peek());
        }
        this.state.pop(1);
        this.state.push(type.getReturnType());
    }

    public void emitInvokestatic(int n, Type type) {
        int n2 = Code.width(type.getParameterTypes());
        this.emitop(184);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        this.state.pop(n2);
        this.state.push(type.getReturnType());
    }

    public void emitInvokevirtual(int n, Type type) {
        int n2 = Code.width(type.getParameterTypes());
        this.emitop(182);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        this.state.pop(n2 + 1);
        this.state.push(type.getReturnType());
    }

    public void emitInvokedynamic(int n, Type type) {
        int n2 = Code.width(type.getParameterTypes());
        this.emitop(186);
        if (!this.alive) {
            return;
        }
        this.emit2(n);
        this.emit2(0);
        this.state.pop(n2);
        this.state.push(type.getReturnType());
    }

    public void emitop0(int n) {
        this.emitop(n);
        if (!this.alive) {
            return;
        }
        switch (n) {
            case 50: {
                this.state.pop(1);
                Type type = this.state.stack[this.state.stacksize - 1];
                this.state.pop(1);
                Type type2 = type.hasTag(TypeTag.BOT) ? this.syms.objectType : this.types.erasure(this.types.elemtype(type));
                this.state.push(type2);
                break;
            }
            case 167: {
                this.markDead();
                break;
            }
            case 0: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                break;
            }
            case 1: {
                this.state.push(this.syms.botType);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.state.push(this.syms.intType);
                break;
            }
            case 9: 
            case 10: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.state.push(this.syms.longType);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.state.push(this.syms.floatType);
                break;
            }
            case 14: 
            case 15: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.state.push(this.syms.doubleType);
                break;
            }
            case 42: {
                this.state.push(this.lvar[0].sym.type);
                break;
            }
            case 43: {
                this.state.push(this.lvar[1].sym.type);
                break;
            }
            case 44: {
                this.state.push(this.lvar[2].sym.type);
                break;
            }
            case 45: {
                this.state.push(this.lvar[3].sym.type);
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 47: {
                this.state.pop(2);
                this.state.push(this.syms.longType);
                break;
            }
            case 48: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 49: {
                this.state.pop(2);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 87: 
            case 121: 
            case 123: 
            case 125: {
                this.state.pop(1);
                break;
            }
            case 172: 
            case 174: 
            case 176: {
                Assert.check(this.state.nlocks == 0);
                this.state.pop(1);
                this.markDead();
                break;
            }
            case 191: {
                this.state.pop(1);
                this.markDead();
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 88: {
                this.state.pop(2);
                break;
            }
            case 173: 
            case 175: {
                Assert.check(this.state.nlocks == 0);
                this.state.pop(2);
                this.markDead();
                break;
            }
            case 89: {
                this.state.push(this.state.stack[this.state.stacksize - 1]);
                break;
            }
            case 177: {
                Assert.check(this.state.nlocks == 0);
                this.markDead();
                break;
            }
            case 190: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                this.state.pop(1);
                break;
            }
            case 83: {
                this.state.pop(3);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.state.pop(2);
                break;
            }
            case 148: {
                this.state.pop(4);
                this.state.push(this.syms.intType);
                break;
            }
            case 136: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 133: {
                this.state.pop(1);
                this.state.push(this.syms.longType);
                break;
            }
            case 134: {
                this.state.pop(1);
                this.state.push(this.syms.floatType);
                break;
            }
            case 135: {
                this.state.pop(1);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 137: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 138: {
                this.state.pop(2);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 139: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 140: {
                this.state.pop(1);
                this.state.push(this.syms.longType);
                break;
            }
            case 141: {
                this.state.pop(1);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 142: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 143: {
                this.state.pop(2);
                this.state.push(this.syms.longType);
                break;
            }
            case 144: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 170: 
            case 171: {
                this.state.pop(1);
                break;
            }
            case 90: {
                Type type = this.state.pop1();
                Type type3 = this.state.pop1();
                this.state.push(type);
                this.state.push(type3);
                this.state.push(type);
                break;
            }
            case 84: {
                this.state.pop(3);
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                this.state.pop(1);
                break;
            }
            case 79: 
            case 81: 
            case 85: 
            case 86: {
                this.state.pop(3);
                break;
            }
            case 80: 
            case 82: {
                this.state.pop(4);
                break;
            }
            case 92: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type type = this.state.pop1();
                    Type type4 = this.state.pop1();
                    this.state.push(type4);
                    this.state.push(type);
                    this.state.push(type4);
                    this.state.push(type);
                    break;
                }
                Type type = this.state.pop2();
                this.state.push(type);
                this.state.push(type);
                break;
            }
            case 93: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type type = this.state.pop1();
                    Type type5 = this.state.pop1();
                    Type type6 = this.state.pop1();
                    this.state.push(type5);
                    this.state.push(type);
                    this.state.push(type6);
                    this.state.push(type5);
                    this.state.push(type);
                    break;
                }
                Type type = this.state.pop2();
                Type type7 = this.state.pop1();
                this.state.push(type);
                this.state.push(type7);
                this.state.push(type);
                break;
            }
            case 94: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type type = this.state.pop1();
                    Type type8 = this.state.pop1();
                    if (this.state.stack[this.state.stacksize - 1] != null) {
                        Type type9 = this.state.pop1();
                        Type type10 = this.state.pop1();
                        this.state.push(type8);
                        this.state.push(type);
                        this.state.push(type10);
                        this.state.push(type9);
                        this.state.push(type8);
                        this.state.push(type);
                        break;
                    }
                    Type type11 = this.state.pop2();
                    this.state.push(type8);
                    this.state.push(type);
                    this.state.push(type11);
                    this.state.push(type8);
                    this.state.push(type);
                    break;
                }
                Type type = this.state.pop2();
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type type12 = this.state.pop1();
                    Type type13 = this.state.pop1();
                    this.state.push(type);
                    this.state.push(type13);
                    this.state.push(type12);
                    this.state.push(type);
                    break;
                }
                Type type14 = this.state.pop2();
                this.state.push(type);
                this.state.push(type14);
                this.state.push(type);
                break;
            }
            case 91: {
                Type type = this.state.pop1();
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type type15 = this.state.pop1();
                    Type type16 = this.state.pop1();
                    this.state.push(type);
                    this.state.push(type16);
                    this.state.push(type15);
                    this.state.push(type);
                    break;
                }
                Type type17 = this.state.pop2();
                this.state.push(type);
                this.state.push(type17);
                this.state.push(type);
                break;
            }
            case 149: 
            case 150: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 151: 
            case 152: {
                this.state.pop(4);
                this.state.push(this.syms.intType);
                break;
            }
            case 95: {
                Type type = this.state.pop1();
                Type type18 = this.state.pop1();
                this.state.push(type);
                this.state.push(type18);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.state.pop(2);
                break;
            }
            case 169: {
                this.markDead();
                break;
            }
            case 196: {
                return;
            }
            case 194: 
            case 195: {
                this.state.pop(1);
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
        this.postop();
    }

    public void emitop1(int n, int n2) {
        this.emitop(n);
        if (!this.alive) {
            return;
        }
        this.emit1(n2);
        switch (n) {
            case 16: {
                this.state.push(this.syms.intType);
                break;
            }
            case 18: {
                this.state.push(this.typeForPool(this.pool.pool[n2]));
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
        this.postop();
    }

    private Type typeForPool(Object object) {
        Object object2;
        if (object instanceof Integer) {
            return this.syms.intType;
        }
        if (object instanceof Float) {
            return this.syms.floatType;
        }
        if (object instanceof String) {
            return this.syms.stringType;
        }
        if (object instanceof Long) {
            return this.syms.longType;
        }
        if (object instanceof Double) {
            return this.syms.doubleType;
        }
        if (object instanceof Symbol.ClassSymbol) {
            return this.syms.classType;
        }
        if (object instanceof Pool.MethodHandle) {
            return this.syms.methodHandleType;
        }
        if (object instanceof Types.UniqueType) {
            return this.typeForPool(((Types.UniqueType)object).type);
        }
        if (object instanceof Type) {
            object2 = ((Type)object).unannotatedType();
            if (object2 instanceof Type.ArrayType) {
                return this.syms.classType;
            }
            if (object2 instanceof Type.MethodType) {
                return this.syms.methodTypeType;
            }
        }
        object2 = String.valueOf(String.valueOf(object.getClass()));
        throw new AssertionError((Object)new StringBuilder(37 + ((String)object2).length()).append("Invalid type of constant pool entry: ").append((String)object2).toString());
    }

    public void emitop1w(int n, int n2) {
        if (n2 > 255) {
            this.emitop(196);
            this.emitop(n);
            this.emit2(n2);
        } else {
            this.emitop(n);
            this.emit1(n2);
        }
        if (!this.alive) {
            return;
        }
        switch (n) {
            case 21: {
                this.state.push(this.syms.intType);
                break;
            }
            case 22: {
                this.state.push(this.syms.longType);
                break;
            }
            case 23: {
                this.state.push(this.syms.floatType);
                break;
            }
            case 24: {
                this.state.push(this.syms.doubleType);
                break;
            }
            case 25: {
                this.state.push(this.lvar[n2].sym.type);
                break;
            }
            case 55: 
            case 57: {
                this.state.pop(2);
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                this.state.pop(1);
                break;
            }
            case 169: {
                this.markDead();
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
        this.postop();
    }

    public void emitop1w(int n, int n2, int n3) {
        if (n2 > 255 || n3 < -128 || n3 > 127) {
            this.emitop(196);
            this.emitop(n);
            this.emit2(n2);
            this.emit2(n3);
        } else {
            this.emitop(n);
            this.emit1(n2);
            this.emit1(n3);
        }
        if (!this.alive) {
            return;
        }
        switch (n) {
            case 132: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
    }

    public void emitop2(int n, int n2) {
        this.emitop(n);
        if (!this.alive) {
            return;
        }
        this.emit2(n2);
        switch (n) {
            case 178: {
                this.state.push(((Symbol)this.pool.pool[n2]).erasure(this.types));
                break;
            }
            case 179: {
                this.state.pop(((Symbol)this.pool.pool[n2]).erasure(this.types));
                break;
            }
            case 187: {
                Symbol symbol = this.pool.pool[n2] instanceof Types.UniqueType ? ((Types.UniqueType)this.pool.pool[n2]).type.tsym : (Symbol)this.pool.pool[n2];
                this.state.push(UninitializedType.uninitializedObject(symbol.erasure(this.types), this.cp - 3));
                break;
            }
            case 17: {
                this.state.push(this.syms.intType);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.state.pop(1);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.state.pop(2);
                break;
            }
            case 167: {
                this.markDead();
                break;
            }
            case 181: {
                this.state.pop(((Symbol)this.pool.pool[n2]).erasure(this.types));
                this.state.pop(1);
                break;
            }
            case 180: {
                this.state.pop(1);
                this.state.push(((Symbol)this.pool.pool[n2]).erasure(this.types));
                break;
            }
            case 192: {
                this.state.pop(1);
                Object object = this.pool.pool[n2];
                Type type = object instanceof Symbol ? ((Symbol)object).erasure(this.types) : this.types.erasure(((Types.UniqueType)object).type);
                this.state.push(type);
                break;
            }
            case 20: {
                this.state.push(this.typeForPool(this.pool.pool[n2]));
                break;
            }
            case 193: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 19: {
                this.state.push(this.typeForPool(this.pool.pool[n2]));
                break;
            }
            case 168: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
    }

    public void emitop4(int n, int n2) {
        this.emitop(n);
        if (!this.alive) {
            return;
        }
        this.emit4(n2);
        switch (n) {
            case 200: {
                this.markDead();
                break;
            }
            case 201: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(n));
            }
        }
    }

    public void align(int n) {
        if (this.alive) {
            while (this.cp % n != 0) {
                this.emitop0(0);
            }
        }
    }

    private void put1(int n, int n2) {
        this.code[n] = (byte)n2;
    }

    private void put2(int n, int n2) {
        this.put1(n, n2 >> 8);
        this.put1(n + 1, n2);
    }

    public void put4(int n, int n2) {
        this.put1(n, n2 >> 24);
        this.put1(n + 1, n2 >> 16);
        this.put1(n + 2, n2 >> 8);
        this.put1(n + 3, n2);
    }

    private int get1(int n) {
        return this.code[n] & 0xFF;
    }

    private int get2(int n) {
        return this.get1(n) << 8 | this.get1(n + 1);
    }

    public int get4(int n) {
        return this.get1(n) << 24 | this.get1(n + 1) << 16 | this.get1(n + 2) << 8 | this.get1(n + 3);
    }

    public boolean isAlive() {
        return this.alive || this.pendingJumps != null;
    }

    public void markDead() {
        this.alive = false;
    }

    public int entryPoint() {
        int n = this.curCP();
        this.alive = true;
        this.pendingStackMap = this.needStackMap;
        return n;
    }

    public int entryPoint(State state) {
        int n = this.curCP();
        this.alive = true;
        this.state = state.dup();
        Assert.check(state.stacksize <= this.max_stack);
        if (this.debugCode) {
            String string = String.valueOf(String.valueOf(state));
            System.err.println(new StringBuilder(12 + string.length()).append("entry point ").append(string).toString());
        }
        this.pendingStackMap = this.needStackMap;
        return n;
    }

    public int entryPoint(State state, Type type) {
        int n = this.curCP();
        this.alive = true;
        this.state = state.dup();
        Assert.check(state.stacksize <= this.max_stack);
        this.state.push(type);
        if (this.debugCode) {
            String string = String.valueOf(String.valueOf(state));
            System.err.println(new StringBuilder(12 + string.length()).append("entry point ").append(string).toString());
        }
        this.pendingStackMap = this.needStackMap;
        return n;
    }

    public void emitStackMap() {
        int n = this.curCP();
        if (!this.needStackMap) {
            return;
        }
        switch (this.stackMap) {
            case CLDC: {
                this.emitCLDCStackMap(n, this.getLocalsSize());
                break;
            }
            case JSR202: {
                this.emitStackMapFrame(n, this.getLocalsSize());
                break;
            }
            default: {
                throw new AssertionError((Object)"Should have chosen a stackmap format");
            }
        }
        if (this.debugCode) {
            this.state.dump(n);
        }
    }

    private int getLocalsSize() {
        int n = 0;
        for (int i = this.max_locals - 1; i >= 0; --i) {
            if (!this.state.defined.isMember(i) || this.lvar[i] == null) continue;
            n = i + Code.width(this.lvar[i].sym.erasure(this.types));
            break;
        }
        return n;
    }

    void emitCLDCStackMap(int n, int n2) {
        int n3;
        if (this.lastStackMapPC == n) {
            this.stackMapBuffer[--this.stackMapBufferSize] = null;
        }
        this.lastStackMapPC = n;
        this.stackMapBuffer = this.stackMapBuffer == null ? new StackMapFrame[20] : ArrayUtils.ensureCapacity(this.stackMapBuffer, this.stackMapBufferSize);
        StackMapFrame stackMapFrame = new StackMapFrame();
        this.stackMapBuffer[this.stackMapBufferSize++] = stackMapFrame;
        StackMapFrame stackMapFrame2 = stackMapFrame;
        stackMapFrame2.pc = n;
        stackMapFrame2.locals = new Type[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            if (!this.state.defined.isMember(n3) || this.lvar[n3] == null) continue;
            Type type = this.lvar[n3].sym.type;
            if (!(type instanceof UninitializedType)) {
                type = this.types.erasure(type);
            }
            stackMapFrame2.locals[n3] = type;
        }
        stackMapFrame2.stack = new Type[this.state.stacksize];
        for (n3 = 0; n3 < this.state.stacksize; ++n3) {
            stackMapFrame2.stack[n3] = this.state.stack[n3];
        }
    }

    void emitStackMapFrame(int n, int n2) {
        if (this.lastFrame == null) {
            this.lastFrame = this.getInitialFrame();
        } else if (this.lastFrame.pc == n) {
            this.stackMapTableBuffer[--this.stackMapBufferSize] = null;
            this.lastFrame = this.frameBeforeLast;
            this.frameBeforeLast = null;
        }
        StackMapFrame stackMapFrame = new StackMapFrame();
        stackMapFrame.pc = n;
        int n3 = 0;
        Type[] typeArray = new Type[n2];
        int n4 = 0;
        while (n4 < n2) {
            if (this.state.defined.isMember(n4) && this.lvar[n4] != null) {
                Type type = this.lvar[n4].sym.type;
                if (!(type instanceof UninitializedType)) {
                    type = this.types.erasure(type);
                }
                typeArray[n4] = type;
                if (Code.width(type) > 1) {
                    ++n4;
                }
            }
            ++n4;
            ++n3;
        }
        stackMapFrame.locals = new Type[n3];
        n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            Assert.check(n5 < n3);
            stackMapFrame.locals[n5] = typeArray[n4];
            if (Code.width(typeArray[n4]) > 1) {
                ++n4;
            }
            ++n4;
            ++n5;
        }
        n4 = 0;
        for (n5 = 0; n5 < this.state.stacksize; ++n5) {
            if (this.state.stack[n5] == null) continue;
            ++n4;
        }
        stackMapFrame.stack = new Type[n4];
        n4 = 0;
        for (n5 = 0; n5 < this.state.stacksize; ++n5) {
            if (this.state.stack[n5] == null) continue;
            stackMapFrame.stack[n4++] = this.types.erasure(this.state.stack[n5]);
        }
        this.stackMapTableBuffer = this.stackMapTableBuffer == null ? new ClassWriter.StackMapTableFrame[20] : ArrayUtils.ensureCapacity(this.stackMapTableBuffer, this.stackMapBufferSize);
        this.stackMapTableBuffer[this.stackMapBufferSize++] = ClassWriter.StackMapTableFrame.getInstance(stackMapFrame, this.lastFrame.pc, this.lastFrame.locals, this.types);
        this.frameBeforeLast = this.lastFrame;
        this.lastFrame = stackMapFrame;
    }

    StackMapFrame getInitialFrame() {
        StackMapFrame stackMapFrame = new StackMapFrame();
        List<Type> list = ((Type.MethodType)this.meth.externalType((Types)this.types)).argtypes;
        int n = list.length();
        int n2 = 0;
        if (!this.meth.isStatic()) {
            Type type = this.meth.owner.type;
            stackMapFrame.locals = new Type[n + 1];
            stackMapFrame.locals[n2++] = this.meth.isConstructor() && type != this.syms.objectType ? UninitializedType.uninitializedThis(type) : this.types.erasure(type);
        } else {
            stackMapFrame.locals = new Type[n];
        }
        for (Type type : list) {
            stackMapFrame.locals[n2++] = this.types.erasure(type);
        }
        stackMapFrame.pc = -1;
        stackMapFrame.stack = null;
        return stackMapFrame;
    }

    public static int negate(int n) {
        if (n == 198) {
            return 199;
        }
        if (n == 199) {
            return 198;
        }
        return (n + 1 ^ 1) - 1;
    }

    public int emitJump(int n) {
        if (this.fatcode) {
            if (n == 167 || n == 168) {
                this.emitop4(n + 200 - 167, 0);
            } else {
                this.emitop2(Code.negate(n), 8);
                this.emitop4(200, 0);
                this.alive = true;
                this.pendingStackMap = this.needStackMap;
            }
            return this.cp - 5;
        }
        this.emitop2(n, 0);
        return this.cp - 3;
    }

    public Chain branch(int n) {
        Chain chain = null;
        if (n == 167) {
            chain = this.pendingJumps;
            this.pendingJumps = null;
        }
        if (n != 168 && this.isAlive()) {
            chain = new Chain(this.emitJump(n), chain, this.state.dup());
            this.fixedPc = this.fatcode;
            if (n == 167) {
                this.alive = false;
            }
        }
        return chain;
    }

    public void resolve(Chain chain, int n) {
        boolean bl = false;
        State state = this.state;
        while (chain != null) {
            Assert.check(this.state != chain.state && (n > chain.pc || this.state.stacksize == 0));
            if (n >= this.cp) {
                n = this.cp;
            } else if (this.get1(n) == 167) {
                n = this.fatcode ? (n += this.get4(n + 1)) : (n += this.get2(n + 1));
            }
            if (this.get1(chain.pc) == 167 && chain.pc + 3 == n && n == this.cp && !this.fixedPc) {
                if (this.varDebugInfo) {
                    this.adjustAliveRanges(this.cp, -3);
                }
                this.cp -= 3;
                n -= 3;
                if (chain.next == null) {
                    this.alive = true;
                    break;
                }
            } else {
                if (this.fatcode) {
                    this.put4(chain.pc + 1, n - chain.pc);
                } else if (n - chain.pc < Short.MIN_VALUE || n - chain.pc > Short.MAX_VALUE) {
                    this.fatcode = true;
                } else {
                    this.put2(chain.pc + 1, n - chain.pc);
                }
                Assert.check(!this.alive || chain.state.stacksize == state.stacksize && chain.state.nlocks == state.nlocks);
            }
            this.fixedPc = true;
            if (this.cp == n) {
                bl = true;
                if (this.debugCode) {
                    String string = String.valueOf(String.valueOf(chain.state));
                    System.err.println(new StringBuilder(22 + string.length()).append("resolving chain state=").append(string).toString());
                }
                if (this.alive) {
                    state = chain.state.join(state);
                } else {
                    state = chain.state;
                    this.alive = true;
                }
            }
            chain = chain.next;
        }
        Assert.check(!bl || this.state != state);
        if (this.state != state) {
            this.setDefined(state.defined);
            this.state = state;
            this.pendingStackMap = this.needStackMap;
        }
    }

    public void resolve(Chain chain) {
        Assert.check(!this.alive || chain == null || this.state.stacksize == chain.state.stacksize && this.state.nlocks == chain.state.nlocks);
        this.pendingJumps = Code.mergeChains(chain, this.pendingJumps);
    }

    public void resolvePending() {
        Chain chain = this.pendingJumps;
        this.pendingJumps = null;
        this.resolve(chain, this.cp);
    }

    public static Chain mergeChains(Chain chain, Chain chain2) {
        if (chain2 == null) {
            return chain;
        }
        if (chain == null) {
            return chain2;
        }
        Assert.check(chain.state.stacksize == chain2.state.stacksize && chain.state.nlocks == chain2.state.nlocks);
        if (chain.pc < chain2.pc) {
            return new Chain(chain2.pc, Code.mergeChains(chain, chain2.next), chain2.state);
        }
        return new Chain(chain.pc, Code.mergeChains(chain.next, chain2), chain.state);
    }

    public void addCatch(char c, char c2, char c3, char c4) {
        this.catchInfo.append(new char[]{c, c2, c3, c4});
    }

    public void compressCatchTable() {
        ListBuffer<char[]> listBuffer = new ListBuffer<char[]>();
        List<Object> list = List.nil();
        for (char[] cArray : this.catchInfo) {
            list = list.prepend(Integer.valueOf(cArray[2]));
        }
        for (char[] cArray : this.catchInfo) {
            char c;
            char c2 = cArray[0];
            if (c2 == (c = cArray[1]) || c2 == c - '\u0001' && list.contains(c2)) continue;
            listBuffer.append(cArray);
        }
        this.catchInfo = listBuffer;
    }

    public void addLineNumber(char c, char c2) {
        if (this.lineDebugInfo) {
            if (this.lineInfo.nonEmpty() && ((char[])this.lineInfo.head)[0] == c) {
                this.lineInfo = this.lineInfo.tail;
            }
            if (this.lineInfo.isEmpty() || ((char[])this.lineInfo.head)[1] != c2) {
                this.lineInfo = this.lineInfo.prepend(new char[]{c, c2});
            }
        }
    }

    public void statBegin(int n) {
        if (n != -1) {
            this.pendingStatPos = n;
        }
    }

    public void markStatBegin() {
        if (this.alive && this.lineDebugInfo) {
            int n = this.lineMap.getLineNumber(this.pendingStatPos);
            char c = (char)this.cp;
            char c2 = (char)n;
            if (c == this.cp && c2 == n) {
                this.addLineNumber(c, c2);
            }
        }
        this.pendingStatPos = -1;
    }

    private void addLocalVar(Symbol.VarSymbol varSymbol) {
        int n = varSymbol.adr;
        this.lvar = ArrayUtils.ensureCapacity(this.lvar, n + 1);
        Assert.checkNull(this.lvar[n]);
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        this.lvar[n] = new LocalVar(varSymbol);
        this.state.defined.excl(n);
    }

    public void closeAliveRanges(JCTree jCTree) {
        this.closeAliveRanges(jCTree, this.cp);
    }

    public void closeAliveRanges(JCTree jCTree, int n) {
        List<Symbol.VarSymbol> list = this.lvtRanges.getVars(this.meth, jCTree);
        for (LocalVar localVar : this.lvar) {
            for (Symbol.VarSymbol varSymbol : list) {
                char c;
                if (localVar == null) {
                    return;
                }
                if (localVar.sym != varSymbol || localVar.lastRange() == null || (c = (char)(n - localVar.lastRange().start_pc)) <= '\u0000' || c >= '\uffff') continue;
                localVar.closeRange(c);
            }
        }
    }

    void adjustAliveRanges(int n, int n2) {
        for (LocalVar localVar : this.lvar) {
            if (localVar == null) {
                return;
            }
            for (LocalVar.Range range : localVar.aliveRanges) {
                if (!range.closed() || range.start_pc + range.length < n) continue;
                range.length = (char)(range.length + n2);
            }
        }
    }

    public int getLVTSize() {
        int n = this.varBufferSize;
        for (int i = 0; i < this.varBufferSize; ++i) {
            LocalVar localVar = this.varBuffer[i];
            n += localVar.aliveRanges.size() - 1;
        }
        return n;
    }

    public void setDefined(Bits bits) {
        if (this.alive && bits != this.state.defined) {
            Bits bits2 = new Bits(this.state.defined).xorSet(bits);
            int n = bits2.nextBit(0);
            while (n >= 0) {
                if (n >= this.nextreg) {
                    this.state.defined.excl(n);
                } else if (this.state.defined.isMember(n)) {
                    this.setUndefined(n);
                } else {
                    this.setDefined(n);
                }
                n = bits2.nextBit(n + 1);
            }
        }
    }

    public void setDefined(int n) {
        LocalVar localVar = this.lvar[n];
        if (localVar == null) {
            this.state.defined.excl(n);
        } else {
            this.state.defined.incl(n);
            if (this.cp < 65535) {
                localVar.openRange((char)this.cp);
            }
        }
    }

    public void setUndefined(int n) {
        this.state.defined.excl(n);
        if (n < this.lvar.length && this.lvar[n] != null && this.lvar[n].isLastRangeInitialized()) {
            LocalVar localVar = this.lvar[n];
            char c = (char)(this.curCP() - localVar.lastRange().start_pc);
            if (c > '\u0000' && c < '\uffff') {
                this.lvar[n] = localVar.dup();
                localVar.closeRange(c);
                this.putVar(localVar);
            } else {
                localVar.lastRange().start_pc = (char)65535;
            }
        }
    }

    private void endScope(int n) {
        LocalVar localVar = this.lvar[n];
        if (localVar != null) {
            char c;
            if (localVar.isLastRangeInitialized() && (c = (char)(this.curCP() - localVar.lastRange().start_pc)) < '\uffff') {
                localVar.closeRange(c);
                this.putVar(localVar);
                this.fillLocalVarPosition(localVar);
            }
            this.lvar[n] = null;
        }
        this.state.defined.excl(n);
    }

    private void fillLocalVarPosition(LocalVar localVar) {
        if (localVar == null || localVar.sym == null || !localVar.sym.hasTypeAnnotations()) {
            return;
        }
        for (Attribute.TypeCompound typeCompound : localVar.sym.getRawTypeAttributes()) {
            TypeAnnotationPosition typeAnnotationPosition = typeCompound.position;
            LocalVar.Range range = localVar.getWidestRange();
            typeAnnotationPosition.lvarOffset = new int[]{range.start_pc};
            typeAnnotationPosition.lvarLength = new int[]{range.length};
            typeAnnotationPosition.lvarIndex = new int[]{localVar.reg};
            typeAnnotationPosition.isValidOffset = true;
        }
    }

    public void fillExceptionParameterPositions() {
        for (int i = 0; i < this.varBufferSize; ++i) {
            LocalVar localVar = this.varBuffer[i];
            if (localVar == null || localVar.sym == null || !localVar.sym.hasTypeAnnotations() || !localVar.sym.isExceptionParameter()) continue;
            for (Attribute.TypeCompound typeCompound : localVar.sym.getRawTypeAttributes()) {
                TypeAnnotationPosition typeAnnotationPosition = typeCompound.position;
                if (typeAnnotationPosition.type_index == -666) continue;
                typeAnnotationPosition.exception_index = this.findExceptionIndex(typeAnnotationPosition.type_index);
                typeAnnotationPosition.type_index = -666;
            }
        }
    }

    private int findExceptionIndex(int n) {
        if (n == Integer.MIN_VALUE) {
            return -1;
        }
        List<Object> list = this.catchInfo.toList();
        int n2 = this.catchInfo.length();
        for (int i = 0; i < n2; ++i) {
            char[] cArray = (char[])list.head;
            list = list.tail;
            char c = cArray[3];
            if (n != c) continue;
            return i;
        }
        return -1;
    }

    void putVar(LocalVar localVar) {
        if (!(this.varDebugInfo || localVar.sym.isExceptionParameter() && !localVar.sym.hasTypeAnnotations())) {
            return;
        }
        if ((localVar.sym.flags() & 0x1000L) != 0L) {
            return;
        }
        this.varBuffer = this.varBuffer == null ? new LocalVar[20] : ArrayUtils.ensureCapacity(this.varBuffer, this.varBufferSize);
        this.varBuffer[this.varBufferSize++] = localVar;
    }

    private int newLocal(int n) {
        int n2 = this.nextreg;
        int n3 = Code.width(n);
        this.nextreg = n2 + n3;
        if (this.nextreg > this.max_locals) {
            this.max_locals = this.nextreg;
        }
        return n2;
    }

    private int newLocal(Type type) {
        return this.newLocal(Code.typecode(type));
    }

    public int newLocal(Symbol.VarSymbol varSymbol) {
        int n = varSymbol.adr = this.newLocal(varSymbol.erasure(this.types));
        this.addLocalVar(varSymbol);
        return n;
    }

    public void newRegSegment() {
        this.nextreg = this.max_locals;
    }

    public void endScopes(int n) {
        int n2 = this.nextreg;
        for (int i = this.nextreg = n; i < n2; ++i) {
            this.endScope(i);
        }
    }

    public static String mnem(int n) {
        return Mneumonics.mnem[n];
    }

    private static class Mneumonics {
        private static final String[] mnem = new String[203];

        private Mneumonics() {
        }

        static {
            Mneumonics.mnem[0] = "nop";
            Mneumonics.mnem[1] = "aconst_null";
            Mneumonics.mnem[2] = "iconst_m1";
            Mneumonics.mnem[3] = "iconst_0";
            Mneumonics.mnem[4] = "iconst_1";
            Mneumonics.mnem[5] = "iconst_2";
            Mneumonics.mnem[6] = "iconst_3";
            Mneumonics.mnem[7] = "iconst_4";
            Mneumonics.mnem[8] = "iconst_5";
            Mneumonics.mnem[9] = "lconst_0";
            Mneumonics.mnem[10] = "lconst_1";
            Mneumonics.mnem[11] = "fconst_0";
            Mneumonics.mnem[12] = "fconst_1";
            Mneumonics.mnem[13] = "fconst_2";
            Mneumonics.mnem[14] = "dconst_0";
            Mneumonics.mnem[15] = "dconst_1";
            Mneumonics.mnem[16] = "bipush";
            Mneumonics.mnem[17] = "sipush";
            Mneumonics.mnem[18] = "ldc1";
            Mneumonics.mnem[19] = "ldc2";
            Mneumonics.mnem[20] = "ldc2w";
            Mneumonics.mnem[21] = "iload";
            Mneumonics.mnem[22] = "lload";
            Mneumonics.mnem[23] = "fload";
            Mneumonics.mnem[24] = "dload";
            Mneumonics.mnem[25] = "aload";
            Mneumonics.mnem[26] = "iload_0";
            Mneumonics.mnem[30] = "lload_0";
            Mneumonics.mnem[34] = "fload_0";
            Mneumonics.mnem[38] = "dload_0";
            Mneumonics.mnem[42] = "aload_0";
            Mneumonics.mnem[27] = "iload_1";
            Mneumonics.mnem[31] = "lload_1";
            Mneumonics.mnem[35] = "fload_1";
            Mneumonics.mnem[39] = "dload_1";
            Mneumonics.mnem[43] = "aload_1";
            Mneumonics.mnem[28] = "iload_2";
            Mneumonics.mnem[32] = "lload_2";
            Mneumonics.mnem[36] = "fload_2";
            Mneumonics.mnem[40] = "dload_2";
            Mneumonics.mnem[44] = "aload_2";
            Mneumonics.mnem[29] = "iload_3";
            Mneumonics.mnem[33] = "lload_3";
            Mneumonics.mnem[37] = "fload_3";
            Mneumonics.mnem[41] = "dload_3";
            Mneumonics.mnem[45] = "aload_3";
            Mneumonics.mnem[46] = "iaload";
            Mneumonics.mnem[47] = "laload";
            Mneumonics.mnem[48] = "faload";
            Mneumonics.mnem[49] = "daload";
            Mneumonics.mnem[50] = "aaload";
            Mneumonics.mnem[51] = "baload";
            Mneumonics.mnem[52] = "caload";
            Mneumonics.mnem[53] = "saload";
            Mneumonics.mnem[54] = "istore";
            Mneumonics.mnem[55] = "lstore";
            Mneumonics.mnem[56] = "fstore";
            Mneumonics.mnem[57] = "dstore";
            Mneumonics.mnem[58] = "astore";
            Mneumonics.mnem[59] = "istore_0";
            Mneumonics.mnem[63] = "lstore_0";
            Mneumonics.mnem[67] = "fstore_0";
            Mneumonics.mnem[71] = "dstore_0";
            Mneumonics.mnem[75] = "astore_0";
            Mneumonics.mnem[60] = "istore_1";
            Mneumonics.mnem[64] = "lstore_1";
            Mneumonics.mnem[68] = "fstore_1";
            Mneumonics.mnem[72] = "dstore_1";
            Mneumonics.mnem[76] = "astore_1";
            Mneumonics.mnem[61] = "istore_2";
            Mneumonics.mnem[65] = "lstore_2";
            Mneumonics.mnem[69] = "fstore_2";
            Mneumonics.mnem[73] = "dstore_2";
            Mneumonics.mnem[77] = "astore_2";
            Mneumonics.mnem[62] = "istore_3";
            Mneumonics.mnem[66] = "lstore_3";
            Mneumonics.mnem[70] = "fstore_3";
            Mneumonics.mnem[74] = "dstore_3";
            Mneumonics.mnem[78] = "astore_3";
            Mneumonics.mnem[79] = "iastore";
            Mneumonics.mnem[80] = "lastore";
            Mneumonics.mnem[81] = "fastore";
            Mneumonics.mnem[82] = "dastore";
            Mneumonics.mnem[83] = "aastore";
            Mneumonics.mnem[84] = "bastore";
            Mneumonics.mnem[85] = "castore";
            Mneumonics.mnem[86] = "sastore";
            Mneumonics.mnem[87] = "pop";
            Mneumonics.mnem[88] = "pop2";
            Mneumonics.mnem[89] = "dup";
            Mneumonics.mnem[90] = "dup_x1";
            Mneumonics.mnem[91] = "dup_x2";
            Mneumonics.mnem[92] = "dup2";
            Mneumonics.mnem[93] = "dup2_x1";
            Mneumonics.mnem[94] = "dup2_x2";
            Mneumonics.mnem[95] = "swap";
            Mneumonics.mnem[96] = "iadd";
            Mneumonics.mnem[97] = "ladd";
            Mneumonics.mnem[98] = "fadd";
            Mneumonics.mnem[99] = "dadd";
            Mneumonics.mnem[100] = "isub";
            Mneumonics.mnem[101] = "lsub";
            Mneumonics.mnem[102] = "fsub";
            Mneumonics.mnem[103] = "dsub";
            Mneumonics.mnem[104] = "imul";
            Mneumonics.mnem[105] = "lmul";
            Mneumonics.mnem[106] = "fmul";
            Mneumonics.mnem[107] = "dmul";
            Mneumonics.mnem[108] = "idiv";
            Mneumonics.mnem[109] = "ldiv";
            Mneumonics.mnem[110] = "fdiv";
            Mneumonics.mnem[111] = "ddiv";
            Mneumonics.mnem[112] = "imod";
            Mneumonics.mnem[113] = "lmod";
            Mneumonics.mnem[114] = "fmod";
            Mneumonics.mnem[115] = "dmod";
            Mneumonics.mnem[116] = "ineg";
            Mneumonics.mnem[117] = "lneg";
            Mneumonics.mnem[118] = "fneg";
            Mneumonics.mnem[119] = "dneg";
            Mneumonics.mnem[120] = "ishl";
            Mneumonics.mnem[121] = "lshl";
            Mneumonics.mnem[122] = "ishr";
            Mneumonics.mnem[123] = "lshr";
            Mneumonics.mnem[124] = "iushr";
            Mneumonics.mnem[125] = "lushr";
            Mneumonics.mnem[126] = "iand";
            Mneumonics.mnem[127] = "land";
            Mneumonics.mnem[128] = "ior";
            Mneumonics.mnem[129] = "lor";
            Mneumonics.mnem[130] = "ixor";
            Mneumonics.mnem[131] = "lxor";
            Mneumonics.mnem[132] = "iinc";
            Mneumonics.mnem[133] = "i2l";
            Mneumonics.mnem[134] = "i2f";
            Mneumonics.mnem[135] = "i2d";
            Mneumonics.mnem[136] = "l2i";
            Mneumonics.mnem[137] = "l2f";
            Mneumonics.mnem[138] = "l2d";
            Mneumonics.mnem[139] = "f2i";
            Mneumonics.mnem[140] = "f2l";
            Mneumonics.mnem[141] = "f2d";
            Mneumonics.mnem[142] = "d2i";
            Mneumonics.mnem[143] = "d2l";
            Mneumonics.mnem[144] = "d2f";
            Mneumonics.mnem[145] = "int2byte";
            Mneumonics.mnem[146] = "int2char";
            Mneumonics.mnem[147] = "int2short";
            Mneumonics.mnem[148] = "lcmp";
            Mneumonics.mnem[149] = "fcmpl";
            Mneumonics.mnem[150] = "fcmpg";
            Mneumonics.mnem[151] = "dcmpl";
            Mneumonics.mnem[152] = "dcmpg";
            Mneumonics.mnem[153] = "ifeq";
            Mneumonics.mnem[154] = "ifne";
            Mneumonics.mnem[155] = "iflt";
            Mneumonics.mnem[156] = "ifge";
            Mneumonics.mnem[157] = "ifgt";
            Mneumonics.mnem[158] = "ifle";
            Mneumonics.mnem[159] = "if_icmpeq";
            Mneumonics.mnem[160] = "if_icmpne";
            Mneumonics.mnem[161] = "if_icmplt";
            Mneumonics.mnem[162] = "if_icmpge";
            Mneumonics.mnem[163] = "if_icmpgt";
            Mneumonics.mnem[164] = "if_icmple";
            Mneumonics.mnem[165] = "if_acmpeq";
            Mneumonics.mnem[166] = "if_acmpne";
            Mneumonics.mnem[167] = "goto_";
            Mneumonics.mnem[168] = "jsr";
            Mneumonics.mnem[169] = "ret";
            Mneumonics.mnem[170] = "tableswitch";
            Mneumonics.mnem[171] = "lookupswitch";
            Mneumonics.mnem[172] = "ireturn";
            Mneumonics.mnem[173] = "lreturn";
            Mneumonics.mnem[174] = "freturn";
            Mneumonics.mnem[175] = "dreturn";
            Mneumonics.mnem[176] = "areturn";
            Mneumonics.mnem[177] = "return_";
            Mneumonics.mnem[178] = "getstatic";
            Mneumonics.mnem[179] = "putstatic";
            Mneumonics.mnem[180] = "getfield";
            Mneumonics.mnem[181] = "putfield";
            Mneumonics.mnem[182] = "invokevirtual";
            Mneumonics.mnem[183] = "invokespecial";
            Mneumonics.mnem[184] = "invokestatic";
            Mneumonics.mnem[185] = "invokeinterface";
            Mneumonics.mnem[186] = "invokedynamic";
            Mneumonics.mnem[187] = "new_";
            Mneumonics.mnem[188] = "newarray";
            Mneumonics.mnem[189] = "anewarray";
            Mneumonics.mnem[190] = "arraylength";
            Mneumonics.mnem[191] = "athrow";
            Mneumonics.mnem[192] = "checkcast";
            Mneumonics.mnem[193] = "instanceof_";
            Mneumonics.mnem[194] = "monitorenter";
            Mneumonics.mnem[195] = "monitorexit";
            Mneumonics.mnem[196] = "wide";
            Mneumonics.mnem[197] = "multianewarray";
            Mneumonics.mnem[198] = "if_acmp_null";
            Mneumonics.mnem[199] = "if_acmp_nonnull";
            Mneumonics.mnem[200] = "goto_w";
            Mneumonics.mnem[201] = "jsr_w";
            Mneumonics.mnem[202] = "breakpoint";
        }
    }

    static class LocalVar {
        final Symbol.VarSymbol sym;
        final char reg;
        java.util.List<Range> aliveRanges = new ArrayList<Range>();

        LocalVar(Symbol.VarSymbol varSymbol) {
            this.sym = varSymbol;
            this.reg = (char)varSymbol.adr;
        }

        public LocalVar dup() {
            return new LocalVar(this.sym);
        }

        Range firstRange() {
            return this.aliveRanges.isEmpty() ? null : this.aliveRanges.get(0);
        }

        Range lastRange() {
            return this.aliveRanges.isEmpty() ? null : this.aliveRanges.get(this.aliveRanges.size() - 1);
        }

        public String toString() {
            if (this.aliveRanges == null) {
                return "empty local var";
            }
            StringBuilder stringBuilder = new StringBuilder().append(this.sym).append(" in register ").append((int)this.reg).append(" \n");
            for (Range range : this.aliveRanges) {
                stringBuilder.append(" starts at pc=").append(Integer.toString(range.start_pc)).append(" length=").append(Integer.toString(range.length)).append("\n");
            }
            return stringBuilder.toString();
        }

        public void openRange(char c) {
            if (!this.hasOpenRange()) {
                this.aliveRanges.add(new Range(c));
            }
        }

        public void closeRange(char c) {
            if (this.isLastRangeInitialized()) {
                Range range = this.lastRange();
                if (range != null && range.length == '\uffff') {
                    range.length = c;
                }
            } else if (!this.aliveRanges.isEmpty()) {
                this.aliveRanges.remove(this.aliveRanges.size() - 1);
            }
        }

        public boolean hasOpenRange() {
            if (this.aliveRanges.isEmpty()) {
                return false;
            }
            Range range = this.lastRange();
            return range.length == '\uffff';
        }

        public boolean isLastRangeInitialized() {
            if (this.aliveRanges.isEmpty()) {
                return false;
            }
            Range range = this.lastRange();
            return range.start_pc != '\uffff';
        }

        public Range getWidestRange() {
            if (this.aliveRanges.isEmpty()) {
                return new Range();
            }
            Range range = this.firstRange();
            Range range2 = this.lastRange();
            char c = (char)(range2.length + (range2.start_pc - range.start_pc));
            return new Range(range.start_pc, c);
        }

        class Range {
            char start_pc = (char)65535;
            char length = (char)65535;

            Range() {
            }

            Range(char c) {
                this.start_pc = c;
            }

            Range(char c, char c2) {
                this.start_pc = c;
                this.length = c2;
            }

            boolean closed() {
                return this.start_pc != '\uffff' && this.length != '\uffff';
            }

            public String toString() {
                char c = this.start_pc;
                char c2 = this.length;
                char c3 = c;
                char c4 = c2;
                return new StringBuilder(40).append("startpc = ").append((int)c3).append(" length ").append((int)c4).toString();
            }
        }
    }

    class State
    implements Cloneable {
        Bits defined = new Bits();
        Type[] stack = new Type[16];
        int stacksize;
        int[] locks;
        int nlocks;

        State() {
        }

        State dup() {
            try {
                State state = (State)super.clone();
                state.defined = new Bits(this.defined);
                state.stack = (Type[])this.stack.clone();
                if (this.locks != null) {
                    state.locks = (int[])this.locks.clone();
                }
                if (Code.this.debugCode) {
                    String string = String.valueOf(String.valueOf(this));
                    System.err.println(new StringBuilder(13 + string.length()).append("duping state ").append(string).toString());
                    this.dump();
                }
                return state;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
        }

        void lock(int n) {
            this.locks = this.locks == null ? new int[20] : ArrayUtils.ensureCapacity(this.locks, this.nlocks);
            this.locks[this.nlocks] = n;
            ++this.nlocks;
        }

        void unlock(int n) {
            --this.nlocks;
            Assert.check(this.locks[this.nlocks] == n);
            this.locks[this.nlocks] = -1;
        }

        void push(Type type) {
            if (Code.this.debugCode) {
                String string = String.valueOf(String.valueOf(type));
                System.err.println(new StringBuilder(11 + string.length()).append("   pushing ").append(string).toString());
            }
            switch (type.getTag()) {
                case VOID: {
                    return;
                }
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case BOOLEAN: {
                    type = Code.this.syms.intType;
                    break;
                }
            }
            this.stack = ArrayUtils.ensureCapacity(this.stack, this.stacksize + 2);
            this.stack[this.stacksize++] = type;
            switch (Code.width(type)) {
                case 1: {
                    break;
                }
                case 2: {
                    this.stack[this.stacksize++] = null;
                    break;
                }
                default: {
                    throw new AssertionError(type);
                }
            }
            if (this.stacksize > Code.this.max_stack) {
                Code.this.max_stack = this.stacksize;
            }
        }

        Type pop1() {
            if (Code.this.debugCode) {
                System.err.println("   popping 1");
            }
            --this.stacksize;
            Type type = this.stack[this.stacksize];
            this.stack[this.stacksize] = null;
            Assert.check(type != null && Code.width(type) == 1);
            return type;
        }

        Type peek() {
            return this.stack[this.stacksize - 1];
        }

        Type pop2() {
            if (Code.this.debugCode) {
                System.err.println("   popping 2");
            }
            this.stacksize -= 2;
            Type type = this.stack[this.stacksize];
            this.stack[this.stacksize] = null;
            Assert.check(this.stack[this.stacksize + 1] == null && type != null && Code.width(type) == 2);
            return type;
        }

        void pop(int n) {
            if (Code.this.debugCode) {
                int n2 = n;
                System.err.println(new StringBuilder(22).append("   popping ").append(n2).toString());
            }
            while (n > 0) {
                this.stack[--this.stacksize] = null;
                --n;
            }
        }

        void pop(Type type) {
            this.pop(Code.width(type));
        }

        void forceStackTop(Type type) {
            if (!Code.this.alive) {
                return;
            }
            switch (type.getTag()) {
                case CLASS: 
                case ARRAY: {
                    int n = Code.width(type);
                    Type type2 = this.stack[this.stacksize - n];
                    Assert.check(Code.this.types.isSubtype(Code.this.types.erasure(type2), Code.this.types.erasure(type)));
                    this.stack[this.stacksize - n] = type;
                    break;
                }
            }
        }

        void markInitialized(UninitializedType uninitializedType) {
            int n;
            Type type = uninitializedType.initializedType();
            for (n = 0; n < this.stacksize; ++n) {
                if (this.stack[n] != uninitializedType) continue;
                this.stack[n] = type;
            }
            for (n = 0; n < Code.this.lvar.length; ++n) {
                LocalVar localVar = Code.this.lvar[n];
                if (localVar == null || localVar.sym.type != uninitializedType) continue;
                Symbol.VarSymbol varSymbol = localVar.sym;
                varSymbol = varSymbol.clone(varSymbol.owner);
                varSymbol.type = type;
                LocalVar localVar2 = Code.this.lvar[n] = new LocalVar(varSymbol);
                localVar2.aliveRanges = localVar.aliveRanges;
            }
        }

        State join(State state) {
            int n;
            this.defined.andSet(state.defined);
            Assert.check(this.stacksize == state.stacksize && this.nlocks == state.nlocks);
            for (int i = 0; i < this.stacksize; i += n) {
                Type type = this.stack[i];
                Type type2 = state.stack[i];
                Type type3 = type == type2 ? type : (Code.this.types.isSubtype(type, type2) ? type2 : (Code.this.types.isSubtype(type2, type) ? type : this.error()));
                n = Code.width(type3);
                this.stack[i] = type3;
                if (n != 2) continue;
                Assert.checkNull(this.stack[i + 1]);
            }
            return this;
        }

        Type error() {
            throw new AssertionError((Object)"inconsistent stack types at join point");
        }

        void dump() {
            this.dump(-1);
        }

        void dump(int n) {
            int n2;
            int n3;
            String string = String.valueOf(String.valueOf(Code.this.meth.owner));
            String string2 = String.valueOf(String.valueOf(Code.this.meth));
            System.err.print(new StringBuilder(14 + string.length() + string2.length()).append("stackMap for ").append(string).append(".").append(string2).toString());
            if (n == -1) {
                System.out.println();
            } else {
                n3 = n;
                System.out.println(new StringBuilder(15).append(" at ").append(n3).toString());
            }
            System.err.println(" stack (from bottom):");
            for (n3 = 0; n3 < this.stacksize; ++n3) {
                n2 = n3;
                String string3 = String.valueOf(String.valueOf(this.stack[n3]));
                System.err.println(new StringBuilder(15 + string3.length()).append("  ").append(n2).append(": ").append(string3).toString());
            }
            n3 = 0;
            for (n2 = Code.this.max_locals - 1; n2 >= 0; --n2) {
                if (!this.defined.isMember(n2)) continue;
                n3 = n2;
                break;
            }
            if (n3 >= 0) {
                System.err.println(" locals:");
            }
            for (n2 = 0; n2 <= n3; ++n2) {
                int n4 = n2;
                System.err.print(new StringBuilder(15).append("  ").append(n4).append(": ").toString());
                if (this.defined.isMember(n2)) {
                    LocalVar localVar = Code.this.lvar[n2];
                    if (localVar == null) {
                        System.err.println("(none)");
                        continue;
                    }
                    if (localVar.sym == null) {
                        System.err.println("UNKNOWN!");
                        continue;
                    }
                    String string4 = String.valueOf(String.valueOf(localVar.sym));
                    String string5 = String.valueOf(String.valueOf(localVar.sym.erasure(Code.this.types)));
                    System.err.println(new StringBuilder(9 + string4.length() + string5.length()).append(string4).append(" of type ").append(string5).toString());
                    continue;
                }
                System.err.println("undefined");
            }
            if (this.nlocks != 0) {
                System.err.print(" locks:");
                for (n2 = 0; n2 < this.nlocks; ++n2) {
                    int n5 = this.locks[n2];
                    System.err.print(new StringBuilder(12).append(" ").append(n5).toString());
                }
                System.err.println();
            }
        }
    }

    public static class Chain {
        public final int pc;
        State state;
        public final Chain next;

        public Chain(int n, Chain chain, State state) {
            this.pc = n;
            this.next = chain;
            this.state = state;
        }
    }

    static class StackMapFrame {
        int pc;
        Type[] locals;
        Type[] stack;

        StackMapFrame() {
        }
    }

    public static enum StackMapFormat {
        NONE,
        CLDC{

            @Override
            Name getAttributeName(Names names) {
                return names.StackMap;
            }
        }
        ,
        JSR202{

            @Override
            Name getAttributeName(Names names) {
                return names.StackMapTable;
            }
        };


        Name getAttributeName(Names names) {
            return names.empty;
        }
    }
}

