/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class JNIWriter {
    protected static final Context.Key<JNIWriter> jniWriterKey = new Context.Key();
    private final JavaFileManager fileManager;
    JavacElements elements;
    JavacTypes types;
    private final Log log;
    private boolean verbose;
    private boolean checkAll;
    private Mangle mangler;
    private Context context;
    private Symtab syms;
    private String lineSep;
    private final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    public static JNIWriter instance(Context context) {
        JNIWriter jNIWriter = context.get(jniWriterKey);
        if (jNIWriter == null) {
            jNIWriter = new JNIWriter(context);
        }
        return jNIWriter;
    }

    private JNIWriter(Context context) {
        context.put(jniWriterKey, this);
        this.fileManager = context.get(JavaFileManager.class);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        this.checkAll = options.isSet("javah:full");
        this.context = context;
        this.syms = Symtab.instance(context);
        this.lineSep = System.getProperty("line.separator");
    }

    private void lazyInit() {
        if (this.mangler == null) {
            this.elements = JavacElements.instance(this.context);
            this.types = JavacTypes.instance(this.context);
            this.mangler = new Mangle(this.elements, this.types);
        }
    }

    public boolean needsHeader(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.isLocal() || (classSymbol.flags() & 0x1000L) != 0L) {
            return false;
        }
        if (this.checkAll) {
            return this.needsHeader(classSymbol.outermostClass(), true);
        }
        return this.needsHeader(classSymbol, false);
    }

    private boolean needsHeader(Symbol.ClassSymbol classSymbol, boolean bl) {
        if (classSymbol.isLocal() || (classSymbol.flags() & 0x1000L) != 0L) {
            return false;
        }
        Scope.Entry entry = classSymbol.members_field.elems;
        while (entry != null) {
            if (entry.sym.kind == 16 && (entry.sym.flags() & 0x100L) != 0L) {
                return true;
            }
            for (Attribute.Compound compound : entry.sym.getDeclarationAttributes()) {
                if (compound.type.tsym != this.syms.nativeHeaderType.tsym) continue;
                return true;
            }
            entry = entry.sibling;
        }
        if (bl) {
            entry = classSymbol.members_field.elems;
            while (entry != null) {
                if (entry.sym.kind == 2 && this.needsHeader((Symbol.ClassSymbol)entry.sym, true)) {
                    return true;
                }
                entry = entry.sibling;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject write(Symbol.ClassSymbol classSymbol) throws IOException {
        String string = classSymbol.flatName().toString();
        FileObject fileObject = this.fileManager.getFileForOutput(StandardLocation.NATIVE_HEADER_OUTPUT, "", String.valueOf(string.replaceAll("[.$]", "_")).concat(".h"), null);
        Writer writer = fileObject.openWriter();
        try {
            this.write(writer, classSymbol);
            if (this.verbose) {
                this.log.printVerbose("wrote.file", fileObject);
            }
            writer.close();
            writer = null;
        }
        finally {
            if (writer != null) {
                writer.close();
                fileObject.delete();
                fileObject = null;
            }
        }
        return fileObject;
    }

    public void write(Writer writer, Symbol.ClassSymbol classSymbol) throws IOException {
        this.lazyInit();
        try {
            String string = this.mangler.mangle(classSymbol.fullname, 1);
            this.println(writer, this.fileTop());
            this.println(writer, this.includes());
            this.println(writer, this.guardBegin(string));
            this.println(writer, this.cppGuardBegin());
            this.writeStatics(writer, classSymbol);
            this.writeMethods(writer, classSymbol, string);
            this.println(writer, this.cppGuardEnd());
            this.println(writer, this.guardEnd(string));
        }
        catch (TypeSignature.SignatureException signatureException) {
            throw new IOException(signatureException);
        }
    }

    protected void writeStatics(Writer writer, Symbol.ClassSymbol classSymbol) throws IOException {
        List<VariableElement> list = this.getAllFields(classSymbol);
        for (VariableElement variableElement : list) {
            if (!variableElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            String string = null;
            string = this.defineForStatic(classSymbol, variableElement);
            if (string == null) continue;
            this.println(writer, string);
        }
    }

    List<VariableElement> getAllFields(TypeElement typeElement) {
        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
        TypeElement typeElement2 = null;
        Stack<TypeElement> stack = new Stack<TypeElement>();
        typeElement2 = typeElement;
        while (true) {
            stack.push(typeElement2);
            TypeElement typeElement3 = (TypeElement)this.types.asElement(typeElement2.getSuperclass());
            if (typeElement3 == null) break;
            typeElement2 = typeElement3;
        }
        while (!stack.empty()) {
            typeElement2 = (TypeElement)stack.pop();
            arrayList.addAll(ElementFilter.fieldsIn(typeElement2.getEnclosedElements()));
        }
        return arrayList;
    }

    protected String defineForStatic(TypeElement typeElement, VariableElement variableElement) {
        Name name = typeElement.getQualifiedName();
        Name name2 = variableElement.getSimpleName();
        String string = this.mangler.mangle(name, 1);
        String string2 = this.mangler.mangle(name2, 2);
        Assert.check(variableElement.getModifiers().contains((Object)Modifier.STATIC));
        if (variableElement.getModifiers().contains((Object)Modifier.FINAL)) {
            Object object = null;
            object = variableElement.getConstantValue();
            if (object != null) {
                Comparable<StringBuilder> comparable;
                String string3 = null;
                if (object instanceof Integer || object instanceof Byte || object instanceof Short) {
                    string3 = String.valueOf(object.toString()).concat("L");
                } else if (object instanceof Boolean) {
                    string3 = (Boolean)object != false ? "1L" : "0L";
                } else if (object instanceof Character) {
                    comparable = (Character)object;
                    string3 = String.valueOf(String.valueOf(((Character)comparable).charValue() & 0xFFFF)).concat("L");
                } else if (object instanceof Long) {
                    string3 = this.isWindows ? String.valueOf(object.toString()).concat("i64") : String.valueOf(object.toString()).concat("LL");
                } else if (object instanceof Float) {
                    float f = ((Float)object).floatValue();
                    string3 = Float.isInfinite(f) ? String.valueOf(f < 0.0f ? "-" : "").concat("Inff") : String.valueOf(object.toString()).concat("f");
                } else if (object instanceof Double) {
                    double d = (Double)object;
                    string3 = Double.isInfinite(d) ? String.valueOf(d < 0.0 ? "-" : "").concat("InfD") : object.toString();
                }
                if (string3 != null) {
                    comparable = new StringBuilder("#undef ");
                    ((StringBuilder)comparable).append(string);
                    ((StringBuilder)comparable).append("_");
                    ((StringBuilder)comparable).append(string2);
                    ((StringBuilder)comparable).append(this.lineSep);
                    ((StringBuilder)comparable).append("#define ");
                    ((StringBuilder)comparable).append(string);
                    ((StringBuilder)comparable).append("_");
                    ((StringBuilder)comparable).append(string2);
                    ((StringBuilder)comparable).append(" ");
                    ((StringBuilder)comparable).append(string3);
                    return ((StringBuilder)comparable).toString();
                }
            }
        }
        return null;
    }

    protected void writeMethods(Writer writer, Symbol.ClassSymbol classSymbol, String string) throws IOException, TypeSignature.SignatureException {
        List<ExecutableElement> list = ElementFilter.methodsIn(classSymbol.getEnclosedElements());
        for (ExecutableElement executableElement : list) {
            if (!executableElement.getModifiers().contains((Object)Modifier.NATIVE)) continue;
            TypeMirror typeMirror = this.types.erasure(executableElement.getReturnType());
            String string2 = this.signature(executableElement);
            TypeSignature typeSignature = new TypeSignature(this.elements);
            Name name = executableElement.getSimpleName();
            boolean bl = false;
            for (ExecutableElement executableElement2 : list) {
                if (executableElement2 == executableElement || !((Object)name).equals(executableElement2.getSimpleName()) || !executableElement2.getModifiers().contains((Object)Modifier.NATIVE)) continue;
                bl = true;
            }
            this.println(writer, "/*");
            String string3 = String.valueOf(string);
            this.println(writer, string3.length() != 0 ? " * Class:     ".concat(string3) : new String(" * Class:     "));
            String string4 = String.valueOf(this.mangler.mangle(name, 2));
            this.println(writer, string4.length() != 0 ? " * Method:    ".concat(string4) : new String(" * Method:    "));
            String string5 = String.valueOf(typeSignature.getTypeSignature(string2, typeMirror));
            this.println(writer, string5.length() != 0 ? " * Signature: ".concat(string5) : new String(" * Signature: "));
            this.println(writer, " */");
            String string6 = String.valueOf(String.valueOf(this.jniType(typeMirror)));
            String object2 = String.valueOf(String.valueOf(this.mangler.mangleMethod(executableElement, classSymbol, bl ? 8 : 7)));
            this.println(writer, new StringBuilder(19 + string6.length() + object2.length()).append("JNIEXPORT ").append(string6).append(" JNICALL ").append(object2).toString());
            this.print(writer, "  (JNIEnv *, ");
            List<? extends VariableElement> list2 = executableElement.getParameters();
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
            for (VariableElement variableElement : list2) {
                arrayList.add(this.types.erasure(variableElement.asType()));
            }
            if (executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
                this.print(writer, "jclass");
            } else {
                this.print(writer, "jobject");
            }
            for (TypeMirror typeMirror2 : arrayList) {
                this.print(writer, ", ");
                this.print(writer, this.jniType(typeMirror2));
            }
            String string7 = String.valueOf(this.lineSep);
            this.println(writer, string7.length() != 0 ? ");".concat(string7) : new String(");"));
        }
    }

    String signature(ExecutableElement executableElement) {
        StringBuilder stringBuilder = new StringBuilder("(");
        String string = "";
        for (VariableElement variableElement : executableElement.getParameters()) {
            stringBuilder.append(string);
            stringBuilder.append(this.types.erasure(variableElement.asType()).toString());
            string = ",";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected final String jniType(TypeMirror typeMirror) {
        Symbol.ClassSymbol classSymbol = this.elements.getTypeElement("java.lang.Throwable");
        Symbol.ClassSymbol classSymbol2 = this.elements.getTypeElement("java.lang.Class");
        Symbol.ClassSymbol classSymbol3 = this.elements.getTypeElement("java.lang.String");
        Element element = this.types.asElement(typeMirror);
        switch (typeMirror.getKind()) {
            case ARRAY: {
                TypeMirror typeMirror2 = ((ArrayType)typeMirror).getComponentType();
                switch (typeMirror2.getKind()) {
                    case BOOLEAN: {
                        return "jbooleanArray";
                    }
                    case BYTE: {
                        return "jbyteArray";
                    }
                    case CHAR: {
                        return "jcharArray";
                    }
                    case SHORT: {
                        return "jshortArray";
                    }
                    case INT: {
                        return "jintArray";
                    }
                    case LONG: {
                        return "jlongArray";
                    }
                    case FLOAT: {
                        return "jfloatArray";
                    }
                    case DOUBLE: {
                        return "jdoubleArray";
                    }
                    case ARRAY: 
                    case DECLARED: {
                        return "jobjectArray";
                    }
                }
                throw new Error(typeMirror2.toString());
            }
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return "jboolean";
            }
            case BYTE: {
                return "jbyte";
            }
            case CHAR: {
                return "jchar";
            }
            case SHORT: {
                return "jshort";
            }
            case INT: {
                return "jint";
            }
            case LONG: {
                return "jlong";
            }
            case FLOAT: {
                return "jfloat";
            }
            case DOUBLE: {
                return "jdouble";
            }
            case DECLARED: {
                if (element.equals(classSymbol3)) {
                    return "jstring";
                }
                if (this.types.isAssignable(typeMirror, classSymbol.asType())) {
                    return "jthrowable";
                }
                if (this.types.isAssignable(typeMirror, classSymbol2.asType())) {
                    return "jclass";
                }
                return "jobject";
            }
        }
        Assert.check(false, "jni unknown type");
        return null;
    }

    protected String fileTop() {
        return "/* DO NOT EDIT THIS FILE - it is machine generated */";
    }

    protected String includes() {
        return "#include <jni.h>";
    }

    protected String cppGuardBegin() {
        String string = String.valueOf(String.valueOf(this.lineSep));
        String string2 = String.valueOf(String.valueOf(this.lineSep));
        return new StringBuilder(36 + string.length() + string2.length()).append("#ifdef __cplusplus").append(string).append("extern \"C\" {").append(string2).append("#endif").toString();
    }

    protected String cppGuardEnd() {
        String string = String.valueOf(String.valueOf(this.lineSep));
        String string2 = String.valueOf(String.valueOf(this.lineSep));
        return new StringBuilder(25 + string.length() + string2.length()).append("#ifdef __cplusplus").append(string).append("}").append(string2).append("#endif").toString();
    }

    protected String guardBegin(String string) {
        String string2 = String.valueOf(String.valueOf(string));
        String string3 = String.valueOf(String.valueOf(this.lineSep));
        String string4 = String.valueOf(String.valueOf(this.lineSep));
        String string5 = String.valueOf(String.valueOf(string));
        String string6 = String.valueOf(String.valueOf(this.lineSep));
        String string7 = String.valueOf(String.valueOf(string));
        return new StringBuilder(59 + string2.length() + string3.length() + string4.length() + string5.length() + string6.length() + string7.length()).append("/* Header for class ").append(string2).append(" */").append(string3).append(string4).append("#ifndef _Included_").append(string5).append(string6).append("#define _Included_").append(string7).toString();
    }

    protected String guardEnd(String string) {
        return "#endif";
    }

    protected void print(Writer writer, String string) throws IOException {
        writer.write(string);
    }

    protected void println(Writer writer, String string) throws IOException {
        writer.write(string);
        writer.write(this.lineSep);
    }

    private static class TypeSignature {
        Elements elems;
        private static final String SIG_VOID = "V";
        private static final String SIG_BOOLEAN = "Z";
        private static final String SIG_BYTE = "B";
        private static final String SIG_CHAR = "C";
        private static final String SIG_SHORT = "S";
        private static final String SIG_INT = "I";
        private static final String SIG_LONG = "J";
        private static final String SIG_FLOAT = "F";
        private static final String SIG_DOUBLE = "D";
        private static final String SIG_ARRAY = "[";
        private static final String SIG_CLASS = "L";

        public TypeSignature(Elements elements) {
            this.elems = elements;
        }

        public String getTypeSignature(String string) throws SignatureException {
            return this.getParamJVMSignature(string);
        }

        public String getTypeSignature(String string, TypeMirror typeMirror) throws SignatureException {
            String string2 = null;
            String string3 = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            int n = 0;
            int n2 = -1;
            int n3 = -1;
            StringTokenizer stringTokenizer = null;
            int n4 = 0;
            if (string != null) {
                n2 = string.indexOf("(");
                n3 = string.indexOf(")");
            }
            if (n2 != -1 && n3 != -1 && n2 + 1 < string.length() && n3 < string.length()) {
                string2 = string.substring(n2 + 1, n3);
            }
            if (string2 != null) {
                if (string2.indexOf(",") != -1) {
                    stringTokenizer = new StringTokenizer(string2, ",");
                    if (stringTokenizer != null) {
                        while (stringTokenizer.hasMoreTokens()) {
                            arrayList.add(stringTokenizer.nextToken());
                        }
                    }
                } else {
                    arrayList.add(string2);
                }
            }
            string3 = "(";
            while (!arrayList.isEmpty()) {
                string4 = ((String)arrayList.remove(n4)).trim();
                string5 = this.getParamJVMSignature(string4);
                if (string5 == null) continue;
                String string8 = String.valueOf(string3);
                String string9 = String.valueOf(string5);
                string3 = string9.length() != 0 ? string8.concat(string9) : new String(string8);
            }
            string3 = String.valueOf(string3).concat(")");
            string7 = "";
            if (typeMirror != null) {
                n = this.dimensions(typeMirror);
            }
            while (n-- > 0) {
                string7 = String.valueOf(string7).concat(SIG_ARRAY);
            }
            if (typeMirror != null) {
                string6 = this.qualifiedTypeName(typeMirror);
                String string10 = String.valueOf(string7);
                String string11 = String.valueOf(this.getComponentType(string6));
                string7 = string11.length() != 0 ? string10.concat(string11) : new String(string10);
            } else {
                System.out.println("Invalid return type.");
            }
            String string12 = String.valueOf(string3);
            String string13 = String.valueOf(string7);
            string3 = string13.length() != 0 ? string12.concat(string13) : new String(string12);
            return string3;
        }

        private String getParamJVMSignature(String string) throws SignatureException {
            String string2 = "";
            String string3 = "";
            if (string != null) {
                if (string.indexOf("[]") != -1) {
                    int n = string.indexOf("[]");
                    string3 = string.substring(0, n);
                    String string4 = string.substring(n);
                    if (string4 != null) {
                        while (string4.indexOf("[]") != -1) {
                            string2 = String.valueOf(string2).concat(SIG_ARRAY);
                            int n2 = string4.indexOf("]") + 1;
                            if (n2 < string4.length()) {
                                string4 = string4.substring(n2);
                                continue;
                            }
                            string4 = "";
                        }
                    }
                } else {
                    string3 = string;
                }
                String string5 = String.valueOf(string2);
                String string6 = String.valueOf(this.getComponentType(string3));
                string2 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            }
            return string2;
        }

        private String getComponentType(String string) throws SignatureException {
            String string2 = "";
            if (string != null) {
                if (string.equals("void")) {
                    String string3 = String.valueOf(string2);
                    String string4 = String.valueOf(SIG_VOID);
                    string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                } else if (string.equals("boolean")) {
                    String string5 = String.valueOf(string2);
                    String string6 = String.valueOf(SIG_BOOLEAN);
                    string2 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
                } else if (string.equals("byte")) {
                    String string7 = String.valueOf(string2);
                    String string8 = String.valueOf(SIG_BYTE);
                    string2 = string8.length() != 0 ? string7.concat(string8) : new String(string7);
                } else if (string.equals("char")) {
                    String string9 = String.valueOf(string2);
                    String string10 = String.valueOf(SIG_CHAR);
                    string2 = string10.length() != 0 ? string9.concat(string10) : new String(string9);
                } else if (string.equals("short")) {
                    String string11 = String.valueOf(string2);
                    String string12 = String.valueOf(SIG_SHORT);
                    string2 = string12.length() != 0 ? string11.concat(string12) : new String(string11);
                } else if (string.equals("int")) {
                    String string13 = String.valueOf(string2);
                    String string14 = String.valueOf(SIG_INT);
                    string2 = string14.length() != 0 ? string13.concat(string14) : new String(string13);
                } else if (string.equals("long")) {
                    String string15 = String.valueOf(string2);
                    String string16 = String.valueOf(SIG_LONG);
                    string2 = string16.length() != 0 ? string15.concat(string16) : new String(string15);
                } else if (string.equals("float")) {
                    String string17 = String.valueOf(string2);
                    String string18 = String.valueOf(SIG_FLOAT);
                    string2 = string18.length() != 0 ? string17.concat(string18) : new String(string17);
                } else if (string.equals("double")) {
                    String string19 = String.valueOf(string2);
                    String string20 = String.valueOf(SIG_DOUBLE);
                    string2 = string20.length() != 0 ? string19.concat(string20) : new String(string19);
                } else if (!string.equals("")) {
                    TypeElement typeElement = this.elems.getTypeElement(string);
                    if (typeElement == null) {
                        throw new SignatureException(string);
                    }
                    String string21 = typeElement.getQualifiedName().toString();
                    String string22 = string21.replace('.', '/');
                    string2 = String.valueOf(string2).concat(SIG_CLASS);
                    String string23 = String.valueOf(string2);
                    String string24 = String.valueOf(string22);
                    string2 = string24.length() != 0 ? string23.concat(string24) : new String(string23);
                    string2 = String.valueOf(string2).concat(";");
                }
            }
            return string2;
        }

        int dimensions(TypeMirror typeMirror) {
            if (typeMirror.getKind() != TypeKind.ARRAY) {
                return 0;
            }
            return 1 + this.dimensions(((ArrayType)typeMirror).getComponentType());
        }

        String qualifiedTypeName(TypeMirror typeMirror) {
            SimpleTypeVisitor8<Name, Void> simpleTypeVisitor8 = new SimpleTypeVisitor8<Name, Void>(){

                @Override
                public Name visitArray(ArrayType arrayType, Void void_) {
                    return arrayType.getComponentType().accept(this, void_);
                }

                @Override
                public Name visitDeclared(DeclaredType declaredType, Void void_) {
                    return ((TypeElement)declaredType.asElement()).getQualifiedName();
                }

                @Override
                public Name visitPrimitive(PrimitiveType primitiveType, Void void_) {
                    return TypeSignature.this.elems.getName(primitiveType.toString());
                }

                @Override
                public Name visitNoType(NoType noType, Void void_) {
                    if (noType.getKind() == TypeKind.VOID) {
                        return TypeSignature.this.elems.getName("void");
                    }
                    return (Name)this.defaultAction(noType, void_);
                }

                @Override
                public Name visitTypeVariable(TypeVariable typeVariable, Void void_) {
                    return typeVariable.getUpperBound().accept(this, void_);
                }
            };
            return ((Name)simpleTypeVisitor8.visit(typeMirror)).toString();
        }

        static class SignatureException
        extends Exception {
            private static final long serialVersionUID = 1L;

            SignatureException(String string) {
                super(string);
            }
        }
    }

    private static class Mangle {
        private Elements elems;
        private Types types;

        Mangle(Elements elements, Types types) {
            this.elems = elements;
            this.types = types;
        }

        public final String mangle(CharSequence charSequence, int n) {
            StringBuilder stringBuilder = new StringBuilder(100);
            int n2 = charSequence.length();
            for (int i = 0; i < n2; ++i) {
                char c = charSequence.charAt(i);
                if (Mangle.isalnum(c)) {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == '.' && n == 1) {
                    stringBuilder.append('_');
                    continue;
                }
                if (c == '$' && n == 1) {
                    stringBuilder.append('_');
                    stringBuilder.append('_');
                    continue;
                }
                if (c == '_' && n == 2) {
                    stringBuilder.append('_');
                    continue;
                }
                if (c == '_' && n == 1) {
                    stringBuilder.append('_');
                    continue;
                }
                if (n == 4) {
                    String string = null;
                    if (c == '_') {
                        string = "_1";
                    } else if (c == '.') {
                        string = "_";
                    } else if (c == ';') {
                        string = "_2";
                    } else if (c == '[') {
                        string = "_3";
                    }
                    if (string != null) {
                        stringBuilder.append(string);
                        continue;
                    }
                    stringBuilder.append(this.mangleChar(c));
                    continue;
                }
                if (n == 5) {
                    if (Mangle.isprint(c)) {
                        stringBuilder.append(c);
                        continue;
                    }
                    stringBuilder.append(this.mangleChar(c));
                    continue;
                }
                stringBuilder.append(this.mangleChar(c));
            }
            return stringBuilder.toString();
        }

        public String mangleMethod(ExecutableElement executableElement, TypeElement typeElement, int n) throws TypeSignature.SignatureException {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("Java_");
            if (n == 6) {
                stringBuilder.append(this.mangle(typeElement.getQualifiedName(), 1));
                stringBuilder.append('_');
                stringBuilder.append(this.mangle(executableElement.getSimpleName(), 3));
                stringBuilder.append("_stub");
                return stringBuilder.toString();
            }
            stringBuilder.append(this.mangle(this.getInnerQualifiedName(typeElement), 4));
            stringBuilder.append('_');
            stringBuilder.append(this.mangle(executableElement.getSimpleName(), 4));
            if (n == 8) {
                stringBuilder.append("__");
                String string = this.signature(executableElement);
                TypeSignature typeSignature = new TypeSignature(this.elems);
                String string2 = typeSignature.getTypeSignature(string, executableElement.getReturnType());
                string2 = string2.substring(1);
                string2 = string2.substring(0, string2.lastIndexOf(41));
                string2 = string2.replace('/', '.');
                stringBuilder.append(this.mangle(string2, 4));
            }
            return stringBuilder.toString();
        }

        private String getInnerQualifiedName(TypeElement typeElement) {
            return this.elems.getBinaryName(typeElement).toString();
        }

        public final String mangleChar(char c) {
            int n;
            String string = Integer.toHexString(c);
            int n2 = 5 - string.length();
            char[] cArray = new char[6];
            cArray[0] = 95;
            for (n = 1; n <= n2; ++n) {
                cArray[n] = 48;
            }
            n = n2 + 1;
            int n3 = 0;
            while (n < 6) {
                cArray[n] = string.charAt(n3);
                ++n;
                ++n3;
            }
            return new String(cArray);
        }

        private String signature(ExecutableElement executableElement) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "(";
            for (VariableElement variableElement : executableElement.getParameters()) {
                stringBuilder.append(string);
                stringBuilder.append(this.types.erasure(variableElement.asType()).toString());
                string = ",";
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        private static boolean isalnum(char c) {
            return c <= '\u007f' && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9');
        }

        private static boolean isprint(char c) {
            return c >= ' ' && c <= '~';
        }

        public static class Type {
            public static final int CLASS = 1;
            public static final int FIELDSTUB = 2;
            public static final int FIELD = 3;
            public static final int JNI = 4;
            public static final int SIGNATURE = 5;
            public static final int METHOD_JDK_1 = 6;
            public static final int METHOD_JNI_SHORT = 7;
            public static final int METHOD_JNI_LONG = 8;
        }
    }
}

