/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.model;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.FilteredMemberList;
import com.sun.tools.javac.model.JavacSourcePosition;
import com.sun.tools.javac.processing.PrintingProcessor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Constants;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.io.Writer;
import java.util.Map;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;

public class JavacElements
implements Elements {
    private JavaCompiler javaCompiler;
    private Symtab syms;
    private Names names;
    private Types types;
    private Enter enter;

    public static JavacElements instance(Context context) {
        JavacElements javacElements = context.get(JavacElements.class);
        if (javacElements == null) {
            javacElements = new JavacElements(context);
        }
        return javacElements;
    }

    protected JavacElements(Context context) {
        this.setContext(context);
    }

    public void setContext(Context context) {
        context.put(JavacElements.class, this);
        this.javaCompiler = JavaCompiler.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.types = Types.instance(context);
        this.enter = Enter.instance(context);
    }

    @Override
    public Symbol.PackageSymbol getPackageElement(CharSequence charSequence) {
        String string = charSequence.toString();
        if (string.equals("")) {
            return this.syms.unnamedPackage;
        }
        return SourceVersion.isName(string) ? this.nameToSymbol(string, Symbol.PackageSymbol.class) : null;
    }

    @Override
    public Symbol.ClassSymbol getTypeElement(CharSequence charSequence) {
        String string = charSequence.toString();
        return SourceVersion.isName(string) ? this.nameToSymbol(string, Symbol.ClassSymbol.class) : null;
    }

    private <S extends Symbol> S nameToSymbol(String string, Class<S> clazz) {
        Name name = this.names.fromString(string);
        Symbol symbol = clazz == Symbol.ClassSymbol.class ? (Symbol.TypeSymbol)this.syms.classes.get(name) : (Symbol.TypeSymbol)this.syms.packages.get(name);
        try {
            if (symbol == null) {
                symbol = this.javaCompiler.resolveIdent(string);
            }
            symbol.complete();
            return (S)(symbol.kind != 63 && symbol.exists() && clazz.isInstance(symbol) && name.equals(symbol.getQualifiedName()) ? (Symbol)clazz.cast(symbol) : null);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return null;
        }
    }

    public JavacSourcePosition getSourcePosition(Element element) {
        Pair<JCTree, JCTree.JCCompilationUnit> pair = this.getTreeAndTopLevel(element);
        if (pair == null) {
            return null;
        }
        JCTree jCTree = (JCTree)pair.fst;
        JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)pair.snd;
        JavaFileObject javaFileObject = jCCompilationUnit.sourcefile;
        if (javaFileObject == null) {
            return null;
        }
        return new JavacSourcePosition(javaFileObject, jCTree.pos, jCCompilationUnit.lineMap);
    }

    public JavacSourcePosition getSourcePosition(Element element, AnnotationMirror annotationMirror) {
        Pair<JCTree, JCTree.JCCompilationUnit> pair = this.getTreeAndTopLevel(element);
        if (pair == null) {
            return null;
        }
        JCTree jCTree = (JCTree)pair.fst;
        JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)pair.snd;
        JavaFileObject javaFileObject = jCCompilationUnit.sourcefile;
        if (javaFileObject == null) {
            return null;
        }
        JCTree jCTree2 = this.matchAnnoToTree(annotationMirror, element, jCTree);
        if (jCTree2 == null) {
            return null;
        }
        return new JavacSourcePosition(javaFileObject, jCTree2.pos, jCCompilationUnit.lineMap);
    }

    public JavacSourcePosition getSourcePosition(Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        return this.getSourcePosition(element, annotationMirror);
    }

    private JCTree matchAnnoToTree(AnnotationMirror annotationMirror, Element element, JCTree jCTree) {
        Symbol symbol = JavacElements.cast(Symbol.class, element);
        class Vis
        extends JCTree.Visitor {
            List<JCTree.JCAnnotation> result = null;

            Vis() {
            }

            @Override
            public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
                this.result = jCCompilationUnit.packageAnnotations;
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
                this.result = jCClassDecl.mods.annotations;
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
                this.result = jCMethodDecl.mods.annotations;
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
                this.result = jCVariableDecl.mods.annotations;
            }
        }
        Vis vis = new Vis();
        jCTree.accept(vis);
        if (vis.result == null) {
            return null;
        }
        List<Attribute.Compound> list = symbol.getRawAttributes();
        return this.matchAnnoToTree(JavacElements.cast(Attribute.Compound.class, annotationMirror), list, vis.result);
    }

    private JCTree matchAnnoToTree(Attribute.Compound compound, List<Attribute.Compound> list, List<JCTree.JCAnnotation> list2) {
        for (Attribute.Compound compound2 : list) {
            for (JCTree.JCAnnotation jCAnnotation : list2) {
                JCTree jCTree = this.matchAnnoToTree(compound, compound2, (JCTree)jCAnnotation);
                if (jCTree == null) continue;
                return jCTree;
            }
        }
        return null;
    }

    private JCTree matchAnnoToTree(final Attribute.Compound compound, Attribute attribute, final JCTree jCTree) {
        if (attribute == compound) {
            return jCTree.type.tsym == compound.type.tsym ? jCTree : null;
        }
        class Vis
        implements Attribute.Visitor {
            JCTree result = null;

            Vis() {
            }

            @Override
            public void visitConstant(Attribute.Constant constant) {
            }

            @Override
            public void visitClass(Attribute.Class clazz) {
            }

            @Override
            public void visitCompound(Attribute.Compound compound2) {
                for (Pair<Symbol.MethodSymbol, Attribute> pair : compound2.values) {
                    JCTree jCTree2;
                    JCTree.JCExpression jCExpression = JavacElements.this.scanForAssign((Symbol.MethodSymbol)pair.fst, jCTree);
                    if (jCExpression == null || (jCTree2 = JavacElements.this.matchAnnoToTree(compound, (Attribute)pair.snd, jCExpression)) == null) continue;
                    this.result = jCTree2;
                    return;
                }
            }

            @Override
            public void visitArray(Attribute.Array array) {
                if (jCTree.hasTag(JCTree.Tag.NEWARRAY) && ((JavacElements)JavacElements.this).types.elemtype((Type)array.type).tsym == compound.type.tsym) {
                    List<JCTree.JCExpression> list = ((JCTree.JCNewArray)jCTree).elems;
                    for (Attribute attribute : array.values) {
                        if (attribute == compound) {
                            this.result = (JCTree)list.head;
                            return;
                        }
                        list = list.tail;
                    }
                }
            }

            @Override
            public void visitEnum(Attribute.Enum enum_) {
            }

            @Override
            public void visitError(Attribute.Error error) {
            }
        }
        Vis vis = new Vis();
        attribute.accept(vis);
        return vis.result;
    }

    private JCTree.JCExpression scanForAssign(final Symbol.MethodSymbol methodSymbol, final JCTree jCTree) {
        class TS
        extends TreeScanner {
            JCTree.JCExpression result = null;

            TS() {
            }

            @Override
            public void scan(JCTree jCTree2) {
                if (jCTree2 != null && this.result == null) {
                    jCTree2.accept(this);
                }
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
                if (jCAnnotation == jCTree) {
                    this.scan(jCAnnotation.args);
                }
            }

            @Override
            public void visitAssign(JCTree.JCAssign jCAssign) {
                if (jCAssign.lhs.hasTag(JCTree.Tag.IDENT)) {
                    JCTree.JCIdent jCIdent = (JCTree.JCIdent)jCAssign.lhs;
                    if (jCIdent.sym == methodSymbol) {
                        this.result = jCAssign.rhs;
                    }
                }
            }
        }
        TS tS = new TS();
        jCTree.accept(tS);
        return tS.result;
    }

    public JCTree getTree(Element element) {
        Pair<JCTree, JCTree.JCCompilationUnit> pair = this.getTreeAndTopLevel(element);
        return pair != null ? (JCTree)pair.fst : null;
    }

    @Override
    public String getDocComment(Element element) {
        Pair<JCTree, JCTree.JCCompilationUnit> pair = this.getTreeAndTopLevel(element);
        if (pair == null) {
            return null;
        }
        JCTree jCTree = (JCTree)pair.fst;
        JCTree.JCCompilationUnit jCCompilationUnit = (JCTree.JCCompilationUnit)pair.snd;
        if (jCCompilationUnit.docComments == null) {
            return null;
        }
        return jCCompilationUnit.docComments.getCommentText(jCTree);
    }

    @Override
    public PackageElement getPackageOf(Element element) {
        return JavacElements.cast(Symbol.class, element).packge();
    }

    @Override
    public boolean isDeprecated(Element element) {
        Symbol symbol = JavacElements.cast(Symbol.class, element);
        return (symbol.flags() & 0x20000L) != 0L;
    }

    @Override
    public Name getBinaryName(TypeElement typeElement) {
        return JavacElements.cast(Symbol.TypeSymbol.class, typeElement).flatName();
    }

    public Map<Symbol.MethodSymbol, Attribute> getElementValuesWithDefaults(AnnotationMirror annotationMirror) {
        Attribute.Compound compound = JavacElements.cast(Attribute.Compound.class, annotationMirror);
        DeclaredType declaredType = annotationMirror.getAnnotationType();
        Map<Symbol.MethodSymbol, Attribute> map = compound.getElementValues();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(declaredType.asElement().getEnclosedElements())) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)executableElement;
            Attribute attribute = methodSymbol.getDefaultValue();
            if (attribute == null || map.containsKey(methodSymbol)) continue;
            map.put(methodSymbol, attribute);
        }
        return map;
    }

    public FilteredMemberList getAllMembers(TypeElement typeElement) {
        Symbol symbol = JavacElements.cast(Symbol.class, typeElement);
        Scope scope = symbol.members().dupUnshared();
        List<Type> list = this.types.closure(symbol.asType());
        for (Type type : list) {
            this.addMembers(scope, type);
        }
        return new FilteredMemberList(scope);
    }

    private void addMembers(Scope scope, Type type) {
        Scope.Entry entry = type.asElement().members().elems;
        while (entry != null) {
            block4: {
                boolean bl;
                Scope.Entry entry2 = scope.lookup(entry.sym.getSimpleName());
                while (entry2.scope != null) {
                    if (entry2.sym.kind != entry.sym.kind || (entry2.sym.flags() & 0x1000L) != 0L || entry2.sym.getKind() != ElementKind.METHOD || !this.overrides((ExecutableElement)((Object)entry2.sym), (ExecutableElement)((Object)entry.sym), (TypeElement)((Object)type.asElement()))) {
                        entry2 = entry2.next();
                        continue;
                    }
                    break block4;
                }
                boolean bl2 = entry.sym.getEnclosingElement() != scope.owner;
                ElementKind elementKind = entry.sym.getKind();
                boolean bl3 = bl = elementKind == ElementKind.CONSTRUCTOR || elementKind == ElementKind.INSTANCE_INIT || elementKind == ElementKind.STATIC_INIT;
                if (!bl2 || !bl && entry.sym.isInheritedIn(scope.owner, this.types)) {
                    scope.enter(entry.sym);
                }
            }
            entry = entry.sibling;
        }
    }

    public List<Attribute.Compound> getAllAnnotationMirrors(Element element) {
        Type type;
        Symbol symbol = JavacElements.cast(Symbol.class, element);
        List<Attribute.Compound> list = symbol.getAnnotationMirrors();
        while (symbol.getKind() == ElementKind.CLASS && (type = ((Symbol.ClassSymbol)symbol).getSuperclass()).hasTag(TypeTag.CLASS) && !type.isErroneous() && type.tsym != this.syms.objectType.tsym) {
            symbol = type.tsym;
            List<Attribute.Compound> list2 = list;
            java.util.List list3 = symbol.getAnnotationMirrors();
            for (Attribute.Compound compound : list3) {
                if (!this.isInherited(compound.type) || JavacElements.containsAnnoOfType(list2, compound.type)) continue;
                list = list.prepend(compound);
            }
        }
        return list;
    }

    private boolean isInherited(Type type) {
        return type.tsym.attribute(this.syms.inheritedType.tsym) != null;
    }

    private static boolean containsAnnoOfType(List<Attribute.Compound> list, Type type) {
        for (Attribute.Compound compound : list) {
            if (compound.type.tsym != type.tsym) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hides(Element element, Element element2) {
        Symbol symbol;
        Symbol symbol2 = JavacElements.cast(Symbol.class, element);
        if (symbol2 == (symbol = JavacElements.cast(Symbol.class, element2)) || symbol2.kind != symbol.kind || symbol2.name != symbol.name) {
            return false;
        }
        if (!(symbol2.kind != 16 || symbol2.isStatic() && this.types.isSubSignature(symbol2.type, symbol.type))) {
            return false;
        }
        Symbol.ClassSymbol classSymbol = symbol2.owner.enclClass();
        Symbol.ClassSymbol classSymbol2 = symbol.owner.enclClass();
        if (classSymbol == null || classSymbol2 == null || !classSymbol.isSubClass(classSymbol2, this.types)) {
            return false;
        }
        return symbol.isInheritedIn(classSymbol, this.types);
    }

    @Override
    public boolean overrides(ExecutableElement executableElement, ExecutableElement executableElement2, TypeElement typeElement) {
        Symbol.MethodSymbol methodSymbol = JavacElements.cast(Symbol.MethodSymbol.class, executableElement);
        Symbol.MethodSymbol methodSymbol2 = JavacElements.cast(Symbol.MethodSymbol.class, executableElement2);
        Symbol.ClassSymbol classSymbol = JavacElements.cast(Symbol.ClassSymbol.class, typeElement);
        return methodSymbol.name == methodSymbol2.name && methodSymbol != methodSymbol2 && !methodSymbol.isStatic() && methodSymbol2.isMemberOf(classSymbol, this.types) && methodSymbol.overrides(methodSymbol2, classSymbol, this.types, false);
    }

    @Override
    public String getConstantExpression(Object object) {
        return Constants.format(object);
    }

    @Override
    public void printElements(Writer writer, Element ... elementArray) {
        for (Element element : elementArray) {
            ((PrintingProcessor.PrintingElementVisitor)new PrintingProcessor.PrintingElementVisitor(writer, this).visit(element)).flush();
        }
    }

    @Override
    public Name getName(CharSequence charSequence) {
        return this.names.fromString(charSequence.toString());
    }

    @Override
    public boolean isFunctionalInterface(TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.INTERFACE) {
            return false;
        }
        Symbol.TypeSymbol typeSymbol = JavacElements.cast(Symbol.TypeSymbol.class, typeElement);
        return this.types.isFunctionalInterface(typeSymbol);
    }

    private Pair<JCTree, JCTree.JCCompilationUnit> getTreeAndTopLevel(Element element) {
        Symbol symbol = JavacElements.cast(Symbol.class, element);
        Env<AttrContext> env = this.getEnterEnv(symbol);
        if (env == null) {
            return null;
        }
        JCTree jCTree = TreeInfo.declarationFor(symbol, env.tree);
        if (jCTree == null || env.toplevel == null) {
            return null;
        }
        return new Pair<JCTree, JCTree.JCCompilationUnit>(jCTree, env.toplevel);
    }

    public Pair<JCTree, JCTree.JCCompilationUnit> getTreeAndTopLevel(Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        if (element == null) {
            return null;
        }
        Pair<JCTree, JCTree.JCCompilationUnit> pair = this.getTreeAndTopLevel(element);
        if (pair == null) {
            return null;
        }
        if (annotationMirror == null) {
            return pair;
        }
        JCTree jCTree = this.matchAnnoToTree(annotationMirror, element, (JCTree)pair.fst);
        if (jCTree == null) {
            return pair;
        }
        return new Pair<JCTree, JCTree.JCCompilationUnit>(jCTree, (JCTree.JCCompilationUnit)pair.snd);
    }

    private Env<AttrContext> getEnterEnv(Symbol symbol) {
        Symbol.TypeSymbol typeSymbol = symbol.kind != 1 ? symbol.enclClass() : (Symbol.PackageSymbol)symbol;
        return typeSymbol != null ? this.enter.getEnv(typeSymbol) : null;
    }

    private static <T> T cast(Class<T> clazz, Object object) {
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(object.toString());
        }
        return clazz.cast(object);
    }
}

