/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.nio;

import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.nio.PathFileManager;
import com.sun.tools.javac.nio.PathFileObject;
import com.sun.tools.javac.util.BaseFileManager;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavacPathFileManager
extends BaseFileManager
implements PathFileManager {
    protected FileSystem defaultFileSystem;
    private boolean inited = false;
    private Map<JavaFileManager.Location, PathsForLocation> pathsForLocation;
    private Map<Path, FileSystem> fileSystems;

    public JavacPathFileManager(Context context, boolean bl, Charset charset) {
        super(charset);
        if (bl) {
            context.put(JavaFileManager.class, this);
        }
        this.pathsForLocation = new HashMap<JavaFileManager.Location, PathsForLocation>();
        this.fileSystems = new HashMap<Path, FileSystem>();
        this.setContext(context);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
    }

    @Override
    public FileSystem getDefaultFileSystem() {
        if (this.defaultFileSystem == null) {
            this.defaultFileSystem = FileSystems.getDefault();
        }
        return this.defaultFileSystem;
    }

    @Override
    public void setDefaultFileSystem(FileSystem fileSystem) {
        this.defaultFileSystem = fileSystem;
    }

    @Override
    public void flush() throws IOException {
        this.contentCache.clear();
    }

    @Override
    public void close() throws IOException {
        for (FileSystem fileSystem : this.fileSystems.values()) {
            fileSystem.close();
        }
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        JavacPathFileManager.nullCheck(location);
        Iterable<? extends Path> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        ListBuffer<URL> listBuffer = new ListBuffer<URL>();
        for (Path path : iterable) {
            try {
                listBuffer.append(path.toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return this.getClassLoader(listBuffer.toArray(new URL[listBuffer.size()]));
    }

    @Override
    public boolean isDefaultBootClassPath() {
        return this.locations.isDefaultBootClassPath();
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.getLocation(location) != null;
    }

    @Override
    public Iterable<? extends Path> getLocation(JavaFileManager.Location location) {
        JavacPathFileManager.nullCheck(location);
        this.lazyInitSearchPaths();
        PathsForLocation pathsForLocation = this.pathsForLocation.get(location);
        if (pathsForLocation == null && !this.pathsForLocation.containsKey(location)) {
            this.setDefaultForLocation(location);
            pathsForLocation = this.pathsForLocation.get(location);
        }
        return pathsForLocation;
    }

    private Path getOutputLocation(JavaFileManager.Location location) {
        Iterable<? extends Path> iterable = this.getLocation(location);
        return iterable == null ? null : iterable.iterator().next();
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends Path> iterable) throws IOException {
        JavacPathFileManager.nullCheck(location);
        this.lazyInitSearchPaths();
        if (iterable == null) {
            this.setDefaultForLocation(location);
        } else {
            if (location.isOutputLocation()) {
                this.checkOutputPath(iterable);
            }
            PathsForLocation pathsForLocation = new PathsForLocation();
            for (Path path : iterable) {
                pathsForLocation.add(path);
            }
            this.pathsForLocation.put(location, pathsForLocation);
        }
    }

    private void checkOutputPath(Iterable<? extends Path> iterable) throws IOException {
        Iterator<? extends Path> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("empty path for directory");
        }
        Path path = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("path too long for directory");
        }
        if (!JavacPathFileManager.isDirectory(path)) {
            String string = String.valueOf(String.valueOf(path));
            throw new IOException(new StringBuilder(17 + string.length()).append(string).append(": not a directory").toString());
        }
    }

    private void setDefaultForLocation(JavaFileManager.Location location) {
        Object object;
        Collection<File> collection = null;
        if (location instanceof StandardLocation) {
            switch ((StandardLocation)location) {
                case CLASS_PATH: {
                    collection = this.locations.userClassPath();
                    break;
                }
                case PLATFORM_CLASS_PATH: {
                    collection = this.locations.bootClassPath();
                    break;
                }
                case SOURCE_PATH: {
                    collection = this.locations.sourcePath();
                    break;
                }
                case CLASS_OUTPUT: {
                    object = this.options.get(Option.D);
                    collection = object == null ? null : Collections.singleton(new File((String)object));
                    break;
                }
                case SOURCE_OUTPUT: {
                    object = this.options.get(Option.S);
                    collection = object == null ? null : Collections.singleton(new File((String)object));
                    break;
                }
            }
        }
        object = new PathsForLocation();
        if (collection != null) {
            for (File file : collection) {
                ((HashSet)object).add(file.toPath());
            }
        }
        if (!((HashSet)object).isEmpty()) {
            this.pathsForLocation.put(location, (PathsForLocation)object);
        }
    }

    private void lazyInitSearchPaths() {
        if (!this.inited) {
            this.setDefaultForLocation(StandardLocation.PLATFORM_CLASS_PATH);
            this.setDefaultForLocation(StandardLocation.CLASS_PATH);
            this.setDefaultForLocation(StandardLocation.SOURCE_PATH);
            this.inited = true;
        }
    }

    @Override
    public Path getPath(FileObject fileObject) {
        JavacPathFileManager.nullCheck(fileObject);
        if (!(fileObject instanceof PathFileObject)) {
            throw new IllegalArgumentException();
        }
        return ((PathFileObject)fileObject).getPath();
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        JavacPathFileManager.nullCheck(fileObject);
        JavacPathFileManager.nullCheck(fileObject2);
        if (!(fileObject instanceof PathFileObject)) {
            String string = String.valueOf(String.valueOf(fileObject));
            throw new IllegalArgumentException(new StringBuilder(15 + string.length()).append("Not supported: ").append(string).toString());
        }
        if (!(fileObject2 instanceof PathFileObject)) {
            String string = String.valueOf(String.valueOf(fileObject2));
            throw new IllegalArgumentException(new StringBuilder(15 + string.length()).append("Not supported: ").append(string).toString());
        }
        return ((PathFileObject)fileObject).isSameFile((PathFileObject)fileObject2);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        JavacPathFileManager.nullCheck(string);
        JavacPathFileManager.nullCheck(set);
        Iterable<? extends Path> iterable = this.getLocation(location);
        if (iterable == null) {
            return List.nil();
        }
        ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        for (Path path : iterable) {
            this.list(path, string, set, bl, listBuffer);
        }
        return listBuffer.toList();
    }

    private void list(Path path, String string, final Set<JavaFileObject.Kind> set, boolean bl, final ListBuffer<JavaFileObject> listBuffer) throws IOException {
        Path path2;
        Object object;
        Path path3;
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (JavacPathFileManager.isDirectory(path)) {
            path3 = path;
        } else {
            object = this.getFileSystem(path);
            if (object == null) {
                return;
            }
            path3 = ((FileSystem)object).getRootDirectories().iterator().next();
        }
        object = path.getFileSystem().getSeparator();
        Path path4 = path2 = string.isEmpty() ? path3 : path3.resolve(string.replace(".", (CharSequence)object));
        if (!Files.exists(path2, new LinkOption[0])) {
            return;
        }
        int n = bl ? Integer.MAX_VALUE : 1;
        EnumSet<FileVisitOption> enumSet = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(path2, enumSet, n, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                Path path2 = path.getFileName();
                if (path2 == null || SourceVersion.isIdentifier(path2.toString())) {
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                if (basicFileAttributes.isRegularFile() && set.contains((Object)BaseFileManager.getKind(path.getFileName().toString()))) {
                    PathFileObject pathFileObject = PathFileObject.createDirectoryPathFileObject(JavacPathFileManager.this, path, path3);
                    listBuffer.append(pathFileObject);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Iterable<? extends Path> iterable) {
        ArrayList<PathFileObject> arrayList = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new ArrayList<PathFileObject>();
        for (Path path : iterable) {
            arrayList.add(PathFileObject.createSimplePathFileObject(this, JavacPathFileManager.nullCheck(path)));
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... pathArray) {
        return this.getJavaFileObjectsFromPaths(Arrays.asList((Object[])JavacPathFileManager.nullCheck(pathArray)));
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        return this.getFileForInput(location, JavacPathFileManager.getRelativePath(string, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        return this.getFileForInput(location, JavacPathFileManager.getRelativePath(string, string2));
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, String string) throws IOException {
        for (Path path : this.getLocation(location)) {
            Path path2;
            Object object;
            if (JavacPathFileManager.isDirectory(path)) {
                object = JavacPathFileManager.resolve(path, string);
                if (!Files.exists((Path)object, new LinkOption[0])) continue;
                return PathFileObject.createDirectoryPathFileObject(this, (Path)object, path);
            }
            object = this.getFileSystem(path);
            if (object == null || !Files.exists(path2 = JavacPathFileManager.getPath((FileSystem)object, string), new LinkOption[0])) continue;
            return PathFileObject.createJarPathFileObject(this, path2);
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        return this.getFileForOutput(location, JavacPathFileManager.getRelativePath(string, kind), fileObject);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        return this.getFileForOutput(location, JavacPathFileManager.getRelativePath(string, string2), fileObject);
    }

    private JavaFileObject getFileForOutput(JavaFileManager.Location location, String string, FileObject fileObject) {
        Path path = this.getOutputLocation(location);
        if (path == null) {
            if (location == StandardLocation.CLASS_OUTPUT) {
                Path path2 = null;
                if (fileObject != null && fileObject instanceof PathFileObject) {
                    path2 = ((PathFileObject)fileObject).getPath().getParent();
                }
                return PathFileObject.createSiblingPathFileObject(this, path2.resolve(JavacPathFileManager.getBaseName(string)), string);
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                path = this.getOutputLocation(StandardLocation.CLASS_OUTPUT);
            }
        }
        if (path != null) {
            Path path3 = JavacPathFileManager.resolve(path, string);
            return PathFileObject.createDirectoryPathFileObject(this, path3, path);
        }
        Path path4 = JavacPathFileManager.getPath(this.getDefaultFileSystem(), string);
        return PathFileObject.createSimplePathFileObject(this, path4);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        JavacPathFileManager.nullCheck(javaFileObject);
        Iterable<? extends Path> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        if (!(javaFileObject instanceof PathFileObject)) {
            throw new IllegalArgumentException(javaFileObject.getClass().getName());
        }
        return ((PathFileObject)javaFileObject).inferBinaryName(iterable);
    }

    private FileSystem getFileSystem(Path path) throws IOException {
        FileSystem fileSystem = this.fileSystems.get(path);
        if (fileSystem == null) {
            fileSystem = FileSystems.newFileSystem(path, null);
            this.fileSystems.put(path, fileSystem);
        }
        return fileSystem;
    }

    private static String getRelativePath(String string, JavaFileObject.Kind kind) {
        String string2 = String.valueOf(string.replace(".", "/"));
        String string3 = String.valueOf(kind.extension);
        return string3.length() != 0 ? string2.concat(string3) : new String(string2);
    }

    private static String getRelativePath(String string, String string2) {
        String string3;
        if (string.isEmpty()) {
            string3 = string2;
        } else {
            String string4 = String.valueOf(String.valueOf(string.replace(".", "/")));
            String string5 = String.valueOf(String.valueOf(string2));
            string3 = new StringBuilder(1 + string4.length() + string5.length()).append(string4).append("/").append(string5).toString();
        }
        return string3;
    }

    private static String getBaseName(String string) {
        int n = string.lastIndexOf("/");
        return string.substring(n + 1);
    }

    private static boolean isDirectory(Path path) throws IOException {
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        return basicFileAttributes.isDirectory();
    }

    private static Path getPath(FileSystem fileSystem, String string) {
        return fileSystem.getPath(string.replace("/", fileSystem.getSeparator()), new String[0]);
    }

    private static Path resolve(Path path, String string) {
        FileSystem fileSystem = path.getFileSystem();
        Path path2 = fileSystem.getPath(string.replace("/", fileSystem.getSeparator()), new String[0]);
        return path.resolve(path2);
    }

    private static class PathsForLocation
    extends LinkedHashSet<Path> {
        private static final long serialVersionUID = 6788510222394486733L;

        private PathsForLocation() {
        }
    }
}

