/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.processing.JavacFiler;
import com.sun.tools.javac.processing.JavacMessager;
import com.sun.tools.javac.processing.JavacRoundEnvironment;
import com.sun.tools.javac.processing.PrintingProcessor;
import com.sun.tools.javac.processing.ServiceProxy;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.ServiceLoader;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner8;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavacProcessingEnvironment
implements ProcessingEnvironment,
Closeable {
    private final Options options;
    private final boolean printProcessorInfo;
    private final boolean printRounds;
    private final boolean verbose;
    private final boolean lint;
    private final boolean fatalErrors;
    private final boolean werror;
    private final boolean showResolveErrors;
    private final JavacFiler filer;
    private final JavacMessager messager;
    private final JavacElements elementUtils;
    private final JavacTypes typeUtils;
    private DiscoveredProcessors discoveredProcs;
    private final Map<String, String> processorOptions;
    private final Set<String> unmatchedProcessorOptions;
    private final Set<String> platformAnnotations;
    private Set<Symbol.PackageSymbol> specifiedPackages = Collections.emptySet();
    Log log;
    JCDiagnostic.Factory diags;
    Source source;
    private ClassLoader processorClassLoader;
    private SecurityException processorClassLoaderException;
    private JavacMessages messages;
    private MultiTaskListener taskListener;
    private Context context;
    private static final TreeScanner treeCleaner = new TreeScanner(){

        @Override
        public void scan(JCTree jCTree) {
            super.scan(jCTree);
            if (jCTree != null) {
                jCTree.type = null;
            }
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
            jCCompilationUnit.packge = null;
            super.visitTopLevel(jCCompilationUnit);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            jCClassDecl.sym = null;
            super.visitClassDef(jCClassDecl);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            jCMethodDecl.sym = null;
            super.visitMethodDef(jCMethodDecl);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            jCVariableDecl.sym = null;
            super.visitVarDef(jCVariableDecl);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            jCNewClass.constructor = null;
            super.visitNewClass(jCNewClass);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
            jCAssignOp.operator = null;
            super.visitAssignop(jCAssignOp);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            jCUnary.operator = null;
            super.visitUnary(jCUnary);
        }

        @Override
        public void visitBinary(JCTree.JCBinary jCBinary) {
            jCBinary.operator = null;
            super.visitBinary(jCBinary);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            jCFieldAccess.sym = null;
            super.visitSelect(jCFieldAccess);
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            jCIdent.sym = null;
            super.visitIdent(jCIdent);
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
            jCAnnotation.attribute = null;
            super.visitAnnotation(jCAnnotation);
        }
    };
    private static final Pattern allMatches = Pattern.compile(".*");
    public static final Pattern noMatches = Pattern.compile("(\\P{all})+");

    public static JavacProcessingEnvironment instance(Context context) {
        JavacProcessingEnvironment javacProcessingEnvironment = context.get(JavacProcessingEnvironment.class);
        if (javacProcessingEnvironment == null) {
            javacProcessingEnvironment = new JavacProcessingEnvironment(context);
        }
        return javacProcessingEnvironment;
    }

    protected JavacProcessingEnvironment(Context context) {
        this.context = context;
        context.put(JavacProcessingEnvironment.class, this);
        this.log = Log.instance(context);
        this.source = Source.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.options = Options.instance(context);
        this.printProcessorInfo = this.options.isSet(Option.XPRINTPROCESSORINFO);
        this.printRounds = this.options.isSet(Option.XPRINTROUNDS);
        this.verbose = this.options.isSet(Option.VERBOSE);
        this.lint = Lint.instance(context).isEnabled(Lint.LintCategory.PROCESSING);
        if (this.options.isSet(Option.PROC, "only") || this.options.isSet(Option.XPRINT)) {
            JavaCompiler javaCompiler = JavaCompiler.instance(context);
            javaCompiler.shouldStopPolicyIfNoError = CompileStates.CompileState.PROCESS;
        }
        this.fatalErrors = this.options.isSet("fatalEnterError");
        this.showResolveErrors = this.options.isSet("showResolveErrors");
        this.werror = this.options.isSet(Option.WERROR);
        this.platformAnnotations = this.initPlatformAnnotations();
        this.filer = new JavacFiler(context);
        this.messager = new JavacMessager(context, this);
        this.elementUtils = JavacElements.instance(context);
        this.typeUtils = JavacTypes.instance(context);
        this.processorOptions = this.initProcessorOptions(context);
        this.unmatchedProcessorOptions = this.initUnmatchedProcessorOptions();
        this.messages = JavacMessages.instance(context);
        this.taskListener = MultiTaskListener.instance(context);
        this.initProcessorClassLoader();
    }

    public void setProcessors(Iterable<? extends Processor> iterable) {
        Assert.checkNull(this.discoveredProcs);
        this.initProcessorIterator(this.context, iterable);
    }

    private Set<String> initPlatformAnnotations() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("java.lang.Deprecated");
        hashSet.add("java.lang.Override");
        hashSet.add("java.lang.SuppressWarnings");
        hashSet.add("java.lang.annotation.Documented");
        hashSet.add("java.lang.annotation.Inherited");
        hashSet.add("java.lang.annotation.Retention");
        hashSet.add("java.lang.annotation.Target");
        return Collections.unmodifiableSet(hashSet);
    }

    private void initProcessorClassLoader() {
        JavaFileManager javaFileManager = this.context.get(JavaFileManager.class);
        try {
            ClassLoader classLoader = this.processorClassLoader = javaFileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? javaFileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH) : javaFileManager.getClassLoader(StandardLocation.CLASS_PATH);
            if (this.processorClassLoader != null && this.processorClassLoader instanceof Closeable) {
                JavaCompiler javaCompiler = JavaCompiler.instance(this.context);
                javaCompiler.closeables = javaCompiler.closeables.prepend((Closeable)((Object)this.processorClassLoader));
            }
        }
        catch (SecurityException securityException) {
            this.processorClassLoaderException = securityException;
        }
    }

    private void initProcessorIterator(Context context, Iterable<? extends Processor> iterable) {
        Iterator<Processor> iterator;
        Log log = Log.instance(context);
        if (this.options.isSet(Option.XPRINT)) {
            try {
                Processor processor = (Processor)PrintingProcessor.class.newInstance();
                iterator = List.of(processor).iterator();
            }
            catch (Throwable throwable) {
                AssertionError assertionError = new AssertionError((Object)"Problem instantiating PrintingProcessor.");
                ((Throwable)((Object)assertionError)).initCause(throwable);
                throw assertionError;
            }
        } else if (iterable != null) {
            iterator = iterable.iterator();
        } else {
            String string = this.options.get(Option.PROCESSOR);
            iterator = this.processorClassLoaderException == null ? (string != null ? new NameProcessIterator(string, this.processorClassLoader, log) : new ServiceIterator(this.processorClassLoader, log)) : this.handleServiceLoaderUnavailability("proc.cant.create.loader", this.processorClassLoaderException);
        }
        this.discoveredProcs = new DiscoveredProcessors(iterator);
    }

    private Iterator<Processor> handleServiceLoaderUnavailability(String string, Exception exception) {
        Object object;
        JavaFileManager javaFileManager = this.context.get(JavaFileManager.class);
        if (javaFileManager instanceof JavacFileManager) {
            Iterable<? extends File> iterable;
            object = (JavacFileManager)javaFileManager;
            Iterable<? extends File> iterable2 = iterable = javaFileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? object.getLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) : object.getLocation(StandardLocation.CLASS_PATH);
            if (this.needClassLoader(this.options.get(Option.PROCESSOR), iterable)) {
                this.handleException(string, exception);
            }
        } else {
            this.handleException(string, exception);
        }
        object = Collections.emptyList();
        return object.iterator();
    }

    private void handleException(String string, Exception exception) {
        if (exception != null) {
            this.log.error(string, exception.getLocalizedMessage());
            throw new Abort(exception);
        }
        this.log.error(string, new Object[0]);
        throw new Abort();
    }

    public boolean atLeastOneProcessor() {
        return this.discoveredProcs.iterator().hasNext();
    }

    private Map<String, String> initProcessorOptions(Context context) {
        Options options = Options.instance(context);
        Set<String> set = options.keySet();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : set) {
            if (!string.startsWith("-A") || string.length() <= 2) continue;
            int n = string.indexOf(61);
            String string2 = null;
            String string3 = null;
            if (n == -1) {
                string2 = string.substring(2);
            } else if (n >= 3) {
                string2 = string.substring(2, n);
                string3 = n < string.length() - 1 ? string.substring(n + 1) : null;
            }
            linkedHashMap.put(string2, string3);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private Set<String> initUnmatchedProcessorOptions() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.processorOptions.keySet());
        return hashSet;
    }

    private void discoverAndRunProcs(Context context, Set<TypeElement> set, List<Symbol.ClassSymbol> list, List<Symbol.PackageSymbol> list2) {
        HashMap<String, TypeElement> hashMap = new HashMap<String, TypeElement>(set.size());
        for (TypeElement set22 : set) {
            hashMap.put(set22.getQualifiedName().toString(), set22);
        }
        if (hashMap.size() == 0) {
            hashMap.put("", null);
        }
        DiscoveredProcessors.ProcessorStateIterator processorStateIterator = this.discoveredProcs.iterator();
        LinkedHashSet<Symbol.TypeSymbol> linkedHashSet = new LinkedHashSet<Symbol.TypeSymbol>();
        linkedHashSet.addAll(list);
        linkedHashSet.addAll(list2);
        Set set2 = Collections.unmodifiableSet(linkedHashSet);
        JavacRoundEnvironment javacRoundEnvironment = new JavacRoundEnvironment(false, false, set2, this);
        while (hashMap.size() > 0 && processorStateIterator.hasNext()) {
            ProcessorState processorState = processorStateIterator.next();
            HashSet<String> hashSet = new HashSet<String>();
            LinkedHashSet<TypeElement> linkedHashSet2 = new LinkedHashSet<TypeElement>();
            for (Map.Entry entry : hashMap.entrySet()) {
                String string = (String)entry.getKey();
                if (!processorState.annotationSupported(string)) continue;
                hashSet.add(string);
                TypeElement typeElement = (TypeElement)entry.getValue();
                if (typeElement == null) continue;
                linkedHashSet2.add(typeElement);
            }
            if (hashSet.size() <= 0 && !processorState.contributed) continue;
            boolean bl = this.callProcessor(processorState.processor, linkedHashSet2, javacRoundEnvironment);
            processorState.contributed = true;
            processorState.removeSupportedOptions(this.unmatchedProcessorOptions);
            if (this.printProcessorInfo || this.verbose) {
                this.log.printLines("x.print.processor.info", processorState.processor.getClass().getName(), ((Object)hashSet).toString(), bl);
            }
            if (!bl) continue;
            hashMap.keySet().removeAll(hashSet);
        }
        hashMap.remove("");
        if (this.lint && hashMap.size() > 0) {
            hashMap.keySet().removeAll(this.platformAnnotations);
            if (hashMap.size() > 0) {
                this.log = Log.instance(context);
                this.log.warning("proc.annotations.without.processors", hashMap.keySet());
            }
        }
        processorStateIterator.runContributingProcs(javacRoundEnvironment);
        if (this.options.isSet("displayFilerState")) {
            this.filer.displayState();
        }
    }

    private boolean callProcessor(Processor processor, Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        try {
            return processor.process(set, roundEnvironment);
        }
        catch (ClassReader.BadClassFile badClassFile) {
            this.log.error("proc.cant.access.1", badClassFile.sym, badClassFile.getDetailValue());
            return false;
        }
        catch (Symbol.CompletionFailure completionFailure) {
            StringWriter stringWriter = new StringWriter();
            completionFailure.printStackTrace(new PrintWriter(stringWriter));
            this.log.error("proc.cant.access", completionFailure.sym, completionFailure.getDetailValue(), stringWriter.toString());
            return false;
        }
        catch (ClientCodeException clientCodeException) {
            throw clientCodeException;
        }
        catch (Throwable throwable) {
            throw new AnnotationProcessingError(throwable);
        }
    }

    public JavaCompiler doProcessing(Context context, List<JCTree.JCCompilationUnit> list, List<Symbol.ClassSymbol> list2, Iterable<? extends Symbol.PackageSymbol> iterable, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        this.log = Log.instance(context);
        LinkedHashSet<Symbol.PackageSymbol> linkedHashSet = new LinkedHashSet<Symbol.PackageSymbol>();
        for (Symbol.PackageSymbol packageSymbol : iterable) {
            linkedHashSet.add(packageSymbol);
        }
        this.specifiedPackages = Collections.unmodifiableSet(linkedHashSet);
        Object object = new Round(context, list, list2, deferredDiagnosticHandler);
        do {
            ((Round)object).run(false, false);
            bl2 = ((Round)object).unrecoverableError();
            bl3 = this.moreToDo();
            ((Round)object).showDiagnostics(bl2 || this.showResolveErrors);
            object = ((Round)object).next(new LinkedHashSet<JavaFileObject>(this.filer.getGeneratedSourceFileObjects()), new LinkedHashMap<String, JavaFileObject>(this.filer.getGeneratedClasses()));
            if (!((Round)object).unrecoverableError()) continue;
            bl2 = true;
        } while (bl3 && !bl2);
        ((Round)object).run(true, bl2);
        ((Round)object).showDiagnostics(true);
        this.filer.warnIfUnclosedFiles();
        this.warnIfUnmatchedOptions();
        if (this.messager.errorRaised() || this.werror && ((Round)object).warningCount() > 0 && ((Round)object).errorCount() > 0) {
            bl = true;
        }
        LinkedHashSet<JavaFileObject> linkedHashSet2 = new LinkedHashSet<JavaFileObject>(this.filer.getGeneratedSourceFileObjects());
        list = JavacProcessingEnvironment.cleanTrees(((Round)object).roots);
        JavaCompiler javaCompiler = ((Round)object).finalCompiler();
        if (linkedHashSet2.size() > 0) {
            list = list.appendList(javaCompiler.parseFiles(linkedHashSet2));
        }
        boolean bl4 = bl || javaCompiler.errorCount() > 0;
        this.close();
        if (!this.taskListener.isEmpty()) {
            this.taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING));
        }
        if (bl4) {
            if (javaCompiler.errorCount() == 0) {
                ++javaCompiler.log.nerrors;
            }
            return javaCompiler;
        }
        javaCompiler.enterTreesIfNeeded(list);
        return javaCompiler;
    }

    private void warnIfUnmatchedOptions() {
        if (!this.unmatchedProcessorOptions.isEmpty()) {
            this.log.warning("proc.unmatched.processor.options", this.unmatchedProcessorOptions.toString());
        }
    }

    @Override
    public void close() {
        this.filer.close();
        if (this.discoveredProcs != null) {
            this.discoveredProcs.close();
        }
        this.discoveredProcs = null;
    }

    private List<Symbol.ClassSymbol> getTopLevelClasses(List<? extends JCTree.JCCompilationUnit> list) {
        List<Symbol.ClassSymbol> list2 = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            for (JCTree jCTree : jCCompilationUnit.defs) {
                if (!jCTree.hasTag(JCTree.Tag.CLASSDEF)) continue;
                Symbol.ClassSymbol classSymbol = ((JCTree.JCClassDecl)jCTree).sym;
                Assert.checkNonNull(classSymbol);
                list2 = list2.prepend(classSymbol);
            }
        }
        return list2.reverse();
    }

    private List<Symbol.ClassSymbol> getTopLevelClassesFromClasses(List<? extends Symbol.ClassSymbol> list) {
        List<Symbol.ClassSymbol> list2 = List.nil();
        for (Symbol.ClassSymbol classSymbol : list) {
            if (this.isPkgInfo(classSymbol)) continue;
            list2 = list2.prepend(classSymbol);
        }
        return list2.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFiles(List<? extends JCTree.JCCompilationUnit> list) {
        List<Symbol.PackageSymbol> list2 = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            if (!this.isPkgInfo(jCCompilationUnit.sourcefile, JavaFileObject.Kind.SOURCE)) continue;
            list2 = list2.prepend(jCCompilationUnit.packge);
        }
        return list2.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFilesFromClasses(List<? extends Symbol.ClassSymbol> list) {
        List<Symbol.PackageSymbol> list2 = List.nil();
        for (Symbol.ClassSymbol classSymbol : list) {
            if (!this.isPkgInfo(classSymbol)) continue;
            list2 = list2.prepend((Symbol.PackageSymbol)classSymbol.owner);
        }
        return list2.reverse();
    }

    private static <T> List<T> join(List<T> list, List<T> list2) {
        return list.appendList(list2);
    }

    private boolean isPkgInfo(JavaFileObject javaFileObject, JavaFileObject.Kind kind) {
        return javaFileObject.isNameCompatible("package-info", kind);
    }

    private boolean isPkgInfo(Symbol.ClassSymbol classSymbol) {
        return this.isPkgInfo(classSymbol.classfile, JavaFileObject.Kind.CLASS) && classSymbol.packge().package_info == classSymbol;
    }

    private boolean needClassLoader(String string, Iterable<? extends File> iterable) {
        if (string != null) {
            return true;
        }
        URL[] uRLArray = new URL[1];
        for (File file : iterable) {
            try {
                uRLArray[0] = file.toURI().toURL();
                if (!ServiceProxy.hasService(Processor.class, uRLArray)) continue;
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
            catch (ServiceProxy.ServiceConfigurationError serviceConfigurationError) {
                this.log.error("proc.bad.config.file", serviceConfigurationError.getLocalizedMessage());
                return true;
            }
        }
        return false;
    }

    private static <T extends JCTree> List<T> cleanTrees(List<T> list) {
        for (JCTree jCTree : list) {
            treeCleaner.scan(jCTree);
        }
        return list;
    }

    private boolean moreToDo() {
        return this.filer.newFiles();
    }

    @Override
    public Map<String, String> getOptions() {
        return this.processorOptions;
    }

    @Override
    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public Filer getFiler() {
        return this.filer;
    }

    @Override
    public JavacElements getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public JavacTypes getTypeUtils() {
        return this.typeUtils;
    }

    @Override
    public SourceVersion getSourceVersion() {
        return Source.toSourceVersion(this.source);
    }

    @Override
    public Locale getLocale() {
        return this.messages.getCurrentLocale();
    }

    public Set<Symbol.PackageSymbol> getSpecifiedPackages() {
        return this.specifiedPackages;
    }

    private static Pattern importStringToPattern(String string, Processor processor, Log log) {
        if (JavacProcessingEnvironment.isValidImportString(string)) {
            return JavacProcessingEnvironment.validImportStringToPattern(string);
        }
        log.warning("proc.malformed.supported.string", string, processor.getClass().getName());
        return noMatches;
    }

    public static boolean isValidImportString(String string) {
        if (string.equals("*")) {
            return true;
        }
        boolean bl = true;
        String string2 = string;
        int n = string2.indexOf(42);
        if (n != -1) {
            if (n == string2.length() - 1) {
                if (n - 1 >= 0) {
                    bl = string2.charAt(n - 1) == '.';
                    string2 = string2.substring(0, string2.length() - 2);
                }
            } else {
                return false;
            }
        }
        if (bl) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split("\\.", string2.length() + 2)) {
                bl &= SourceVersion.isIdentifier(string3);
            }
        }
        return bl;
    }

    public static Pattern validImportStringToPattern(String string) {
        if (string.equals("*")) {
            return allMatches;
        }
        String string2 = string.replace(".", "\\.");
        if (string2.endsWith("*")) {
            string2 = String.valueOf(string2.substring(0, string2.length() - 1)).concat(".+");
        }
        return Pattern.compile(string2);
    }

    public Context getContext() {
        return this.context;
    }

    public ClassLoader getProcessorClassLoader() {
        return this.processorClassLoader;
    }

    public String toString() {
        return "javac ProcessingEnvironment";
    }

    public static boolean isValidOptionName(String string) {
        for (String string2 : string.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    class Round {
        final int number;
        final Context context;
        final JavaCompiler compiler;
        final Log log;
        final Log.DeferredDiagnosticHandler deferredDiagnosticHandler;
        List<JCTree.JCCompilationUnit> roots;
        Map<String, JavaFileObject> genClassFiles;
        Set<TypeElement> annotationsPresent;
        List<Symbol.ClassSymbol> topLevelClasses;
        List<Symbol.PackageSymbol> packageInfoFiles;

        private Round(Context context, int n, int n2, int n3, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
            this.context = context;
            this.number = n;
            this.compiler = JavaCompiler.instance(context);
            this.log = Log.instance(context);
            this.log.nerrors = n2;
            this.log.nwarnings = n3;
            if (n == 1) {
                Assert.checkNonNull(deferredDiagnosticHandler);
                this.deferredDiagnosticHandler = deferredDiagnosticHandler;
            } else {
                this.deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.log);
            }
            JavacProcessingEnvironment.this.context = context;
            this.topLevelClasses = List.nil();
            this.packageInfoFiles = List.nil();
        }

        Round(Context context, List<JCTree.JCCompilationUnit> list, List<Symbol.ClassSymbol> list2, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
            this(context, 1, 0, 0, deferredDiagnosticHandler);
            this.roots = list;
            this.genClassFiles = new HashMap<String, JavaFileObject>();
            this.compiler.todo.clear();
            this.topLevelClasses = javacProcessingEnvironment.getTopLevelClasses(list).prependList(list2.reverse());
            this.packageInfoFiles = javacProcessingEnvironment.getPackageInfoFiles(list);
            this.findAnnotationsPresent();
        }

        private Round(Round round, Set<JavaFileObject> set, Map<String, JavaFileObject> map) {
            this(round.nextContext(), round.number + 1, round.compiler.log.nerrors, round.compiler.log.nwarnings, null);
            this.genClassFiles = round.genClassFiles;
            List<JCTree.JCCompilationUnit> list = this.compiler.parseFiles(set);
            this.roots = JavacProcessingEnvironment.cleanTrees(round.roots).appendList(list);
            if (this.unrecoverableError()) {
                return;
            }
            this.enterClassFiles(this.genClassFiles);
            List<Symbol.ClassSymbol> list2 = this.enterClassFiles(map);
            this.genClassFiles.putAll(map);
            this.enterTrees(this.roots);
            if (this.unrecoverableError()) {
                return;
            }
            this.topLevelClasses = JavacProcessingEnvironment.join(javacProcessingEnvironment.getTopLevelClasses(list), javacProcessingEnvironment.getTopLevelClassesFromClasses(list2));
            this.packageInfoFiles = JavacProcessingEnvironment.join(javacProcessingEnvironment.getPackageInfoFiles(list), javacProcessingEnvironment.getPackageInfoFilesFromClasses(list2));
            this.findAnnotationsPresent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Round next(Set<JavaFileObject> set, Map<String, JavaFileObject> map) {
            try {
                Round round = new Round(this, set, map);
                return round;
            }
            finally {
                this.compiler.close(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JavaCompiler finalCompiler() {
            try {
                Context context = this.nextContext();
                JavacProcessingEnvironment.this.context = context;
                JavaCompiler javaCompiler = JavaCompiler.instance(context);
                javaCompiler.log.initRound(this.compiler.log);
                JavaCompiler javaCompiler2 = javaCompiler;
                return javaCompiler2;
            }
            finally {
                this.compiler.close(false);
            }
        }

        int errorCount() {
            return this.compiler.errorCount();
        }

        int warningCount() {
            return this.compiler.warningCount();
        }

        boolean unrecoverableError() {
            if (JavacProcessingEnvironment.this.messager.errorRaised()) {
                return true;
            }
            for (JCDiagnostic jCDiagnostic : this.deferredDiagnosticHandler.getDiagnostics()) {
                switch (jCDiagnostic.getKind()) {
                    case WARNING: {
                        if (!JavacProcessingEnvironment.this.werror) break;
                        return true;
                    }
                    case ERROR: {
                        if (!JavacProcessingEnvironment.this.fatalErrors && jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.RECOVERABLE)) break;
                        return true;
                    }
                }
            }
            return false;
        }

        void findAnnotationsPresent() {
            ComputeAnnotationSet computeAnnotationSet = new ComputeAnnotationSet(JavacProcessingEnvironment.this.elementUtils);
            this.annotationsPresent = new LinkedHashSet<TypeElement>();
            for (Symbol.ClassSymbol typeSymbol : this.topLevelClasses) {
                computeAnnotationSet.scan((Element)typeSymbol, this.annotationsPresent);
            }
            for (Symbol.PackageSymbol packageSymbol : this.packageInfoFiles) {
                computeAnnotationSet.scan((Element)packageSymbol, this.annotationsPresent);
            }
        }

        private List<Symbol.ClassSymbol> enterClassFiles(Map<String, JavaFileObject> map) {
            ClassReader classReader = ClassReader.instance(this.context);
            Names names = Names.instance(this.context);
            List<Symbol.ClassSymbol> list = List.nil();
            for (Map.Entry<String, JavaFileObject> entry : map.entrySet()) {
                Symbol.ClassSymbol classSymbol;
                Name name = names.fromString(entry.getKey());
                JavaFileObject javaFileObject = entry.getValue();
                if (javaFileObject.getKind() != JavaFileObject.Kind.CLASS) {
                    throw new AssertionError(javaFileObject);
                }
                if (JavacProcessingEnvironment.this.isPkgInfo(javaFileObject, JavaFileObject.Kind.CLASS)) {
                    Name name2 = Convert.packagePart(name);
                    Symbol.PackageSymbol packageSymbol = classReader.enterPackage(name2);
                    if (packageSymbol.package_info == null) {
                        packageSymbol.package_info = classReader.enterClass(Convert.shortName(name), packageSymbol);
                    }
                    classSymbol = packageSymbol.package_info;
                    if (classSymbol.classfile == null) {
                        classSymbol.classfile = javaFileObject;
                    }
                } else {
                    classSymbol = classReader.enterClass(name, javaFileObject);
                }
                list = list.prepend(classSymbol);
            }
            return list.reverse();
        }

        private void enterTrees(List<JCTree.JCCompilationUnit> list) {
            this.compiler.enterTrees(list);
        }

        void run(boolean bl, boolean bl2) {
            this.printRoundInfo(bl);
            if (!JavacProcessingEnvironment.this.taskListener.isEmpty()) {
                JavacProcessingEnvironment.this.taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
            }
            try {
                if (bl) {
                    JavacProcessingEnvironment.this.filer.setLastRound(true);
                    Set set = Collections.emptySet();
                    JavacRoundEnvironment javacRoundEnvironment = new JavacRoundEnvironment(true, bl2, set, JavacProcessingEnvironment.this);
                    JavacProcessingEnvironment.this.discoveredProcs.iterator().runContributingProcs(javacRoundEnvironment);
                } else {
                    JavacProcessingEnvironment.this.discoverAndRunProcs(this.context, this.annotationsPresent, this.topLevelClasses, this.packageInfoFiles);
                }
            }
            catch (Throwable throwable) {
                this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                throw throwable;
            }
            finally {
                if (!JavacProcessingEnvironment.this.taskListener.isEmpty()) {
                    JavacProcessingEnvironment.this.taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
                }
            }
        }

        void showDiagnostics(boolean bl) {
            EnumSet<Diagnostic.Kind> enumSet = EnumSet.allOf(Diagnostic.Kind.class);
            if (!bl) {
                enumSet.remove((Object)Diagnostic.Kind.ERROR);
            }
            this.deferredDiagnosticHandler.reportDeferredDiagnostics(enumSet);
            this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
        }

        private void printRoundInfo(boolean bl) {
            if (JavacProcessingEnvironment.this.printRounds || JavacProcessingEnvironment.this.verbose) {
                List<Object> list = bl ? List.nil() : this.topLevelClasses;
                Set<Object> set = bl ? Collections.emptySet() : this.annotationsPresent;
                Object[] objectArray = new Object[4];
                objectArray[0] = this.number;
                String string = String.valueOf(String.valueOf(list.toString(", ")));
                objectArray[1] = new StringBuilder(2 + string.length()).append("{").append(string).append("}").toString();
                objectArray[2] = set;
                objectArray[3] = bl;
                this.log.printLines("x.print.rounds", objectArray);
            }
        }

        private Context nextContext() {
            JavacTrees javacTrees;
            FSInfo fSInfo;
            MultiTaskListener multiTaskListener;
            Context context = new Context(this.context);
            Options options = Options.instance(this.context);
            Assert.checkNonNull(options);
            context.put(Options.optionsKey, options);
            Locale locale = this.context.get(Locale.class);
            if (locale != null) {
                context.put(Locale.class, locale);
            }
            Assert.checkNonNull(JavacProcessingEnvironment.this.messages);
            context.put(JavacMessages.messagesKey, JavacProcessingEnvironment.this.messages);
            Object object = Names.instance(this.context);
            Assert.checkNonNull(object);
            context.put(Names.namesKey, object);
            object = this.context.get(DiagnosticListener.class);
            if (object != null) {
                context.put(DiagnosticListener.class, object);
            }
            if ((multiTaskListener = this.context.get(MultiTaskListener.taskListenerKey)) != null) {
                context.put(MultiTaskListener.taskListenerKey, multiTaskListener);
            }
            if ((fSInfo = this.context.get(FSInfo.class)) != null) {
                context.put(FSInfo.class, fSInfo);
            }
            JavaFileManager javaFileManager = this.context.get(JavaFileManager.class);
            Assert.checkNonNull(javaFileManager);
            context.put(JavaFileManager.class, javaFileManager);
            if (javaFileManager instanceof JavacFileManager) {
                ((JavacFileManager)javaFileManager).setContext(context);
            }
            Names names = Names.instance(this.context);
            Assert.checkNonNull(names);
            context.put(Names.namesKey, names);
            Tokens tokens = Tokens.instance(this.context);
            Assert.checkNonNull(tokens);
            context.put(Tokens.tokensKey, tokens);
            Log log = Log.instance(context);
            log.initRound(this.log);
            JavaCompiler javaCompiler = JavaCompiler.instance(this.context);
            JavaCompiler javaCompiler2 = JavaCompiler.instance(context);
            javaCompiler2.initRound(javaCompiler);
            JavacProcessingEnvironment.this.filer.newRound(context);
            JavacProcessingEnvironment.this.messager.newRound(context);
            JavacProcessingEnvironment.this.elementUtils.setContext(context);
            JavacProcessingEnvironment.this.typeUtils.setContext(context);
            JavacTask javacTask = this.context.get(JavacTask.class);
            if (javacTask != null) {
                context.put(JavacTask.class, javacTask);
                if (javacTask instanceof BasicJavacTask) {
                    ((BasicJavacTask)javacTask).updateContext(context);
                }
            }
            if ((javacTrees = this.context.get(JavacTrees.class)) != null) {
                context.put(JavacTrees.class, javacTrees);
                javacTrees.updateContext(context);
            }
            this.context.clear();
            return context;
        }
    }

    public static class ComputeAnnotationSet
    extends ElementScanner8<Set<TypeElement>, Set<TypeElement>> {
        final Elements elements;

        public ComputeAnnotationSet(Elements elements) {
            this.elements = elements;
        }

        @Override
        public Set<TypeElement> visitPackage(PackageElement packageElement, Set<TypeElement> set) {
            return set;
        }

        @Override
        public Set<TypeElement> visitType(TypeElement typeElement, Set<TypeElement> set) {
            this.scan(typeElement.getTypeParameters(), set);
            return (Set)this.scan(typeElement.getEnclosedElements(), set);
        }

        @Override
        public Set<TypeElement> visitExecutable(ExecutableElement executableElement, Set<TypeElement> set) {
            this.scan(executableElement.getTypeParameters(), set);
            return (Set)this.scan(executableElement.getEnclosedElements(), set);
        }

        void addAnnotations(Element element, Set<TypeElement> set) {
            for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(element)) {
                Element element2 = annotationMirror.getAnnotationType().asElement();
                set.add((TypeElement)element2);
            }
        }

        @Override
        public Set<TypeElement> scan(Element element, Set<TypeElement> set) {
            this.addAnnotations(element, set);
            return (Set)super.scan(element, set);
        }
    }

    class DiscoveredProcessors
    implements Iterable<ProcessorState> {
        Iterator<? extends Processor> processorIterator;
        ArrayList<ProcessorState> procStateList;

        public ProcessorStateIterator iterator() {
            return new ProcessorStateIterator(this);
        }

        DiscoveredProcessors(Iterator<? extends Processor> iterator) {
            this.processorIterator = iterator;
            this.procStateList = new ArrayList();
        }

        public void close() {
            if (this.processorIterator != null && this.processorIterator instanceof ServiceIterator) {
                ((ServiceIterator)this.processorIterator).close();
            }
        }

        class ProcessorStateIterator
        implements Iterator<ProcessorState> {
            DiscoveredProcessors psi;
            Iterator<ProcessorState> innerIter;
            boolean onProcInterator;

            ProcessorStateIterator(DiscoveredProcessors discoveredProcessors2) {
                this.psi = discoveredProcessors2;
                this.innerIter = discoveredProcessors2.procStateList.iterator();
                this.onProcInterator = false;
            }

            @Override
            public ProcessorState next() {
                if (!this.onProcInterator) {
                    if (this.innerIter.hasNext()) {
                        return this.innerIter.next();
                    }
                    this.onProcInterator = true;
                }
                if (this.psi.processorIterator.hasNext()) {
                    ProcessorState processorState = new ProcessorState(this.psi.processorIterator.next(), JavacProcessingEnvironment.this.log, JavacProcessingEnvironment.this.source, JavacProcessingEnvironment.this);
                    this.psi.procStateList.add(processorState);
                    return processorState;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.onProcInterator) {
                    return this.psi.processorIterator.hasNext();
                }
                return this.innerIter.hasNext() || this.psi.processorIterator.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void runContributingProcs(RoundEnvironment roundEnvironment) {
                if (!this.onProcInterator) {
                    Set set = Collections.emptySet();
                    while (this.innerIter.hasNext()) {
                        ProcessorState processorState = this.innerIter.next();
                        if (!processorState.contributed) continue;
                        JavacProcessingEnvironment.this.callProcessor(processorState.processor, set, roundEnvironment);
                    }
                }
            }
        }
    }

    static class ProcessorState {
        public Processor processor;
        public boolean contributed;
        private ArrayList<Pattern> supportedAnnotationPatterns;
        private ArrayList<String> supportedOptionNames;

        ProcessorState(Processor processor, Log log, Source source, ProcessingEnvironment processingEnvironment) {
            this.processor = processor;
            this.contributed = false;
            try {
                this.processor.init(processingEnvironment);
                this.checkSourceVersionCompatibility(source, log);
                this.supportedAnnotationPatterns = new ArrayList();
                for (String string : this.processor.getSupportedAnnotationTypes()) {
                    this.supportedAnnotationPatterns.add(JavacProcessingEnvironment.importStringToPattern(string, this.processor, log));
                }
                this.supportedOptionNames = new ArrayList();
                for (String string : this.processor.getSupportedOptions()) {
                    if (!this.checkOptionName(string, log)) continue;
                    this.supportedOptionNames.add(string);
                }
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Throwable throwable) {
                throw new AnnotationProcessingError(throwable);
            }
        }

        private void checkSourceVersionCompatibility(Source source, Log log) {
            SourceVersion sourceVersion = this.processor.getSupportedSourceVersion();
            if (sourceVersion.compareTo(Source.toSourceVersion(source)) < 0) {
                log.warning("proc.processor.incompatible.source.version", new Object[]{sourceVersion, this.processor.getClass().getName(), source.name});
            }
        }

        private boolean checkOptionName(String string, Log log) {
            boolean bl = JavacProcessingEnvironment.isValidOptionName(string);
            if (!bl) {
                log.error("proc.processor.bad.option.name", string, this.processor.getClass().getName());
            }
            return bl;
        }

        public boolean annotationSupported(String string) {
            for (Pattern pattern : this.supportedAnnotationPatterns) {
                if (!pattern.matcher(string).matches()) continue;
                return true;
            }
            return false;
        }

        public void removeSupportedOptions(Set<String> set) {
            set.removeAll(this.supportedOptionNames);
        }
    }

    private static class NameProcessIterator
    implements Iterator<Processor> {
        Processor nextProc = null;
        Iterator<String> names;
        ClassLoader processorCL;
        Log log;

        NameProcessIterator(String string, ClassLoader classLoader, Log log) {
            this.names = Arrays.asList(string.split(",")).iterator();
            this.processorCL = classLoader;
            this.log = log;
        }

        @Override
        public boolean hasNext() {
            Processor processor;
            if (this.nextProc != null) {
                return true;
            }
            if (!this.names.hasNext()) {
                return false;
            }
            String string = this.names.next();
            try {
                try {
                    processor = (Processor)this.processorCL.loadClass(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.log.error("proc.processor.not.found", string);
                    return false;
                }
                catch (ClassCastException classCastException) {
                    this.log.error("proc.processor.wrong.type", string);
                    return false;
                }
                catch (Exception exception) {
                    this.log.error("proc.processor.cant.instantiate", string);
                    return false;
                }
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Throwable throwable) {
                throw new AnnotationProcessingError(throwable);
            }
            this.nextProc = processor;
            return true;
        }

        @Override
        public Processor next() {
            if (this.hasNext()) {
                Processor processor = this.nextProc;
                this.nextProc = null;
                return processor;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ServiceIterator
    implements Iterator<Processor> {
        private Iterator<Processor> iterator;
        private Log log;
        private ServiceLoader<Processor> loader;

        ServiceIterator(ClassLoader classLoader, Log log) {
            this.log = log;
            try {
                try {
                    this.loader = ServiceLoader.load(Processor.class, classLoader);
                    this.iterator = this.loader.iterator();
                }
                catch (Exception exception) {
                    this.iterator = JavacProcessingEnvironment.this.handleServiceLoaderUnavailability("proc.no.service", null);
                }
            }
            catch (Throwable throwable) {
                log.error("proc.service.problem", new Object[0]);
                throw new Abort(throwable);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.iterator.hasNext();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                this.log.error("proc.bad.config.file", serviceConfigurationError.getLocalizedMessage());
                throw new Abort(serviceConfigurationError);
            }
            catch (Throwable throwable) {
                throw new Abort(throwable);
            }
        }

        @Override
        public Processor next() {
            try {
                return this.iterator.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                this.log.error("proc.bad.config.file", serviceConfigurationError.getLocalizedMessage());
                throw new Abort(serviceConfigurationError);
            }
            catch (Throwable throwable) {
                throw new Abort(throwable);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            if (this.loader != null) {
                try {
                    this.loader.reload();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

