/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor7;
import javax.lang.model.util.SimpleElementVisitor8;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class PrintingProcessor
extends AbstractProcessor {
    PrintWriter writer = new PrintWriter(System.out);

    public void setWriter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getRootElements()) {
            this.print(element);
        }
        return true;
    }

    void print(Element element) {
        ((PrintingElementVisitor)new PrintingElementVisitor(this.writer, this.processingEnv.getElementUtils()).visit(element)).flush();
    }

    public static class PrintingElementVisitor
    extends SimpleElementVisitor8<PrintingElementVisitor, Boolean> {
        int indentation;
        final PrintWriter writer;
        final Elements elementUtils;
        private static final String[] spaces = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            ", "              ", "                ", "                  ", "                    "};

        public PrintingElementVisitor(Writer writer, Elements elements) {
            this.writer = new PrintWriter(writer);
            this.elementUtils = elements;
            this.indentation = 0;
        }

        @Override
        protected PrintingElementVisitor defaultAction(Element element, Boolean bl) {
            if (bl != null && bl.booleanValue()) {
                this.writer.println();
            }
            this.printDocComment(element);
            this.printModifiers(element);
            return this;
        }

        @Override
        public PrintingElementVisitor visitExecutable(ExecutableElement executableElement, Boolean bl) {
            ElementKind elementKind = executableElement.getKind();
            if (elementKind != ElementKind.STATIC_INIT && elementKind != ElementKind.INSTANCE_INIT) {
                Element element = executableElement.getEnclosingElement();
                if (elementKind == ElementKind.CONSTRUCTOR && element != null && NestingKind.ANONYMOUS == new SimpleElementVisitor7<NestingKind, Void>(){

                    @Override
                    public NestingKind visitType(TypeElement typeElement, Void void_) {
                        return typeElement.getNestingKind();
                    }
                }.visit(element)) {
                    return this;
                }
                this.defaultAction((Element)executableElement, true);
                this.printFormalTypeParameters(executableElement, true);
                switch (elementKind) {
                    case CONSTRUCTOR: {
                        this.writer.print(executableElement.getEnclosingElement().getSimpleName());
                        break;
                    }
                    case METHOD: {
                        this.writer.print(executableElement.getReturnType().toString());
                        this.writer.print(" ");
                        this.writer.print(executableElement.getSimpleName().toString());
                    }
                }
                this.writer.print("(");
                this.printParameters(executableElement);
                this.writer.print(")");
                AnnotationValue annotationValue = executableElement.getDefaultValue();
                if (annotationValue != null) {
                    String string = String.valueOf(String.valueOf(annotationValue));
                    this.writer.print(new StringBuilder(9 + string.length()).append(" default ").append(string).toString());
                }
                this.printThrows(executableElement);
                this.writer.println(";");
            }
            return this;
        }

        @Override
        public PrintingElementVisitor visitType(TypeElement typeElement, Boolean bl) {
            Object object;
            Object object3;
            ElementKind elementKind = typeElement.getKind();
            NestingKind nestingKind = typeElement.getNestingKind();
            if (NestingKind.ANONYMOUS == nestingKind) {
                List<ExecutableElement> object22;
                this.writer.print("new ");
                object3 = typeElement.getInterfaces();
                if (!object3.isEmpty()) {
                    this.writer.print(object3.get(0));
                } else {
                    this.writer.print(typeElement.getSuperclass());
                }
                this.writer.print("(");
                if (object3.isEmpty() && !(object22 = ElementFilter.constructorsIn(typeElement.getEnclosedElements())).isEmpty()) {
                    this.printParameters(object22.get(0));
                }
                this.writer.print(")");
            } else {
                TypeElement typeElement2;
                if (nestingKind == NestingKind.TOP_LEVEL && !(object3 = this.elementUtils.getPackageOf(typeElement)).isUnnamed()) {
                    String string = String.valueOf(String.valueOf(object3.getQualifiedName()));
                    this.writer.print(new StringBuilder(10 + string.length()).append("package ").append(string).append(";\n").toString());
                }
                this.defaultAction((Element)typeElement, true);
                switch (elementKind) {
                    case ANNOTATION_TYPE: {
                        this.writer.print("@interface");
                        break;
                    }
                    default: {
                        this.writer.print(elementKind.toString().toLowerCase());
                    }
                }
                this.writer.print(" ");
                this.writer.print(typeElement.getSimpleName());
                this.printFormalTypeParameters(typeElement, false);
                if (elementKind == ElementKind.CLASS && (object3 = typeElement.getSuperclass()).getKind() != TypeKind.NONE && (typeElement2 = (TypeElement)((DeclaredType)object3).asElement()).getSuperclass().getKind() != TypeKind.NONE) {
                    object = String.valueOf(String.valueOf(object3));
                    this.writer.print(new StringBuilder(9 + ((String)object).length()).append(" extends ").append((String)object).toString());
                }
                this.printInterfaces(typeElement);
            }
            this.writer.println(" {");
            ++this.indentation;
            if (elementKind == ElementKind.ENUM) {
                Element element;
                object3 = new ArrayList<Element>(typeElement.getEnclosedElements());
                ArrayList<Element> arrayList = new ArrayList<Element>();
                object = object3.iterator();
                while (object.hasNext()) {
                    element = (Element)object.next();
                    if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    arrayList.add(element);
                }
                if (!arrayList.isEmpty()) {
                    int n;
                    for (n = 0; n < arrayList.size() - 1; ++n) {
                        this.visit((Element)arrayList.get(n), true);
                        this.writer.print(",");
                    }
                    this.visit((Element)arrayList.get(n), true);
                    this.writer.println(";\n");
                    object3.removeAll(arrayList);
                }
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    element = (Element)iterator.next();
                    this.visit(element);
                }
            } else {
                for (Element element : typeElement.getEnclosedElements()) {
                    this.visit(element);
                }
            }
            --this.indentation;
            this.indent();
            this.writer.println("}");
            return this;
        }

        @Override
        public PrintingElementVisitor visitVariable(VariableElement variableElement, Boolean bl) {
            ElementKind elementKind = variableElement.getKind();
            this.defaultAction((Element)variableElement, bl);
            if (elementKind == ElementKind.ENUM_CONSTANT) {
                this.writer.print(variableElement.getSimpleName());
            } else {
                String string = String.valueOf(String.valueOf(variableElement.asType().toString()));
                String string2 = String.valueOf(String.valueOf(variableElement.getSimpleName()));
                this.writer.print(new StringBuilder(1 + string.length() + string2.length()).append(string).append(" ").append(string2).toString());
                Object object = variableElement.getConstantValue();
                if (object != null) {
                    this.writer.print(" = ");
                    this.writer.print(this.elementUtils.getConstantExpression(object));
                }
                this.writer.println(";");
            }
            return this;
        }

        @Override
        public PrintingElementVisitor visitTypeParameter(TypeParameterElement typeParameterElement, Boolean bl) {
            this.writer.print(typeParameterElement.getSimpleName());
            return this;
        }

        @Override
        public PrintingElementVisitor visitPackage(PackageElement packageElement, Boolean bl) {
            this.defaultAction((Element)packageElement, false);
            if (!packageElement.isUnnamed()) {
                String string = String.valueOf(String.valueOf(packageElement.getQualifiedName()));
                this.writer.println(new StringBuilder(9 + string.length()).append("package ").append(string).append(";").toString());
            } else {
                this.writer.println("// Unnamed package");
            }
            return this;
        }

        public void flush() {
            this.writer.flush();
        }

        private void printDocComment(Element element) {
            String string = this.elementUtils.getDocComment(element);
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
                this.indent();
                this.writer.println("/**");
                while (stringTokenizer.hasMoreTokens()) {
                    this.indent();
                    this.writer.print(" *");
                    this.writer.println(stringTokenizer.nextToken());
                }
                this.indent();
                this.writer.println(" */");
            }
        }

        private void printModifiers(Element element) {
            ElementKind elementKind = element.getKind();
            if (elementKind == ElementKind.PARAMETER) {
                this.printAnnotationsInline(element);
            } else {
                this.printAnnotations(element);
                this.indent();
            }
            if (elementKind == ElementKind.ENUM_CONSTANT) {
                return;
            }
            LinkedHashSet<Modifier> linkedHashSet = new LinkedHashSet<Modifier>();
            linkedHashSet.addAll(element.getModifiers());
            switch (elementKind) {
                case ANNOTATION_TYPE: 
                case INTERFACE: {
                    linkedHashSet.remove((Object)Modifier.ABSTRACT);
                    break;
                }
                case ENUM: {
                    linkedHashSet.remove((Object)Modifier.FINAL);
                    linkedHashSet.remove((Object)Modifier.ABSTRACT);
                    break;
                }
                case METHOD: 
                case FIELD: {
                    Element element2 = element.getEnclosingElement();
                    if (element2 == null || !element2.getKind().isInterface()) break;
                    linkedHashSet.remove((Object)Modifier.PUBLIC);
                    linkedHashSet.remove((Object)Modifier.ABSTRACT);
                    linkedHashSet.remove((Object)Modifier.STATIC);
                    linkedHashSet.remove((Object)Modifier.FINAL);
                }
            }
            for (Modifier modifier : linkedHashSet) {
                this.writer.print(String.valueOf(modifier.toString()).concat(" "));
            }
        }

        private void printFormalTypeParameters(Parameterizable parameterizable, boolean bl) {
            List<? extends TypeParameterElement> list = parameterizable.getTypeParameters();
            if (list.size() > 0) {
                this.writer.print("<");
                boolean bl2 = true;
                for (TypeParameterElement typeParameterElement : list) {
                    if (!bl2) {
                        this.writer.print(", ");
                    }
                    this.printAnnotationsInline(typeParameterElement);
                    this.writer.print(typeParameterElement.toString());
                    bl2 = false;
                }
                this.writer.print(">");
                if (bl) {
                    this.writer.print(" ");
                }
            }
        }

        private void printAnnotationsInline(Element element) {
            List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                this.writer.print(annotationMirror);
                this.writer.print(" ");
            }
        }

        private void printAnnotations(Element element) {
            List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                this.indent();
                this.writer.println(annotationMirror);
            }
        }

        private void printParameters(ExecutableElement executableElement) {
            List<? extends VariableElement> list = executableElement.getParameters();
            int n = list.size();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    for (VariableElement variableElement2 : list) {
                        VariableElement variableElement2;
                        this.printModifiers(variableElement2);
                        if (executableElement.isVarArgs()) {
                            TypeMirror variableElement3 = variableElement2.asType();
                            if (variableElement3.getKind() != TypeKind.ARRAY) {
                                String string = String.valueOf(String.valueOf(variableElement3));
                                throw new AssertionError((Object)new StringBuilder(41 + string.length()).append("Var-args parameter is not an array type: ").append(string).toString());
                            }
                            this.writer.print(((ArrayType)ArrayType.class.cast(variableElement3)).getComponentType());
                            this.writer.print("...");
                        } else {
                            this.writer.print(variableElement2.asType());
                        }
                        String object = String.valueOf(String.valueOf(variableElement2.getSimpleName()));
                        this.writer.print(new StringBuilder(1 + object.length()).append(" ").append(object).toString());
                    }
                    break;
                }
                default: {
                    int n2 = 1;
                    for (VariableElement variableElement : list) {
                        Object object;
                        if (n2 == 2) {
                            ++this.indentation;
                        }
                        if (n2 > 1) {
                            this.indent();
                        }
                        this.printModifiers(variableElement);
                        if (n2 == n && executableElement.isVarArgs()) {
                            object = variableElement.asType();
                            if (object.getKind() != TypeKind.ARRAY) {
                                String string = String.valueOf(String.valueOf(object));
                                throw new AssertionError((Object)new StringBuilder(41 + string.length()).append("Var-args parameter is not an array type: ").append(string).toString());
                            }
                            this.writer.print(((ArrayType)ArrayType.class.cast(object)).getComponentType());
                            this.writer.print("...");
                        } else {
                            this.writer.print(variableElement.asType());
                        }
                        object = String.valueOf(String.valueOf(variableElement.getSimpleName()));
                        this.writer.print(new StringBuilder(1 + ((String)object).length()).append(" ").append((String)object).toString());
                        if (n2 < n) {
                            this.writer.println(",");
                        }
                        ++n2;
                    }
                    if (list.size() < 2) break;
                    --this.indentation;
                }
            }
        }

        private void printInterfaces(TypeElement typeElement) {
            List<? extends TypeMirror> list;
            ElementKind elementKind = typeElement.getKind();
            if (elementKind != ElementKind.ANNOTATION_TYPE && (list = typeElement.getInterfaces()).size() > 0) {
                this.writer.print(elementKind.isClass() ? " implements" : " extends");
                boolean bl = true;
                for (TypeMirror typeMirror : list) {
                    if (!bl) {
                        this.writer.print(",");
                    }
                    this.writer.print(" ");
                    this.writer.print(typeMirror.toString());
                    bl = false;
                }
            }
        }

        private void printThrows(ExecutableElement executableElement) {
            List<? extends TypeMirror> list = executableElement.getThrownTypes();
            int n = list.size();
            if (n != 0) {
                this.writer.print(" throws");
                int n2 = 1;
                for (TypeMirror typeMirror : list) {
                    if (n2 == 1) {
                        this.writer.print(" ");
                    }
                    if (n2 == 2) {
                        ++this.indentation;
                    }
                    if (n2 >= 2) {
                        this.indent();
                    }
                    this.writer.print(typeMirror);
                    if (n2 != n) {
                        this.writer.println(", ");
                    }
                    ++n2;
                }
                if (n >= 2) {
                    --this.indentation;
                }
            }
        }

        private void indent() {
            int n = this.indentation;
            if (n < 0) {
                return;
            }
            int n2 = spaces.length - 1;
            while (n > n2) {
                this.writer.print(spaces[n2]);
                n -= n2;
            }
            this.writer.print(spaces[n]);
        }
    }
}

