/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Convert;

public class Constants {
    public static Object decode(Object object, Type type) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            switch (type.getTag()) {
                case BOOLEAN: {
                    return n != 0;
                }
                case CHAR: {
                    return Character.valueOf((char)n);
                }
                case BYTE: {
                    return (byte)n;
                }
                case SHORT: {
                    return (short)n;
                }
            }
        }
        return object;
    }

    public static String format(Object object, Type type) {
        object = Constants.decode(object, type);
        switch (type.getTag()) {
            case BYTE: {
                return Constants.formatByte((Byte)object);
            }
            case LONG: {
                return Constants.formatLong((Long)object);
            }
            case FLOAT: {
                return Constants.formatFloat(((Float)object).floatValue());
            }
            case DOUBLE: {
                return Constants.formatDouble((Double)object);
            }
            case CHAR: {
                return Constants.formatChar(((Character)object).charValue());
            }
        }
        if (object instanceof String) {
            return Constants.formatString((String)object);
        }
        String string = String.valueOf(String.valueOf(object));
        return new StringBuilder(0 + string.length()).append(string).toString();
    }

    public static String format(Object object) {
        String string;
        if (object instanceof Byte) {
            return Constants.formatByte((Byte)object);
        }
        if (object instanceof Short) {
            return Constants.formatShort((Short)object);
        }
        if (object instanceof Long) {
            return Constants.formatLong((Long)object);
        }
        if (object instanceof Float) {
            return Constants.formatFloat(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return Constants.formatDouble((Double)object);
        }
        if (object instanceof Character) {
            return Constants.formatChar(((Character)object).charValue());
        }
        if (object instanceof String) {
            return Constants.formatString((String)object);
        }
        if (object instanceof Integer || object instanceof Boolean) {
            return object.toString();
        }
        if (object == null) {
            string = "is a null value.";
        } else {
            String string2 = String.valueOf(object.getClass().getName());
            string = string2.length() != 0 ? "has class ".concat(string2) : new String("has class ");
        }
        String string3 = String.valueOf(String.valueOf(string));
        throw new IllegalArgumentException(new StringBuilder(50 + string3.length()).append("Argument is not a primitive type or a string; it ").append(string3).append(".").toString());
    }

    private static String formatByte(byte by) {
        return String.format("(byte)0x%02x", by);
    }

    private static String formatShort(short s) {
        return String.format("(short)%d", s);
    }

    private static String formatLong(long l) {
        long l2 = l;
        return new StringBuilder(21).append(l2).append("L").toString();
    }

    private static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "0.0f/0.0f";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-1.0f/0.0f" : "1.0f/0.0f";
        }
        float f2 = f;
        return new StringBuilder(16).append(f2).append("f").toString();
    }

    private static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "0.0/0.0";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-1.0/0.0" : "1.0/0.0";
        }
        double d2 = d;
        return new StringBuilder(24).append(d2).toString();
    }

    private static String formatChar(char c) {
        String string = String.valueOf(String.valueOf(Convert.quote(c)));
        return new StringBuilder(2 + string.length()).append("'").append(string).append("'").toString();
    }

    private static String formatString(String string) {
        String string2 = String.valueOf(String.valueOf(Convert.quote(string)));
        return new StringBuilder(2 + string2.length()).append("\"").append(string2).append("\"").toString();
    }
}

