from distutils.command.build import build as _build
import subprocess

import setuptools

# This class handles the pip install mechanism.


class build(_build):  # pylint: disable=invalid-name
    """A build command class that will be invoked during package install.
    The package built using the current setup.py will be staged and later
    installed in the worker using `pip install package'. This class will be
    instantiated during install for this specific scenario and will trigger
    running the custom commands specified.
    """
    sub_commands = _build.sub_commands + [('CustomCommands', None)]


# Some custom command to run during setup. The command is not essential for this
# workflow. It is used here as an example. Each command will spawn a child
# process. Typically, these commands will include steps to install non-Python
# packages.
#
# First, note that there is no need to use the sudo command because the setup
# script runs with appropriate access.
# Second, if apt-get tool is used then the first command needs to be 'apt-get
# update' so the tool refreshes itself and initializes links to download
# repositories.  Without this initial step the other apt-get install commands
# will fail with package not found errors. Note also --assume-yes option which
# shortcuts the interactive confirmation.
#
# The output of custom commands (including failures) will be logged in the
# worker-startup log.
"""
CUSTOM_COMMANDS = [
    ['apt-get', 'update'],
    ['apt-get', '--assume-yes', 'install', 'wget'],
    ['apt-get', '--assume-yes', 'install', 'net-tools'],
    ['wget', 'https://dl.google.com/cloudsql/cloud_sql_proxy.linux.amd64 -O cloud_sql_proxy'],
    ['chmod+x', 'cloud_sql_proxy']
]
"""
CUSTOM_COMMANDS = []


class CustomCommands(setuptools.Command):
    """A setuptools Command class able to run arbitrary commands."""

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def RunCustomCommand(self, command_list):
        print
        'Running command: %s' % command_list
        p = subprocess.Popen(
            command_list,
            stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        # Can use communicate(input='y\n'.encode()) if the command run requires
        # some confirmation.
        stdout_data, _ = p.communicate()
        print
        'Command output: %s' % stdout_data
        if p.returncode != 0:
            raise RuntimeError(
                'Command %s failed: exit code: %s' % (command_list, p.returncode))

    def run(self):
        for command in CUSTOM_COMMANDS:
            self.RunCustomCommand(command)


setuptools.setup(name='pycloudsqlproxy',
                 version='0.0.14',
                 description='Connect through cloud_sql_proxy',
                 url='http://github.com/noah-goodrich/pycloudsqlproxy',
                 author='Noah Goodrich',
                 author_email='me@noahgoodrich.com',
                 license='Apache 2.0',
                 cmdclass={
                    # Command class instantiated and run during pip install scenarios.
                    'build': build,
                    'CustomCommands': CustomCommands,
                 },
                 include_package_data=True,
                 packages=['pycloudsqlproxy'])
