/* global io */

const socket = io.connect('http://' + document.domain + ':' + location.port);

socket.on('fileAnalyzedChange', msg => {
	const div = document.getElementById('AnalyzedFile');
	div.innerHTML = 'Analyzing : ' + msg.file;
});

socket.on('analysisCompleted', _ => {
	window.location.href = './home';
});

socket.on('disconnect', () => {
	console.log('disconnected');
	const div = document.getElementById('AnalyzedFile');
	const loader = document.getElementById('Loader');

	div.innerHTML = 'No supported file found';
	loader.classList.remove('loader');
	loader.innerHTML = `<svg version="1.0" xmlns="http://www.w3.org/2000/svg"
 width="512.000000pt" height="512.000000pt" viewBox="0 0 512.000000 512.000000"
 preserveAspectRatio="xMidYMid meet">

<g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"
fill="#000000" stroke="none">
<path d="M2365 5109 c-343 -33 -612 -139 -793 -313 -167 -159 -259 -337 -297
-570 -17 -102 -20 -369 -6 -512 10 -102 24 -136 86 -209 59 -69 77 -109 83
-181 3 -48 -1 -77 -19 -130 -21 -61 -23 -86 -22 -210 2 -218 16 -233 230 -245
155 -9 212 -28 238 -79 15 -29 16 -55 10 -209 -6 -158 -4 -179 12 -210 24 -45
79 -73 162 -80 55 -5 73 -12 107 -39 66 -53 136 -65 219 -36 45 15 47 15 107
-15 86 -44 170 -44 256 0 60 30 62 30 107 15 83 -29 149 -17 219 38 32 24 53
32 105 37 78 7 133 30 158 67 16 24 18 51 18 228 0 225 0 224 73 256 30 14 80
21 175 27 213 12 228 28 228 253 0 120 -3 153 -20 202 -23 66 -27 139 -10 197
7 21 38 71 71 111 87 109 92 130 92 443 1 233 -1 269 -21 352 -87 366 -337
625 -718 742 -234 71 -555 98 -850 70z m-82 -1417 c72 -41 102 -99 101 -197 0
-56 -6 -81 -30 -129 -42 -87 -113 -159 -192 -198 -62 -31 -74 -33 -167 -33
-110 0 -173 20 -227 72 -68 65 -90 231 -44 328 41 89 107 134 243 169 86 22
111 25 191 21 58 -3 83 -9 125 -33z m966 13 c181 -47 258 -123 269 -266 10
-136 -37 -231 -136 -277 -50 -24 -70 -27 -157 -27 -93 0 -105 2 -167 33 -79
39 -153 115 -195 200 -37 75 -40 184 -5 249 55 104 202 137 391 88z m-574
-412 c15 -16 50 -77 77 -138 103 -227 102 -224 103 -311 0 -70 -3 -85 -26
-120 -35 -52 -113 -94 -189 -101 -161 -15 -280 78 -280 218 0 71 13 115 65
224 24 50 55 116 69 147 34 79 65 108 115 108 30 0 46 -7 66 -27z"/>
<path d="M1130 2443 c-39 -14 -81 -70 -100 -131 -28 -91 -58 -139 -97 -157
-30 -14 -44 -15 -103 -5 -79 13 -104 8 -143 -29 -64 -58 -82 -137 -53 -232 38
-125 111 -210 215 -250 66 -26 196 -30 354 -12 176 21 320 -8 511 -103 209
-104 516 -270 513 -277 -3 -11 -404 -235 -622 -347 -288 -149 -424 -186 -655
-175 -110 5 -143 4 -179 -9 -92 -34 -151 -100 -151 -172 0 -40 19 -77 89 -167
17 -21 44 -79 62 -129 18 -50 42 -104 53 -121 51 -75 175 -134 261 -125 66 8
111 42 185 142 37 50 87 109 111 131 94 86 424 322 689 492 225 145 474 293
491 293 17 0 275 -155 499 -299 276 -178 633 -435 699 -504 18 -19 63 -75 100
-123 82 -110 129 -138 211 -131 70 6 137 36 189 82 32 29 48 58 85 153 31 78
59 134 87 167 54 65 69 96 69 142 0 46 -26 91 -72 127 -64 48 -102 55 -295 54
-198 -2 -252 8 -421 77 -125 51 -822 428 -822 444 0 7 409 223 551 291 188 89
335 110 559 80 262 -35 420 52 486 269 28 94 14 162 -49 228 -38 41 -72 48
-152 33 -54 -10 -68 -10 -98 5 -39 18 -76 78 -101 165 -15 55 -47 95 -93 119
-37 19 -123 13 -178 -13 -75 -34 -108 -67 -188 -185 -91 -135 -268 -314 -392
-397 -121 -82 -660 -404 -674 -404 -16 0 -606 354 -696 418 -141 99 -287 252
-393 413 -57 86 -96 122 -167 155 -48 23 -136 31 -175 17z"/>
</g>
</svg>`;
	loader.classList.add('death');
});
