# Contributing

Contributions are welcome!
Please open an [issue](https://github.com/pycodehash/pycodehash/issues)
or create a [pull request](https://github.com/pycodehash/pycodehash/pulls).

## Commit message convention

`pycodehash` follows a [numpy-inspired](https://numpy.org/devdocs/dev/development_workflow.html#writing-the-commit-message) commit message convention:

```text
API: an (incompatible) API change
BENCH: changes to the benchmark suite
BLD/PKG: change related to building pycodehash
BUG: bug fix
CHG: functional code change
CICD: CI/CD changes
DEP: deprecate something, or remove a deprecated object
DEV: development tool or utility
DOC: documentation
ENH: enhancement
MAINT: maintenance commit (refactoring, typos, etc.)
REV: revert an earlier commit
STY: style fix (whitespace, PEP8)
TST: addition or modification of tests
TYP: static typing
REL: related to releasing numpy
```

## Testing

To install the testing dependencies:

```shell
pip install -e .[test]
```

To run the tests:

```shell
pytest
```

To run testing and code coverage:

```shell
pytest --cov=./src/pycodehash/
```

## Documentation

The documentation is built with Mkdocs. Install using:

```shell
pip install pycodehash[docs]
```

Then you can serve the docs locally:

```shell
mkdocs serve
```

The docs are [automatically deployed](https://github.com/pycodehash/pycodehash/blob/main/.github/workflows/docs.yml) to GitHub Pages by GitHub actions.

## Release

The flow for releasing a new version of `pycodehash` is:

- Increase the package version in `src/pycodehash/version.py`
- A release is triggered by [creating a GitHub Release](https://github.com/pycodehash/pycodehash/releases/new)
- The release notes are auto-generated by GitHub based on the Pull Request titles ("Generate Release notes")
- [GitHub Actions](https://github.com/pycodehash/pycodehash/blob/main/.github/workflows/publish.yml) builds and uploads the package to PyPI
