#!/usr/bin/env python
# -*- coding:utf8 -*-


mimes = {
    'rtf': 'text/rtf',
    '.obj': 'application/octet-stream',
    '.ra': 'audio/x-pn-realaudio',
    'gz': 'application/x-gzip',
    'jpeg': 'image/jpeg',
    'aifc': 'audio/x-aiff',
    '.wsdl': 'application/xml',
    'mp2': 'audio/mpeg',
    'mp3': 'audio/mp3',
    '.dll': 'application/octet-stream',
    'rtx': 'text/richtext',
    'xhtml': 'application/xhtml+xml',
    'xml': 'text/xml',
    '.ras': 'image/x-cmu-raster',
    '.ram': 'application/x-pn-realaudio',
    'html': 'text/html',
    '.bcpio': 'application/x-bcpio',
    '.sh': 'application/x-sh',
    'aiff': 'audio/x-aiff',
    '.m1v': 'video/mpeg',
    'bin': 'application/macbinary',
    'mpg': 'video/mpeg',
    'docx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    '.xwd': 'image/x-xwindowdump',
    '.doc': 'application/msword',
    '.bmp': 'image/x-ms-bmp',
    'mov': 'video/quicktime',
    'psd': 'application/x-photoshop',
    '.shar': 'application/x-shar',
    '.js': 'application/javascript',
    'lzh': 'application/octet-stream',
    '.src': 'application/x-wais-source',
    '.dvi': 'application/x-dvi',
    '.aif': 'audio/x-aiff',
    '.ksh': 'text/plain',
    'tif': 'image/tiff',
    '.dot': 'application/msword',
    'hqx': 'application/mac-binhex40',
    'csv': 'text/x-comma-separated-values',
    'qt': 'video/quicktime',
    '.mht': 'message/rfc822',
    'eml': 'message/rfc822',
    '.p12': 'application/x-pkcs12',
    '.css': 'text/css',
    'exe': 'application/x-msdownload',
    '.csh': 'application/x-csh',
    '.pwz': 'application/vnd.ms-powerpoint',
    '.pdf': 'application/pdf',
    'dvi': 'application/x-dvi',
    'xsl': 'text/xml',
    '.cdf': 'application/x-netcdf',
    '.pl': 'text/plain',
    '.ai': 'application/postscript',
    'htm': 'text/html',
    'gtar': 'application/x-gtar',
    '.jpe': 'image/jpeg',
    '.jpg': 'image/jpeg',
    '.py': 'text/x-python',
    'sea': 'application/octet-stream',
    '.xml': 'text/xml',
    '.jpeg': 'image/jpeg',
    '.ps': 'application/postscript',
    '.gtar': 'application/x-gtar',
    'xht': 'application/xhtml+xml',
    'rv': 'video/vnd.rn-realvideo',
    '.xpm': 'image/x-xpixmap',
    '.hdf': 'application/x-hdf',
    '.nws': 'message/rfc822',
    '.tsv': 'text/tab-separated-values',
    '.xpdl': 'application/xml',
    '.p7c': 'application/pkcs7-mime',
    'dll': 'application/octet-stream',
    'dms': 'application/octet-stream',
    'ra': 'audio/x-realaudio',
    'smi': 'application/smil',
    'rm': 'audio/x-pn-realaudio',
    'php': 'application/x-httpd-php',
    '.ico': 'image/vnd.microsoft.icon',
    '.eps': 'application/postscript',
    'phps': 'application/x-httpd-php-source',
    '.ief': 'image/ief',
    '.so': 'application/octet-stream',
    '.xlb': 'application/vnd.ms-excel',
    'word': 'application/msword',
    'json': 'application/json',
    '.pbm': 'image/x-portable-bitmap',
    'js': 'application/x-javascript',
    '.texinfo': 'application/x-texinfo',
    '.xls': 'application/vnd.ms-excel',
    'dcr': 'application/x-director',
    '.tex': 'application/x-tex',
    'midi': 'audio/midi',
    'xls': 'application/excel',
    '.rtx': 'text/richtext',
    'dir': 'application/x-director',
    '.html': 'text/html',
    '.aiff': 'audio/x-aiff',
    '.aifc': 'audio/x-aiff',
    '.exe': 'application/octet-stream',
    'xl': 'application/excel',
    'tgz': 'application/x-tar',
    'tiff': 'image/tiff',
    '.sgm': 'text/x-sgml',
    'doc': 'application/msword',
    'ppt': 'application/powerpoint',
    '.tif': 'image/tiff',
    '.mpeg': 'video/mpeg',
    '.ustar': 'application/x-ustar',
    'ps': 'application/postscript',
    'mpga': 'audio/mpeg',
    'log': 'text/plain',
    'zip': 'application/x-zip',
    '.gif': 'image/gif',
    '.ppt': 'application/vnd.ms-powerpoint',
    '.pps': 'application/vnd.ms-powerpoint',
    'swf': 'application/x-shockwave-flash',
    'gif': 'image/gif',
    '.sgml': 'text/x-sgml',
    '.ppm': 'image/x-portable-pixmap',
    'rpm': 'audio/x-pn-realaudio-plugin',
    'smil': 'application/smil',
    '.latex': 'application/x-latex',
    'wav': 'audio/wav',
    '.bat': 'text/plain',
    '.mov': 'video/quicktime',
    '.ppa': 'application/vnd.ms-powerpoint',
    'xlsx': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    'phtml': 'application/x-httpd-php',
    '.tr': 'application/x-troff',
    '.rdf': 'application/xml',
    '.xsl': 'application/xml',
    '.eml': 'message/rfc822',
    '.nc': 'application/x-netcdf',
    '.sv4cpio': 'application/x-sv4cpio',
    'bmp': 'image/bmp',
    'txt': 'text/plain',
    'wbxml': 'application/wbxml',
    '.bin': 'application/octet-stream',
    'png': 'image/png',
    '.h': 'text/plain',
    'mpe': 'video/mpeg',
    '.tcl': 'application/x-tcl',
    '.wiz': 'application/msword',
    'lha': 'application/octet-stream',
    '.o': 'application/octet-stream',
    '.a': 'application/octet-stream',
    '.c': 'text/plain',
    'ram': 'audio/x-pn-realaudio',
    '.wav': 'audio/x-wav',
    '.vcf': 'text/x-vcard',
    '.xbm': 'image/x-xbitmap',
    '.txt': 'text/plain',
    '.au': 'audio/basic',
    'aif': 'audio/x-aiff',
    '.t': 'application/x-troff',
    '.tiff': 'image/tiff',
    '.texi': 'application/x-texinfo',
    '.oda': 'application/oda',
    '.ms': 'application/x-troff-ms',
    'tar': 'application/x-tar',
    'ai': 'application/postscript',
    '.rgb': 'image/x-rgb',
    'jpe': 'image/jpeg',
    'dxr': 'application/x-director',
    'jpg': 'image/jpeg',
    '.me': 'application/x-troff-me',
    'avi': 'video/x-msvideo',
    'oda': 'application/oda',
    '.sv4crc': 'application/x-sv4crc',
    'shtml': 'text/html',
    '.qt': 'video/quicktime',
    'sit': 'application/x-stuffit',
    '.mpa': 'video/mpeg',
    '.mpg': 'video/mpeg',
    'mid': 'audio/midi',
    '.mpe': 'video/mpeg',
    'mif': 'application/vnd.mif',
    '.avi': 'video/x-msvideo',
    '.pgm': 'image/x-portable-graymap',
    '.pot': 'application/vnd.ms-powerpoint',
    '.mif': 'application/x-mif',
    'php4': 'application/x-httpd-php',
    'so': 'application/octet-stream',
    '.roff': 'application/x-troff',
    '.htm': 'text/html',
    'css': 'text/css',
    'php3': 'application/x-httpd-php',
    'mpeg': 'video/mpeg',
    '.man': 'application/x-troff-man',
    '.etx': 'text/x-setext',
    'pdf': 'application/pdf',
    '.zip': 'application/zip',
    'class': 'application/octet-stream',
    '.movie': 'video/x-sgi-movie',
    '.pyc': 'application/x-python-code',
    '.png': 'image/png',
    '.pfx': 'application/x-pkcs12',
    '.mhtml': 'message/rfc822',
    '.tar': 'application/x-tar',
    '.pnm': 'image/x-portable-anymap',
    'eps': 'application/postscript',
    '.pyo': 'application/x-python-code',
    '.snd': 'audio/basic',
    '.cpio': 'application/x-cpio',
    'text': 'text/plain',
    '.swf': 'application/x-shockwave-flash',
    'movie': 'video/x-sgi-movie',
    '.mp3': 'audio/mpeg',
    '.mp2': 'audio/mpeg',
    'wmlc': 'application/wmlc',
    'cpt': 'application/mac-compactpro',
    '.mp4': 'video/mp4'
}
import os

class CI_Static(object):

    def __init__(self, **kwargs):
        super(CI_Static, self).__init__()
        self.application_path= kwargs['application_path']
        self.app = kwargs['app']
        self.static_path = kwargs['server']['static_dir']

    def accept(self,env):
        paths = [e for e in env['PATH_INFO'].split("/") if e != ""]
        ##防止读取上层目录
        if ".." in paths:
            return False
        if paths[0] == self.static_path:
            path = "%s/%s"  % ( self.application_path , "/".join(paths) )
            ##如果文件存在则跑静态路由
            if os.path.exists(path):
                return True

        return False

    def route(self,env):
        paths = [e for e in env['PATH_INFO'].split("/") if e != ""]
        path = "./%s"  %"/".join(paths)
        filename = paths[-1]
        extname = filename.split(".")[-1]
        mime = mimes.get(extname,"text/html")
        self.app.set_header("Content-type",mime)
        content = b""
        with open(path) as fp:
            content = fp.read()
        return "200 OK",content



