import click
from .client import client
from .config import *
from .cache import cache





# leet_contribute_help_msg = """\b leet contribute                     leet contribute\b
#     \bIf you have a membership, you can use this command to store your membership data in local
#     \bThis command will directly change a .py file for company tags data, if you git clone from
#     \bgithub directly, after [leet contribute], you can pull request to share the data with other
#     \bpeople
# """
@click.group()
def leet():
    """
    \b
    leet login                           Login to LeetCode
    \b
    leet lang <language>                 Set default coding langugae for generating templates [leet start]
    \b
    leet show <start> <end>              Display the list of questions in given range, [start, end]
    \b
    leet detail <question_id>            Display the detail of the question by <question_id>
    \b
    leet start <question_id>             Generate the template with target coding language by <question_id>
    \b
    leet test <filename>                 Test the solution code, <filename> should be generated by [leet start]
    \b
    leet submit <filename>               Submit the solution code, <filename> should be generated by [leet start]
    \b
    leet diss <question_id> <ranking>    Show the discussion post titles/detail of given question id and given 
    \b                                      ranking, if the ranking is empty, only show post titles of the question, 
    \b                                      otherwise, show the detail
    \b
    leet create <company> <start> <end>  Generate top interview question for <company>, in given frequency range <start> <end>
    \b                                      For example, [leet google 20 50] means create the list for top 20~50 frequently 
    \b                                      asked interview question in google
    \b 
    leet contribute                      If you have a membership for LeetCode, you can use this command to store your membership 
    \b                                      data in local so that you can keep using them even after your membership has expired
    \b                                      This command will directly change a .py file in this project, if you git clone from
    \b                                      github repo directly, after [leet contribute], you can pull request to share the data 
    \b                                      with other people
    \b
    leet logout                          Logout from LeetCode
    \b
    leet clean                           Clean all cache

    """
    pass


@click.command(short_help=leet_login_help_msg)
def login():
    client.login()


@click.command(short_help=leet_logout_help_msg)
def logout():
    client.logout()


@click.command(short_help=leet_lang_help_msg)
@click.argument('lang', default='java', type=click.Choice(lang_dict))
def lang(lang):
    client.set_coding_language(lang)


@click.command(short_help=leet_submit_help_msg)
@click.argument('filename')
def submit(filename):
    client.check_login()
    client.submit(filename)


@click.command(short_help=leet_show_help_msg)
@click.argument('start', default=1, type=click.IntRange(0, 2000))
@click.argument('end', default=50, type=click.IntRange(0, 2000))
def show(start, end):
    client.check_login()
    client.check_question_list()
    client.show(start, end)


@click.command(short_help=leet_detail_help_msg)
@click.argument('question_id', default=1, type=click.IntRange(0, 2000))
def detail(question_id):
    client.check_login()
    client.check_question_list()
    client.detail(question_id)


@click.command(short_help=leet_start_help_msg)
@click.argument('question_id', default=1)
def start(question_id):
    client.check_login()
    client.check_lang()
    client.check_question_list()
    client.create_template(question_id)


@click.command(short_help=leet_test_help_msg)
@click.argument('filename')
def test(filename):
    client.check_login()
    client.test(filename)


@click.command(short_help=leet_clean_help_msg)
def clean():
    client.clean()



@click.command(short_help=leet_diss_help_msg)
@click.argument('question_id', type = click.IntRange(0, 2000))
@click.argument('rank', default=0, type=click.IntRange(0, 21))
def diss(question_id, rank):
    """
    leet diss [question id],
    leet diss [question id] [rank],
    """
    client.check_login()
    if rank == 0:
        client.disscussion_list(question_id)
    else:
        client.disscussion_post(question_id, rank)


@click.command(short_help=leet_create_help_msg)
@click.argument('list_name', type=click.Choice(cache.get_company_slugs()))
@click.argument('start', type=click.IntRange(1, 1000))
@click.argument('end', type=click.IntRange(1, 1000))
def create(list_name, start, end):
    if (start > end):
        print('invalid input')
    client.check_login()
    client.create_company_list(list_name, start, end)


@click.command(short_help=leet_contribute_help_msg)
def contribute():
    client.check_login()
    client.contribute()


leet.add_command(login)
leet.add_command(logout)
leet.add_command(lang)
leet.add_command(clean)


leet.add_command(show)
leet.add_command(detail)
leet.add_command(start)


leet.add_command(test)
leet.add_command(submit)
leet.add_command(diss)


leet.add_command(create)
leet.add_command(contribute)
