# pyobsplot

[![PyPI](https://img.shields.io/pypi/v/pyobsplot.svg?color=green)](https://pypi.org/project/pyobsplot)
[![npm](https://img.shields.io/npm/v/pyobsplot?color=green)](https://www.npmjs.com/package/pyobsplot)
[![Tests](https://github.com/juba/pyobsplot/actions/workflows/tests.yml/badge.svg)](https://github.com/juba/pyobsplot/actions/workflows/tests.yml)
[![Documentation](https://github.com/juba/pyobsplot/actions/workflows/publish.yml/badge.svg)](https://github.com/juba/pyobsplot/actions/workflows/publish.yml)
[![Open In Colab](https://github.com/juba/pyobsplot/raw/main/doc/img/colab-badge.svg)](https://colab.research.google.com/github/juba/pyobsplot/blob/main/examples/introduction.ipynb)


`pyobsplot` allows to use [Observable Plot](https://observablehq.com/@observablehq/plot?collection=@observablehq/plot) to create charts in [Jupyter](https://jupyter.org) notebooks, [VSCode](https://code.visualstudio.com) notebooks, [Google Colab](https://colab.research.google.com) and [Quarto](https://quarto.org) documents. Plots are created from Python code with a syntax as close as possible to the JavaScript one.

It allows to do things like :

```python
import polars as pl
from pyobsplot import Plot

penguins = pl.read_csv("https://github.com/juba/pyobsplot/raw/main/doc/data/penguins.csv")

Plot.plot({
    "grid": True,
    "color": {"legend": True},
    "marks": [
        Plot.dot(
            penguins, 
            {"x": "flipper_length_mm", "y": "body_mass_g", "fill": "species"}
        ),
        Plot.density(
            penguins, 
            {"x": "flipper_length_mm", "y": "body_mass_g", "stroke": "species"}
        )
    ]
})
```

![Sample plot screenshot](https://github.com/juba/pyobsplot/raw/main/doc/screenshots/readme_plot.png)


## Installation and usage

> **Warning**: this project is at an early stage. There will be bugs, and the API may change.

`pyobsplot` can be installed with `pip`:

```sh
pip install pyobsplot
```

For usage instructions, see the [documentation website](https://juba.github.io/pyobsplot):

- See [getting started](https://juba.github.io/pyobsplot/getting_started.html) for a quick usage overview.
- See [usage](https://juba.github.io/pyobsplot/usage.html) for more detailed usage instructions.

If you just want to try this package without installing it on your computer, you can open an introduction notebook in Google Colab: 

[![](https://github.com/juba/pyobsplot/raw/main/doc/img/colab-badge.svg)](https://colab.research.google.com/github/juba/pyobsplot/blob/main/examples/introduction.ipynb)


## Features and limitations

**Features:**

- Syntax as close as possible to the JavaScript one
- Two renderers available: `widget`, which generates plots as Jupyter widgets, and `jsdom`, which generates SVG or HTML outputs
- [Pandas](https://pandas.pydata.org) and [polars](https://pola.rs) DataFrame and Series objects are serialized using [Arrow](https://arrow.apache.org) IPC format for improved speed and better data type conversions
- Works offline, no iframe or dependency to Observable runtime
- Caching mechanism of data objects if they are used several times in the same plot
- Custom JavaScript code can be passed as strings with the `js` method
- Python `date` and `datetime` objects are automatically converted to JavaScript `Date` objects
- Works with Jupyter notebooks and Quarto HTML documents. Plots without legends are also supported in PDF and docx outputs with the `jsdom` renderer.

**Limitations:**

- Plots with legends don't work in Quarto in formats other than HTML. (#9)
- Some faceting operations produce warnings when used as top-level faceting (but the plots should be fine). This doesn't happen when using mark-level faceting (with the `fx` and `fy` channels). (#3)



## Credits

- [Observable Plot](https://observablehq.com/@observablehq/plot?collection=@observablehq/plot), developed by [Mike Bostock](https://observablehq.com/@mbostock) and [Philippe Rivière](https://observablehq.com/@fil) among others.
- The widget is developed thanks to the [anywidget](https://anywidget.dev) framework.
- Some code from the `jsdom` renderer has been adapted from [altair_saver](https://github.com/altair-viz/altair_saver).
- The documentation website is generated by [Quarto](https://quarto.org).
