from typing import Literal

from pyobsplot.obsplot import Obsplot
from pyobsplot.utils import DEFAULT_THEME
from pyobsplot.widget import ObsplotWidget

# Default format for Plot.plot() calls.
# Not documented, only internal use for documentation generation
_plot_format = None


class PlotSpec(dict):

    def __init__(self, *args, **kwargs) -> None:
        super().__init__(*args, **kwargs)

    def plot(self, *args, **kwargs):
        return Plot.plot(self, *args, **kwargs)


def method_to_spec(name, *args, **kwargs) -> PlotSpec:
    """
    Function used for creating Plot.xyz static methods.
    Generates a dict of specification with method name and args.

    Returns
    -------
    dict
        Plot function specification.
    """
    if len(kwargs) > 1:
        msg = f"kwargs must not be passed to Plot.{name} : {kwargs}"
        raise ValueError(msg)
    return PlotSpec(
        {
            "pyobsplot-type": "function",
            "module": "Plot",
            "method": name,
            "args": args,
        }
    )


class PlotClass:
    """
    Plot methods class.
    """

    def __init__(self):
        self.op = Obsplot()

    def plot(
        self,
        spec: dict,
        format: Literal["widget", "html", "svg", "png"] | None = None,  # noqa: A002
        format_options: dict | None = None,
        theme: Literal["light", "dark", "current"] = DEFAULT_THEME,
        path: str | None = None,
    ) -> ObsplotWidget | None:
        """
        Plot.plot static method. If called directly, create an ObsplotWidget
        or an ObpsplotJsdom with args and kwargs.

        Parameters
        ----------
        spec : dict
            plot specification dictionary
        format : {'widget', 'html', 'svg', 'png'}, optional
            default output format, by default "widget"
        path : str | io.StringIO | None, optional
            if provided, plot is saved to disk to an HTML file instead of displayed
            as a jupyter widget, by default None
        format_options : dict, optional
            default output format options for typst formatter. Currently
            possible keys are 'font' (name of font family), 'scale' (font scaling)
            and 'margin' (margin around the plot, e.g. '1in' or '10pt')
        """
        format_value = format or _plot_format
        return self.op(
            spec,
            path=path,
            format=format_value,
            format_options=format_options,
            theme=theme,
        )

    # ⚠️ WARNING ⚠️
    # The rest of the file is auto generated by utils/get_plot_methods.js.
    # Do not edit by hand and do not remove the START and END comments.

    # STATIC PLOT METHODS START

    @staticmethod
    def area(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("area", *args, **kwargs)

    @staticmethod
    def areaX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("areaX", *args, **kwargs)

    @staticmethod
    def areaY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("areaY", *args, **kwargs)

    @staticmethod
    def arrow(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("arrow", *args, **kwargs)

    @staticmethod
    def auto(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("auto", *args, **kwargs)

    @staticmethod
    def autoSpec(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("autoSpec", *args, **kwargs)

    @staticmethod
    def axisFx(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("axisFx", *args, **kwargs)

    @staticmethod
    def axisFy(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("axisFy", *args, **kwargs)

    @staticmethod
    def axisX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("axisX", *args, **kwargs)

    @staticmethod
    def axisY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("axisY", *args, **kwargs)

    @staticmethod
    def barX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("barX", *args, **kwargs)

    @staticmethod
    def barY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("barY", *args, **kwargs)

    @staticmethod
    def bin(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("bin", *args, **kwargs)

    @staticmethod
    def binX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("binX", *args, **kwargs)

    @staticmethod
    def binY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("binY", *args, **kwargs)

    @staticmethod
    def bollinger(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("bollinger", *args, **kwargs)

    @staticmethod
    def bollingerX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("bollingerX", *args, **kwargs)

    @staticmethod
    def bollingerY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("bollingerY", *args, **kwargs)

    @staticmethod
    def boxX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("boxX", *args, **kwargs)

    @staticmethod
    def boxY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("boxY", *args, **kwargs)

    @staticmethod
    def cell(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("cell", *args, **kwargs)

    @staticmethod
    def cellX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("cellX", *args, **kwargs)

    @staticmethod
    def cellY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("cellY", *args, **kwargs)

    @staticmethod
    def centroid(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("centroid", *args, **kwargs)

    @staticmethod
    def circle(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("circle", *args, **kwargs)

    @staticmethod
    def cluster(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("cluster", *args, **kwargs)

    @staticmethod
    def column(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("column", *args, **kwargs)

    @staticmethod
    def contour(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("contour", *args, **kwargs)

    @staticmethod
    def crosshair(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("crosshair", *args, **kwargs)

    @staticmethod
    def crosshairX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("crosshairX", *args, **kwargs)

    @staticmethod
    def crosshairY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("crosshairY", *args, **kwargs)

    @staticmethod
    def delaunayLink(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("delaunayLink", *args, **kwargs)

    @staticmethod
    def delaunayMesh(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("delaunayMesh", *args, **kwargs)

    @staticmethod
    def density(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("density", *args, **kwargs)

    @staticmethod
    def differenceX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("differenceX", *args, **kwargs)

    @staticmethod
    def differenceY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("differenceY", *args, **kwargs)

    @staticmethod
    def dodgeX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("dodgeX", *args, **kwargs)

    @staticmethod
    def dodgeY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("dodgeY", *args, **kwargs)

    @staticmethod
    def dot(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("dot", *args, **kwargs)

    @staticmethod
    def dotX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("dotX", *args, **kwargs)

    @staticmethod
    def dotY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("dotY", *args, **kwargs)

    @staticmethod
    def filter(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("filter", *args, **kwargs)

    @staticmethod
    def find(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("find", *args, **kwargs)

    @staticmethod
    def formatIsoDate(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("formatIsoDate", *args, **kwargs)

    @staticmethod
    def formatMonth(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("formatMonth", *args, **kwargs)

    @staticmethod
    def formatNumber(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("formatNumber", *args, **kwargs)

    @staticmethod
    def formatWeekday(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("formatWeekday", *args, **kwargs)

    @staticmethod
    def frame(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("frame", *args, **kwargs)

    @staticmethod
    def geo(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("geo", *args, **kwargs)

    @staticmethod
    def geoCentroid(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("geoCentroid", *args, **kwargs)

    @staticmethod
    def graticule(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("graticule", *args, **kwargs)

    @staticmethod
    def gridFx(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("gridFx", *args, **kwargs)

    @staticmethod
    def gridFy(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("gridFy", *args, **kwargs)

    @staticmethod
    def gridX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("gridX", *args, **kwargs)

    @staticmethod
    def gridY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("gridY", *args, **kwargs)

    @staticmethod
    def group(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("group", *args, **kwargs)

    @staticmethod
    def groupX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("groupX", *args, **kwargs)

    @staticmethod
    def groupY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("groupY", *args, **kwargs)

    @staticmethod
    def groupZ(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("groupZ", *args, **kwargs)

    @staticmethod
    def hexagon(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("hexagon", *args, **kwargs)

    @staticmethod
    def hexbin(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("hexbin", *args, **kwargs)

    @staticmethod
    def hexgrid(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("hexgrid", *args, **kwargs)

    @staticmethod
    def hull(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("hull", *args, **kwargs)

    @staticmethod
    def identity(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("identity", *args, **kwargs)

    @staticmethod
    def image(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("image", *args, **kwargs)

    @staticmethod
    def indexOf(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("indexOf", *args, **kwargs)

    @staticmethod
    def initializer(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("initializer", *args, **kwargs)

    @staticmethod
    def interpolateNearest(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("interpolateNearest", *args, **kwargs)

    @staticmethod
    def interpolateNone(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("interpolateNone", *args, **kwargs)

    @staticmethod
    def interpolatorBarycentric(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("interpolatorBarycentric", *args, **kwargs)

    @staticmethod
    def interpolatorRandomWalk(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("interpolatorRandomWalk", *args, **kwargs)

    @staticmethod
    def legend(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("legend", *args, **kwargs)

    @staticmethod
    def line(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("line", *args, **kwargs)

    @staticmethod
    def lineX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("lineX", *args, **kwargs)

    @staticmethod
    def lineY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("lineY", *args, **kwargs)

    @staticmethod
    def linearRegressionX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("linearRegressionX", *args, **kwargs)

    @staticmethod
    def linearRegressionY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("linearRegressionY", *args, **kwargs)

    @staticmethod
    def link(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("link", *args, **kwargs)

    @staticmethod
    def map(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("map", *args, **kwargs)

    @staticmethod
    def mapX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("mapX", *args, **kwargs)

    @staticmethod
    def mapY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("mapY", *args, **kwargs)

    @staticmethod
    def marks(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("marks", *args, **kwargs)

    @staticmethod
    def normalize(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("normalize", *args, **kwargs)

    @staticmethod
    def normalizeX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("normalizeX", *args, **kwargs)

    @staticmethod
    def normalizeY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("normalizeY", *args, **kwargs)

    @staticmethod
    def numberInterval(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("numberInterval", *args, **kwargs)

    @staticmethod
    def pointer(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("pointer", *args, **kwargs)

    @staticmethod
    def pointerX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("pointerX", *args, **kwargs)

    @staticmethod
    def pointerY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("pointerY", *args, **kwargs)

    @staticmethod
    def raster(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("raster", *args, **kwargs)

    @staticmethod
    def rect(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("rect", *args, **kwargs)

    @staticmethod
    def rectX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("rectX", *args, **kwargs)

    @staticmethod
    def rectY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("rectY", *args, **kwargs)

    @staticmethod
    def reverse(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("reverse", *args, **kwargs)

    @staticmethod
    def ruleX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("ruleX", *args, **kwargs)

    @staticmethod
    def ruleY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("ruleY", *args, **kwargs)

    @staticmethod
    def scale(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("scale", *args, **kwargs)

    @staticmethod
    def select(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("select", *args, **kwargs)

    @staticmethod
    def selectFirst(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("selectFirst", *args, **kwargs)

    @staticmethod
    def selectLast(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("selectLast", *args, **kwargs)

    @staticmethod
    def selectMaxX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("selectMaxX", *args, **kwargs)

    @staticmethod
    def selectMaxY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("selectMaxY", *args, **kwargs)

    @staticmethod
    def selectMinX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("selectMinX", *args, **kwargs)

    @staticmethod
    def selectMinY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("selectMinY", *args, **kwargs)

    @staticmethod
    def shiftX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("shiftX", *args, **kwargs)

    @staticmethod
    def shiftY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("shiftY", *args, **kwargs)

    @staticmethod
    def shuffle(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("shuffle", *args, **kwargs)

    @staticmethod
    def sort(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("sort", *args, **kwargs)

    @staticmethod
    def sphere(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("sphere", *args, **kwargs)

    @staticmethod
    def spike(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("spike", *args, **kwargs)

    @staticmethod
    def stackX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("stackX", *args, **kwargs)

    @staticmethod
    def stackX1(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("stackX1", *args, **kwargs)

    @staticmethod
    def stackX2(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("stackX2", *args, **kwargs)

    @staticmethod
    def stackY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("stackY", *args, **kwargs)

    @staticmethod
    def stackY1(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("stackY1", *args, **kwargs)

    @staticmethod
    def stackY2(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("stackY2", *args, **kwargs)

    @staticmethod
    def text(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("text", *args, **kwargs)

    @staticmethod
    def textX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("textX", *args, **kwargs)

    @staticmethod
    def textY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("textY", *args, **kwargs)

    @staticmethod
    def tickX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("tickX", *args, **kwargs)

    @staticmethod
    def tickY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("tickY", *args, **kwargs)

    @staticmethod
    def timeInterval(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("timeInterval", *args, **kwargs)

    @staticmethod
    def tip(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("tip", *args, **kwargs)

    @staticmethod
    def transform(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("transform", *args, **kwargs)

    @staticmethod
    def tree(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("tree", *args, **kwargs)

    @staticmethod
    def treeLink(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("treeLink", *args, **kwargs)

    @staticmethod
    def treeNode(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("treeNode", *args, **kwargs)

    @staticmethod
    def utcInterval(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("utcInterval", *args, **kwargs)

    @staticmethod
    def valueof(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("valueof", *args, **kwargs)

    @staticmethod
    def vector(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("vector", *args, **kwargs)

    @staticmethod
    def vectorX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("vectorX", *args, **kwargs)

    @staticmethod
    def vectorY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("vectorY", *args, **kwargs)

    @staticmethod
    def voronoi(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("voronoi", *args, **kwargs)

    @staticmethod
    def voronoiMesh(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("voronoiMesh", *args, **kwargs)

    @staticmethod
    def waffleX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("waffleX", *args, **kwargs)

    @staticmethod
    def waffleY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("waffleY", *args, **kwargs)

    @staticmethod
    def window(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("window", *args, **kwargs)

    @staticmethod
    def windowX(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("windowX", *args, **kwargs)

    @staticmethod
    def windowY(*args, **kwargs) -> PlotSpec: # noqa: ARG001, ARG004, RUF100
        return method_to_spec("windowY", *args, **kwargs)

    # STATIC PLOT METHODS END


Plot = PlotClass()
