# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2020 Dan <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class UpdateChannelReadMessagesContents(TLObject):
    """Attributes:
        LAYER: ``112``

    Attributes:
        ID: ``0x89893b45``

    Parameters:
        channel_id: ``int`` ``32-bit``
        messages: List of ``int`` ``32-bit``
    """

    __slots__ = ["channel_id", "messages"]

    ID = 0x89893b45
    QUALNAME = "types.UpdateChannelReadMessagesContents"

    def __init__(self, *, channel_id: int, messages: list):
        self.channel_id = channel_id  # int
        self.messages = messages  # Vector<int>

    @staticmethod
    def read(b: BytesIO, *args) -> "UpdateChannelReadMessagesContents":
        # No flags
        
        channel_id = Int.read(b)
        
        messages = TLObject.read(b, Int)
        
        return UpdateChannelReadMessagesContents(channel_id=channel_id, messages=messages)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(Int(self.channel_id))
        
        b.write(Vector(self.messages, Int))
        
        return b.getvalue()
