# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2020 Dan <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class UpdateGeoLiveViewed(TLObject):
    """Attributes:
        LAYER: ``112``

    Attributes:
        ID: ``0x871fb939``

    Parameters:
        peer: Either :obj:`PeerUser <pyrogram.api.types.PeerUser>`, :obj:`PeerChat <pyrogram.api.types.PeerChat>` or :obj:`PeerChannel <pyrogram.api.types.PeerChannel>`
        msg_id: ``int`` ``32-bit``
    """

    __slots__ = ["peer", "msg_id"]

    ID = 0x871fb939
    QUALNAME = "types.UpdateGeoLiveViewed"

    def __init__(self, *, peer, msg_id: int):
        self.peer = peer  # Peer
        self.msg_id = msg_id  # int

    @staticmethod
    def read(b: BytesIO, *args) -> "UpdateGeoLiveViewed":
        # No flags
        
        peer = TLObject.read(b)
        
        msg_id = Int.read(b)
        
        return UpdateGeoLiveViewed(peer=peer, msg_id=msg_id)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(self.peer.write())
        
        b.write(Int(self.msg_id))
        
        return b.getvalue()
