# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2020 Dan <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class MessageActionGameScore(TLObject):
    """Attributes:
        LAYER: ``112``

    Attributes:
        ID: ``0x92a72876``

    Parameters:
        game_id: ``int`` ``64-bit``
        score: ``int`` ``32-bit``
    """

    __slots__ = ["game_id", "score"]

    ID = 0x92a72876
    QUALNAME = "types.MessageActionGameScore"

    def __init__(self, *, game_id: int, score: int):
        self.game_id = game_id  # long
        self.score = score  # int

    @staticmethod
    def read(b: BytesIO, *args) -> "MessageActionGameScore":
        # No flags
        
        game_id = Long.read(b)
        
        score = Int.read(b)
        
        return MessageActionGameScore(game_id=game_id, score=score)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(Long(self.game_id))
        
        b.write(Int(self.score))
        
        return b.getvalue()
