# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2020 Dan <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class PhoneCall(TLObject):
    """Attributes:
        LAYER: ``112``

    Attributes:
        ID: ``0xec82e140``

    Parameters:
        phone_call: Either :obj:`PhoneCallEmpty <pyrogram.api.types.PhoneCallEmpty>`, :obj:`PhoneCallWaiting <pyrogram.api.types.PhoneCallWaiting>`, :obj:`PhoneCallRequested <pyrogram.api.types.PhoneCallRequested>`, :obj:`PhoneCallAccepted <pyrogram.api.types.PhoneCallAccepted>`, :obj:`PhoneCall <pyrogram.api.types.PhoneCall>` or :obj:`PhoneCallDiscarded <pyrogram.api.types.PhoneCallDiscarded>`
        users: List of either :obj:`UserEmpty <pyrogram.api.types.UserEmpty>` or :obj:`User <pyrogram.api.types.User>`

    See Also:
        This object can be returned by :obj:`phone.RequestCall <pyrogram.api.functions.phone.RequestCall>`, :obj:`phone.AcceptCall <pyrogram.api.functions.phone.AcceptCall>` and :obj:`phone.ConfirmCall <pyrogram.api.functions.phone.ConfirmCall>`.
    """

    __slots__ = ["phone_call", "users"]

    ID = 0xec82e140
    QUALNAME = "types.phone.PhoneCall"

    def __init__(self, *, phone_call, users: list):
        self.phone_call = phone_call  # PhoneCall
        self.users = users  # Vector<User>

    @staticmethod
    def read(b: BytesIO, *args) -> "PhoneCall":
        # No flags
        
        phone_call = TLObject.read(b)
        
        users = TLObject.read(b)
        
        return PhoneCall(phone_call=phone_call, users=users)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(self.phone_call.write())
        
        b.write(Vector(self.users))
        
        return b.getvalue()
