# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2018 Dan Tès <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class InputChannel(Object):
    """
    Attributes:
        ID (:obj:`int`): ``0xafeb712e``

    Args:
        channel_id: :obj:`int`
        access_hash: :obj:`int`
    """
    ID = 0xafeb712e

    def __init__(self, channel_id, access_hash):
        self.channel_id = channel_id  # int
        self.access_hash = access_hash  # long

    @staticmethod
    def read(b: BytesIO, *args) -> "InputChannel":
        # No flags
        
        channel_id = Int.read(b)
        
        access_hash = Long.read(b)
        
        return InputChannel(channel_id, access_hash)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(Int(self.channel_id))
        
        b.write(Long(self.access_hash))
        
        return b.getvalue()
