# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2018 Dan Tès <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

layer = 81

objects = {
    0x05162463: "pyrogram.api.types.ResPQ",
    0x83c95aec: "pyrogram.api.types.PQInnerData",
    0xa9f55f95: "pyrogram.api.types.PQInnerDataDc",
    0x3c6a84d4: "pyrogram.api.types.PQInnerDataTemp",
    0x56fddf88: "pyrogram.api.types.PQInnerDataTempDc",
    0x75a3f765: "pyrogram.api.types.BindAuthKeyInner",
    0x79cb045d: "pyrogram.api.types.ServerDHParamsFail",
    0xd0e8075c: "pyrogram.api.types.ServerDHParamsOk",
    0xb5890dba: "pyrogram.api.types.ServerDHInnerData",
    0x6643b654: "pyrogram.api.types.ClientDHInnerData",
    0x3bcbf734: "pyrogram.api.types.DhGenOk",
    0x46dc1fb9: "pyrogram.api.types.DhGenRetry",
    0xa69dae02: "pyrogram.api.types.DhGenFail",
    0xf660e1d4: "pyrogram.api.types.DestroyAuthKeyOk",
    0x0a9f2259: "pyrogram.api.types.DestroyAuthKeyNone",
    0xea109b13: "pyrogram.api.types.DestroyAuthKeyFail",
    0x60469778: "pyrogram.api.functions.ReqPq",
    0xbe7e8ef1: "pyrogram.api.functions.ReqPqMulti",
    0xd712e4be: "pyrogram.api.functions.ReqDHParams",
    0xf5045f1f: "pyrogram.api.functions.SetClientDHParams",
    0xd1435160: "pyrogram.api.functions.DestroyAuthKey",
    0x62d6b459: "pyrogram.api.types.MsgsAck",
    0xa7eff811: "pyrogram.api.types.BadMsgNotification",
    0xedab447b: "pyrogram.api.types.BadServerSalt",
    0xda69fb52: "pyrogram.api.types.MsgsStateReq",
    0x04deb57d: "pyrogram.api.types.MsgsStateInfo",
    0x8cc0d131: "pyrogram.api.types.MsgsAllInfo",
    0x276d3ec6: "pyrogram.api.types.MsgDetailedInfo",
    0x809db6df: "pyrogram.api.types.MsgNewDetailedInfo",
    0x7d861a08: "pyrogram.api.types.MsgResendReq",
    0x8610baeb: "pyrogram.api.types.MsgResendAnsReq",
    0xf35c6d01: "pyrogram.api.types.RpcResult",
    0x2144ca19: "pyrogram.api.types.RpcError",
    0x5e2ad36e: "pyrogram.api.types.RpcAnswerUnknown",
    0xcd78e586: "pyrogram.api.types.RpcAnswerDroppedRunning",
    0xa43ad8b7: "pyrogram.api.types.RpcAnswerDropped",
    0x347773c5: "pyrogram.api.types.Pong",
    0xe22045fc: "pyrogram.api.types.DestroySessionOk",
    0x62d350c9: "pyrogram.api.types.DestroySessionNone",
    0x9ec20908: "pyrogram.api.types.NewSessionCreated",
    0x9299359f: "pyrogram.api.types.HttpWait",
    0xd433ad73: "pyrogram.api.types.IpPort",
    0x37982646: "pyrogram.api.types.IpPortSecret",
    0x4679b65f: "pyrogram.api.types.AccessPointRule",
    0x5a592a6c: "pyrogram.api.types.help.ConfigSimple",
    0x58e4a740: "pyrogram.api.functions.RpcDropAnswer",
    0xb921bd04: "pyrogram.api.functions.GetFutureSalts",
    0x7abe77ec: "pyrogram.api.functions.Ping",
    0xf3427b8c: "pyrogram.api.functions.PingDelayDisconnect",
    0xe7512126: "pyrogram.api.functions.DestroySession",
    0x9a5f6e95: "pyrogram.api.functions.contest.SaveDeveloperInfo",
    0x7f3b18ea: "pyrogram.api.types.InputPeerEmpty",
    0x7da07ec9: "pyrogram.api.types.InputPeerSelf",
    0x179be863: "pyrogram.api.types.InputPeerChat",
    0x7b8e7de6: "pyrogram.api.types.InputPeerUser",
    0x20adaef8: "pyrogram.api.types.InputPeerChannel",
    0xb98886cf: "pyrogram.api.types.InputUserEmpty",
    0xf7c1b13f: "pyrogram.api.types.InputUserSelf",
    0xd8292816: "pyrogram.api.types.InputUser",
    0xf392b7f4: "pyrogram.api.types.InputPhoneContact",
    0xf52ff27f: "pyrogram.api.types.InputFile",
    0xfa4f0bb5: "pyrogram.api.types.InputFileBig",
    0x9664f57f: "pyrogram.api.types.InputMediaEmpty",
    0x1e287d04: "pyrogram.api.types.InputMediaUploadedPhoto",
    0xb3ba0635: "pyrogram.api.types.InputMediaPhoto",
    0xf9c44144: "pyrogram.api.types.InputMediaGeoPoint",
    0xa6e45987: "pyrogram.api.types.InputMediaContact",
    0x5b38c6c1: "pyrogram.api.types.InputMediaUploadedDocument",
    0x23ab23d2: "pyrogram.api.types.InputMediaDocument",
    0xc13d1c11: "pyrogram.api.types.InputMediaVenue",
    0x4843b0fd: "pyrogram.api.types.InputMediaGifExternal",
    0xe5bbfe1a: "pyrogram.api.types.InputMediaPhotoExternal",
    0xfb52dc99: "pyrogram.api.types.InputMediaDocumentExternal",
    0xd33f43f3: "pyrogram.api.types.InputMediaGame",
    0xf4e096c3: "pyrogram.api.types.InputMediaInvoice",
    0x7b1a118f: "pyrogram.api.types.InputMediaGeoLive",
    0x1ca48f57: "pyrogram.api.types.InputChatPhotoEmpty",
    0x927c55b4: "pyrogram.api.types.InputChatUploadedPhoto",
    0x8953ad37: "pyrogram.api.types.InputChatPhoto",
    0xe4c123d6: "pyrogram.api.types.InputGeoPointEmpty",
    0xf3b7acc9: "pyrogram.api.types.InputGeoPoint",
    0x1cd7bf0d: "pyrogram.api.types.InputPhotoEmpty",
    0xfb95c6c4: "pyrogram.api.types.InputPhoto",
    0x14637196: "pyrogram.api.types.InputFileLocation",
    0xf5235d55: "pyrogram.api.types.InputEncryptedFileLocation",
    0x430f0724: "pyrogram.api.types.InputDocumentFileLocation",
    0xcbc7ee28: "pyrogram.api.types.InputSecureFileLocation",
    0x770656a8: "pyrogram.api.types.InputAppEvent",
    0x9db1bc6d: "pyrogram.api.types.PeerUser",
    0xbad0e5bb: "pyrogram.api.types.PeerChat",
    0xbddde532: "pyrogram.api.types.PeerChannel",
    0xaa963b05: "pyrogram.api.types.storage.FileUnknown",
    0x40bc6f52: "pyrogram.api.types.storage.FilePartial",
    0x007efe0e: "pyrogram.api.types.storage.FileJpeg",
    0xcae1aadf: "pyrogram.api.types.storage.FileGif",
    0x0a4f63c0: "pyrogram.api.types.storage.FilePng",
    0xae1e508d: "pyrogram.api.types.storage.FilePdf",
    0x528a0677: "pyrogram.api.types.storage.FileMp3",
    0x4b09ebbc: "pyrogram.api.types.storage.FileMov",
    0xb3cea0e4: "pyrogram.api.types.storage.FileMp4",
    0x1081464c: "pyrogram.api.types.storage.FileWebp",
    0x7c596b46: "pyrogram.api.types.FileLocationUnavailable",
    0x53d69076: "pyrogram.api.types.FileLocation",
    0x200250ba: "pyrogram.api.types.UserEmpty",
    0x2e13f4c3: "pyrogram.api.types.User",
    0x4f11bae1: "pyrogram.api.types.UserProfilePhotoEmpty",
    0xd559d8c8: "pyrogram.api.types.UserProfilePhoto",
    0x09d05049: "pyrogram.api.types.UserStatusEmpty",
    0xedb93949: "pyrogram.api.types.UserStatusOnline",
    0x008c703f: "pyrogram.api.types.UserStatusOffline",
    0xe26f42f1: "pyrogram.api.types.UserStatusRecently",
    0x07bf09fc: "pyrogram.api.types.UserStatusLastWeek",
    0x77ebc742: "pyrogram.api.types.UserStatusLastMonth",
    0x9ba2d800: "pyrogram.api.types.ChatEmpty",
    0xd91cdd54: "pyrogram.api.types.Chat",
    0x07328bdb: "pyrogram.api.types.ChatForbidden",
    0xc88974ac: "pyrogram.api.types.Channel",
    0x289da732: "pyrogram.api.types.ChannelForbidden",
    0x2e02a614: "pyrogram.api.types.ChatFull",
    0x76af5481: "pyrogram.api.types.ChannelFull",
    0xc8d7493e: "pyrogram.api.types.ChatParticipant",
    0xda13538a: "pyrogram.api.types.ChatParticipantCreator",
    0xe2d6e436: "pyrogram.api.types.ChatParticipantAdmin",
    0xfc900c2b: "pyrogram.api.types.ChatParticipantsForbidden",
    0x3f460fed: "pyrogram.api.types.ChatParticipants",
    0x37c1011c: "pyrogram.api.types.ChatPhotoEmpty",
    0x6153276a: "pyrogram.api.types.ChatPhoto",
    0x83e5de54: "pyrogram.api.types.MessageEmpty",
    0x44f9b43d: "pyrogram.api.types.Message",
    0x9e19a1f6: "pyrogram.api.types.MessageService",
    0x3ded6320: "pyrogram.api.types.MessageMediaEmpty",
    0x695150d7: "pyrogram.api.types.MessageMediaPhoto",
    0x56e0d474: "pyrogram.api.types.MessageMediaGeo",
    0x5e7d2f39: "pyrogram.api.types.MessageMediaContact",
    0x9f84f49e: "pyrogram.api.types.MessageMediaUnsupported",
    0x9cb070d7: "pyrogram.api.types.MessageMediaDocument",
    0xa32dd600: "pyrogram.api.types.MessageMediaWebPage",
    0x2ec0533f: "pyrogram.api.types.MessageMediaVenue",
    0xfdb19008: "pyrogram.api.types.MessageMediaGame",
    0x84551347: "pyrogram.api.types.MessageMediaInvoice",
    0x7c3c2609: "pyrogram.api.types.MessageMediaGeoLive",
    0xb6aef7b0: "pyrogram.api.types.MessageActionEmpty",
    0xa6638b9a: "pyrogram.api.types.MessageActionChatCreate",
    0xb5a1ce5a: "pyrogram.api.types.MessageActionChatEditTitle",
    0x7fcb13a8: "pyrogram.api.types.MessageActionChatEditPhoto",
    0x95e3fbef: "pyrogram.api.types.MessageActionChatDeletePhoto",
    0x488a7337: "pyrogram.api.types.MessageActionChatAddUser",
    0xb2ae9b0c: "pyrogram.api.types.MessageActionChatDeleteUser",
    0xf89cf5e8: "pyrogram.api.types.MessageActionChatJoinedByLink",
    0x95d2ac92: "pyrogram.api.types.MessageActionChannelCreate",
    0x51bdb021: "pyrogram.api.types.MessageActionChatMigrateTo",
    0xb055eaee: "pyrogram.api.types.MessageActionChannelMigrateFrom",
    0x94bd38ed: "pyrogram.api.types.MessageActionPinMessage",
    0x9fbab604: "pyrogram.api.types.MessageActionHistoryClear",
    0x92a72876: "pyrogram.api.types.MessageActionGameScore",
    0x8f31b327: "pyrogram.api.types.MessageActionPaymentSentMe",
    0x40699cd0: "pyrogram.api.types.MessageActionPaymentSent",
    0x80e11a7f: "pyrogram.api.types.MessageActionPhoneCall",
    0x4792929b: "pyrogram.api.types.MessageActionScreenshotTaken",
    0xfae69f56: "pyrogram.api.types.MessageActionCustomAction",
    0xabe9affe: "pyrogram.api.types.MessageActionBotAllowed",
    0x1b287353: "pyrogram.api.types.MessageActionSecureValuesSentMe",
    0xd95c6154: "pyrogram.api.types.MessageActionSecureValuesSent",
    0xe4def5db: "pyrogram.api.types.Dialog",
    0x2331b22d: "pyrogram.api.types.PhotoEmpty",
    0x9288dd29: "pyrogram.api.types.Photo",
    0x0e17e23c: "pyrogram.api.types.PhotoSizeEmpty",
    0x77bfb61b: "pyrogram.api.types.PhotoSize",
    0xe9a734fa: "pyrogram.api.types.PhotoCachedSize",
    0x1117dd5f: "pyrogram.api.types.GeoPointEmpty",
    0x2049d70c: "pyrogram.api.types.GeoPoint",
    0x811ea28e: "pyrogram.api.types.auth.CheckedPhone",
    0x38faab5f: "pyrogram.api.types.auth.SentCode",
    0xcd050916: "pyrogram.api.types.auth.Authorization",
    0xdf969c2d: "pyrogram.api.types.auth.ExportedAuthorization",
    0xb8bc5b0c: "pyrogram.api.types.InputNotifyPeer",
    0x193b4417: "pyrogram.api.types.InputNotifyUsers",
    0x4a95e84e: "pyrogram.api.types.InputNotifyChats",
    0x9c3d198e: "pyrogram.api.types.InputPeerNotifySettings",
    0xaf509d20: "pyrogram.api.types.PeerNotifySettings",
    0x818426cd: "pyrogram.api.types.PeerSettings",
    0xccb03657: "pyrogram.api.types.WallPaper",
    0x63117f24: "pyrogram.api.types.WallPaperSolid",
    0x58dbcab8: "pyrogram.api.types.InputReportReasonSpam",
    0x1e22c78d: "pyrogram.api.types.InputReportReasonViolence",
    0x2e59d922: "pyrogram.api.types.InputReportReasonPornography",
    0xe1746d0a: "pyrogram.api.types.InputReportReasonOther",
    0x0f220f3f: "pyrogram.api.types.UserFull",
    0xf911c994: "pyrogram.api.types.Contact",
    0xd0028438: "pyrogram.api.types.ImportedContact",
    0x561bc879: "pyrogram.api.types.ContactBlocked",
    0xd3680c61: "pyrogram.api.types.ContactStatus",
    0x3ace484c: "pyrogram.api.types.contacts.Link",
    0xb74ba9d2: "pyrogram.api.types.contacts.ContactsNotModified",
    0xeae87e42: "pyrogram.api.types.contacts.Contacts",
    0x77d01c3b: "pyrogram.api.types.contacts.ImportedContacts",
    0x1c138d15: "pyrogram.api.types.contacts.Blocked",
    0x900802a1: "pyrogram.api.types.contacts.BlockedSlice",
    0x15ba6c40: "pyrogram.api.types.messages.Dialogs",
    0x71e094f3: "pyrogram.api.types.messages.DialogsSlice",
    0x8c718e87: "pyrogram.api.types.messages.Messages",
    0x0b446ae3: "pyrogram.api.types.messages.MessagesSlice",
    0x99262e37: "pyrogram.api.types.messages.ChannelMessages",
    0x74535f21: "pyrogram.api.types.messages.MessagesNotModified",
    0x64ff9fd5: "pyrogram.api.types.messages.Chats",
    0x9cd81144: "pyrogram.api.types.messages.ChatsSlice",
    0xe5d7d19c: "pyrogram.api.types.messages.ChatFull",
    0xb45c69d1: "pyrogram.api.types.messages.AffectedHistory",
    0x57e2f66c: "pyrogram.api.types.InputMessagesFilterEmpty",
    0x9609a51c: "pyrogram.api.types.InputMessagesFilterPhotos",
    0x9fc00e65: "pyrogram.api.types.InputMessagesFilterVideo",
    0x56e9f0e4: "pyrogram.api.types.InputMessagesFilterPhotoVideo",
    0x9eddf188: "pyrogram.api.types.InputMessagesFilterDocument",
    0x7ef0dd87: "pyrogram.api.types.InputMessagesFilterUrl",
    0xffc86587: "pyrogram.api.types.InputMessagesFilterGif",
    0x50f5c392: "pyrogram.api.types.InputMessagesFilterVoice",
    0x3751b49e: "pyrogram.api.types.InputMessagesFilterMusic",
    0x3a20ecb8: "pyrogram.api.types.InputMessagesFilterChatPhotos",
    0x80c99768: "pyrogram.api.types.InputMessagesFilterPhoneCalls",
    0x7a7c17a4: "pyrogram.api.types.InputMessagesFilterRoundVoice",
    0xb549da53: "pyrogram.api.types.InputMessagesFilterRoundVideo",
    0xc1f8e69a: "pyrogram.api.types.InputMessagesFilterMyMentions",
    0xe7026d0d: "pyrogram.api.types.InputMessagesFilterGeo",
    0xe062db83: "pyrogram.api.types.InputMessagesFilterContacts",
    0x1f2b0afd: "pyrogram.api.types.UpdateNewMessage",
    0x4e90bfd6: "pyrogram.api.types.UpdateMessageID",
    0xa20db0e5: "pyrogram.api.types.UpdateDeleteMessages",
    0x5c486927: "pyrogram.api.types.UpdateUserTyping",
    0x9a65ea1f: "pyrogram.api.types.UpdateChatUserTyping",
    0x07761198: "pyrogram.api.types.UpdateChatParticipants",
    0x1bfbd823: "pyrogram.api.types.UpdateUserStatus",
    0xa7332b73: "pyrogram.api.types.UpdateUserName",
    0x95313b0c: "pyrogram.api.types.UpdateUserPhoto",
    0x2575bbb9: "pyrogram.api.types.UpdateContactRegistered",
    0x9d2e67c5: "pyrogram.api.types.UpdateContactLink",
    0x12bcbd9a: "pyrogram.api.types.UpdateNewEncryptedMessage",
    0x1710f156: "pyrogram.api.types.UpdateEncryptedChatTyping",
    0xb4a2e88d: "pyrogram.api.types.UpdateEncryption",
    0x38fe25b7: "pyrogram.api.types.UpdateEncryptedMessagesRead",
    0xea4b0e5c: "pyrogram.api.types.UpdateChatParticipantAdd",
    0x6e5f8c22: "pyrogram.api.types.UpdateChatParticipantDelete",
    0x8e5e9873: "pyrogram.api.types.UpdateDcOptions",
    0x80ece81a: "pyrogram.api.types.UpdateUserBlocked",
    0xbec268ef: "pyrogram.api.types.UpdateNotifySettings",
    0xebe46819: "pyrogram.api.types.UpdateServiceNotification",
    0xee3b272a: "pyrogram.api.types.UpdatePrivacy",
    0x12b9417b: "pyrogram.api.types.UpdateUserPhone",
    0x9961fd5c: "pyrogram.api.types.UpdateReadHistoryInbox",
    0x2f2f21bf: "pyrogram.api.types.UpdateReadHistoryOutbox",
    0x7f891213: "pyrogram.api.types.UpdateWebPage",
    0x68c13933: "pyrogram.api.types.UpdateReadMessagesContents",
    0xeb0467fb: "pyrogram.api.types.UpdateChannelTooLong",
    0xb6d45656: "pyrogram.api.types.UpdateChannel",
    0x62ba04d9: "pyrogram.api.types.UpdateNewChannelMessage",
    0x4214f37f: "pyrogram.api.types.UpdateReadChannelInbox",
    0xc37521c9: "pyrogram.api.types.UpdateDeleteChannelMessages",
    0x98a12b4b: "pyrogram.api.types.UpdateChannelMessageViews",
    0x6e947941: "pyrogram.api.types.UpdateChatAdmins",
    0xb6901959: "pyrogram.api.types.UpdateChatParticipantAdmin",
    0x688a30aa: "pyrogram.api.types.UpdateNewStickerSet",
    0x0bb2d201: "pyrogram.api.types.UpdateStickerSetsOrder",
    0x43ae3dec: "pyrogram.api.types.UpdateStickerSets",
    0x9375341e: "pyrogram.api.types.UpdateSavedGifs",
    0x54826690: "pyrogram.api.types.UpdateBotInlineQuery",
    0x0e48f964: "pyrogram.api.types.UpdateBotInlineSend",
    0x1b3f4df7: "pyrogram.api.types.UpdateEditChannelMessage",
    0x98592475: "pyrogram.api.types.UpdateChannelPinnedMessage",
    0xe73547e1: "pyrogram.api.types.UpdateBotCallbackQuery",
    0xe40370a3: "pyrogram.api.types.UpdateEditMessage",
    0xf9d27a5a: "pyrogram.api.types.UpdateInlineBotCallbackQuery",
    0x25d6c9c7: "pyrogram.api.types.UpdateReadChannelOutbox",
    0xee2bb969: "pyrogram.api.types.UpdateDraftMessage",
    0x571d2742: "pyrogram.api.types.UpdateReadFeaturedStickers",
    0x9a422c20: "pyrogram.api.types.UpdateRecentStickers",
    0xa229dd06: "pyrogram.api.types.UpdateConfig",
    0x3354678f: "pyrogram.api.types.UpdatePtsChanged",
    0x40771900: "pyrogram.api.types.UpdateChannelWebPage",
    0x19d27f3c: "pyrogram.api.types.UpdateDialogPinned",
    0xea4cb65b: "pyrogram.api.types.UpdatePinnedDialogs",
    0x8317c0c3: "pyrogram.api.types.UpdateBotWebhookJSON",
    0x9b9240a6: "pyrogram.api.types.UpdateBotWebhookJSONQuery",
    0xe0cdc940: "pyrogram.api.types.UpdateBotShippingQuery",
    0x5d2f3aa9: "pyrogram.api.types.UpdateBotPrecheckoutQuery",
    0xab0f6b1e: "pyrogram.api.types.UpdatePhoneCall",
    0x10c2404b: "pyrogram.api.types.UpdateLangPackTooLong",
    0x56022f4d: "pyrogram.api.types.UpdateLangPack",
    0xe511996d: "pyrogram.api.types.UpdateFavedStickers",
    0x89893b45: "pyrogram.api.types.UpdateChannelReadMessagesContents",
    0x7084a7be: "pyrogram.api.types.UpdateContactsReset",
    0x70db6837: "pyrogram.api.types.UpdateChannelAvailableMessages",
    0xa56c2a3e: "pyrogram.api.types.updates.State",
    0x5d75a138: "pyrogram.api.types.updates.DifferenceEmpty",
    0x00f49ca0: "pyrogram.api.types.updates.Difference",
    0xa8fb1981: "pyrogram.api.types.updates.DifferenceSlice",
    0x4afe8f6d: "pyrogram.api.types.updates.DifferenceTooLong",
    0xe317af7e: "pyrogram.api.types.UpdatesTooLong",
    0x914fbf11: "pyrogram.api.types.UpdateShortMessage",
    0x16812688: "pyrogram.api.types.UpdateShortChatMessage",
    0x78d4dec1: "pyrogram.api.types.UpdateShort",
    0x725b04c3: "pyrogram.api.types.UpdatesCombined",
    0x74ae4240: "pyrogram.api.types.Update",
    0x11f1331c: "pyrogram.api.types.UpdateShortSentMessage",
    0x8dca6aa5: "pyrogram.api.types.photos.Photos",
    0x15051f54: "pyrogram.api.types.photos.PhotosSlice",
    0x20212ca8: "pyrogram.api.types.photos.Photo",
    0x096a18d5: "pyrogram.api.types.upload.File",
    0xf18cda44: "pyrogram.api.types.upload.FileCdnRedirect",
    0x18b7a10d: "pyrogram.api.types.DcOption",
    0xeb7bb160: "pyrogram.api.types.Config",
    0x8e1a1775: "pyrogram.api.types.NearestDc",
    0x8987f311: "pyrogram.api.types.help.AppUpdate",
    0xc45a6536: "pyrogram.api.types.help.NoAppUpdate",
    0x18cb9f78: "pyrogram.api.types.help.InviteText",
    0xab7ec0a0: "pyrogram.api.types.EncryptedChatEmpty",
    0x3bf703dc: "pyrogram.api.types.EncryptedChatWaiting",
    0xc878527e: "pyrogram.api.types.EncryptedChatRequested",
    0xfa56ce36: "pyrogram.api.types.EncryptedChat",
    0x13d6dd27: "pyrogram.api.types.EncryptedChatDiscarded",
    0xf141b5e1: "pyrogram.api.types.InputEncryptedChat",
    0xc21f497e: "pyrogram.api.types.EncryptedFileEmpty",
    0x4a70994c: "pyrogram.api.types.EncryptedFile",
    0x1837c364: "pyrogram.api.types.InputEncryptedFileEmpty",
    0x64bd0306: "pyrogram.api.types.InputEncryptedFileUploaded",
    0x5a17b5e5: "pyrogram.api.types.InputEncryptedFile",
    0x2dc173c8: "pyrogram.api.types.InputEncryptedFileBigUploaded",
    0xed18c118: "pyrogram.api.types.EncryptedMessage",
    0x23734b06: "pyrogram.api.types.EncryptedMessageService",
    0xc0e24635: "pyrogram.api.types.messages.DhConfigNotModified",
    0x2c221edd: "pyrogram.api.types.messages.DhConfig",
    0x560f8935: "pyrogram.api.types.messages.SentEncryptedMessage",
    0x9493ff32: "pyrogram.api.types.messages.SentEncryptedFile",
    0x72f0eaae: "pyrogram.api.types.InputDocumentEmpty",
    0x18798952: "pyrogram.api.types.InputDocument",
    0x36f8c871: "pyrogram.api.types.DocumentEmpty",
    0x87232bc7: "pyrogram.api.types.Document",
    0x17c6b5f6: "pyrogram.api.types.help.Support",
    0x9fd40bd8: "pyrogram.api.types.NotifyPeer",
    0xb4c83b4c: "pyrogram.api.types.NotifyUsers",
    0xc007cec3: "pyrogram.api.types.NotifyChats",
    0x16bf744e: "pyrogram.api.types.SendMessageTypingAction",
    0xfd5ec8f5: "pyrogram.api.types.SendMessageCancelAction",
    0xa187d66f: "pyrogram.api.types.SendMessageRecordVideoAction",
    0xe9763aec: "pyrogram.api.types.SendMessageUploadVideoAction",
    0xd52f73f7: "pyrogram.api.types.SendMessageRecordAudioAction",
    0xf351d7ab: "pyrogram.api.types.SendMessageUploadAudioAction",
    0xd1d34a26: "pyrogram.api.types.SendMessageUploadPhotoAction",
    0xaa0cd9e4: "pyrogram.api.types.SendMessageUploadDocumentAction",
    0x176f8ba1: "pyrogram.api.types.SendMessageGeoLocationAction",
    0x628cbc6f: "pyrogram.api.types.SendMessageChooseContactAction",
    0xdd6a8f48: "pyrogram.api.types.SendMessageGamePlayAction",
    0x88f27fbc: "pyrogram.api.types.SendMessageRecordRoundAction",
    0x243e1c66: "pyrogram.api.types.SendMessageUploadRoundAction",
    0xb3134d9d: "pyrogram.api.types.contacts.Found",
    0x4f96cb18: "pyrogram.api.types.InputPrivacyKeyStatusTimestamp",
    0xbdfb0426: "pyrogram.api.types.InputPrivacyKeyChatInvite",
    0xfabadc5f: "pyrogram.api.types.InputPrivacyKeyPhoneCall",
    0xbc2eab30: "pyrogram.api.types.PrivacyKeyStatusTimestamp",
    0x500e6dfa: "pyrogram.api.types.PrivacyKeyChatInvite",
    0x3d662b7b: "pyrogram.api.types.PrivacyKeyPhoneCall",
    0x0d09e07b: "pyrogram.api.types.InputPrivacyValueAllowContacts",
    0x184b35ce: "pyrogram.api.types.InputPrivacyValueAllowAll",
    0x131cc67f: "pyrogram.api.types.InputPrivacyValueAllowUsers",
    0x0ba52007: "pyrogram.api.types.InputPrivacyValueDisallowContacts",
    0xd66b66c9: "pyrogram.api.types.InputPrivacyValueDisallowAll",
    0x90110467: "pyrogram.api.types.InputPrivacyValueDisallowUsers",
    0xfffe1bac: "pyrogram.api.types.PrivacyValueAllowContacts",
    0x65427b82: "pyrogram.api.types.PrivacyValueAllowAll",
    0x4d5bbe0c: "pyrogram.api.types.PrivacyValueAllowUsers",
    0xf888fa1a: "pyrogram.api.types.PrivacyValueDisallowContacts",
    0x8b73e763: "pyrogram.api.types.PrivacyValueDisallowAll",
    0x0c7f49b7: "pyrogram.api.types.PrivacyValueDisallowUsers",
    0x554abb6f: "pyrogram.api.types.account.PrivacyRules",
    0xb8d0afdf: "pyrogram.api.types.AccountDaysTTL",
    0x6c37c15c: "pyrogram.api.types.DocumentAttributeImageSize",
    0x11b58939: "pyrogram.api.types.DocumentAttributeAnimated",
    0x6319d612: "pyrogram.api.types.DocumentAttributeSticker",
    0x0ef02ce6: "pyrogram.api.types.DocumentAttributeVideo",
    0x9852f9c6: "pyrogram.api.types.DocumentAttributeAudio",
    0x15590068: "pyrogram.api.types.DocumentAttributeFilename",
    0x9801d2f7: "pyrogram.api.types.DocumentAttributeHasStickers",
    0xf1749a22: "pyrogram.api.types.messages.StickersNotModified",
    0xe4599bbd: "pyrogram.api.types.messages.Stickers",
    0x12b299d4: "pyrogram.api.types.StickerPack",
    0xe86602c3: "pyrogram.api.types.messages.AllStickersNotModified",
    0xedfd405f: "pyrogram.api.types.messages.AllStickers",
    0x84d19185: "pyrogram.api.types.messages.AffectedMessages",
    0x5f4f9247: "pyrogram.api.types.ContactLinkUnknown",
    0xfeedd3ad: "pyrogram.api.types.ContactLinkNone",
    0x268f3f59: "pyrogram.api.types.ContactLinkHasPhone",
    0xd502c2d0: "pyrogram.api.types.ContactLinkContact",
    0xeb1477e8: "pyrogram.api.types.WebPageEmpty",
    0xc586da1c: "pyrogram.api.types.WebPagePending",
    0x5f07b4bc: "pyrogram.api.types.WebPage",
    0x85849473: "pyrogram.api.types.WebPageNotModified",
    0x7bf2e6f6: "pyrogram.api.types.Authorization",
    0x1250abde: "pyrogram.api.types.account.Authorizations",
    0x5ea182f6: "pyrogram.api.types.account.NoPassword",
    0xca39b447: "pyrogram.api.types.account.Password",
    0x7bd9c3f1: "pyrogram.api.types.account.PasswordSettings",
    0x21ffa60d: "pyrogram.api.types.account.PasswordInputSettings",
    0x137948a5: "pyrogram.api.types.auth.PasswordRecovery",
    0xa384b779: "pyrogram.api.types.ReceivedNotifyMessage",
    0x69df3769: "pyrogram.api.types.ChatInviteEmpty",
    0xfc2e05bc: "pyrogram.api.types.ChatInviteExported",
    0x5a686d7c: "pyrogram.api.types.ChatInviteAlready",
    0xdb74f558: "pyrogram.api.types.ChatInvite",
    0xffb62b95: "pyrogram.api.types.InputStickerSetEmpty",
    0x9de7a269: "pyrogram.api.types.InputStickerSetID",
    0x861cc8a0: "pyrogram.api.types.InputStickerSetShortName",
    0x5585a139: "pyrogram.api.types.StickerSet",
    0xb60a24a6: "pyrogram.api.types.messages.StickerSet",
    0xc27ac8c7: "pyrogram.api.types.BotCommand",
    0x98e81d3a: "pyrogram.api.types.BotInfo",
    0xa2fa4880: "pyrogram.api.types.KeyboardButton",
    0x258aff05: "pyrogram.api.types.KeyboardButtonUrl",
    0x683a5e46: "pyrogram.api.types.KeyboardButtonCallback",
    0xb16a6c29: "pyrogram.api.types.KeyboardButtonRequestPhone",
    0xfc796b3f: "pyrogram.api.types.KeyboardButtonRequestGeoLocation",
    0x0568a748: "pyrogram.api.types.KeyboardButtonSwitchInline",
    0x50f41ccf: "pyrogram.api.types.KeyboardButtonGame",
    0xafd93fbb: "pyrogram.api.types.KeyboardButtonBuy",
    0x77608b83: "pyrogram.api.types.KeyboardButtonRow",
    0xa03e5b85: "pyrogram.api.types.ReplyKeyboardHide",
    0xf4108aa0: "pyrogram.api.types.ReplyKeyboardForceReply",
    0x3502758c: "pyrogram.api.types.ReplyKeyboardMarkup",
    0x48a30254: "pyrogram.api.types.ReplyInlineMarkup",
    0xbb92ba95: "pyrogram.api.types.MessageEntityUnknown",
    0xfa04579d: "pyrogram.api.types.MessageEntityMention",
    0x6f635b0d: "pyrogram.api.types.MessageEntityHashtag",
    0x6cef8ac7: "pyrogram.api.types.MessageEntityBotCommand",
    0x6ed02538: "pyrogram.api.types.MessageEntityUrl",
    0x64e475c2: "pyrogram.api.types.MessageEntityEmail",
    0xbd610bc9: "pyrogram.api.types.MessageEntityBold",
    0x826f8b60: "pyrogram.api.types.MessageEntityItalic",
    0x28a20571: "pyrogram.api.types.MessageEntityCode",
    0x73924be0: "pyrogram.api.types.MessageEntityPre",
    0x76a6d327: "pyrogram.api.types.MessageEntityTextUrl",
    0x352dca58: "pyrogram.api.types.MessageEntityMentionName",
    0x208e68c9: "pyrogram.api.types.InputMessageEntityMentionName",
    0x9b69e34b: "pyrogram.api.types.MessageEntityPhone",
    0x4c4e743f: "pyrogram.api.types.MessageEntityCashtag",
    0xee8c1e86: "pyrogram.api.types.InputChannelEmpty",
    0xafeb712e: "pyrogram.api.types.InputChannel",
    0x7f077ad9: "pyrogram.api.types.contacts.ResolvedPeer",
    0x0ae30253: "pyrogram.api.types.MessageRange",
    0x3e11affb: "pyrogram.api.types.updates.ChannelDifferenceEmpty",
    0x6a9d7b35: "pyrogram.api.types.updates.ChannelDifferenceTooLong",
    0x2064674e: "pyrogram.api.types.updates.ChannelDifference",
    0x94d42ee7: "pyrogram.api.types.ChannelMessagesFilterEmpty",
    0xcd77d957: "pyrogram.api.types.ChannelMessagesFilter",
    0x15ebac1d: "pyrogram.api.types.ChannelParticipant",
    0xa3289a6d: "pyrogram.api.types.ChannelParticipantSelf",
    0xe3e2e1f9: "pyrogram.api.types.ChannelParticipantCreator",
    0xa82fa898: "pyrogram.api.types.ChannelParticipantAdmin",
    0x222c1886: "pyrogram.api.types.ChannelParticipantBanned",
    0xde3f3c79: "pyrogram.api.types.ChannelParticipantsRecent",
    0xb4608969: "pyrogram.api.types.ChannelParticipantsAdmins",
    0xa3b54985: "pyrogram.api.types.ChannelParticipantsKicked",
    0xb0d1865b: "pyrogram.api.types.ChannelParticipantsBots",
    0x1427a5e1: "pyrogram.api.types.ChannelParticipantsBanned",
    0x0656ac4b: "pyrogram.api.types.ChannelParticipantsSearch",
    0xf56ee2a8: "pyrogram.api.types.channels.ChannelParticipants",
    0xf0173fe9: "pyrogram.api.types.channels.ChannelParticipantsNotModified",
    0xd0d9b163: "pyrogram.api.types.channels.ChannelParticipant",
    0x780a0310: "pyrogram.api.types.help.TermsOfService",
    0x162ecc1f: "pyrogram.api.types.FoundGif",
    0x9c750409: "pyrogram.api.types.FoundGifCached",
    0x450a1c0a: "pyrogram.api.types.messages.FoundGifs",
    0xe8025ca2: "pyrogram.api.types.messages.SavedGifsNotModified",
    0x2e0709a5: "pyrogram.api.types.messages.SavedGifs",
    0x3380c786: "pyrogram.api.types.InputBotInlineMessageMediaAuto",
    0x3dcd7a87: "pyrogram.api.types.InputBotInlineMessageText",
    0xc1b15d65: "pyrogram.api.types.InputBotInlineMessageMediaGeo",
    0x417bbf11: "pyrogram.api.types.InputBotInlineMessageMediaVenue",
    0x2daf01a7: "pyrogram.api.types.InputBotInlineMessageMediaContact",
    0x4b425864: "pyrogram.api.types.InputBotInlineMessageGame",
    0x88bf9319: "pyrogram.api.types.InputBotInlineResult",
    0xa8d864a7: "pyrogram.api.types.InputBotInlineResultPhoto",
    0xfff8fdc4: "pyrogram.api.types.InputBotInlineResultDocument",
    0x4fa417f2: "pyrogram.api.types.InputBotInlineResultGame",
    0x764cf810: "pyrogram.api.types.BotInlineMessageMediaAuto",
    0x8c7f65e2: "pyrogram.api.types.BotInlineMessageText",
    0xb722de65: "pyrogram.api.types.BotInlineMessageMediaGeo",
    0x8a86659c: "pyrogram.api.types.BotInlineMessageMediaVenue",
    0x35edb4d4: "pyrogram.api.types.BotInlineMessageMediaContact",
    0x11965f3a: "pyrogram.api.types.BotInlineResult",
    0x17db940b: "pyrogram.api.types.BotInlineMediaResult",
    0x947ca848: "pyrogram.api.types.messages.BotResults",
    0x5dab1af4: "pyrogram.api.types.ExportedMessageLink",
    0x559ebe6d: "pyrogram.api.types.MessageFwdHeader",
    0x72a3158c: "pyrogram.api.types.auth.CodeTypeSms",
    0x741cd3e3: "pyrogram.api.types.auth.CodeTypeCall",
    0x226ccefb: "pyrogram.api.types.auth.CodeTypeFlashCall",
    0x3dbb5986: "pyrogram.api.types.auth.SentCodeTypeApp",
    0xc000bba2: "pyrogram.api.types.auth.SentCodeTypeSms",
    0x5353e5a7: "pyrogram.api.types.auth.SentCodeTypeCall",
    0xab03c6d9: "pyrogram.api.types.auth.SentCodeTypeFlashCall",
    0x36585ea4: "pyrogram.api.types.messages.BotCallbackAnswer",
    0x26b5dde6: "pyrogram.api.types.messages.MessageEditData",
    0x890c3d89: "pyrogram.api.types.InputBotInlineMessageID",
    0x3c20629f: "pyrogram.api.types.InlineBotSwitchPM",
    0x3371c354: "pyrogram.api.types.messages.PeerDialogs",
    0xedcdc05b: "pyrogram.api.types.TopPeer",
    0xab661b5b: "pyrogram.api.types.TopPeerCategoryBotsPM",
    0x148677e2: "pyrogram.api.types.TopPeerCategoryBotsInline",
    0x0637b7ed: "pyrogram.api.types.TopPeerCategoryCorrespondents",
    0xbd17a14a: "pyrogram.api.types.TopPeerCategoryGroups",
    0x161d9628: "pyrogram.api.types.TopPeerCategoryChannels",
    0x1e76a78c: "pyrogram.api.types.TopPeerCategoryPhoneCalls",
    0xfb834291: "pyrogram.api.types.TopPeerCategoryPeers",
    0xde266ef5: "pyrogram.api.types.contacts.TopPeersNotModified",
    0x70b772a8: "pyrogram.api.types.contacts.TopPeers",
    0xba4baec5: "pyrogram.api.types.DraftMessageEmpty",
    0xfd8e711f: "pyrogram.api.types.DraftMessage",
    0x04ede3cf: "pyrogram.api.types.messages.FeaturedStickersNotModified",
    0xf89d88e5: "pyrogram.api.types.messages.FeaturedStickers",
    0x0b17f890: "pyrogram.api.types.messages.RecentStickersNotModified",
    0x22f3afb3: "pyrogram.api.types.messages.RecentStickers",
    0x4fcba9c8: "pyrogram.api.types.messages.ArchivedStickers",
    0x38641628: "pyrogram.api.types.messages.StickerSetInstallResultSuccess",
    0x35e410a8: "pyrogram.api.types.messages.StickerSetInstallResultArchive",
    0x6410a5d2: "pyrogram.api.types.StickerSetCovered",
    0x3407e51b: "pyrogram.api.types.StickerSetMultiCovered",
    0xaed6dbb2: "pyrogram.api.types.MaskCoords",
    0x4a992157: "pyrogram.api.types.InputStickeredMediaPhoto",
    0x0438865b: "pyrogram.api.types.InputStickeredMediaDocument",
    0xbdf9653b: "pyrogram.api.types.Game",
    0x032c3e77: "pyrogram.api.types.InputGameID",
    0xc331e80a: "pyrogram.api.types.InputGameShortName",
    0x58fffcd0: "pyrogram.api.types.HighScore",
    0x9a3bfd99: "pyrogram.api.types.messages.HighScores",
    0xdc3d824f: "pyrogram.api.types.TextEmpty",
    0x744694e0: "pyrogram.api.types.TextPlain",
    0x6724abc4: "pyrogram.api.types.TextBold",
    0xd912a59c: "pyrogram.api.types.TextItalic",
    0xc12622c4: "pyrogram.api.types.TextUnderline",
    0x9bf8bb95: "pyrogram.api.types.TextStrike",
    0x6c3f19b9: "pyrogram.api.types.TextFixed",
    0x3c2884c1: "pyrogram.api.types.TextUrl",
    0xde5a0dd6: "pyrogram.api.types.TextEmail",
    0x7e6260d7: "pyrogram.api.types.TextConcat",
    0x13567e8a: "pyrogram.api.types.PageBlockUnsupported",
    0x70abc3fd: "pyrogram.api.types.PageBlockTitle",
    0x8ffa9a1f: "pyrogram.api.types.PageBlockSubtitle",
    0xbaafe5e0: "pyrogram.api.types.PageBlockAuthorDate",
    0xbfd064ec: "pyrogram.api.types.PageBlockHeader",
    0xf12bb6e1: "pyrogram.api.types.PageBlockSubheader",
    0x467a0766: "pyrogram.api.types.PageBlockParagraph",
    0xc070d93e: "pyrogram.api.types.PageBlockPreformatted",
    0x48870999: "pyrogram.api.types.PageBlockFooter",
    0xdb20b188: "pyrogram.api.types.PageBlockDivider",
    0xce0d37b0: "pyrogram.api.types.PageBlockAnchor",
    0x3a58c7f4: "pyrogram.api.types.PageBlockList",
    0x263d7c26: "pyrogram.api.types.PageBlockBlockquote",
    0x4f4456d3: "pyrogram.api.types.PageBlockPullquote",
    0xe9c69982: "pyrogram.api.types.PageBlockPhoto",
    0xd9d71866: "pyrogram.api.types.PageBlockVideo",
    0x39f23300: "pyrogram.api.types.PageBlockCover",
    0xcde200d1: "pyrogram.api.types.PageBlockEmbed",
    0x292c7be9: "pyrogram.api.types.PageBlockEmbedPost",
    0x08b31c4f: "pyrogram.api.types.PageBlockCollage",
    0x130c8963: "pyrogram.api.types.PageBlockSlideshow",
    0xef1751b5: "pyrogram.api.types.PageBlockChannel",
    0x31b81a7f: "pyrogram.api.types.PageBlockAudio",
    0x8e3f9ebe: "pyrogram.api.types.PagePart",
    0x556ec7aa: "pyrogram.api.types.PageFull",
    0x85e42301: "pyrogram.api.types.PhoneCallDiscardReasonMissed",
    0xe095c1a0: "pyrogram.api.types.PhoneCallDiscardReasonDisconnect",
    0x57adc690: "pyrogram.api.types.PhoneCallDiscardReasonHangup",
    0xfaf7e8c9: "pyrogram.api.types.PhoneCallDiscardReasonBusy",
    0x7d748d04: "pyrogram.api.types.DataJSON",
    0xcb296bf8: "pyrogram.api.types.LabeledPrice",
    0xc30aa358: "pyrogram.api.types.Invoice",
    0xea02c27e: "pyrogram.api.types.PaymentCharge",
    0x1e8caaeb: "pyrogram.api.types.PostAddress",
    0x909c3f94: "pyrogram.api.types.PaymentRequestedInfo",
    0xcdc27a1f: "pyrogram.api.types.PaymentSavedCredentialsCard",
    0xc61acbd8: "pyrogram.api.types.WebDocument",
    0xf9c8bcc6: "pyrogram.api.types.WebDocumentNoProxy",
    0x9bed434d: "pyrogram.api.types.InputWebDocument",
    0xc239d686: "pyrogram.api.types.InputWebFileLocation",
    0x66275a62: "pyrogram.api.types.InputWebFileGeoPointLocation",
    0x553f32eb: "pyrogram.api.types.InputWebFileGeoMessageLocation",
    0x21e753bc: "pyrogram.api.types.upload.WebFile",
    0x3f56aea3: "pyrogram.api.types.payments.PaymentForm",
    0xd1451883: "pyrogram.api.types.payments.ValidatedRequestedInfo",
    0x4e5f810d: "pyrogram.api.types.payments.PaymentResult",
    0x6b56b921: "pyrogram.api.types.payments.PaymentVerficationNeeded",
    0x500911e1: "pyrogram.api.types.payments.PaymentReceipt",
    0xfb8fe43c: "pyrogram.api.types.payments.SavedInfo",
    0xc10eb2cf: "pyrogram.api.types.InputPaymentCredentialsSaved",
    0x3417d728: "pyrogram.api.types.InputPaymentCredentials",
    0x0aa1c39f: "pyrogram.api.types.InputPaymentCredentialsApplePay",
    0xca05d50e: "pyrogram.api.types.InputPaymentCredentialsAndroidPay",
    0xdb64fd34: "pyrogram.api.types.account.TmpPassword",
    0xb6213cdf: "pyrogram.api.types.ShippingOption",
    0xffa0a496: "pyrogram.api.types.InputStickerSetItem",
    0x1e36fded: "pyrogram.api.types.InputPhoneCall",
    0x5366c915: "pyrogram.api.types.PhoneCallEmpty",
    0x1b8f4ad1: "pyrogram.api.types.PhoneCallWaiting",
    0x83761ce4: "pyrogram.api.types.PhoneCallRequested",
    0x6d003d3f: "pyrogram.api.types.PhoneCallAccepted",
    0xffe6ab67: "pyrogram.api.types.PhoneCall",
    0x50ca4de1: "pyrogram.api.types.PhoneCallDiscarded",
    0x9d4c17c0: "pyrogram.api.types.PhoneConnection",
    0xa2bb35cb: "pyrogram.api.types.PhoneCallProtocol",
    0xec82e140: "pyrogram.api.types.phone.PhoneCall",
    0xeea8e46e: "pyrogram.api.types.upload.CdnFileReuploadNeeded",
    0xa99fca4f: "pyrogram.api.types.upload.CdnFile",
    0xc982eaba: "pyrogram.api.types.CdnPublicKey",
    0x5725e40a: "pyrogram.api.types.CdnConfig",
    0xcad181f6: "pyrogram.api.types.LangPackString",
    0x6c47ac9f: "pyrogram.api.types.LangPackStringPluralized",
    0x2979eeb2: "pyrogram.api.types.LangPackStringDeleted",
    0xf385c1f6: "pyrogram.api.types.LangPackDifference",
    0x117698f1: "pyrogram.api.types.LangPackLanguage",
    0x5d7ceba5: "pyrogram.api.types.ChannelAdminRights",
    0x58cf4249: "pyrogram.api.types.ChannelBannedRights",
    0xe6dfb825: "pyrogram.api.types.ChannelAdminLogEventActionChangeTitle",
    0x55188a2e: "pyrogram.api.types.ChannelAdminLogEventActionChangeAbout",
    0x6a4afc38: "pyrogram.api.types.ChannelAdminLogEventActionChangeUsername",
    0xb82f55c3: "pyrogram.api.types.ChannelAdminLogEventActionChangePhoto",
    0x1b7907ae: "pyrogram.api.types.ChannelAdminLogEventActionToggleInvites",
    0x26ae0971: "pyrogram.api.types.ChannelAdminLogEventActionToggleSignatures",
    0xe9e82c18: "pyrogram.api.types.ChannelAdminLogEventActionUpdatePinned",
    0x709b2405: "pyrogram.api.types.ChannelAdminLogEventActionEditMessage",
    0x42e047bb: "pyrogram.api.types.ChannelAdminLogEventActionDeleteMessage",
    0x183040d3: "pyrogram.api.types.ChannelAdminLogEventActionParticipantJoin",
    0xf89777f2: "pyrogram.api.types.ChannelAdminLogEventActionParticipantLeave",
    0xe31c34d8: "pyrogram.api.types.ChannelAdminLogEventActionParticipantInvite",
    0xe6d83d7e: "pyrogram.api.types.ChannelAdminLogEventActionParticipantToggleBan",
    0xd5676710: "pyrogram.api.types.ChannelAdminLogEventActionParticipantToggleAdmin",
    0xb1c3caa7: "pyrogram.api.types.ChannelAdminLogEventActionChangeStickerSet",
    0x5f5c95f1: "pyrogram.api.types.ChannelAdminLogEventActionTogglePreHistoryHidden",
    0x3b5a3e40: "pyrogram.api.types.ChannelAdminLogEvent",
    0xed8af74d: "pyrogram.api.types.channels.AdminLogResults",
    0xea107ae4: "pyrogram.api.types.ChannelAdminLogEventsFilter",
    0x5ce14175: "pyrogram.api.types.PopularContact",
    0x9e8fa6d3: "pyrogram.api.types.messages.FavedStickersNotModified",
    0xf37f2f16: "pyrogram.api.types.messages.FavedStickers",
    0x46e1d13d: "pyrogram.api.types.RecentMeUrlUnknown",
    0x8dbc3336: "pyrogram.api.types.RecentMeUrlUser",
    0xa01b22f9: "pyrogram.api.types.RecentMeUrlChat",
    0xeb49081d: "pyrogram.api.types.RecentMeUrlChatInvite",
    0xbc0a57dc: "pyrogram.api.types.RecentMeUrlStickerSet",
    0x0e0310d7: "pyrogram.api.types.help.RecentMeUrls",
    0x1cc6e91f: "pyrogram.api.types.InputSingleMedia",
    0xcac943f2: "pyrogram.api.types.WebAuthorization",
    0xed56c9fc: "pyrogram.api.types.account.WebAuthorizations",
    0xa676a322: "pyrogram.api.types.InputMessageID",
    0xbad88395: "pyrogram.api.types.InputMessageReplyTo",
    0x86872538: "pyrogram.api.types.InputMessagePinned",
    0xfcaafeb7: "pyrogram.api.types.InputDialogPeer",
    0xe56dbf05: "pyrogram.api.types.DialogPeer",
    0x0d54b65d: "pyrogram.api.types.messages.FoundStickerSetsNotModified",
    0x5108d648: "pyrogram.api.types.messages.FoundStickerSets",
    0x6242c773: "pyrogram.api.types.FileHash",
    0x75588b3f: "pyrogram.api.types.InputClientProxy",
    0xe09e1fb8: "pyrogram.api.types.help.ProxyDataEmpty",
    0x2bf7ee23: "pyrogram.api.types.help.ProxyDataPromo",
    0xe3309f7f: "pyrogram.api.types.help.TermsOfServiceUpdateEmpty",
    0x28ecf961: "pyrogram.api.types.help.TermsOfServiceUpdate",
    0x3334b0f0: "pyrogram.api.types.InputSecureFileUploaded",
    0x5367e5be: "pyrogram.api.types.InputSecureFile",
    0x64199744: "pyrogram.api.types.SecureFileEmpty",
    0xe0277a62: "pyrogram.api.types.SecureFile",
    0x8aeabec3: "pyrogram.api.types.SecureData",
    0x7d6099dd: "pyrogram.api.types.SecurePlainPhone",
    0x21ec5a5f: "pyrogram.api.types.SecurePlainEmail",
    0x9d2a81e3: "pyrogram.api.types.SecureValueTypePersonalDetails",
    0x3dac6a00: "pyrogram.api.types.SecureValueTypePassport",
    0x06e425c4: "pyrogram.api.types.SecureValueTypeDriverLicense",
    0xa0d0744b: "pyrogram.api.types.SecureValueTypeIdentityCard",
    0x99a48f23: "pyrogram.api.types.SecureValueTypeInternalPassport",
    0xcbe31e26: "pyrogram.api.types.SecureValueTypeAddress",
    0xfc36954e: "pyrogram.api.types.SecureValueTypeUtilityBill",
    0x89137c0d: "pyrogram.api.types.SecureValueTypeBankStatement",
    0x8b883488: "pyrogram.api.types.SecureValueTypeRentalAgreement",
    0x99e3806a: "pyrogram.api.types.SecureValueTypePassportRegistration",
    0xea02ec33: "pyrogram.api.types.SecureValueTypeTemporaryRegistration",
    0xb320aadb: "pyrogram.api.types.SecureValueTypePhone",
    0x8e3ca7ee: "pyrogram.api.types.SecureValueTypeEmail",
    0xb4b4b699: "pyrogram.api.types.SecureValue",
    0x067872e8: "pyrogram.api.types.InputSecureValue",
    0xed1ecdb0: "pyrogram.api.types.SecureValueHash",
    0xe8a40bd9: "pyrogram.api.types.SecureValueErrorData",
    0x00be3dfa: "pyrogram.api.types.SecureValueErrorFrontSide",
    0x868a2aa5: "pyrogram.api.types.SecureValueErrorReverseSide",
    0xe537ced6: "pyrogram.api.types.SecureValueErrorSelfie",
    0x7a700873: "pyrogram.api.types.SecureValueErrorFile",
    0x666220e9: "pyrogram.api.types.SecureValueErrorFiles",
    0x33f0ea47: "pyrogram.api.types.SecureCredentialsEncrypted",
    0xcb976d53: "pyrogram.api.types.account.AuthorizationForm",
    0x811f854f: "pyrogram.api.types.account.SentEmailCode",
    0x66afa166: "pyrogram.api.types.help.DeepLinkInfoEmpty",
    0x6a4ee832: "pyrogram.api.types.help.DeepLinkInfo",
    0xcb9f372d: "pyrogram.api.functions.InvokeAfterMsg",
    0x3dc4b4f0: "pyrogram.api.functions.InvokeAfterMsgs",
    0x785188b8: "pyrogram.api.functions.InitConnection",
    0xda9b0d0d: "pyrogram.api.functions.InvokeWithLayer",
    0xbf9459b7: "pyrogram.api.functions.InvokeWithoutUpdates",
    0x86aef0ec: "pyrogram.api.functions.auth.SendCode",
    0x1b067634: "pyrogram.api.functions.auth.SignUp",
    0xbcd51581: "pyrogram.api.functions.auth.SignIn",
    0x5717da40: "pyrogram.api.functions.auth.LogOut",
    0x9fab0d1a: "pyrogram.api.functions.auth.ResetAuthorizations",
    0x771c1d97: "pyrogram.api.functions.auth.SendInvites",
    0xe5bfffcd: "pyrogram.api.functions.auth.ExportAuthorization",
    0xe3ef9613: "pyrogram.api.functions.auth.ImportAuthorization",
    0xcdd42a05: "pyrogram.api.functions.auth.BindTempAuthKey",
    0x67a3ff2c: "pyrogram.api.functions.auth.ImportBotAuthorization",
    0x0a63011e: "pyrogram.api.functions.auth.CheckPassword",
    0xd897bc66: "pyrogram.api.functions.auth.RequestPasswordRecovery",
    0x4ea56e92: "pyrogram.api.functions.auth.RecoverPassword",
    0x3ef1a9bf: "pyrogram.api.functions.auth.ResendCode",
    0x1f040578: "pyrogram.api.functions.auth.CancelCode",
    0x8e48a188: "pyrogram.api.functions.auth.DropTempAuthKeys",
    0x5cbea590: "pyrogram.api.functions.account.RegisterDevice",
    0x3076c4bf: "pyrogram.api.functions.account.UnregisterDevice",
    0x84be5b93: "pyrogram.api.functions.account.UpdateNotifySettings",
    0x12b3ad31: "pyrogram.api.functions.account.GetNotifySettings",
    0xdb7e1747: "pyrogram.api.functions.account.ResetNotifySettings",
    0x78515775: "pyrogram.api.functions.account.UpdateProfile",
    0x6628562c: "pyrogram.api.functions.account.UpdateStatus",
    0xc04cfac2: "pyrogram.api.functions.account.GetWallPapers",
    0xae189d5f: "pyrogram.api.functions.account.ReportPeer",
    0x2714d86c: "pyrogram.api.functions.account.CheckUsername",
    0x3e0bdd7c: "pyrogram.api.functions.account.UpdateUsername",
    0xdadbc950: "pyrogram.api.functions.account.GetPrivacy",
    0xc9f81ce8: "pyrogram.api.functions.account.SetPrivacy",
    0x418d4e0b: "pyrogram.api.functions.account.DeleteAccount",
    0x08fc711d: "pyrogram.api.functions.account.GetAccountTTL",
    0x2442485e: "pyrogram.api.functions.account.SetAccountTTL",
    0x08e57deb: "pyrogram.api.functions.account.SendChangePhoneCode",
    0x70c32edb: "pyrogram.api.functions.account.ChangePhone",
    0x38df3532: "pyrogram.api.functions.account.UpdateDeviceLocked",
    0xe320c158: "pyrogram.api.functions.account.GetAuthorizations",
    0xdf77f3bc: "pyrogram.api.functions.account.ResetAuthorization",
    0x548a30f5: "pyrogram.api.functions.account.GetPassword",
    0xbc8d11bb: "pyrogram.api.functions.account.GetPasswordSettings",
    0xfa7c4b86: "pyrogram.api.functions.account.UpdatePasswordSettings",
    0x1516d7bd: "pyrogram.api.functions.account.SendConfirmPhoneCode",
    0x5f2178c3: "pyrogram.api.functions.account.ConfirmPhone",
    0x4a82327e: "pyrogram.api.functions.account.GetTmpPassword",
    0x182e6d6f: "pyrogram.api.functions.account.GetWebAuthorizations",
    0x2d01b9ef: "pyrogram.api.functions.account.ResetWebAuthorization",
    0x682d2594: "pyrogram.api.functions.account.ResetWebAuthorizations",
    0xb288bc7d: "pyrogram.api.functions.account.GetAllSecureValues",
    0x73665bc2: "pyrogram.api.functions.account.GetSecureValue",
    0x899fe31d: "pyrogram.api.functions.account.SaveSecureValue",
    0xb880bc4b: "pyrogram.api.functions.account.DeleteSecureValue",
    0xb86ba8e1: "pyrogram.api.functions.account.GetAuthorizationForm",
    0xe7027c94: "pyrogram.api.functions.account.AcceptAuthorization",
    0x823380b4: "pyrogram.api.functions.account.SendVerifyPhoneCode",
    0x4dd3a7f6: "pyrogram.api.functions.account.VerifyPhone",
    0x7011509f: "pyrogram.api.functions.account.SendVerifyEmailCode",
    0xecba39db: "pyrogram.api.functions.account.VerifyEmail",
    0x0d91a548: "pyrogram.api.functions.users.GetUsers",
    0xca30a5b1: "pyrogram.api.functions.users.GetFullUser",
    0x90c894b5: "pyrogram.api.functions.users.SetSecureValueErrors",
    0xc4a353ee: "pyrogram.api.functions.contacts.GetStatuses",
    0xc023849f: "pyrogram.api.functions.contacts.GetContacts",
    0x2c800be5: "pyrogram.api.functions.contacts.ImportContacts",
    0x8e953744: "pyrogram.api.functions.contacts.DeleteContact",
    0x59ab389e: "pyrogram.api.functions.contacts.DeleteContacts",
    0x332b49fc: "pyrogram.api.functions.contacts.Block",
    0xe54100bd: "pyrogram.api.functions.contacts.Unblock",
    0xf57c350f: "pyrogram.api.functions.contacts.GetBlocked",
    0x84e53737: "pyrogram.api.functions.contacts.ExportCard",
    0x4fe196fe: "pyrogram.api.functions.contacts.ImportCard",
    0x11f812d8: "pyrogram.api.functions.contacts.Search",
    0xf93ccba3: "pyrogram.api.functions.contacts.ResolveUsername",
    0xd4982db5: "pyrogram.api.functions.contacts.GetTopPeers",
    0x1ae373ac: "pyrogram.api.functions.contacts.ResetTopPeerRating",
    0x879537f1: "pyrogram.api.functions.contacts.ResetSaved",
    0x63c66506: "pyrogram.api.functions.messages.GetMessages",
    0x191ba9c5: "pyrogram.api.functions.messages.GetDialogs",
    0xdcbb8260: "pyrogram.api.functions.messages.GetHistory",
    0x8614ef68: "pyrogram.api.functions.messages.Search",
    0x0e306d3a: "pyrogram.api.functions.messages.ReadHistory",
    0x1c015b09: "pyrogram.api.functions.messages.DeleteHistory",
    0xe58e95d2: "pyrogram.api.functions.messages.DeleteMessages",
    0x05a954c0: "pyrogram.api.functions.messages.ReceivedMessages",
    0xa3825e50: "pyrogram.api.functions.messages.SetTyping",
    0xfa88427a: "pyrogram.api.functions.messages.SendMessage",
    0xb8d1262b: "pyrogram.api.functions.messages.SendMedia",
    0x708e0195: "pyrogram.api.functions.messages.ForwardMessages",
    0xcf1592db: "pyrogram.api.functions.messages.ReportSpam",
    0xa8f1709b: "pyrogram.api.functions.messages.HideReportSpam",
    0x3672e09c: "pyrogram.api.functions.messages.GetPeerSettings",
    0xbd82b658: "pyrogram.api.functions.messages.Report",
    0x3c6aa187: "pyrogram.api.functions.messages.GetChats",
    0x3b831c66: "pyrogram.api.functions.messages.GetFullChat",
    0xdc452855: "pyrogram.api.functions.messages.EditChatTitle",
    0xca4c79d8: "pyrogram.api.functions.messages.EditChatPhoto",
    0xf9a0aa09: "pyrogram.api.functions.messages.AddChatUser",
    0xe0611f16: "pyrogram.api.functions.messages.DeleteChatUser",
    0x09cb126e: "pyrogram.api.functions.messages.CreateChat",
    0x26cf8950: "pyrogram.api.functions.messages.GetDhConfig",
    0xf64daf43: "pyrogram.api.functions.messages.RequestEncryption",
    0x3dbc0415: "pyrogram.api.functions.messages.AcceptEncryption",
    0xedd923c5: "pyrogram.api.functions.messages.DiscardEncryption",
    0x791451ed: "pyrogram.api.functions.messages.SetEncryptedTyping",
    0x7f4b690a: "pyrogram.api.functions.messages.ReadEncryptedHistory",
    0xa9776773: "pyrogram.api.functions.messages.SendEncrypted",
    0x9a901b66: "pyrogram.api.functions.messages.SendEncryptedFile",
    0x32d439a4: "pyrogram.api.functions.messages.SendEncryptedService",
    0x55a5bb66: "pyrogram.api.functions.messages.ReceivedQueue",
    0x4b0c8c0f: "pyrogram.api.functions.messages.ReportEncryptedSpam",
    0x36a73f77: "pyrogram.api.functions.messages.ReadMessageContents",
    0x043d4f2c: "pyrogram.api.functions.messages.GetStickers",
    0x1c9618b1: "pyrogram.api.functions.messages.GetAllStickers",
    0x8b68b0cc: "pyrogram.api.functions.messages.GetWebPagePreview",
    0x7d885289: "pyrogram.api.functions.messages.ExportChatInvite",
    0x3eadb1bb: "pyrogram.api.functions.messages.CheckChatInvite",
    0x6c50051c: "pyrogram.api.functions.messages.ImportChatInvite",
    0x2619a90e: "pyrogram.api.functions.messages.GetStickerSet",
    0xc78fe460: "pyrogram.api.functions.messages.InstallStickerSet",
    0xf96e55de: "pyrogram.api.functions.messages.UninstallStickerSet",
    0xe6df7378: "pyrogram.api.functions.messages.StartBot",
    0xc4c8a55d: "pyrogram.api.functions.messages.GetMessagesViews",
    0xec8bd9e1: "pyrogram.api.functions.messages.ToggleChatAdmins",
    0xa9e69f2e: "pyrogram.api.functions.messages.EditChatAdmin",
    0x15a3b8e3: "pyrogram.api.functions.messages.MigrateChat",
    0x9e3cacb0: "pyrogram.api.functions.messages.SearchGlobal",
    0x78337739: "pyrogram.api.functions.messages.ReorderStickerSets",
    0x338e2464: "pyrogram.api.functions.messages.GetDocumentByHash",
    0xbf9a776b: "pyrogram.api.functions.messages.SearchGifs",
    0x83bf3d52: "pyrogram.api.functions.messages.GetSavedGifs",
    0x327a30cb: "pyrogram.api.functions.messages.SaveGif",
    0x514e999d: "pyrogram.api.functions.messages.GetInlineBotResults",
    0xeb5ea206: "pyrogram.api.functions.messages.SetInlineBotResults",
    0xb16e06fe: "pyrogram.api.functions.messages.SendInlineBotResult",
    0xfda68d36: "pyrogram.api.functions.messages.GetMessageEditData",
    0xc000e4c8: "pyrogram.api.functions.messages.EditMessage",
    0xadc3e828: "pyrogram.api.functions.messages.EditInlineBotMessage",
    0x810a9fec: "pyrogram.api.functions.messages.GetBotCallbackAnswer",
    0xd58f130a: "pyrogram.api.functions.messages.SetBotCallbackAnswer",
    0xe470bcfd: "pyrogram.api.functions.messages.GetPeerDialogs",
    0xbc39e14b: "pyrogram.api.functions.messages.SaveDraft",
    0x6a3f8d65: "pyrogram.api.functions.messages.GetAllDrafts",
    0x2dacca4f: "pyrogram.api.functions.messages.GetFeaturedStickers",
    0x5b118126: "pyrogram.api.functions.messages.ReadFeaturedStickers",
    0x5ea192c9: "pyrogram.api.functions.messages.GetRecentStickers",
    0x392718f8: "pyrogram.api.functions.messages.SaveRecentSticker",
    0x8999602d: "pyrogram.api.functions.messages.ClearRecentStickers",
    0x57f17692: "pyrogram.api.functions.messages.GetArchivedStickers",
    0x65b8c79f: "pyrogram.api.functions.messages.GetMaskStickers",
    0xcc5b67cc: "pyrogram.api.functions.messages.GetAttachedStickers",
    0x8ef8ecc0: "pyrogram.api.functions.messages.SetGameScore",
    0x15ad9f64: "pyrogram.api.functions.messages.SetInlineGameScore",
    0xe822649d: "pyrogram.api.functions.messages.GetGameHighScores",
    0x0f635e1b: "pyrogram.api.functions.messages.GetInlineGameHighScores",
    0x0d0a48c4: "pyrogram.api.functions.messages.GetCommonChats",
    0xeba80ff0: "pyrogram.api.functions.messages.GetAllChats",
    0x32ca8f91: "pyrogram.api.functions.messages.GetWebPage",
    0xa731e257: "pyrogram.api.functions.messages.ToggleDialogPin",
    0x5b51d63f: "pyrogram.api.functions.messages.ReorderPinnedDialogs",
    0xe254d64e: "pyrogram.api.functions.messages.GetPinnedDialogs",
    0xe5f672fa: "pyrogram.api.functions.messages.SetBotShippingResults",
    0x09c2dd95: "pyrogram.api.functions.messages.SetBotPrecheckoutResults",
    0x519bc2b1: "pyrogram.api.functions.messages.UploadMedia",
    0xc97df020: "pyrogram.api.functions.messages.SendScreenshotNotification",
    0x21ce0b0e: "pyrogram.api.functions.messages.GetFavedStickers",
    0xb9ffc55b: "pyrogram.api.functions.messages.FaveSticker",
    0x46578472: "pyrogram.api.functions.messages.GetUnreadMentions",
    0x0f0189d3: "pyrogram.api.functions.messages.ReadMentions",
    0xbbc45b09: "pyrogram.api.functions.messages.GetRecentLocations",
    0x2095512f: "pyrogram.api.functions.messages.SendMultiMedia",
    0x5057c497: "pyrogram.api.functions.messages.UploadEncryptedFile",
    0xc2b7d08b: "pyrogram.api.functions.messages.SearchStickerSets",
    0xedd4882a: "pyrogram.api.functions.updates.GetState",
    0x25939651: "pyrogram.api.functions.updates.GetDifference",
    0x03173d78: "pyrogram.api.functions.updates.GetChannelDifference",
    0xf0bb5152: "pyrogram.api.functions.photos.UpdateProfilePhoto",
    0x4f32c098: "pyrogram.api.functions.photos.UploadProfilePhoto",
    0x87cf7f2f: "pyrogram.api.functions.photos.DeletePhotos",
    0x91cd32a8: "pyrogram.api.functions.photos.GetUserPhotos",
    0xb304a621: "pyrogram.api.functions.upload.SaveFilePart",
    0xe3a6cfb5: "pyrogram.api.functions.upload.GetFile",
    0xde7b673d: "pyrogram.api.functions.upload.SaveBigFilePart",
    0x24e6818d: "pyrogram.api.functions.upload.GetWebFile",
    0x2000bcc3: "pyrogram.api.functions.upload.GetCdnFile",
    0x9b2754a8: "pyrogram.api.functions.upload.ReuploadCdnFile",
    0x4da54231: "pyrogram.api.functions.upload.GetCdnFileHashes",
    0xc7025931: "pyrogram.api.functions.upload.GetFileHashes",
    0xc4f9186b: "pyrogram.api.functions.help.GetConfig",
    0x1fb33026: "pyrogram.api.functions.help.GetNearestDc",
    0xae2de196: "pyrogram.api.functions.help.GetAppUpdate",
    0x6f02f748: "pyrogram.api.functions.help.SaveAppLog",
    0x4d392343: "pyrogram.api.functions.help.GetInviteText",
    0x9cdf08cd: "pyrogram.api.functions.help.GetSupport",
    0x9010ef6f: "pyrogram.api.functions.help.GetAppChangelog",
    0xec22cfcd: "pyrogram.api.functions.help.SetBotUpdatesStatus",
    0x52029342: "pyrogram.api.functions.help.GetCdnConfig",
    0x3dc0f114: "pyrogram.api.functions.help.GetRecentMeUrls",
    0x3d7758e1: "pyrogram.api.functions.help.GetProxyData",
    0x2ca51fd1: "pyrogram.api.functions.help.GetTermsOfServiceUpdate",
    0xee72f79a: "pyrogram.api.functions.help.AcceptTermsOfService",
    0x3fedc75f: "pyrogram.api.functions.help.GetDeepLinkInfo",
    0xcc104937: "pyrogram.api.functions.channels.ReadHistory",
    0x84c1fd4e: "pyrogram.api.functions.channels.DeleteMessages",
    0xd10dd71b: "pyrogram.api.functions.channels.DeleteUserHistory",
    0xfe087810: "pyrogram.api.functions.channels.ReportSpam",
    0xad8c9a23: "pyrogram.api.functions.channels.GetMessages",
    0x123e05e9: "pyrogram.api.functions.channels.GetParticipants",
    0x546dd7a6: "pyrogram.api.functions.channels.GetParticipant",
    0x0a7f6bbb: "pyrogram.api.functions.channels.GetChannels",
    0x08736a09: "pyrogram.api.functions.channels.GetFullChannel",
    0xf4893d7f: "pyrogram.api.functions.channels.CreateChannel",
    0x13e27f1e: "pyrogram.api.functions.channels.EditAbout",
    0x20b88214: "pyrogram.api.functions.channels.EditAdmin",
    0x566decd0: "pyrogram.api.functions.channels.EditTitle",
    0xf12e57c9: "pyrogram.api.functions.channels.EditPhoto",
    0x10e6bd2c: "pyrogram.api.functions.channels.CheckUsername",
    0x3514b3de: "pyrogram.api.functions.channels.UpdateUsername",
    0x24b524c5: "pyrogram.api.functions.channels.JoinChannel",
    0xf836aa95: "pyrogram.api.functions.channels.LeaveChannel",
    0x199f3a6c: "pyrogram.api.functions.channels.InviteToChannel",
    0xc7560885: "pyrogram.api.functions.channels.ExportInvite",
    0xc0111fe3: "pyrogram.api.functions.channels.DeleteChannel",
    0x49609307: "pyrogram.api.functions.channels.ToggleInvites",
    0xceb77163: "pyrogram.api.functions.channels.ExportMessageLink",
    0x1f69b606: "pyrogram.api.functions.channels.ToggleSignatures",
    0xa72ded52: "pyrogram.api.functions.channels.UpdatePinnedMessage",
    0x8d8d82d7: "pyrogram.api.functions.channels.GetAdminedPublicChannels",
    0xbfd915cd: "pyrogram.api.functions.channels.EditBanned",
    0x33ddf480: "pyrogram.api.functions.channels.GetAdminLog",
    0xea8ca4f9: "pyrogram.api.functions.channels.SetStickers",
    0xeab5dc38: "pyrogram.api.functions.channels.ReadMessageContents",
    0xaf369d42: "pyrogram.api.functions.channels.DeleteHistory",
    0xeabbb94c: "pyrogram.api.functions.channels.TogglePreHistoryHidden",
    0xaa2769ed: "pyrogram.api.functions.bots.SendCustomRequest",
    0xe6213f4d: "pyrogram.api.functions.bots.AnswerWebhookJSONQuery",
    0x99f09745: "pyrogram.api.functions.payments.GetPaymentForm",
    0xa092a980: "pyrogram.api.functions.payments.GetPaymentReceipt",
    0x770a8e74: "pyrogram.api.functions.payments.ValidateRequestedInfo",
    0x2b8879b3: "pyrogram.api.functions.payments.SendPaymentForm",
    0x227d824b: "pyrogram.api.functions.payments.GetSavedInfo",
    0xd83d70c1: "pyrogram.api.functions.payments.ClearSavedInfo",
    0x9bd86e6a: "pyrogram.api.functions.stickers.CreateStickerSet",
    0xf7760f51: "pyrogram.api.functions.stickers.RemoveStickerFromSet",
    0xffb6d4ca: "pyrogram.api.functions.stickers.ChangeStickerPosition",
    0x8653febe: "pyrogram.api.functions.stickers.AddStickerToSet",
    0x55451fa9: "pyrogram.api.functions.phone.GetCallConfig",
    0x5b95b3d4: "pyrogram.api.functions.phone.RequestCall",
    0x3bd2b4a0: "pyrogram.api.functions.phone.AcceptCall",
    0x2efe1722: "pyrogram.api.functions.phone.ConfirmCall",
    0x17d54f61: "pyrogram.api.functions.phone.ReceivedCall",
    0x78d413a6: "pyrogram.api.functions.phone.DiscardCall",
    0x1c536a34: "pyrogram.api.functions.phone.SetCallRating",
    0x277add7e: "pyrogram.api.functions.phone.SaveCallDebug",
    0x9ab5c58e: "pyrogram.api.functions.langpack.GetLangPack",
    0x2e1ee318: "pyrogram.api.functions.langpack.GetStrings",
    0x0b2e4d7d: "pyrogram.api.functions.langpack.GetDifference",
    0x800fd57d: "pyrogram.api.functions.langpack.GetLanguages",
    0xbc799737: "pyrogram.api.core.BoolFalse",
    0x997275b5: "pyrogram.api.core.BoolTrue",
    0x56730bcc: "pyrogram.api.core.Null",
    0x1cb5c415: "pyrogram.api.core.Vector",
    0x73f1f8dc: "pyrogram.api.core.MsgContainer",
    0xae500895: "pyrogram.api.core.FutureSalts",
    0x0949d9dc: "pyrogram.api.core.FutureSalt",
    0x3072cfa1: "pyrogram.api.core.GzipPacked",
    0x5bb8e511: "pyrogram.api.core.Message",
    0xb0700000: "pyrogram.client.types.Update",
    0xb0700001: "pyrogram.client.types.User",
    0xb0700002: "pyrogram.client.types.Chat",
    0xb0700003: "pyrogram.client.types.Message",
    0xb0700004: "pyrogram.client.types.MessageEntity",
    0xb0700005: "pyrogram.client.types.PhotoSize",
    0xb0700006: "pyrogram.client.types.Audio",
    0xb0700007: "pyrogram.client.types.Document",
    0xb0700008: "pyrogram.client.types.Video",
    0xb0700009: "pyrogram.client.types.Voice",
    0xb0700010: "pyrogram.client.types.VideoNote",
    0xb0700011: "pyrogram.client.types.Contact",
    0xb0700012: "pyrogram.client.types.Location",
    0xb0700013: "pyrogram.client.types.Venue",
    0xb0700014: "pyrogram.client.types.UserProfilePhotos",
    0xb0700015: "pyrogram.client.types.ChatPhoto",
    0xb0700016: "pyrogram.client.types.ChatMember",
    0xb0700017: "pyrogram.client.types.Sticker",
    0xb0700025: "pyrogram.client.types.GIF",
    0xb0700026: "pyrogram.client.types.Messages",
    0xb0700018: "pyrogram.client.types.reply_markup.ForceReply",
    0xb0700019: "pyrogram.client.types.reply_markup.InlineKeyboardButton",
    0xb0700020: "pyrogram.client.types.reply_markup.InlineKeyboardMarkup",
    0xb0700021: "pyrogram.client.types.reply_markup.KeyboardButton",
    0xb0700022: "pyrogram.client.types.reply_markup.ReplyKeyboardMarkup",
    0xb0700023: "pyrogram.client.types.reply_markup.ReplyKeyboardRemove",
    0xb0700024: "pyrogram.client.types.CallbackQuery"
}
