#  Pyrogram - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of Pyrogram.
#
#  Pyrogram is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Pyrogram is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.raw.core.primitives import Int, Long, Int128, Int256, Bool, Bytes, String, Double, Vector
from pyrogram.raw.core import TLObject
from pyrogram import raw
from typing import List, Optional, Any

# # # # # # # # # # # # # # # # # # # # # # # #
#               !!! WARNING !!!               #
#          This is a generated file!          #
# All changes made in this file will be lost! #
# # # # # # # # # # # # # # # # # # # # # # # #


class BroadcastRevenueTransactions(TLObject):  # type: ignore
    """Telegram API type.

    Constructor of :obj:`~pyrogram.raw.base.stats.BroadcastRevenueTransactions`.

    Details:
        - Layer: ``187``
        - ID: ``87158466``

    Parameters:
        count (``int`` ``32-bit``):
            N/A

        transactions (List of :obj:`BroadcastRevenueTransaction <pyrogram.raw.base.BroadcastRevenueTransaction>`):
            N/A

    Functions:
        This object can be returned by 1 function.

        .. currentmodule:: pyrogram.raw.functions

        .. autosummary::
            :nosignatures:

            stats.GetBroadcastRevenueTransactions
    """

    __slots__: List[str] = ["count", "transactions"]

    ID = 0x87158466
    QUALNAME = "types.stats.BroadcastRevenueTransactions"

    def __init__(self, *, count: int, transactions: List["raw.base.BroadcastRevenueTransaction"]) -> None:
        self.count = count  # int
        self.transactions = transactions  # Vector<BroadcastRevenueTransaction>

    @staticmethod
    def read(b: BytesIO, *args: Any) -> "BroadcastRevenueTransactions":
        # No flags
        
        count = Int.read(b)
        
        transactions = TLObject.read(b)
        
        return BroadcastRevenueTransactions(count=count, transactions=transactions)

    def write(self, *args) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(Int(self.count))
        
        b.write(Vector(self.transactions))
        
        return b.getvalue()
