#  Pyrogram - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of Pyrogram.
#
#  Pyrogram is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Pyrogram is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.raw.core.primitives import Int, Long, Int128, Int256, Bool, Bytes, String, Double, Vector
from pyrogram.raw.core import TLObject
from pyrogram import raw
from typing import List, Optional, Any

# # # # # # # # # # # # # # # # # # # # # # # #
#               !!! WARNING !!!               #
#          This is a generated file!          #
# All changes made in this file will be lost! #
# # # # # # # # # # # # # # # # # # # # # # # #


class MessageMediaToDo(TLObject):  # type: ignore
    """Represents a todo list ».

    Constructor of :obj:`~pyrogram.raw.base.MessageMedia`.

    Details:
        - Layer: ``216``
        - ID: ``8A53B014``

    Parameters:
        todo (:obj:`TodoList <pyrogram.raw.base.TodoList>`):
            The todo list.

        completions (List of :obj:`TodoCompletion <pyrogram.raw.base.TodoCompletion>`, *optional*):
            Completed items.

    Functions:
        This object can be returned by 2 functions.

        .. currentmodule:: pyrogram.raw.functions

        .. autosummary::
            :nosignatures:

            messages.UploadMedia
            messages.UploadImportedMedia
    """

    __slots__: List[str] = ["todo", "completions"]

    ID = 0x8a53b014
    QUALNAME = "types.MessageMediaToDo"

    def __init__(self, *, todo: "raw.base.TodoList", completions: Optional[List["raw.base.TodoCompletion"]] = None) -> None:
        self.todo = todo  # TodoList
        self.completions = completions  # flags.0?Vector<TodoCompletion>

    @staticmethod
    def read(b: BytesIO, *args: Any) -> "MessageMediaToDo":
        
        flags = Int.read(b)
        
        todo = TLObject.read(b)
        
        completions = TLObject.read(b) if flags & (1 << 0) else []
        
        return MessageMediaToDo(todo=todo, completions=completions)

    def write(self, *args) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        flags = 0
        flags |= (1 << 0) if self.completions else 0
        b.write(Int(flags))
        
        b.write(self.todo.write())
        
        if self.completions is not None:
            b.write(Vector(self.completions))
        
        return b.getvalue()
