#  Pyrogram - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of Pyrogram.
#
#  Pyrogram is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Pyrogram is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.raw.core.primitives import Int, Long, Int128, Int256, Bool, Bytes, String, Double, Vector
from pyrogram.raw.core import TLObject
from pyrogram import raw
from typing import List, Optional, Any

# # # # # # # # # # # # # # # # # # # # # # # #
#               !!! WARNING !!!               #
#          This is a generated file!          #
# All changes made in this file will be lost! #
# # # # # # # # # # # # # # # # # # # # # # # #


class GetResaleStarGifts(TLObject):  # type: ignore
    """Get collectible gifts of a specific type currently on resale, see here » for more info.


    Details:
        - Layer: ``216``
        - ID: ``7A5FA236``

    Parameters:
        gift_id (``int`` ``64-bit``):
            Mandatory identifier of the base gift from which the collectible gift was upgraded.

        offset (``str``):
            Offset for pagination. If not equal to an empty string, payments.resaleStarGifts.counters will not be set to avoid returning the counters every time a new page is fetched.

        limit (``int`` ``32-bit``):
            Maximum number of results to return, see pagination

        sort_by_price (``bool``, *optional*):
            Sort gifts by price (ascending).

        sort_by_num (``bool``, *optional*):
            Sort gifts by number (ascending).

        attributes_hash (``int`` ``64-bit``, *optional*):
            If a previous call to the method was made and payments.resaleStarGifts.attributes_hash was set, pass it here to avoid returning any results if they haven't changed. Otherwise, set this flag and pass 0 to return payments.resaleStarGifts.attributes_hash and payments.resaleStarGifts.attributes, these two fields will not be set if this flag is not set.

        attributes (List of :obj:`StarGiftAttributeId <pyrogram.raw.base.StarGiftAttributeId>`, *optional*):
            Optionally filter gifts with the specified attributes. If no attributes of a specific type are specified, all attributes of that type are allowed.

    Returns:
        :obj:`payments.ResaleStarGifts <pyrogram.raw.base.payments.ResaleStarGifts>`
    """

    __slots__: List[str] = ["gift_id", "offset", "limit", "sort_by_price", "sort_by_num", "attributes_hash", "attributes"]

    ID = 0x7a5fa236
    QUALNAME = "functions.payments.GetResaleStarGifts"

    def __init__(self, *, gift_id: int, offset: str, limit: int, sort_by_price: Optional[bool] = None, sort_by_num: Optional[bool] = None, attributes_hash: Optional[int] = None, attributes: Optional[List["raw.base.StarGiftAttributeId"]] = None) -> None:
        self.gift_id = gift_id  # long
        self.offset = offset  # string
        self.limit = limit  # int
        self.sort_by_price = sort_by_price  # flags.1?true
        self.sort_by_num = sort_by_num  # flags.2?true
        self.attributes_hash = attributes_hash  # flags.0?long
        self.attributes = attributes  # flags.3?Vector<StarGiftAttributeId>

    @staticmethod
    def read(b: BytesIO, *args: Any) -> "GetResaleStarGifts":
        
        flags = Int.read(b)
        
        sort_by_price = True if flags & (1 << 1) else False
        sort_by_num = True if flags & (1 << 2) else False
        attributes_hash = Long.read(b) if flags & (1 << 0) else None
        gift_id = Long.read(b)
        
        attributes = TLObject.read(b) if flags & (1 << 3) else []
        
        offset = String.read(b)
        
        limit = Int.read(b)
        
        return GetResaleStarGifts(gift_id=gift_id, offset=offset, limit=limit, sort_by_price=sort_by_price, sort_by_num=sort_by_num, attributes_hash=attributes_hash, attributes=attributes)

    def write(self, *args) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        flags = 0
        flags |= (1 << 1) if self.sort_by_price else 0
        flags |= (1 << 2) if self.sort_by_num else 0
        flags |= (1 << 0) if self.attributes_hash is not None else 0
        flags |= (1 << 3) if self.attributes else 0
        b.write(Int(flags))
        
        if self.attributes_hash is not None:
            b.write(Long(self.attributes_hash))
        
        b.write(Long(self.gift_id))
        
        if self.attributes is not None:
            b.write(Vector(self.attributes))
        
        b.write(String(self.offset))
        
        b.write(Int(self.limit))
        
        return b.getvalue()
