#  Pyrogram - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of Pyrogram.
#
#  Pyrogram is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Pyrogram is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.raw.core.primitives import Int, Long, Int128, Int256, Bool, Bytes, String, Double, Vector
from pyrogram.raw.core import TLObject
from pyrogram import raw
from typing import List, Optional, Any

# # # # # # # # # # # # # # # # # # # # # # # #
#               !!! WARNING !!!               #
#          This is a generated file!          #
# All changes made in this file will be lost! #
# # # # # # # # # # # # # # # # # # # # # # # #


class SetMainProfileTab(TLObject):  # type: ignore
    """Changes the main profile tab of a channel, see here » for more info.


    Details:
        - Layer: ``216``
        - ID: ``3583FCB1``

    Parameters:
        channel (:obj:`InputChannel <pyrogram.raw.base.InputChannel>`):
            The channel.

        tab (:obj:`ProfileTab <pyrogram.raw.base.ProfileTab>`):
            The tab to set as main tab.

    Returns:
        ``bool``
    """

    __slots__: List[str] = ["channel", "tab"]

    ID = 0x3583fcb1
    QUALNAME = "functions.channels.SetMainProfileTab"

    def __init__(self, *, channel: "raw.base.InputChannel", tab: "raw.base.ProfileTab") -> None:
        self.channel = channel  # InputChannel
        self.tab = tab  # ProfileTab

    @staticmethod
    def read(b: BytesIO, *args: Any) -> "SetMainProfileTab":
        # No flags
        
        channel = TLObject.read(b)
        
        tab = TLObject.read(b)
        
        return SetMainProfileTab(channel=channel, tab=tab)

    def write(self, *args) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(self.channel.write())
        
        b.write(self.tab.write())
        
        return b.getvalue()
