#  Pyrogram - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of Pyrogram.
#
#  Pyrogram is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Pyrogram is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.raw.core.primitives import Int, Long, Int128, Int256, Bool, Bytes, String, Double, Vector
from pyrogram.raw.core import TLObject
from pyrogram import raw
from typing import List, Optional, Any

# # # # # # # # # # # # # # # # # # # # # # # #
#               !!! WARNING !!!               #
#          This is a generated file!          #
# All changes made in this file will be lost! #
# # # # # # # # # # # # # # # # # # # # # # # #


class MessageActionSuggestedPostSuccess(TLObject):  # type: ignore
    """A suggested post » was successfully posted, and payment for it was successfully received.

    Constructor of :obj:`~pyrogram.raw.base.MessageAction`.

    Details:
        - Layer: ``216``
        - ID: ``95DDCF69``

    Parameters:
        price (:obj:`StarsAmount <pyrogram.raw.base.StarsAmount>`):
            The price.

    """

    __slots__: List[str] = ["price"]

    ID = 0x95ddcf69
    QUALNAME = "types.MessageActionSuggestedPostSuccess"

    def __init__(self, *, price: "raw.base.StarsAmount") -> None:
        self.price = price  # StarsAmount

    @staticmethod
    def read(b: BytesIO, *args: Any) -> "MessageActionSuggestedPostSuccess":
        # No flags
        
        price = TLObject.read(b)
        
        return MessageActionSuggestedPostSuccess(price=price)

    def write(self, *args) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(self.price.write())
        
        return b.getvalue()
