# PyScript Language📖

<p align="center">
    <img src="PyScript.png" alt="PyScript Logo" width="200">
</p>

PyScript adalah bahasa pemprograman sederhana yang dibuat di atas bahasa Python. Bahasa ini mengabungkan beberapa sintaks dari Python dan JavaScript, jadi bagi Anda yang sudah familiar dengan sintaks Python atau JavaScript atau keduanya pasti seharusnya cukup mudah mempelajari bahasa ini.

## Bagaimana Cara Pemasangannya?
1. Pertama-tama Anda perlu mengunduh Python terlebih dahulu. Usahakan versi yang digunakan sudah paling terbaru di atas versi `3.5` agar kode bisa di jalankan dengan benar. Kunjungi [website resmi Python](https://python.org) untuk mengunduhnya.
2. Setelah mengunduh dan melakukan beberapa konfigurasi aplikasi Python, unduh repositori ini atau melalui direktori `pyscript` atau dengan perintah `python -m pip install pyscript-programming-language` (_Direkomendasikan_).
3. Sekarang coba Anda jalankan PyScript shell (REPL) dengan perintah `python -m pyscript`. Jika berhasil maka harusnya anda akan melihat versi, tanggal dan tanda `>>>`.
4. _OPSIONAL_. Anda bisa mengunduh dan menyiapkan kode editor seperti VS Code atau kode editor lainnya untuk menulis program. Atau kalau mau yang berbeda Anda bisa menggunakan Notepad.
5. Jika semua sudah aman dan berjalan dengan benar, sekarang Anda sudah bisa masuk ke sesi pengenalan bahasa PyScript!

## Pengenalan PyScript
Mungkin PyScript dikenal bukanlah bahasa yang akan kita bahas, tetapi sebenarnya nama PyScript sendiri sudah ada yang merupakan platform untuk menjalankan Python dalam browser yang fleksibel dan mudah. Sebelumnya sejak awal bahasa ini dibuat, nama ini dipilih karena memang terinspirasi dengan bahasa Python dan JavaScript yang bahasanya cukup mudah untuk di baca manusia. Dengan itulah nama itu dipilih, karena memang belum diketahui secara langsung apakah nama ini sudah dipakai atau belum. 

Bahasa ini tidak di rancang untuk masuk sebagai bahasa pemprograman modern yang bersaing dengan bahasa lain, tetapi bahasa ini sebagai metode pembelajaran soal bagaimana bahasa pemprograman bekerja dan cara sebuah kode yang manusia tulis bisa di mengerti oleh mesin. Selain daripada itu, bahasa ini dibuat sebagai projek yang cukup kompleks. Dengan bahasa Python sebagai dasar pembuatan bahasa PyScript dengan sintaksnya yang cukup mudah dipahami membuatnya bisa menjadi mudah di mengerti soal bagaimana bahasa itu dibuat tanpa memahami tentang instruksi lain yang kompleks seperti di C, C++, dan bahasa tingkat rendah lain.

## Memulai Koding!
Anda sudah mengetahui cara menjalankan PyScript serta tujuan bahasa ini dibuat. Sekarang Anda masuk ke sesi koding untuk membuat kode di PyScript. Untuk memulai Anda perlu membuat sebuah file, buatlah file bernama `belajar.pys` dan kemudian buka kode editor Anda. Kini kita akan membuat kode program _Hello World_ lalu menampilkannya di layar atau terminal. Caranya cukup sederhana, seperti Python cukup tulis kode seperti ini:
<pre class="pyscript-code"><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="string">&quot;Hello World!&quot;</span><span id="parenthesis-0">)</span></pre>

Kemudian jangan lupa Anda simpan hasilnya lalu jalankan kodenya dengan perintah:
```sh
python -m pyscript belajar.pys
```
> Catatan: `python` disini memanggil interpreter Python untuk menjalankan file `__main__.py` dari dalam folder `pyscript`, kemudian file `__main__.py` menerima argumen `belajar.pys` sebagai path file yang lalu di jalankan interpreter PyScript. Perlu di ingat ini akan bekerja jika direktori PyScript berada di direktori yang sama dengan direktori kerja.

Maka hasilnya di terminal Anda adalah:
```
Hello World!
```

Ini bukan dijalankan oleh Python dengan fungsi `exec` atau `eval`, ini murni dari bahasa PyScript! Sekarang Anda masuk ke sesi Pengenalan Sintaks!

## Pengenalan Bahasa
Di sesi ini, Anda akan mempelajari semua aspek bahasa dalam bahasa PyScript yang ada.

### Komentar
Pertama-tama Anda akan mempelajari tentang komentar, komentar adalah cara kita memberikan penjelasan tertentu pada blok kita agar jika suatu nanti atau orang lain bisa mengetahui maksud kode yang Anda tulis. Komentar di PyScript mirip dengan Python dimana ia dikuti dengan pagar `#` lalu setelah itu Anda bisa memberikan komentar. Komentar tidak diesekusi oleh program.
<pre class="pyscript-code"><span id="comment"># Ini adalah komentar</span><br><br><span id="comment"># Ini mencetak kata &quot;Halo!&quot; ke layar</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="string">&quot;Halo!&quot;</span><span id="parenthesis-0">)</span><br><br><span id="number">1</span><span id="default"> + </span><span id="number">1</span><span id="default"> </span><span id="comment"># Ekspresi</span></pre>

### Variabel
Variabel secara singkat yakni menyimpan suatu nilai. Pasti harusnya Anda sudah tidak asing dengan variabel. Variabel di buat sebagai berikut ini:
<pre class="pyscript-code"><span id="identifier">x</span><span id="default"> = </span><span id="number">1</span><br><span id="identifier">y</span><span id="default"> = </span><span id="number">1</span><br><span id="identifier">z</span><span id="default"> = </span><span id="number">1</span></pre>

Di bahasa Python pun juga sama, kita membuat suatu nama lalu di lanjutkan tanda sama dengan lalu nilai yang mau kita isi.

Untuk membuat variabel ada aturan penamaannya, ia tidak boleh dipisah dengan spasi atau `-`. Ia harus berupa karakter huruf, angka (bukan di awal), dan underscore `_`.

Anda juga bisa sekaligus menyimpan lebih dari 1 variabel dengan hanya 1 nilai sekaligus seperti ini:
<pre class="pyscript-code"><span id="identifier">data</span><span id="default"> = </span><span id="identifier">daftar</span><span id="default"> = </span><span id="identifier">array</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="number">3</span><span id="default">, </span><span id="number">4</span><span id="default">, </span><span id="number">5</span><span id="parenthesis-0">]</span></pre>

### Objek dan Tipe Data
Di PyScript sebenarnya objek dan tipe data di atur oleh Python. Jadi semua objek serta sifat-sifat dan fungsi-fungsinya semuanya di atur dari Python. Berikut ini beberapa objek literal dari Python/PyScript:
<pre class="pyscript-code"><span id="identifier">a</span><span id="default"> = </span><span id="number">1</span><span id="default">        </span><span id="comment"># int</span><br><span id="identifier">b</span><span id="default"> = </span><span id="number">1.0</span><span id="default">      </span><span id="comment"># float</span><br><span id="identifier">c</span><span id="default"> = </span><span id="number">1j</span><span id="default">       </span><span id="comment"># complex</span><br><span id="identifier">d</span><span id="default"> = </span><span id="number">1</span><span id="default">+</span><span id="number">1j</span><span id="default">     </span><span id="comment"># ini juga complex</span><br><span id="identifier">e</span><span id="default"> = </span><span id="string">&#x27;string&#x27;</span><span id="default"> </span><span id="comment"># ini str</span><br><span id="identifier">f</span><span id="default"> = </span><span id="string">&quot;string&quot;</span><span id="default"> </span><span id="comment"># ini juga str (beda kutipan saja)</span><br><span id="identifier">g</span><span id="default"> = </span><span id="string">r&#x27;raw&#x27;</span><span id="default">   </span><span id="comment"># ini raw str (string mentah tidak memproses escape)</span><br><span id="identifier">h</span><span id="default"> = </span><span id="string">b&#x27;bytes&#x27;</span><span id="default"> </span><span id="comment"># ini bytes</span><br><span id="identifier">i</span><span id="default"> = </span><span id="keyword-identifier">True</span><span id="default">     </span><span id="comment"># ini bool</span><br><span id="identifier">j</span><span id="default"> = </span><span id="keyword-identifier">False</span><span id="default">    </span><span id="comment"># ini juga bool (lawannya)</span><br><span id="identifier">k</span><span id="default"> = </span><span id="keyword-identifier">None</span><span id="default">     </span><span id="comment"># ini NoneType (tidak ada nilai)</span><br><span id="identifier">l</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-0">]</span><span id="default">   </span><span id="comment"># ini list</span><br><span id="identifier">m</span><span id="default"> = </span><span id="parenthesis-0">(</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-0">)</span><span id="default">   </span><span id="comment"># ini tuple</span><br><span id="identifier">n</span><span id="default"> = </span><span id="parenthesis-0">{</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-0">}</span><span id="default">   </span><span id="comment"># ini set (himpunan)</span><br><span id="identifier">o</span><span id="default"> = </span><span id="parenthesis-0">{</span><span id="string">&#x27;a&#x27;</span><span id="default">: </span><span id="number">1</span><span id="parenthesis-0">}</span><span id="default"> </span><span id="comment"># ini dict (dictionary atau kamus)</span></pre>

Sebenarnya masih banyak pembahasan soal tipe data dan objek ini, Anda bisa mempelajarinya lebih dalam dari Python. Mungkin beberapa hal yang perlu Anda ketahui bahwa tidak semua literal Python bisa di tulis secara langsung di PyScript. Misalnya f-string atau formated string, untuk menulis literalnya di Python anda cukup beri prefix di string `f` seperti ini:
```py
data = f'Hello'
```
Sayangnya, ini tidak valid di PyScript dan bisa error!

Untuk menggantikannya, Anda bisa menggunakan berbagai cara, salah satunya menggunakan metode `str` di Python berupa `format`, dengan modulus `%`, atau lainnya.

Tapi ada juga beberapa literal unik yang masih bisa anda tulis seperti objek int dengan 0x, 0b, dan lainnya. Misalnya:
<pre class="pyscript-code"><span id="number">1j</span><span id="default">                 </span><span id="comment"># kompleks</span><br><span id="number">0xffff</span><span id="default">             </span><span id="comment"># hex</span><br><span id="number">0b0101</span><span id="default">             </span><span id="comment"># bit</span><br><span id="number">0o777</span><span id="default">              </span><span id="comment"># oktal</span><br><span id="number">11_000_000_000_000</span><span id="default"> </span><span id="comment"># underscore</span><br><span id="number">1e10</span><span id="default">               </span><span id="comment"># notasi ilmiah</span><br><span id="number">2e2j</span><span id="default">               </span><span id="comment"># notasi ilmiah + kompleks</span><br><br><span id="comment"># ini tidak valid di Python, tapi di PyScript ini valid</span><br><span id="number">0xffj</span><br><span id="number">0o1111j</span><br><br><span id="comment"># literal kutip 3 string</span><br><span id="string">&#x27;&#x27;&#x27;<br>Hallo ini adalah string!<br>Ini adalah baris baru!<br>&#x27;&#x27;&#x27;</span><br><br><span id="string">&quot;&quot;&quot;<br>Ini juga kutip 3 string!<br>&quot;&quot;&quot;</span></pre>

### Fungsi dan Variabel Bawaan
Fungsi dan variabel bawaan atau disebut _builtins_ adalah fungsi yang bisa Anda pakai dalam keperluan tertentu sehingga Anda tidak perlu membuat fungsi dasar secara manual. Cukup memahami cara pemakaiannya.

Bagaimana sih cara memanggil fungsi? Caranya cukup mudah! Anda cukup tulis nama fungsi apa yang anda mau panggil, lalu kemudian jangan lupa selanjutnya beri tanda kurung `(` dan juga jangan lupa tutup kembali dengan tutup kurung `)`. Didalam kurung, Anda bisa memasukan beberapa parameter di dalamnya. Jika tadi Anda lihat cara memprogram _Hello World_ Anda akan menyadari bahwa itu pasti adalah fungsi dari penjelasan ini.
<pre class="pyscript-code"><span id="identifier-call">print</span><span id="parenthesis-0">()</span><span id="default">                      </span><span id="comment"># ini fungsi tanpa parameter</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="string">&quot;Cetak!&quot;</span><span id="parenthesis-0">)</span><span id="default">              </span><span id="comment"># ini fungsi dengan parameter</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="string">&quot;Hello&quot;</span><span id="default">, </span><span id="string">&quot;World!&quot;</span><span id="parenthesis-0">)</span><span id="default">     </span><span id="comment"># ini fungsi dengan beberapa parameter</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="string">&quot;Fufu&quot;</span><span id="default">, </span><span id="identifier">end</span><span id="default">=</span><span id="string">&quot;Fafa!\n&quot;</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># ini fungsi dengan parameter serta kata kunci argumen</span></pre>

Anda bisa memanggil fungsi tanpa parameter apapun, asalkan fungsi secara langsung tidak butuh parameter atau bisa menerima tidak ada parameter.

Lanjut ke beberapa fungsi dan variabel bawaan atau _builtins_. Semua ini juga berasal dari Python. Untuk mempelajari builtins Python selengkapnya bisa cek di [website resmi _builtins_ Python](https://docs.python.org/3/library/builtins.html?utm_source=chatgpt.com) (pengecualian _builtins_ berupa `compile`, `copyright`, `credits`, `dir`, `eval`, `exec`, `globals`, `license`, `locals`, dan `vars`).

Ada beberapa pengecualian di atas sebenarnya cuma di ganti agar sinkron dengan bahasa PyScript dan tidak terhubung ke Python seperti `dir`, `eval`, `exec`, `globals`, `license`, `locals`, dan `vars`. Berikut ini fungsi dan pemakaiannya masing-masing:

- `dir` (_`dir()`_, _`dir(o)`_) <br>
Fungsi ini sama saja seperti cara kerja `dir` yang ada dalam Python. Perbedaanya ketika parameter `o` tidak diberikan alias di panggil dengan tidak ada parameter, maka akan mengambalikan nilai _namespace_ program saat ini. Berikut contoh penggunaannya:
<pre class="pyscript-code"><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier-call">dir</span><span id="parenthesis-1">()</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># akan menghasilkan nilai namespace program</span></pre>

- `eval` (_`eval(source, globals=None)`_) <br>
Fungsi ini meevaluasi ekspresi PyScript dari source yang diberikan. Source bisa diisi dengan `str`, `bytes`, `bytearray`, dan `IObase` (bisa dibaca). Fungsi ini akan mengembalikan nilai hasil evaluasi tersebut. Parameter `globals` adalah _namespace_ berupa objek `dict` yang bisa di muat dan disimpan di dalam kode. Jika parameter ini tidak diberikan atau nilainya `None` maka menggunakan _namespace_ program saat ini. Berikut contoh penggunannya:
<pre class="pyscript-code"><span id="identifier">result</span><span id="default"> = </span><span id="identifier-call">eval</span><span id="parenthesis-0">(</span><span id="string">&quot;1 + 4 * 2&quot;</span><span id="parenthesis-0">)</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">result</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># 9</span></pre>

- `exec` (_`exec(source, globals=None)`_) <br>
Fungsi ini cukup mirip dengan `eval` bedanya ia meeksekusi keseluruhan kode termasuk statemen dan ekspresi yang ada dan fungsi ini tidak mengembalikan nilai apapun. Berikut contoh penggunaannya:
<pre class="pyscript-code"><span id="identifier-call">exec</span><span id="parenthesis-0">(</span><span id="string">&quot;print(&#x27;Hello!&#x27;)\na = 2&quot;</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># Hello!</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># 2</span></pre>

- `globals` (_`globals()`_)
Fungsi ini meakses semua nilai _namespace_ yang bisa di akses (tidak terpaku pada _namespace_ modul) dan akan mengembalikan dalam bentuk objek `dict` baru atau refrensi langsung (hanya jika di panggil di _namespace_ modul bukan di dalam fungsi). Berikut ini adalah contoh penggunaannya:
<pre class="pyscript-code"><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier-call">globals</span><span id="parenthesis-1">()</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># semua identifier modul. globals() sama dengan locals()</span><br><br><span id="identifier">x</span><span id="default"> = </span><span id="number">1</span><br><br><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">hello</span><span id="parenthesis-0">()</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier">y</span><span id="default"> = </span><span id="number">1</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="identifier-call">globals</span><span id="parenthesis-2">()</span><span id="parenthesis-1">)</span><span id="default"> </span><span id="comment"># semua identifier di namespace ini yang bisa di akses</span><br><br><span id="default">    </span><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">inner</span><span id="parenthesis-1">()</span><span id="default"> </span><span id="parenthesis-1">{</span><br><span id="default">        </span><span id="identifier">z</span><span id="default"> = </span><span id="number">1</span><br><span id="default">        </span><span id="identifier-call">print</span><span id="parenthesis-2">(</span><span id="identifier-call">globals</span><span id="parenthesis-0">()</span><span id="parenthesis-2">)</span><br><span id="default">    </span><span id="parenthesis-1">}</span><br><br><span id="default">    </span><span id="identifier-call">inner</span><span id="parenthesis-1">()</span><br><span id="parenthesis-0">}</span><br><br><span id="identifier-call">hello</span><span id="parenthesis-0">()</span></pre>

- `license` (_`license()`_) <br>
Fungsi ini adalah berupa lisensi PyScript.

- `locals` (_`locals()`_) <br>
Fungsi ini cukup mirip dengan fungsi `globals` barusan, tetapi ini lingkupannya cuma di area lokal saja, dan _namespace_ bisa di muat disini. Berikut contoh penggunaannya:
<pre class="pyscript-code"><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier-call">locals</span><span id="parenthesis-1">()</span><span id="parenthesis-0">)</span><span id="default">              </span><span id="comment"># namespace modul</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier-call">globals</span><span id="parenthesis-1">()</span><span id="default"> </span><span id="keyword-identifier">is</span><span id="default"> </span><span id="identifier-call">locals</span><span id="parenthesis-1">()</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># benar</span><br><br><span id="identifier-call">locals</span><span id="parenthesis-0">()[</span><span id="string">&#x27;a&#x27;</span><span id="parenthesis-0">]</span><span id="default"> = </span><span id="number">1</span><span id="default"> </span><span id="comment"># buat variabel &#x27;a&#x27; dengan nilai 1</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="parenthesis-0">)</span><span id="default">          </span><span id="comment"># 1</span></pre>

- `vars` (_`vars(object=None)`_) <br>
Fungsi ini sama saja dengan fungsi _builtins_ `vars` di Python. Perbedaanya ketika parameter `object` berisi nilai `None` atau tidak diberi parameter apapun maka akan mengembalikan _namespace_ program saat ini yang sama saja dengan fungsi `locals`.

Ada penambahan fungsi bawaan yang ada dalam bahasa PyScript, di antara lain sebagai berikut:

- `pyimport` (_`pyimport(name)`_) <br>
Fungsi ini untuk meimpor modul atau file Python. Berasal dari `importlib.import_module`.

- `require` (_`require(name)`_) <br>
Fungsi ini cara kerjanya sama seperti fungsi `pyimport`, perbedaannya untuk meimpor modul atau file PyScript.

- `ce` (_`ce(a, b, *, rel_tol=1e-9, abs_tol=0)`_) <br>
Fungsi ini adalah singkatan dari _close equal_ yang artinya membandingkan nilai berupa hampir sama dengan. Berguna untuk metolerir perbedaan jauh antara kedua nilai.

- `nce` (_`nce(a, b, *, rel_tol=1e-9, abs_tol=0)`_) <br>
Fungsi ini adalah singkatan dari _not close equal_ dan sama saja konsepnya dengan fungsi `ce` tetapi ini berupa tidak hampir sama dengan.

- `increment` (_`increment(object)`_) <br>
Fungsi ini menambahkan satu nilai dari objek yang diberikan.

- `decrement` (_`decrement(object)`_) <br>
Fungsi ini mengurangkan satu nilai dari objek yang diberikan.

- `comprehension` (_`comprehension(init, wrap, condition=None)`_) <br>
Fungsi ini menggantikan sintaks Python yang ini:
```py
[wrap(i) for i in init if condition(i)]
```
Parameter `wrap` adalah berupa fungsi untuk menghasilkan nilai baru, parameter `condition` adalah berupa fungsi untuk memfilter nilai.

- `isobjectof` (_`isobjectof(obj, class_or_tuple)`_) <br>
Fungsi ini mirip dengan fungsi _builtins_ Python `isinstance`, tetapi ini juga termasuk mengecek parameter `obj` adakah objek itu turunan dari `class_or_tuple` yang diberikan jika `obj` adalah berupa `type`.

### _Unpacking Variable_
Anda sudah mempelajari cara membuat variabel, sekarang Anda masuk ke unpacking variabel. Intinya ini adalah cara kita membuat banyak variabel sekaligus dalam 1 baris kode agar kode mudah diperlihara dan mudah dimonesasi. Berikut ini adalah contoh dari unpacking variabel.
<pre class="pyscript-code"><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">)</span><span id="default"> = </span><span id="parenthesis-0">(</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-0">)</span></pre>

Untuk membuat unpacking variabel, anda perlu memberikan tanda kurung `()`, `[]`, atau `{}` kemudian diisi beberapa nama variabel. Nilai juga harus sesuai yakni berupa urutan dan keduanya harus memiliki panjang yang sama.
<pre class="pyscript-code"><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">)</span><span id="default"> = </span><span id="parenthesis-0">(</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># valid</span><br><span id="parenthesis-0">[</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">]</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-0">]</span><span id="default"> </span><span id="comment"># valid</span><br><span id="parenthesis-0">{</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">}</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-0">]</span><span id="default"> </span><span id="comment"># valid</span><br><br><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="default">, </span><span id="identifier">c</span><span id="parenthesis-0">)</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-0">]</span><span id="default">    </span><span id="comment"># tidak valid karena yang di unpack 3 tapi nilainya cuma menyimpan 2</span><br><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">)</span><span id="default"> = </span><span id="parenthesis-0">(</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="number">3</span><span id="default">, </span><span id="number">4</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># tidak valid karena yang di unpack 2 tapi nilainya 4</span><br><br><span id="comment"># tidak valid keduanya harus di berikan tanda kurung</span><br><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-0">]</span><br><span id="parenthesis-0">{</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">}</span><span id="default"> = </span><span id="number">1</span><span id="default">, </span><span id="number">2</span><br><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="default"> = </span><span id="number">1</span><span id="default">, </span><span id="number">2</span></pre>

Nilai yang akan di unpack bisa cukup kompleks (beranak) seperti ini:
<pre class="pyscript-code"><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="default">, </span><span id="parenthesis-1">[</span><span id="identifier">c</span><span id="default">, </span><span id="identifier">d</span><span id="default">, </span><span id="parenthesis-2">{</span><span id="identifier">e</span><span id="default">, </span><span id="identifier">f</span><span id="parenthesis-2">}</span><span id="parenthesis-1">]</span><span id="default">, </span><span id="identifier">g</span><span id="parenthesis-0">)</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="parenthesis-1">[</span><span id="number">3</span><span id="default">, </span><span id="number">4</span><span id="default">, </span><span id="parenthesis-2">[</span><span id="number">5</span><span id="default">, </span><span id="number">6</span><span id="parenthesis-2">]</span><span id="parenthesis-1">]</span><span id="default">, </span><span id="number">7</span><span id="parenthesis-0">]</span></pre>

Dengan pemahaman ini Anda bisa juga menukar 2 variabel seperti ini:
<pre class="pyscript-code"><span id="identifier">a</span><span id="default"> = </span><span id="number">1</span><br><span id="identifier">b</span><span id="default"> = </span><span id="number">2</span><br><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># 1 2</span><br><br><span id="comment"># menukar nilai</span><br><span id="parenthesis-0">[</span><span id="identifier">b</span><span id="default">, </span><span id="identifier">a</span><span id="parenthesis-0">]</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">]</span><br><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># 2 1</span></pre>

### Operasi
Dalam matematika ada berbagai macam operasi seperti penjumlahan `+`, pengurangan `-`, dan lain sebagainya. Berikut ini adalah beberapa operasi aritmatika:
<pre class="pyscript-code"><span id="number">1</span><span id="default"> + </span><span id="number">1</span><span id="default">  </span><span id="comment"># penjumlahan</span><br><span id="number">1</span><span id="default"> - </span><span id="number">1</span><span id="default">  </span><span id="comment"># pengurangan</span><br><span id="number">1</span><span id="default"> * </span><span id="number">1</span><span id="default">  </span><span id="comment"># perkalian</span><br><span id="number">1</span><span id="default"> / </span><span id="number">1</span><span id="default">  </span><span id="comment"># pembagian</span><br><span id="number">1</span><span id="default"> // </span><span id="number">1</span><span id="default"> </span><span id="comment"># pembagian bulat</span><br><span id="number">1</span><span id="default"> % </span><span id="number">1</span><span id="default">  </span><span id="comment"># pembagian sisa (modulus)</span><br><span id="number">1</span><span id="default"> ** </span><span id="number">1</span><span id="default"> </span><span id="comment"># perpangkatan</span></pre>

Lalu ada operasi _matmul_ `@`, ini cuma bekerja pada objek atau tipe data yang mendukungnya seperti array pada modul terkenal di Python yakni `numpy`:
<pre class="pyscript-code"><span id="keyword">import</span><span id="default"> </span><span id="identifier">numpy</span><br><br><span id="identifier">numpy</span><span id="default">.</span><span id="identifier-call">array</span><span id="parenthesis-0">(</span><span id="parenthesis-1">[</span><span id="number">2</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-1">]</span><span id="parenthesis-0">)</span><span id="default"> @ </span><span id="identifier">numpy</span><span id="default">.</span><span id="identifier-call">array</span><span id="parenthesis-0">(</span><span id="parenthesis-1">[</span><span id="number">2</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-1">]</span><span id="parenthesis-0">)</span></pre>

Selanjutnya, ada operasi bitwise yang bekerja dalam implementasi kode biner (0 dan 1). Berikut ini adalah operasi-operasi tersebut:
<pre class="pyscript-code"><span id="number">1</span><span id="default"> &amp; </span><span id="number">1</span><span id="default">  </span><span id="comment"># and</span><br><span id="number">1</span><span id="default"> | </span><span id="number">1</span><span id="default">  </span><span id="comment"># or</span><br><span id="number">1</span><span id="default"> ^ </span><span id="number">1</span><span id="default">  </span><span id="comment"># xor</span><br><span id="number">1</span><span id="default"> &lt;&lt; </span><span id="number">1</span><span id="default"> </span><span id="comment"># lshift</span><br><span id="number">1</span><span id="default"> &gt;&gt; </span><span id="number">1</span><span id="default"> </span><span id="comment"># rshift</span><br><span id="default">~</span><span id="number">1</span><span id="default">     </span><span id="comment"># not</span></pre>

Kemudian, ada operasi perbandingan. Berikut ini adalah beberapa operasinya:
<pre class="pyscript-code"><span id="number">1</span><span id="default"> == </span><span id="number">1</span><span id="default"> </span><span id="comment"># sama dengan</span><br><span id="number">1</span><span id="default"> != </span><span id="number">1</span><span id="default"> </span><span id="comment"># tidak sama dengan</span><br><span id="number">1</span><span id="default"> ~= </span><span id="number">1</span><span id="default"> </span><span id="comment"># hampir sama dengan</span><br><span id="number">1</span><span id="default"> ~! </span><span id="number">1</span><span id="default"> </span><span id="comment"># tidak hampir sama dengan</span><br><span id="number">1</span><span id="default"> &lt; </span><span id="number">1</span><span id="default">  </span><span id="comment"># lebih kecil</span><br><span id="number">1</span><span id="default"> &gt; </span><span id="number">1</span><span id="default">  </span><span id="comment"># lebih besar</span><br><span id="number">1</span><span id="default"> &lt;= </span><span id="number">1</span><span id="default"> </span><span id="comment"># lebih kecil sama dengan</span><br><span id="number">1</span><span id="default"> &gt;= </span><span id="number">1</span><span id="default"> </span><span id="comment"># lebih besar sama dengan</span></pre>

Berikutnya juga operasi logika:
<pre class="pyscript-code"><span id="keyword-identifier">True</span><span id="default"> </span><span id="keyword-identifier">and</span><span id="default"> </span><span id="keyword-identifier">True</span><span id="default"> </span><span id="comment"># dan</span><br><span id="keyword-identifier">False</span><span id="default"> </span><span id="keyword-identifier">or</span><span id="default"> </span><span id="keyword-identifier">True</span><span id="default"> </span><span id="comment"># atau</span><br><span id="keyword-identifier">not</span><span id="default"> </span><span id="keyword-identifier">False</span><span id="default">     </span><span id="comment"># bukan</span></pre>

Ada juga operasi ke anggotaan:
<pre class="pyscript-code"><span id="number">1</span><span id="default"> </span><span id="keyword-identifier">in</span><span id="default"> </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="number">3</span><span id="default">, </span><span id="number">4</span><span id="parenthesis-0">]</span><span id="default">     </span><span id="comment"># ada dalam elemen</span><br><span id="number">1</span><span id="default"> </span><span id="keyword-identifier">not</span><span id="default"> </span><span id="keyword-identifier">in</span><span id="default"> </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="number">3</span><span id="default">, </span><span id="number">4</span><span id="parenthesis-0">]</span><span id="default"> </span><span id="comment"># bukan dalam elemen</span><br><span id="number">1</span><span id="default"> </span><span id="keyword-identifier">is</span><span id="default"> </span><span id="number">1</span><span id="default">                </span><span id="comment"># refrensi yang sama</span><br><span id="number">1</span><span id="default"> </span><span id="keyword-identifier">is</span><span id="default"> </span><span id="keyword-identifier">not</span><span id="default"> </span><span id="number">1</span><span id="default">            </span><span id="comment"># bukan refrensi yang sama</span></pre>

Sisanya adalah operasi unik:
<pre class="pyscript-code"><span id="keyword-identifier">None</span><span id="default"> ?? </span><span id="number">0</span><span id="default">                </span><span id="comment"># operasi nullish (beda dengan or ia hanya peduli dengan nilai None)</span><br><span id="keyword-identifier">True</span><span id="default"> ? </span><span id="string">&quot;Benar&quot;</span><span id="default"> : </span><span id="string">&quot;Salah&quot;</span><span id="default"> </span><span id="comment"># operasi terner</span><br><br><span id="identifier">a</span><span id="default"> = </span><span id="number">0</span><br><br><span id="identifier">a</span><span id="default">++ </span><span id="comment"># operasi jumlahkan (menghasilkan nilai a sebelum di jumlahkan 1)</span><br><span id="default">++</span><span id="identifier">a</span><span id="default"> </span><span id="comment"># operasi jumlahkan (menghasilkan nilai a di tambahkan 1)</span><br><span id="identifier">a</span><span id="default">-- </span><span id="comment"># operasi kurangkan</span><br><span id="default">--</span><span id="identifier">a</span><span id="default"> </span><span id="comment"># operasi kurangkan</span></pre>

### Operasi Penugasan
Anda baru saja mempelajari cara menyimpan nilai ke sebuah variabel dan soal _unpacking variable_ itu semua adalah operasi penugasan. Operasi penugasan tidak berupa sama dengan `=`, tapi bisa operasi nilai seperti yang di sebutkan di atas berupa operasi-operasi, ini adalah cara sederhana memaksudkan arti `a = a <operasi> b` menjadi `a <operasi>= b`. Berikut ini contohnya:
<pre class="pyscript-code"><span id="identifier">a</span><span id="default"> = </span><span id="number">0</span><br><br><span id="identifier">a</span><span id="default"> += </span><span id="number">2</span><br><span id="identifier">a</span><span id="default"> -= </span><span id="number">1</span><br><span id="identifier">a</span><span id="default"> *= </span><span id="number">10</span><br><span id="identifier">a</span><span id="default"> /= </span><span id="number">2</span><br><span id="identifier">a</span><span id="default"> //= </span><span id="number">2</span><br><span id="identifier">a</span><span id="default"> %= </span><span id="number">3</span><br><span id="identifier">a</span><span id="default"> **= </span><span id="number">2</span><br><br><span id="identifier">b</span><span id="default"> = </span><span id="identifier">numpy</span><span id="default">.</span><span id="identifier-call">array</span><span id="parenthesis-0">(</span><span id="parenthesis-1">[</span><span id="number">2</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-1">]</span><span id="parenthesis-0">)</span><br><span id="identifier">b</span><span id="default"> @= </span><span id="identifier">numpy</span><span id="default">.</span><span id="identifier-call">array</span><span id="parenthesis-0">(</span><span id="parenthesis-1">[</span><span id="number">2</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-1">]</span><span id="parenthesis-0">)</span><br><br><span id="identifier">c</span><span id="default"> = </span><span id="number">8</span><br><span id="identifier">c</span><span id="default"> &amp;= </span><span id="number">8</span><br><span id="identifier">c</span><span id="default"> |= </span><span id="number">16</span><br><span id="identifier">c</span><span id="default"> ^= </span><span id="number">2</span><br><span id="identifier">c</span><span id="default"> &lt;&lt;= </span><span id="number">2</span><br><span id="identifier">c</span><span id="default"> &gt;&gt;= </span><span id="number">2</span></pre>

### Blok kode
Blok kode dalam PyScript mengikuti bahasa seperti JavaScript, C, C++, dan sesamanya yang dimana menggunakan tanda kurung keriting `{}` untuk menyertakan bagian blok kode. Kadang, jika blok kode hanya berupa 1 statemen maka Anda bisa langsung menulis statemen itu tanpa perlu menggunakan tanda kurung.
<pre class="pyscript-code"><span id="keyword">if</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="identifier">kondisi</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="comment"># blok kode</span><br><span id="parenthesis-0">}</span><br><br><span id="keyword">if</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="identifier">kondisi</span><span id="parenthesis-0">)</span><span id="default"> ... </span><span id="comment"># blok kode tunggal</span><br><br><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">fufu</span><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="keyword">if</span><span id="default"> </span><span id="parenthesis-1">(</span><span id="keyword-identifier">not</span><span id="default"> </span><span id="identifier">a</span><span id="parenthesis-1">)</span><span id="default"> </span><span id="keyword">return</span><span id="default">; </span><span id="comment"># statemen return seperti ini harus diberi</span><br><span id="default">                       </span><span id="comment"># titik koma sebagai akhir statemen agar</span><br><span id="default">                       </span><span id="comment"># tidak bocor ke statemen bawahnya</span><br><span id="default">    </span><span id="identifier">b</span><span id="default"> = </span><span id="identifier">a</span><br><span id="default">    </span><span id="keyword">return</span><span id="default"> </span><span id="identifier">a</span><br><span id="parenthesis-0">}</span><br><br><span id="comment"># kesalahan fatal (sulit diketahui karena apa)</span><br><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">fafa</span><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="keyword">if</span><span id="default"> </span><span id="parenthesis-1">(</span><span id="keyword-identifier">not</span><span id="default"> </span><span id="identifier">a</span><span id="parenthesis-1">)</span><span id="default"> </span><span id="keyword">return</span><span id="default"> </span><span id="comment"># tidak ada tanda koma</span><br><span id="default">    </span><span id="identifier">b</span><span id="default"> = </span><span id="identifier">a</span><span id="default">             </span><span id="comment"># parser mengiranya akan berupa return b</span><br><span id="default">                      </span><span id="comment"># bukan return, hasilnya terjadi kesalahan di &#x27;=&#x27;</span><br><span id="default">    </span><span id="keyword">return</span><span id="default"> </span><span id="identifier">a</span><br><span id="parenthesis-0">}</span><br><br><span id="identifier">loop</span><span id="default"> = </span><span id="number">100</span><br><span id="keyword">while</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="identifier">loop</span><span id="default">--</span><span id="parenthesis-0">)</span><span id="default">; </span><span id="comment"># tanpa ada blok kode sama sekali (tidak berlaku</span><br><span id="default">                </span><span id="comment"># untuk semuanya kadang suatu statemen perlu blok kode)</span><br><span id="default">                </span><span id="comment"># sekali lagi jangan lupakan titik koma!</span></pre>

### Statemen _if-elif-else_
Statemen ini berfungsi untuk mengecek suatu nilai kondisi dimana jika kondisi itu benar, maka blok kodenya akan dieksekusi. _elif_ atau singkatan dari _else if_ adalah lanjutan blok kondisi jika kondisi di atasnya tidak terpenuhi sampai jika semuanya tidak terpenuhi maka akan menuju blok _else_.
<pre class="pyscript-code"><span id="identifier">kondisi</span><span id="default"> = </span><span id="number">0</span><br><br><span id="keyword">if</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="identifier">kondisi</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;kondisi benar&quot;</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><br><span id="keyword">elif</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="identifier">kondisi</span><span id="default"> == </span><span id="number">1</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;kondisi adalah 1&quot;</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><br><span id="keyword">else</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;kondisi tidak memenuhi kriteria di atas&quot;</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span></pre>

### Statemen _for_
Statemen ini adalah statemen perulangan dimana biasanya perulangannya sudah di ketahui berapa kali.
<pre class="pyscript-code"><span id="comment"># perulangan 0 sampai 4 (totalnya 5 perulangan)</span><br><span id="keyword">for</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="identifier">i</span><span id="default"> = </span><span id="number">0</span><span id="default">; </span><span id="identifier">i</span><span id="default"> &lt; </span><span id="number">5</span><span id="default">; </span><span id="identifier">i</span><span id="default">++</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;i ke&quot;</span><span id="default">, </span><span id="identifier">i</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><br><br><span id="comment"># strukturnya:</span><br><span id="comment"># for (&lt;initilisasi&gt;; &lt;kondisi&gt;; &lt;pembaruan&gt;) &lt;blok perulangannnya&gt;</span><br><br><span id="comment"># for-each (perulangan tiap elemen)</span><br><span id="identifier">element</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="number">3</span><span id="default">, </span><span id="number">4</span><span id="default">, </span><span id="number">5</span><span id="parenthesis-0">]</span><br><span id="keyword">for</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="identifier">i</span><span id="default"> </span><span id="keyword-identifier">of</span><span id="default"> </span><span id="identifier">element</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;i ke&quot;</span><span id="default">, </span><span id="identifier">i</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span></pre>

### Statemen _while_
Statemen ini juga perulangan mirip dengan statemen _for_, tapi bedanya ini perulangannya belum diketahui sampai akhirnya kondisinya salah atau tidak memenuhi.
<pre class="pyscript-code"><span id="identifier">selesai</span><span id="default"> = </span><span id="keyword-identifier">False</span><br><span id="keyword">while</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="keyword-identifier">not</span><span id="default"> </span><span id="identifier">selesai</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier">masukan</span><span id="default"> = </span><span id="identifier-call">input</span><span id="parenthesis-1">(</span><span id="string">&quot;Ketik sesuatu (keluar untuk keluar): &quot;</span><span id="parenthesis-1">)</span><br><span id="default">    </span><span id="keyword">if</span><span id="default"> </span><span id="parenthesis-1">(</span><span id="identifier">masukan</span><span id="default">.</span><span id="identifier-call">strip</span><span id="parenthesis-2">()</span><span id="default">.</span><span id="identifier-call">lower</span><span id="parenthesis-2">()</span><span id="default"> == </span><span id="string">&#x27;keluar&#x27;</span><span id="parenthesis-1">)</span><span id="default"> </span><span id="parenthesis-1">{</span><br><span id="default">        </span><span id="identifier">selesai</span><span id="default"> = </span><span id="keyword-identifier">True</span><br><span id="default">    </span><span id="parenthesis-1">}</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;Anda memasukan:&quot;</span><span id="default">, </span><span id="identifier">masukan</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span></pre>

### Statemen _do-while_
Statemen perulangan ini mirip dengan statemen _while_, bedanya adalah blok kode setidaknya dijalankan sekali meski kondisinya salah atau tidak memenuhi sejak awal.
<pre class="pyscript-code"><span id="identifier">selanjutnya</span><span id="default"> = </span><span id="keyword-identifier">False</span><br><span id="keyword">do</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;Selanjutnya&quot;</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><span id="default"> </span><span id="keyword">while</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="identifier">selanjutnya</span><span id="parenthesis-0">)</span></pre>

### Statemen _switch-case-default_
Statemen ini adalah bentuk kontrol untuk memilih suatu aksi dari target nilai yang diberikan untuk dijalankan.
<pre class="pyscript-code"><span id="parenthesis-0">[</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">]</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="number">1</span><span id="default">, </span><span id="number">1</span><span id="parenthesis-0">]</span><br><span id="identifier">operasi</span><span id="default"> = </span><span id="string">&#x27;+&#x27;</span><br><br><span id="keyword">switch</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="identifier">operasi</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="keyword">case</span><span id="default"> </span><span id="string">&#x27;+&#x27;</span><span id="default">:</span><br><span id="default">        </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="identifier">a</span><span id="default"> + </span><span id="identifier">b</span><span id="parenthesis-1">)</span><br><span id="default">        </span><span id="keyword">break</span><span id="default"> </span><span id="comment"># break untuk menghentikan kasus selanjutnya</span><br><span id="default">    </span><span id="keyword">case</span><span id="default"> </span><span id="string">&#x27;-&#x27;</span><span id="default">:</span><br><span id="default">        </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="identifier">a</span><span id="default"> - </span><span id="identifier">b</span><span id="parenthesis-1">)</span><br><span id="default">        </span><span id="keyword">break</span><br><span id="default">    </span><span id="keyword">default</span><span id="default">: </span><span id="comment"># tidak memenuhi semua kasus di atas</span><br><span id="default">        </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;Operasi belum tersedia untuk&quot;</span><span id="default">, </span><span id="identifier">operasi</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span></pre>

### Statemen _func_
Statemen ini untuk mendeklarasikan sebuah fungsi. Fungsi ini bisa ditulis dalam ekspresi.
<pre class="pyscript-code"><span id="comment"># buat fungsi</span><br><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">foo</span><span id="parenthesis-0">()</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;Halo!&quot;</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><br><br><span id="identifier-call">foo</span><span id="parenthesis-0">()</span><span id="default"> </span><span id="comment"># panggil fungsi</span><br><br><span id="comment"># dengan parameter</span><br><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">add</span><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="identifier">a</span><span id="default"> + </span><span id="identifier">b</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><br><br><span id="identifier-call">add</span><span id="parenthesis-0">(</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># 3</span><br><br><span id="comment"># dengan parameter dan parameter dengan nilai default</span><br><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">sapa</span><span id="parenthesis-0">(</span><span id="identifier">nama</span><span id="default">, </span><span id="identifier">pekerjaan</span><span id="default">=</span><span id="string">&#x27;pengaguran&#x27;</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="keyword">if</span><span id="default"> </span><span id="parenthesis-1">(</span><span id="identifier">pekerjaan</span><span id="default"> == </span><span id="string">&#x27;pengaguran&#x27;</span><span id="parenthesis-1">)</span><span id="default"> </span><span id="parenthesis-1">{</span><br><span id="default">        </span><span id="identifier-call">print</span><span id="parenthesis-2">(</span><span id="string">&quot;get a job vro&quot;</span><span id="parenthesis-2">)</span><br><span id="default">    </span><span id="parenthesis-1">}</span><br><span id="default">    </span><span id="keyword">else</span><span id="default"> </span><span id="parenthesis-1">{</span><br><span id="default">        </span><span id="identifier-call">print</span><span id="parenthesis-2">(</span><span id="string">&quot;Halo {}! Kamu bekerja sebagai {}&quot;</span><span id="default">.</span><span id="identifier-call">format</span><span id="parenthesis-0">(</span><span id="identifier">nama</span><span id="default">, </span><span id="identifier">pekerjaan</span><span id="parenthesis-0">)</span><span id="parenthesis-2">)</span><br><span id="default">    </span><span id="parenthesis-1">}</span><br><span id="parenthesis-0">}</span><br><br><span id="identifier-call">sapa</span><span id="parenthesis-0">(</span><span id="string">&quot;Budi&quot;</span><span id="parenthesis-0">)</span><br><span id="identifier-call">sapa</span><span id="parenthesis-0">(</span><span id="string">&quot;Ahmad&quot;</span><span id="default">, </span><span id="string">&quot;Teknik&quot;</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># parameter pekerjaan kini menjadi &#x27;Teknik&#x27;</span><br><br><span id="comment"># mengembalikan nilai</span><br><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">kurang</span><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="default">, </span><span id="identifier">b</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="keyword">return</span><span id="default"> </span><span id="identifier">a</span><span id="default"> - </span><span id="identifier">b</span><br><span id="parenthesis-0">}</span><br><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier-call">kurang</span><span id="parenthesis-1">(</span><span id="number">1</span><span id="default">, </span><span id="number">1</span><span id="parenthesis-1">)</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># 0</span><br><br><span id="identifier">data</span><span id="default"> = </span><span id="parenthesis-0">[</span><span id="string">&#x27;5&#x27;</span><span id="default">, </span><span id="string">&#x27;4&#x27;</span><span id="default">, </span><span id="number">1</span><span id="default">, </span><span id="number">3</span><span id="default">, </span><span id="string">&#x27;2&#x27;</span><span id="parenthesis-0">]</span><br><br><span id="comment"># membuat fungsi di dalam ekspresi (bisa ditulis tanpa nama fungsi)</span><br><span id="identifier">urut</span><span id="default"> = </span><span id="identifier-call">sorted</span><span id="parenthesis-0">(</span><span id="identifier">data</span><span id="default">, </span><span id="identifier">key</span><span id="default">=</span><span id="keyword">func</span><span id="default"> </span><span id="parenthesis-1">(</span><span id="identifier">item</span><span id="parenthesis-1">)</span><span id="default"> </span><span id="parenthesis-1">{</span><br><span id="default">    </span><span id="keyword">if</span><span id="default"> </span><span id="parenthesis-2">(</span><span id="identifier-call">isinstance</span><span id="parenthesis-0">(</span><span id="identifier">item</span><span id="default">, </span><span id="identifier-class">str</span><span id="parenthesis-0">)</span><span id="parenthesis-2">)</span><span id="default"> </span><span id="keyword">return</span><span id="default"> </span><span id="identifier-class">int</span><span id="parenthesis-2">(</span><span id="identifier">item</span><span id="parenthesis-2">)</span><br><span id="default">    </span><span id="keyword">return</span><span id="default"> </span><span id="identifier">item</span><br><span id="parenthesis-1">}</span><span id="parenthesis-0">)</span><br><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">data</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># [1, &#x27;2&#x27;, 3, &#x27;4&#x27;, &#x27;5&#x27;]</span></pre>

### Statemen _del_
Statemen ini menghapus refrensi variabel (kadang objek dihapus atau tidak dihapus tergantung pada _garbage collector_ Python).
<pre class="pyscript-code"><span id="identifier">a</span><span id="default"> = </span><span id="number">1</span><br><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># 1</span><br><br><span id="keyword">del</span><span id="default"> </span><span id="identifier">a</span><br><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">a</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># NameError</span></pre>

### Statemen _assert_
Statemen ini menegaskan suatu kondisinya harus benar, jika tidak maka akan melempar `AssertionError`. Statemen ini bisa di _bypass_ dengan flag `-O` (_optimize_)
<pre class="pyscript-code"><span id="keyword">assert</span><span id="default"> </span><span id="number">1</span><span id="default"> + </span><span id="number">1</span><span id="default"> == </span><span id="number">2</span><span id="default"> </span><span id="comment"># tidak masalah</span><br><br><span id="keyword">assert</span><span id="default"> </span><span id="number">1</span><span id="default"> + </span><span id="number">1</span><span id="default"> == </span><span id="number">1</span><span id="default">, </span><span id="string">&quot;1 + 1 bukan 1&quot;</span><span id="default"> </span><span id="comment"># bermasalah (kondisinya salah)</span><br><br><span id="keyword">assert</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="number">1</span><span id="default"> + </span><span id="number">1</span><span id="default"> == </span><span id="number">1</span><span id="default">, </span><span id="string">&quot;1 + 1 bukan 1&quot;</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># tidak masalah karena kondisi adalah tuple</span><br><span id="default">                                     </span><span id="comment"># dan tuple itu berisi yang dimana akan selalu</span><br><span id="default">                                     </span><span id="comment"># benar</span></pre>

### Statemen _throw_
Statemen ini akan melempar kesalahan. Tidak seperti statemen _assert_, ia tidak bisa di _bypass_ dengan flag tertentu kecuali dengan statemen _try-catch_.
<pre class="pyscript-code"><span id="keyword">throw</span><span id="default"> </span><span id="identifier-class">Exception</span><span id="parenthesis-0">(</span><span id="string">&quot;Kesalahan fatal!&quot;</span><span id="parenthesis-0">)</span></pre>

### Statemen _try-catch-finally_
Statemen ini mencoba untuk menangkap eksepsi yang terjadi pada blok kode. Blok _finally_ berfungsi agar blok _finally_ itu di eksekusi apapun yang terjadi entah itu adanya kesalahan, adanya statemen penghenti seperti _break_, _continue_, dan _return_. Blok _catch_ adalah blok yang menganani terjadinya sebuah kesalahan jika itu terjadi.
<pre class="pyscript-code"><span id="keyword">try</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="number">1</span><span id="default"> / </span><span id="number">0</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><br><span id="keyword">catch</span><span id="default"> </span><span id="parenthesis-0">(</span><span id="identifier">e</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;Terjadi kesalahan:&quot;</span><span id="default">, </span><span id="identifier">e</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><br><span id="keyword">finally</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;Program Selesai&quot;</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><br><br><span id="comment"># jika tanpa blok catch (hanya finally) maka lemparan eksepsi akan terjadi</span><br><span id="comment"># dan blok finally tetap dijalankan</span><br><span id="keyword">try</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="keyword">throw</span><span id="default"> </span><span id="identifier-class">Exception</span><span id="parenthesis-1">(</span><span id="string">&quot;fatal!&quot;</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><span id="default"> </span><span id="keyword">finally</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;Program Selesai&quot;</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span></pre>

### Statemen _class_
Statemen ini adalah untuk membuat objek yang dikenal dengan istilah _Object Oriented Programming_ (_OOP_).
<pre class="pyscript-code"><span id="keyword">class</span><span id="default"> </span><span id="identifier-class">Posisi2D</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">__init__</span><span id="parenthesis-1">(</span><span id="identifier">self</span><span id="default">, </span><span id="identifier">x</span><span id="default">, </span><span id="identifier">y</span><span id="parenthesis-1">)</span><span id="default"> </span><span id="parenthesis-1">{</span><br><span id="default">        </span><span id="identifier">self</span><span id="default">.</span><span id="identifier">x</span><span id="default"> = </span><span id="identifier">x</span><br><span id="default">        </span><span id="identifier">self</span><span id="default">.</span><span id="identifier">y</span><span id="default"> = </span><span id="identifier">y</span><br><span id="default">    </span><span id="parenthesis-1">}</span><br><br><span id="default">    </span><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">__repr__</span><span id="parenthesis-1">(</span><span id="identifier">self</span><span id="parenthesis-1">)</span><span id="default"> </span><span id="parenthesis-1">{</span><br><span id="default">        </span><span id="keyword">return</span><span id="default"> </span><span id="string">&#x27;Posisi2D({!r}, {!r})&#x27;</span><span id="default">.</span><span id="identifier-call">format</span><span id="parenthesis-2">(</span><span id="identifier">self</span><span id="default">.</span><span id="identifier">x</span><span id="default">, </span><span id="identifier">self</span><span id="default">.</span><span id="identifier">y</span><span id="parenthesis-2">)</span><br><span id="default">    </span><span id="parenthesis-1">}</span><br><span id="parenthesis-0">}</span><br><br><span id="identifier">posisiku</span><span id="default"> = </span><span id="identifier-call">Posisi2D</span><span id="parenthesis-0">(</span><span id="number">0</span><span id="default">, </span><span id="number">0</span><span id="parenthesis-0">)</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">posisiku</span><span id="parenthesis-0">)</span></pre>

### Statemen dekorasi (_decorator_)
Statemen ini digunakan untuk mendekorasi sebuah definisi fungsi atau kelas. Prefix yang digunakan ialah `@` diikuti dengan statemen _func_, _class_, atau dekorator lain/tambahan.
<pre class="pyscript-code"><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">dekorasiku</span><span id="parenthesis-0">(</span><span id="identifier">fungsi</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="keyword">return</span><span id="default"> </span><span id="keyword">func</span><span id="parenthesis-1">()</span><span id="default"> </span><span id="parenthesis-1">{</span><br><span id="default">        </span><span id="identifier-call">print</span><span id="parenthesis-2">(</span><span id="string">&quot;Menjankan fungsi utama&quot;</span><span id="parenthesis-2">)</span><br><span id="default">        </span><span id="identifier">hasil</span><span id="default"> = </span><span id="identifier-call">fungsi</span><span id="parenthesis-2">()</span><br><span id="default">        </span><span id="identifier-call">print</span><span id="parenthesis-2">(</span><span id="string">&quot;Selesai&quot;</span><span id="parenthesis-2">)</span><br><span id="default">        </span><span id="keyword">return</span><span id="default"> </span><span id="identifier">hasil</span><br><span id="default">    </span><span id="parenthesis-1">}</span><br><span id="parenthesis-0">}</span><br><br><span id="default">@</span><span id="identifier">dekorasiku</span><br><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">foo</span><span id="parenthesis-0">()</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="identifier-call">print</span><span id="parenthesis-1">(</span><span id="string">&quot;Foo!!&quot;</span><span id="parenthesis-1">)</span><br><span id="parenthesis-0">}</span><br><br><span id="identifier-call">foo</span><span id="parenthesis-0">()</span><br><br><span id="default">@</span><span id="identifier">dekorasiku</span><br><span id="keyword">class</span><span id="default"> </span><span id="identifier-class">Test</span><span id="default"> </span><span id="parenthesis-0">{</span><br><span id="default">    </span><span id="keyword">func</span><span id="default"> </span><span id="identifier-call">__init__</span><span id="parenthesis-1">(</span><span id="identifier">self</span><span id="parenthesis-1">)</span><span id="default"> </span><span id="parenthesis-1">{</span><br><span id="default">        </span><span id="identifier-call">print</span><span id="parenthesis-2">(</span><span id="string">&quot;Test..&quot;</span><span id="parenthesis-2">)</span><br><span id="default">    </span><span id="parenthesis-1">}</span><br><span id="parenthesis-0">}</span><br><br><span id="identifier-call">Test</span><span id="parenthesis-0">()</span></pre>

### Statemen _from-import_
Statemen ini dipakai untuk me-impor file modul yang bisa berupa modul PyScript atau Python.
<pre class="pyscript-code"><span id="keyword">import</span><span id="default"> </span><span id="identifier">time</span><span id="default">   </span><span id="comment"># impor time dari python</span><br><span id="identifier">time</span><span id="default">.</span><span id="identifier-call">sleep</span><span id="parenthesis-0">(</span><span id="number">2</span><span id="parenthesis-0">)</span><span id="default"> </span><span id="comment"># tidur 2 detik</span><br><br><span id="keyword">from</span><span id="default"> </span><span id="identifier">time</span><span id="default"> </span><span id="keyword">import</span><span id="default"> </span><span id="identifier">sleep</span><span id="default"> </span><span id="comment"># impor salah satu paket di dalam time</span><br><span id="identifier-call">sleep</span><span id="parenthesis-0">(</span><span id="number">3</span><span id="parenthesis-0">)</span><span id="default">               </span><span id="comment"># tidur 3 detik</span><br><br><span id="keyword">from</span><span id="default"> </span><span id="identifier">time</span><span id="default"> </span><span id="keyword">import</span><span id="default"> </span><span id="parenthesis-0">[</span><span id="identifier">time</span><span id="default">, </span><span id="identifier">monotonic</span><span id="parenthesis-0">]</span><span id="default"> </span><span id="comment"># impor lebih dari 1 paket (wajib pakai kurung)</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier-call">time</span><span id="parenthesis-1">()</span><span id="default">, </span><span id="identifier-call">monotonic</span><span id="parenthesis-1">()</span><span id="parenthesis-0">)</span><br><br><span id="keyword">import</span><span id="default"> </span><span id="identifier">numpy</span><span id="default"> </span><span id="keyword">as</span><span id="default"> </span><span id="identifier">np</span><span id="default"> </span><span id="comment"># alias numpy adalah np</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">np</span><span id="default">.</span><span id="identifier-call">array</span><span id="parenthesis-1">(</span><span id="parenthesis-2">[</span><span id="number">1</span><span id="default">, </span><span id="number">2</span><span id="default">, </span><span id="number">3</span><span id="parenthesis-2">]</span><span id="parenthesis-1">)</span><span id="parenthesis-0">)</span><br><br><span id="comment"># alias pada masing paket</span><br><span id="keyword">from</span><span id="default"> </span><span id="identifier">this</span><span id="default"> </span><span id="keyword">import</span><span id="default"> </span><span id="identifier">s</span><span id="default"> </span><span id="keyword">as</span><span id="default"> </span><span id="identifier">kata_kata</span><br><span id="keyword">from</span><span id="default"> </span><span id="identifier">time</span><span id="default"> </span><span id="keyword">import</span><span id="default"> </span><span id="parenthesis-0">[</span><span id="identifier">time</span><span id="default"> </span><span id="keyword">as</span><span id="default"> </span><span id="identifier">waktu</span><span id="default">, </span><span id="identifier">monotonic</span><span id="default"> </span><span id="keyword">as</span><span id="default"> </span><span id="identifier">monotonik</span><span id="parenthesis-0">]</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">kata_kata</span><span id="parenthesis-0">)</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">waktu</span><span id="default">, </span><span id="identifier">monotonik</span><span id="parenthesis-0">)</span><br><br><span id="comment"># meimpor modul dalam bentuk file path</span><br><span id="keyword">import</span><span id="default"> </span><span id="string">&quot;kalkulatorku.pys&quot;</span><span id="default"> </span><span id="keyword">as</span><span id="default"> </span><span id="identifier">kalkulator</span><span id="default"> </span><span id="comment"># kalo string pakai alias untuk meakses modulnya</span><br><span id="identifier-call">print</span><span id="parenthesis-0">(</span><span id="identifier">kalkulator</span><span id="default">.</span><span id="identifier-call">tambah</span><span id="parenthesis-1">(</span><span id="number">2</span><span id="default">, </span><span id="number">2</span><span id="parenthesis-1">)</span><span id="parenthesis-0">)</span></pre>

## Penutup
Anda sudah sampai akhir, harusnya Anda sudah cukup bisa menulis dan memahami syntax dari PyScript ini. Saya ada tantangan untuk Anda, cobalah untuk membuat beberapa kode PyScript sesuai dengan permintaan dibawah ini:

1. Buat program untuk menghitung nilai pitagoras.
2. Buat program untuk mencari nilai faktorial.
3. Buat program untuk mencari nilai fibonaci.
4. Buat program gim sederhana yakni tebak angka.
5. Buat program gim ular menggunakan _egine_ atau modul Python [PyGame](https://pygame.org).

_Good Luck :)_

<style>
    /*
        if you seeing this it means this platform has disabled style tags
        for security reasons.
    */

    :root {
        --default: #D4D4D4;
        --keyword: #C586C0;
        --keyword-identifier: #307CD6;
        --identifier: #8CDCFE;
        --identifier-const: #2EA3FF;
        --identifier-call: #DCDCAA;
        --identifier-class: #4EC9B0;
        --number: #B5CEA8;
        --string: #CE9178;
        --parenthesis-unmatch: #B51819;
        --parenthesis-0: #FFD705;
        --parenthesis-1: #D45DBA;
        --parenthesis-2: #1A9FFF;
        --comment: #549952;
    }

    .pyscript-code span#default {
        color: var(--default);
    }

    .pyscript-code span#keyword {
        color: var(--keyword);
    }

    .pyscript-code span#keyword-identifier {
        color: var(--keyword-identifier);
    }

    .pyscript-code span#identifier {
        color: var(--identifier);
    }

    .pyscript-code span#identifier-const {
        color: var(--identifier-const);
    }

    .pyscript-code span#identifier-call {
        color: var(--identifier-call);
    }

    .pyscript-code span#identifier-class {
        color: var(--identifier-class);
    }

    .pyscript-code span#number {
        color: var(--number);
    }

    .pyscript-code span#string {
        color: var(--string);
    }

    .pyscript-code span#parenthesis-unmatch {
        color: var(--parenthesis-unmatch);
    }

    .pyscript-code span#parenthesis-0 {
        color: var(--parenthesis-0);
    }

    .pyscript-code span#parenthesis-1 {
        color: var(--parenthesis-1);
    }

    .pyscript-code span#parenthesis-2 {
        color: var(--parenthesis-2);
    }

    .pyscript-code span#comment {
        color: var(--comment);
    }
</style>