# PyScript

<p align="center">
    <img src="https://github.com/azzammuhyala/pyscript/blob/main/PyScript.png?raw=true" alt="PyScript Logo" width="200">
</p>

PyScript is a simple programming language built on top of Python. It combines some syntax from Python and JavaScript,
so if you're already familiar with Python or JavaScript, or both, it should be quite easy to learn.

## Introduction PyScript
PyScript may not be the language we'll be discussing, but the name PyScript already exists, a flexible and platform for
running Python in a browser. Since it's inception, the language was inspired by Python and JavaScript, which are
relatively easy for humans to read. This name was chosen because it wasn't immediately known whether this name was
already in use.

This language wasn't designed to compete with other modern programming languages, but rather as a learning for
understanding how programming languages ​​work and how human written code can be understood by machines. Furthermore, this
language was created as a relatively complex project. Using Python as the foundation for PyScript, it's easy to
understand syntax makes it easy to understand how the language is built without having to understand complex
instructions like those in C, C++, and other low-level languages.

To learn more about PyScript, you can see on [PyScript documentation here](https://azzammuhyala.github.io/pyscript) or 
[PyScript repository](https://github.com/azzammuhyala/pyscript).

## Syntax
<pre class="pyscript-code"><span style="color:#C586C0">func</span><span style="color:#D4D4D4"> </span><span style="color:#DCDCAA">greet</span><span style="color:#FFD705">(</span><span style="color:#8CDCFE">name</span><span style="color:#FFD705">)</span><span style="color:#D4D4D4"> </span><span style="color:#FFD705">{</span><br><span style="color:#D4D4D4">    </span><span style="color:#DCDCAA">print</span><span style="color:#D45DBA">(</span><span style="color:#CE9178">&quot;Hello, &quot;</span><span style="color:#D4D4D4"> + </span><span style="color:#8CDCFE">name</span><span style="color:#D4D4D4"> + </span><span style="color:#CE9178">&quot;!&quot;</span><span style="color:#D45DBA">)</span><br><span style="color:#FFD705">}</span><br><br><span style="color:#DCDCAA">greet</span><span style="color:#FFD705">(</span><span style="color:#CE9178">&quot;Azzam&quot;</span><span style="color:#FFD705">)</span></pre>

## Behind it
This language created from based up on a
[YouTube tutorial](https://www.youtube.com/playlist?list=PLZQftyCk7_SdoVexSmwy_tBgs7P0b97yD). At least, it takes
about 6 months to learn it, and also need to learn general things that exist in other programming languages.